/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.dis.ApplyCreditLevel;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.BillTypeCusFilterPojo;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.OrgSetUserGroupPojo;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.util.TaskWorkFlowUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class TaskAskFormPlugin
extends AbstractFormPlugin {
    private static final char NEWLINE = '\n';
    private static final String TASK_DISRULEMETA = "task_disrule";
    private static final String TASK_USERGROUP = "task_usergroup";
    private static final Log log = LogFactory.getLog(TaskAskFormPlugin.class);
    private Map<Long, Long> task2GroupMap = new HashMap<Long, Long>(32);
    private Map<Long, WorkerStatusPojo> group2WorkerStatusPojo = new HashMap<Long, WorkerStatusPojo>(32);
    private long currUserId = 0L;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"okbtn"});
        this.currUserId = RequestContext.get().getCurrUserId();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        boolean passValidate = false;
        try {
            if ("okbtn".equalsIgnoreCase(key)) {
                Object taskNumObj = this.getModel().getValue("tasknum");
                if (taskNumObj == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u6570", (String)"TaskAskFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                } else if ((Integer)taskNumObj <= 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4ec5\u80fd\u62c9\u53d6\u5927\u4e8e0\u6761\u7684\u4efb\u52a1\u3002", (String)"TaskAskFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                } else {
                    passValidate = true;
                }
            }
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519\uff1a%s", (String)"TaskAskFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
            log.error("\u6821\u9a8c\u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
        if (passValidate) {
            String isQuality = (String)this.getView().getFormShowParameter().getCustomParam("isQuality");
            if ("true".equals(isQuality)) {
                this.askQualityTask();
            } else {
                this.askTask();
            }
        }
    }

    public void askTask() {
        Integer taskNum = (Integer)this.getModel().getValue("tasknum");
        String sscIDStr = (String)this.getView().getFormShowParameter().getCustomParam("sscid.id");
        Map<String, StringBuffer> askTaskRsMap = this.askTask(taskNum, sscIDStr);
        this.getView().returnDataToParent(askTaskRsMap);
        this.getView().close();
    }

    public void askQualityTask() {
        Integer taskNum = (Integer)this.getModel().getValue("tasknum");
        String sscIDStr = (String)this.getView().getFormShowParameter().getCustomParam("sscid.id");
        Map<String, StringBuffer> askTaskRsMap = this.askTaskNew(taskNum, sscIDStr, true);
        this.getView().returnDataToParent(askTaskRsMap);
        this.getView().close();
    }

    private void getWordLoad4CurUserInPerGroup() {
        DynamicObjectCollection userGroups = QueryServiceHelper.query((String)TASK_USERGROUP, (String)"id,entryentity.curtasknum_e", (QFilter[])new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.userfield", "=", (Object)this.currUserId).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue()).toArray());
        if (userGroups == null) {
            return;
        }
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()).and(new QFilter("personid", "=", (Object)this.currUserId));
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        DynamicObjectCollection processingTasks = QueryServiceHelper.query((String)"task_task", (String)"id,usergroup", (QFilter[])new QFilter[]{disedTKFilter});
        Map<Long, List<DynamicObject>> group2Tasks = processingTasks.stream().collect(Collectors.groupingBy(k -> k.getLong("usergroup")));
        for (DynamicObject userGroup : userGroups) {
            Long gId = userGroup.getLong("id");
            WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
            workerStatusPojo.setUserGroupId(gId);
            workerStatusPojo.setTaskUpper(userGroup.getInt("entryentity.curtasknum_e"));
            List<DynamicObject> tasks = group2Tasks.get(gId);
            workerStatusPojo.setTaskTotal(tasks != null ? tasks.size() : 0);
            this.group2WorkerStatusPojo.put(gId, workerStatusPojo);
        }
    }

    public Map<String, StringBuffer> askTask(Integer taskNum, String sscIDStr) {
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            return this.askTaskNew(taskNum, sscIDStr, false);
        }
        return this.askTaskOld(taskNum, sscIDStr);
    }

    private Map<String, StringBuffer> askTaskNew(Integer taskNum, String sscIDStr, boolean isQuality) {
        if (this.currUserId == 0L) {
            this.currUserId = RequestContext.get().getCurrUserId();
        }
        HashMap<String, StringBuffer> checkMsgMap = new HashMap<String, StringBuffer>();
        StringBuffer msg = new StringBuffer();
        List<Object> successTaskIds = new ArrayList();
        QFilter askTaskExtQFilter = this.getAskTaskExtQFilter();
        try {
            Long sscId = Long.valueOf(sscIDStr);
            if (isQuality) {
                askTaskExtQFilter.and(new QFilter("qualitysamplelibrary", ">", (Object)0));
                successTaskIds = Distribution.askTaskDistribution(this.currUserId, sscId, askTaskExtQFilter, taskNum);
            } else {
                askTaskExtQFilter.and(new QFilter("qualitysamplelibrary", "=", (Object)0));
                successTaskIds = Distribution.askTaskDistributionFast(this.currUserId, sscId, askTaskExtQFilter, taskNum);
            }
        }
        catch (Exception e) {
            log.error("\u4e3b\u52a8\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            if (e instanceof KDException) {
                msg.append(e.getMessage());
                checkMsgMap.put("parent", msg);
                return checkMsgMap;
            }
            msg.append(ResManager.loadKDString((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u5904\u7406\u3002", (String)"TaskAskFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            checkMsgMap.put("parent", msg);
            return checkMsgMap;
        }
        if (successTaskIds.isEmpty()) {
            msg.append(ResManager.loadKDString((String)"\u6682\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4efb\u52a1\uff0c\u6216\u5df2\u8fbe\u5230\u5904\u7406\u4e2d\u4efb\u52a1\u4e0a\u9650\u3002", (String)"TaskAskFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            checkMsgMap.put("parent", msg);
        } else {
            msg.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u83b7\u53d6%s\u6761\u4efb\u52a1\u3002", (String)"TaskAskFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), successTaskIds.size()));
            checkMsgMap.put("success", msg);
        }
        return checkMsgMap;
    }

    private Map<String, StringBuffer> askTaskOld(Integer taskNum, String sscIDStr) {
        if (this.currUserId == 0L) {
            this.currUserId = RequestContext.get().getCurrUserId();
        }
        HashMap<String, StringBuffer> checkMsgMap = new HashMap<String, StringBuffer>();
        StringBuffer checkMsg = new StringBuffer();
        this.getWordLoad4CurUserInPerGroup();
        ArrayList<CusDisrulePojo> disRulePOJOs = this.getDisRules(sscIDStr);
        if (disRulePOJOs == null || disRulePOJOs.isEmpty()) {
            checkMsgMap.put("local", checkMsg);
            checkMsg.append(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u4f60\u7684\u4efb\u52a1\u5206\u914d\u89c4\u5219\uff0c\u4e0d\u80fd\u83b7\u53d6\u4efb\u52a1\u3002", (String)"TaskAskFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0])).append('\n');
            return checkMsgMap;
        }
        QFilter taskBaseFilter = this.buildDisTaskBaseFilter();
        ORM orm = ORM.create();
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet backTaskDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query disrule", "task_task", "id,receivetime,expirestate,personid,pooltype,assignid,subject,source,billtype,billtype.id,tasktypeid,tasktypeid.id,creator.id,orgid,billid,sourcetaskid,qualitysamplelibrary.id,autoprocess,billnumber", new QFilter[]{taskBaseFilter}, "tasklevelid.priority,createtime");){
            DynamicObjectCollection taskDynaColl = ORMUtil.toDynamicObjectCollection((DataSet)backTaskDS, (String)"task_task");
            taskDynaColl = this.matchTask(disRulePOJOs, taskDynaColl);
            taskDynaColl = TaskApprevalHelper.getTasks(taskDynaColl, RequestContext.get().getCurrUserId(), taskNum);
            if (taskDynaColl.size() == 0) {
                checkMsg.append(ResManager.loadKDString((String)"\u6682\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4efb\u52a1\uff0c\u6216\u5df2\u8fbe\u5230\u5904\u7406\u4e2d\u4efb\u52a1\u4e0a\u9650\u3002", (String)"TaskAskFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0])).append('\n');
            }
            for (DynamicObject disTask : taskDynaColl) {
                ids.add(disTask.getLong("id"));
            }
        }
        QFilter toDisfilter = new QFilter("id", "in", ids);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,receivetime,state,expirestate,personid,pooltype,tasktypeid,billtype,orgid,assignid,subject,source,usergroup,sscid,qualitysamplelibrary.id,orignalperson,firstreceivetime", (QFilter[])new QFilter[]{toDisfilter});
        ArrayList<DynamicObject> stateChangeDyObjlist = new ArrayList<DynamicObject>();
        HashSet<Long> sampleLibIds = new HashSet<Long>();
        StringBuffer sucessMsg = new StringBuffer();
        for (DynamicObject disTask : tasks) {
            String oldState = disTask.getString("state");
            this.setTaskValue(disTask);
            this.addSateChange(stateChangeDyObjlist, disTask, oldState, orm);
            if (this.isWfWork(disTask)) {
                TaskWorkFlowUtil.updateWfMsg((DynamicObject)disTask, (boolean)false);
                this.updateWfState(disTask);
                this.updateWfAuditMsg(disTask);
            }
            if (disTask.getLong("qualitysamplelibrary.id") <= 0L) continue;
            sampleLibIds.add(disTask.getLong("qualitysamplelibrary.id"));
        }
        if (tasks.length > 0) {
            SaveServiceHelper.save((DynamicObject[])tasks);
            orm.insert(stateChangeDyObjlist);
            QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(sampleLibIds);
            sucessMsg.append(String.format(ResManager.loadKDString((String)"\u6210\u529f\u83b7\u53d6%s\u6761\u4efb\u52a1\u3002", (String)"TaskAskFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), tasks.length));
        }
        if (checkMsg.length() > 0) {
            checkMsgMap.put("parent", checkMsg);
        } else {
            checkMsgMap.put("success", sucessMsg);
            OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(tasks, this.getView());
        }
        return checkMsgMap;
    }

    private boolean isWfWork(DynamicObject taskDynObj) {
        String wfTaskId = taskDynObj.getString("assignid");
        return StringUtils.isNotEmpty((String)wfTaskId);
    }

    private void updateWfState(DynamicObject taskDynObj) {
        TaskWorkFlowUtil.updateMsgCreateTask((DynamicObject[])new DynamicObject[]{taskDynObj}, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskAdministrateListPlugin_46", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private void updateWfAuditMsg(DynamicObject taskDynObj) {
        Long taskid = (Long)taskDynObj.getPkValue();
        DynamicObject[] updateRecords = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"personid,dealdate,taskstate", (QFilter[])new QFilter[]{new QFilter("taskid", "=", (Object)taskid)});
        if (updateRecords.length > 0) {
            for (DynamicObject updateRecord : updateRecords) {
                updateRecord.set("personid", (Object)taskDynObj.getLong("personid"));
                updateRecord.set("dealdate", (Object)new Date());
                updateRecord.set("taskstate", (Object)AuditStateEnum.INPROCESS.getState());
            }
            SaveServiceHelper.save((DynamicObject[])updateRecords);
        }
    }

    public void setTaskValue(DynamicObject disTask) {
        Date date = new Date();
        disTask.set("receivetime", (Object)date);
        if (disTask.getLong("qualitysamplelibrary.id") == 0L && disTask.getDate("firstreceivetime") == null) {
            disTask.set("firstreceivetime", (Object)date);
        }
        disTask.set("expirestate", (Object)1);
        disTask.set("personid", (Object)this.currUserId);
        disTask.set("pooltype", (Object)1);
        if (disTask.getLong("qualitysamplelibrary.id") > 0L) {
            disTask.set("state", (Object)TaskStateEnum.CHECKING.getValue());
            disTask.set("orignalperson", (Object)this.currUserId);
        } else {
            disTask.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        disTask.set("usergroup", (Object)this.task2GroupMap.get(disTask.getLong("id")));
    }

    public void addSateChange(List<DynamicObject> stateChangeDyObjlist, DynamicObject disTask, String oldState, ORM orm) {
        DynamicObject stateChangeDyObj = orm.newDynamicObject("task_statechange");
        stateChangeDyObj.set("jobid", disTask.get("id"));
        stateChangeDyObj.set("newjobstate", disTask.get("state"));
        stateChangeDyObj.set("oldjobstate", (Object)oldState);
        stateChangeDyObj.set("changetime", (Object)new Date());
        stateChangeDyObj.set("operatorid", (Object)this.currUserId);
        stateChangeDyObj.set("allocatedpersonid", (Object)RequestContext.get().getCurrUserId());
        stateChangeDyObj.set("operation", (Object)6);
        stateChangeDyObj.set("tasktype", disTask.get("tasktypeid"));
        stateChangeDyObj.set("billtype", disTask.get("billtype"));
        stateChangeDyObjlist.add(stateChangeDyObj);
    }

    private QFilter buildDisTaskBaseFilter() {
        QFilter toDisfilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        QFilter stateFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.TO_BE_DIS.getValue(), TaskStateEnum.DIS_EXCEPTION.getValue()});
        String sscIDStr = (String)this.getView().getFormShowParameter().getCustomParam("sscid.id");
        QFilter sscQFilter = new QFilter("sscid", "=", (Object)this.getSscID(sscIDStr));
        QFilter askTaskExtQFilter = this.getAskTaskExtQFilter();
        return toDisfilter.and(stateFilter).and(sscQFilter).and(askTaskExtQFilter);
    }

    @NotNull
    private QFilter getAskTaskExtQFilter() {
        Long taskbill;
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        List taskbillType = (List)this.getView().getFormShowParameter().getCustomParam("taskbillType");
        if (CollectionUtils.isNotEmpty((Collection)taskbillType)) {
            qFilter = new QFilter("billtype.group", "in", (Object)taskbillType);
        }
        if ((taskbill = (Long)this.getView().getFormShowParameter().getCustomParam("taskbill")) != null) {
            qFilter.and(new QFilter("billtype", "=", (Object)taskbill));
        }
        return qFilter;
    }

    private Long getSscID(String sscIDStr) {
        return NumberUtils.toLong((String)sscIDStr, (long)-1L);
    }

    private DynamicObjectCollection matchTask(ArrayList<CusDisrulePojo> disRulePOJOs, DynamicObjectCollection taskCollection) {
        Object[] taskArray = new DynamicObject[taskCollection.size()];
        taskCollection.toArray(taskArray);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel((DynamicObject[])taskArray);
        applyCreditLevel.prepareData();
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        QulityJob qulityJob = new QulityJob((DynamicObject[])taskArray);
        qulityJob.prepareData();
        long curUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection matchedTasks = new DynamicObjectCollection();
        for (DynamicObject task : taskCollection) {
            try {
                if (task.getLong("qualitysamplelibrary.id") > 0L && curUserId == qulityJob.getQjobSourcePerson(task) || task.getLong("qualitysamplelibrary.id") == 0L && !billCusFilter.isAllowAnyApplier(task.getLong("billtype.id")) && Long.valueOf(curUserId).equals(task.getLong("creator.id"))) continue;
                for (CusDisrulePojo disRule : disRulePOJOs) {
                    long hisTaskType;
                    long taskType = task.getLong("tasktypeid");
                    if (qulityJob.isAutoAdtQJb(task) && (hisTaskType = qulityJob.getQjobSourceType(task)) > -1L) {
                        taskType = hisTaskType;
                    }
                    if (taskType != disRule.getTaskTypeId()) continue;
                    boolean billMatched = false;
                    for (BillTypeCusFilterPojo billTypeCusFilterPojo : disRule.getBillTypeCusFilterList()) {
                        if (task.getLong("billtype") != billTypeCusFilterPojo.getBillType() || !applyCreditLevel.match(task, billTypeCusFilterPojo.getApplycreditleveljoson()) || !billCusFilter.match(task, billTypeCusFilterPojo.getFilterrulejson(), disRule.getId())) continue;
                        billMatched = true;
                        break;
                    }
                    if (!billMatched) continue;
                    boolean matched = false;
                    for (OrgSetUserGroupPojo orgSetUserGroupPojo : disRule.getOrgSetUserGroupPojoList()) {
                        Long gId;
                        WorkerStatusPojo workerStatusPojo;
                        if (!orgSetUserGroupPojo.isEnable() || !orgSetUserGroupPojo.getOrgSet().contains(task.getLong("orgid")) || (workerStatusPojo = this.group2WorkerStatusPojo.get(gId = Long.valueOf(orgSetUserGroupPojo.getGroup()))) == null || workerStatusPojo.getTaskTotal() >= workerStatusPojo.getTaskUpper()) continue;
                        matched = true;
                        workerStatusPojo.setTaskTotal(workerStatusPojo.getTaskTotal() + 1);
                        this.task2GroupMap.put(task.getLong("id"), gId);
                        break;
                    }
                    if (!matched) continue;
                    matchedTasks.add((Object)task);
                }
            }
            catch (Exception e) {
                log.info("\u4e3b\u52a8\u83b7\u53d6\u4efb\u52a1\u5f02\u5e38\uff1a" + task.get("id"));
            }
        }
        return matchedTasks;
    }

    private ArrayList<CusDisrulePojo> getDisRules(String sscIDStr) {
        List<Long> groupIDs = this.getGroupIncludeCurrentUser();
        if (groupIDs.isEmpty()) {
            return null;
        }
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        QFilter userFilter = new QFilter("entryentity1.usergroup", "in", groupIDs).and(new QFilter("ssccenter", "=", (Object)this.getSscID(sscIDStr)));
        DynamicObject[] taskDisRules = BusinessDataServiceHelper.load((String)TASK_DISRULEMETA, (String)"id,number,entryentity.id,ssccenter,entryentity1.id,tasktype,priority,entryentity.billtype,entryentity.billtype.externalerp.number,entryentity.filterrulejson_tag,entryentity.filterrulejson,entryentity.applycreditleveljoson_tag,entryentity.applycreditleveljoson,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{userFilter, disruleEnbaleQFilter}, (String)"priority");
        return CusDisrulePojo.buildDisRulePOJOListIncludeGroups(taskDisRules, groupIDs);
    }

    private List<Long> getGroupIncludeCurrentUser() {
        ORM orm = ORM.create();
        QFilter userFilter = new QFilter("entryentity.userfield", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        userFilter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue());
        ArrayList<Long> groupIDs = new ArrayList<Long>();
        try (DataSet groupDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query usergroup", TASK_USERGROUP, "id", new QFilter[]{userFilter});){
            for (Row row : groupDS) {
                groupIDs.add(row.getLong("id"));
            }
        }
        return groupIDs;
    }
}

