/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.business.task.TaskRule4ImptEditHelper;
import kd.ssc.task.formplugin.imports.TaskImportHelper;

public class TaskRule4ImptEditPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(TaskRule4ImptEditPlugin.class);
    Map<String, Set<Long>> bindBill2TaskBillOrgsMap;
    Map<String, DynamicObject> number2DataInsightMap;
    private Map<String, DynamicObject> taskBillClassifyMap;
    private Map<String, DynamicObject> taskPoolMap;
    private Map<String, DynamicObject> applyCondMap;

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        String sscNumber = SscDistributeCache.get((String)"sscNumber");
        DynamicObject ssc = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)sscNumber).toArray());
        this.getPageCache().put("sscId", ssc.getString("id"));
        HashSet<String> bindBillNumbers = new HashSet<String>();
        for (Map rowMap : e.getSourceDataList()) {
            JSONObject row = (JSONObject)rowMap;
            JSONObject bindbillNew = row.getJSONObject("bindbill_new");
            if (bindbillNew != null) {
                bindBillNumbers.add(bindbillNew.getString("number"));
            }
            row.getJSONObject("ssccenter").put("id", (Object)ssc.getString("id"));
        }
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"bindbill_new.number,sscbillorgpar.FBasedataId", (QFilter[])new QFilter("effective", "=", (Object)"1").and("bindbill_new.number", "in", bindBillNumbers).toArray());
        this.bindBill2TaskBillOrgsMap = taskBills.stream().collect(Collectors.groupingBy(b -> b.getString("bindbill_new.number"), Collectors.mapping(b -> b.getLong("sscbillorgpar.FBasedataId"), Collectors.toSet())));
        DynamicObject[] dataInsight = BusinessDataServiceHelper.load((String)"idi_schema", (String)"id,number,enable", (QFilter[])new QFilter("sourceentitynumber.number", "in", bindBillNumbers).toArray());
        this.number2DataInsightMap = Arrays.stream(dataInsight).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        DynamicObjectCollection taskBillClassifys = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number,isleaf", (QFilter[])new QFilter[]{new QFilter("ssccenter", "=", (Object)ssc.getLong("id"))});
        this.taskBillClassifyMap = taskBillClassifys.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        DynamicObjectCollection taskPools = QueryServiceHelper.query((String)"task_querylistpool", (String)"id,number,bill.id,enable", null);
        this.taskPoolMap = taskPools.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        DynamicObjectCollection applyConds = QueryServiceHelper.query((String)"ssc_apply_condition", (String)"id,number,enable", null);
        this.applyCondMap = applyConds.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        JSONObject row = (JSONObject)e.getSourceData();
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "number", row.getString("number"), e);
        TaskImportHelper.checkUniqueForFieldInFile((AbstractFormPlugin)this, "name", row.getJSONObject("name").getString(RequestContext.get().getLang().toString()), e);
        long sscId = Long.parseLong(this.getPageCache().get("sscId"));
        IFormView view = this.getView();
        if (!TaskRule4ImptEditHelper.checkTaskBill((long)sscId, (BeforeImportDataEventArgs)e, (IFormView)view)) {
            return;
        }
        TaskRule4ImptEditHelper.checkTaskType((long)sscId, (BeforeImportDataEventArgs)e, (IFormView)view);
        TaskRule4ImptEditHelper.checkCheckPoint((long)sscId, (BeforeImportDataEventArgs)e, (IFormView)view);
        TaskRule4ImptEditHelper.checkDataInsight((BeforeImportDataEventArgs)e, this.number2DataInsightMap);
        TaskRule4ImptEditHelper.checkBizSystem((BeforeImportDataEventArgs)e, (IFormView)view);
        TaskRule4ImptEditHelper.checkFieldEntity((BeforeImportDataEventArgs)e);
        TaskRule4ImptEditHelper.checkTaskBillClassify((BeforeImportDataEventArgs)e, this.taskBillClassifyMap);
        TaskRule4ImptEditHelper.checkTaskPool((BeforeImportDataEventArgs)e, this.taskPoolMap);
        TaskRule4ImptEditHelper.checkApplyCond((BeforeImportDataEventArgs)e, this.applyCondMap);
        TaskRule4ImptEditHelper.checkImage((BeforeImportDataEventArgs)e);
        TaskRule4ImptEditHelper.checkOrg4Ssc((long)sscId, (BeforeImportDataEventArgs)e, (IFormView)view);
        TaskRule4ImptEditHelper.checkIsEmbed((BeforeImportDataEventArgs)e);
    }
}

