/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.formplugin.imports.TaskImportHelper;

public class TaskTypePlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(TaskTypePlugin.class);

    public void initialize() {
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        JSONObject row = (JSONObject)e.getSourceData();
        TaskImportHelper.checkUniqueForFieldInFile(this, "number", row.getString("number"), e);
        TaskImportHelper.checkUniqueForFieldInFile(this, "name", row.getJSONObject("name").getString(RequestContext.get().getLang().toString()), e);
        JSONObject ssc = row.getJSONObject("orgfield");
        log.info("number = {} , orgfield = {}", (Object)row.getString("number"), (Object)ssc);
        String sscNumber = ssc.getString("number");
        DynamicObject sscDo = QueryServiceHelper.queryOne((String)"bos_org", (String)"id, number", (QFilter[])new QFilter("number", "=", (Object)sscNumber).toArray());
        if (sscDo != null) {
            Long sscId = sscDo.getLong("id");
            String qualityJudge = row.getString("qualityjudge");
            String sscType = DutyManageDataHelper.getSSCType((long)sscId);
            if (SSCTypeEnum.HR.getValue().equals(sscType)) {
                if (TaskPropertyEnum.QUACHECKTASK.getValue().equals(qualityJudge)) {
                    e.setCancel(true);
                    String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4eba\u529b\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\uff0c\u4e0d\u652f\u6301\u8d28\u68c0\u4efb\u52a1\u3002", (String)"TaskTypePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), ssc.getString("name"));
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), errMsg);
                }
            } else if (TaskPropertyEnum.HANDLE_TASK.getValue().equals(qualityJudge)) {
                e.setCancel(true);
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u975e\u4eba\u529b\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\uff0c\u4e0d\u652f\u6301\u201c\u529e\u7406\u4efb\u52a1\u201d\u3002", (String)"TaskTypePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), ssc.getString("name"));
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), errMsg);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.checkTaskLevelFieldAfterImport();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (key.equals("qualityjudge") && !Objects.isNull(newValue = e.getChangeSet()[0].getNewValue()) && "1".equals(newValue)) {
            model.setValue("tasklevel", (Object)" ");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject ssc = (DynamicObject)model.getValue("orgfield");
        if (ssc != null) {
            Long sscId = ssc.getLong("id");
            String sscType = DutyManageDataHelper.getSSCType((long)sscId);
            this.setTaskPropertyCombo(sscType);
        }
    }

    private void setTaskPropertyCombo(String sscType) {
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("qualityjudge");
        List comboItems = comboProp.getComboItems();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        if (SSCTypeEnum.HR.getValue().equals(sscType)) {
            for (ValueMapItem comboItem : comboItems) {
                String value = comboItem.getValue();
                LocaleString name = comboItem.getName();
                if (TaskPropertyEnum.QUACHECKTASK.getValue().equals(value)) continue;
                ComboItem citem = new ComboItem();
                citem.setValue(value);
                citem.setCaption(name);
                list.add(citem);
            }
        } else {
            for (ValueMapItem comboItem : comboItems) {
                String value = comboItem.getValue();
                LocaleString name = comboItem.getName();
                if (TaskPropertyEnum.HANDLE_TASK.getValue().equals(value)) continue;
                ComboItem citem = new ComboItem();
                citem.setValue(value);
                citem.setCaption(name);
                list.add(citem);
            }
        }
        ComboEdit comboPropCtl = (ComboEdit)this.getControl("qualityjudge");
        comboPropCtl.setComboItems(list);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "orgfield"});
        }
        Object id = this.getModel().getValue("id");
        boolean taskbillflag = this.isExistInTaskbill(id);
        boolean disruleflag = this.isExistInDisrule(id);
        if (taskbillflag || disruleflag) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"qualityjudge"});
        }
    }

    private boolean isExistInTaskbill(Object fid) {
        boolean flag = false;
        QFilter filter1 = new QFilter("tasktype.id", "=", fid);
        DynamicObject result = QueryServiceHelper.queryOne((String)"task_taskbill_child", (String)"id", (QFilter[])new QFilter[]{filter1});
        if (result != null) {
            flag = true;
        }
        return flag;
    }

    private boolean isExistInDisrule(Object fid) {
        boolean flag = false;
        QFilter filter1 = new QFilter("tasktype.id", "=", fid);
        DynamicObject result = QueryServiceHelper.queryOne((String)"task_disrule", (String)"id", (QFilter[])new QFilter[]{filter1});
        if (result != null) {
            flag = true;
        }
        return flag;
    }

    private void checkTaskLevelFieldAfterImport() {
        IDataModel model = this.getModel();
        String qualityJudge = (String)model.getValue("qualityjudge");
        String taskLevel = (String)model.getValue("tasklevel");
        if ("1".equals(qualityJudge) && StringUtils.isNotEmpty((String)taskLevel)) {
            model.setValue("tasklevel", (Object)"");
        }
    }
}

