/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;

public class ConditionFormPlugin
extends AbstractBillPlugIn {
    private static final String CB_CONDITION_EDIT = "condition_edit";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"conditionshow"});
    }

    public void afterLoadData(EventObject e) {
        this.initData();
        this.getModel().setDataChanged(false);
        String enable = (String)this.getModel().getValue("enable");
        if ("0".equals(enable)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
        }
    }

    public void afterCopyData(EventObject e) {
        this.initData();
    }

    private void initData() {
        IDataModel model = this.getModel();
        model.setValue("conditionshow", model.getValue("conditionjson"));
    }

    public void afterBindData(EventObject e) {
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("conditionshow".equals(key)) {
            this.showConditionForm();
        }
    }

    private void showConditionForm() {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("ssc_condition_edit");
        formShowParameter.setCustomParam("conditionJson", model.getValue("conditionjson_tag"));
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L) {
            formShowParameter.setCustomParam("conditionId", (Object)pkValue);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CB_CONDITION_EDIT);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (CB_CONDITION_EDIT.equals(actionId)) {
            Map map = (Map)returnData;
            String conditionDesc = (String)map.get("desc");
            String conditionJson = (String)map.get("conditionJson");
            this.getModel().setValue("conditionshow", (Object)conditionDesc);
            this.getModel().setValue("conditionjson", (Object)conditionDesc);
            this.getModel().setValue("conditionjson_tag", (Object)conditionJson);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel dataModel = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("conditionshow".equals(propName) && StringUtils.isEmpty((CharSequence)((String)newValue))) {
            dataModel.setValue("conditionjson", null);
            dataModel.setValue("conditionjson_tag", null);
        }
    }
}

