/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;

public class ReportFormPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        String indicatorInfo = (String)this.getModel().getValue("indicatortext_tag");
        this.openRuleView(indicatorInfo);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IPageCache pageCache = this.getView().getPageCache();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            String showPage = pageCache.get("showPage");
            IFormView view = this.getView().getView(showPage);
            if (Objects.isNull(view)) {
                args.setCancel(true);
                return;
            }
            IDataModel model = view.getModel();
            boolean dataLoaded = model.isDataLoaded();
            if (!dataLoaded) {
                return;
            }
            DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                args.setCancel(true);
                return;
            }
            Object indicatorTextTag = this.getModel().getValue("indicatortext_tag");
            if (ObjectUtils.isEmpty((Object)indicatorTextTag)) {
                return;
            }
            Map indicatorInfo = (Map)SerializationUtils.fromJsonString((String)indicatorTextTag.toString(), Map.class);
            Map rowData = (Map)SerializationUtils.fromJsonString((String)((String)indicatorInfo.get("rowData")), Map.class);
            List columnInfo = (List)SerializationUtils.fromJsonString((String)((String)indicatorInfo.get("columnInfo")), List.class);
            Map<Object, Tuple2> columnMap = columnInfo.stream().collect(Collectors.toMap(m -> m.get("columnId"), m -> new Tuple2((Object)m.get("columnNumber").toString(), (Object)m.get("columnType").toString())));
            for (DynamicObject dy : dynamicObjects) {
                Map indicators = (Map)SerializationUtils.fromJsonString((String)((String)rowData.get(dy.get("monitor"))), Map.class);
                for (Map.Entry<Object, Tuple2> entry : columnMap.entrySet()) {
                    Object columnId = entry.getKey();
                    Tuple2 tuple2 = entry.getValue();
                    String number = (String)tuple2.t1;
                    String type = (String)tuple2.t2;
                    if (!StringUtils.equals((CharSequence)IndicatorsTypeEnum.MANUAL.getType(), (CharSequence)type)) continue;
                    indicators.put(columnId.toString(), dy.getString(number));
                    rowData.put(dy.getString("monitor"), SerializationUtils.toJsonString((Object)indicators));
                }
            }
            indicatorInfo.put("rowData", SerializationUtils.toJsonString((Object)rowData));
            String info = SerializationUtils.toJsonString((Object)indicatorInfo);
            this.getModel().setValue("indicatortext_tag", (Object)info);
            this.getModel().setValue("indicatortext", (Object)info.substring(0, 255));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("submit")) {
            String indicatorInfo = (String)this.getModel().getValue("indicatortext_tag");
            this.openRuleView(indicatorInfo);
        }
    }

    private void openRuleView(String info) {
        FormShowParameter paramEdit = new FormShowParameter();
        paramEdit.setFormId("som_monitorindex");
        paramEdit.getOpenStyle().setTargetKey("monitorindexsubflex");
        paramEdit.getOpenStyle().setShowType(ShowType.InContainer);
        if (StringUtils.isNotBlank((CharSequence)info)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
            paramEdit.setCustomParam("columnInfo", map.get("columnInfo"));
            paramEdit.setCustomParam("rowData", map.get("rowData"));
        }
        paramEdit.setCustomParam("detailParams", (Object)info);
        paramEdit.setCustomParam("reportStatus", (Object)((String)this.getModel().getValue("billstatus")));
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("showPage", paramEdit.getPageId());
        this.getView().showForm(paramEdit);
    }
}

