/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptQualityCheckProgressFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String KEY_RPTQCPROGRESS_FIRSTROAD = "rptQCProgressFirstRoad";
    private List<FilterColumn> commonFilters;

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        ReportList reportlist = (ReportList)this.getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            int taskcount = row.getInt("taskcount");
            int taskcompletecount = row.getInt("taskcompletecount");
            int pointcount = row.getInt("pointcount");
            int pointfailcount = row.getInt("pointfailcount");
            if (taskcount != 0) {
                row.set("completerate", (Object)(100.0 * (double)taskcompletecount / (double)taskcount));
            } else {
                row.set("completerate", (Object)0);
            }
            if (pointcount != 0) {
                row.set("pointfailrate", (Object)(100.0 * (double)pointfailcount / (double)pointcount));
                continue;
            }
            row.set("pointfailrate", (Object)0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscId = "-1";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)KEY_RPTQCPROGRESS_FIRSTROAD)) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                QFilter filter;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sharecenter.name".equals(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscId = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscId);
                    commonFilterColumn.setDefValue(sscId);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put("sscid", sscId);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)KEY_RPTQCPROGRESS_FIRSTROAD), "true");
                    continue;
                }
                if ("receivetime".equals(fieldName)) {
                    filterColumn.setDefaultValue("63");
                    continue;
                }
                if ("org".equals(fieldName)) {
                    filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "qualityCheckProgress_orgFilter", sscId);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckProgress_org", commonFilterColumn, "bos_org", filter, sscId, false);
                    continue;
                }
                if ("qualitycheckscheme".equals(fieldName)) {
                    if (!StringUtils.isNotBlank((CharSequence)sscId)) continue;
                    filter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscId));
                    filter.and(new QFilter("status", "=", (Object)"C"));
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckProgress_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
                    CommonFilterUtil.createSmartSchemeFilter(commonFilterColumn, Long.parseLong(sscId));
                    continue;
                }
                if (!"qualitysamplelibrary".equals(fieldName)) continue;
                List<ComboItem> allQualitySampleLib = this.queryAllQualitySampleLibFromDb(CommonFilterUtil.getSscIdList(sscId));
                commonFilterColumn.setComboItems(allQualitySampleLib);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter;
        super.filterContainerSearchClick(args);
        List<String> nullFieldValues0 = Arrays.asList("tasktype.id", "taskbill.id");
        String cacheSscId = CommonFilterUtil.handleMultiSelectSSC(args, "sharecenter.id", nullFieldValues0);
        if (CommonFilterUtil.hasSsc(cacheSscId)) {
            this.getPageCache().put("sscid", CommonFilterUtil.getSscIdListString(cacheSscId));
        }
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        List<String> nullFieldValues = Arrays.asList("org.id", "qualitycheckscheme.id");
        String sscId = CommonFilterUtil.handleMultiSelectSSC(args, "sharecenter.id", nullFieldValues);
        for (FilterColumn filterColumn : this.commonFilters) {
            QFilter filter;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!CommonFilterUtil.hasSsc(sscId)) break;
            List<Long> sscIdList = CommonFilterUtil.getSscIdList(sscId);
            if ("org".equalsIgnoreCase(fieldName)) {
                if (!CommonFilterUtil.hasSsc(sscId)) continue;
                filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "qualityCheckProgress_orgFilter", sscId);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckProgress_org", commonFilterColumn, "bos_org", filter, sscId, false);
                continue;
            }
            if ("qualitycheckscheme".equalsIgnoreCase(fieldName)) {
                if (!CommonFilterUtil.hasSsc(sscId)) continue;
                filter = new QFilter("ssccenter.id", "in", sscIdList);
                filter.and(new QFilter("status", "=", (Object)"C"));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckProgress_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
                sscIdList.forEach(id -> CommonFilterUtil.createSmartSchemeFilter(commonFilterColumn, id));
                continue;
            }
            if (!"qualitysamplelibrary".equalsIgnoreCase(fieldName)) continue;
            String curFieldName = (String)((List)args.getCurrentCommonFilter().get("FieldName")).get(0);
            this.clearSelectedPoints(args, curFieldName);
            if (StringUtils.equals((CharSequence)"sharecenter.id", (CharSequence)curFieldName)) {
                List<ComboItem> allQualitySampleLib = this.queryAllQualitySampleLibFromDb(sscIdList);
                commonFilterColumn.setComboItems(allQualitySampleLib);
                continue;
            }
            Optional<Object> qualityCheckSchemeIdOptional = args.getFilterParameter().getQFilters().stream().filter(qFilter -> "qualitycheckscheme.id".equals(qFilter.getProperty())).map(QFilter::getValue).findFirst();
            Long checkSchemeId = qualityCheckSchemeIdOptional.isPresent() ? (Long)qualityCheckSchemeIdOptional.get() : -1L;
            List<ComboItem> comboItemsFromCache = this.querySampleLibFromCache(checkSchemeId, sscId);
            if (comboItemsFromCache != null) {
                commonFilterColumn.setComboItems(comboItemsFromCache);
                continue;
            }
            List<ComboItem> comboItemsFromDb = this.querySampleLibFromDb(sscIdList, checkSchemeId);
            commonFilterColumn.setComboItems(comboItemsFromDb);
        }
        if ("sharecenter.id".equals(((List)(currentCommonFilter = args.getCurrentCommonFilter()).get("FieldName")).get(0))) {
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                String propName = next.getPropName();
                if ("sharecenter.id".equals(propName) || "receivetime".equals(propName) || "aduittype".equals(propName)) continue;
                iterator.remove();
            }
        }
    }

    private List<ComboItem> querySampleLibFromDb(List<Long> sscId, Long checkSchemeId) {
        QFilter filters;
        ArrayList<ComboItem> retComboItems = new ArrayList(16);
        if (checkSchemeId == -1L) {
            retComboItems = this.queryAllQualitySampleLibFromDb(sscId);
        } else if (checkSchemeId == 0L) {
            filters = new QFilter("smartcheckscheme.ssccenter.id", "in", sscId);
            filters.and(new QFilter("issmart", "=", (Object)"1"));
            retComboItems = CommonFilterUtil.getComboItems("task_qualitysamplelibrary", filters, "createtime desc");
        } else {
            filters = new QFilter("checkscheme", "=", (Object)checkSchemeId);
            filters.and(new QFilter("checkscheme.ssccenter.id", "in", sscId));
            retComboItems = CommonFilterUtil.getComboItems("task_qualitysamplelibrary", filters, "createtime desc");
        }
        String cbItemStr = SerializationUtils.toJsonString(retComboItems);
        String cachkey = CacheKey.getSOMKey((Object)"qualityCheckProgress_samplelib", (Object)(sscId + "_" + checkSchemeId));
        this.getPageCache().put(cachkey, cbItemStr);
        return retComboItems;
    }

    private List<ComboItem> querySampleLibFromCache(Long qualityCheckSchemeId, String sscId) {
        String cachkey = CacheKey.getSOMKey((Object)"qualityCheckProgress_samplelib", (Object)(sscId + "_" + qualityCheckSchemeId));
        IPageCache pageCache = this.getPageCache();
        String cbItemStr = pageCache.get(cachkey);
        if (StringUtils.isEmpty((CharSequence)cbItemStr)) {
            return null;
        }
        return SerializationUtils.fromJsonStringToList((String)cbItemStr, ComboItem.class);
    }

    private List<ComboItem> queryAllQualitySampleLibFromDb(List<Long> sscId) {
        QFilter filter = new QFilter("checkscheme.ssccenter.id", "in", sscId);
        List<ComboItem> comboItems = CommonFilterUtil.getComboItems("task_qualitysamplelibrary", filter, "createtime desc");
        QFilter filters = new QFilter("smartcheckscheme.ssccenter.id", "in", sscId);
        filters.and(new QFilter("issmart", "=", (Object)"1"));
        DynamicObjectCollection sampleLibraries = QueryServiceHelper.query((String)"task_qualitysamplelibrary", (String)"id,number,name", (QFilter[])new QFilter[]{filters});
        if (!sampleLibraries.isEmpty()) {
            sampleLibraries.forEach(lib -> comboItems.add(new ComboItem(new LocaleString(lib.get("number") + ""), lib.get("id") + "")));
        }
        return comboItems;
    }

    private void clearSelectedPoints(FilterContainerSearchClickArgs args, String curFieldName) {
        if (!StringUtils.equals((CharSequence)"sharecenter.id", (CharSequence)curFieldName) && !StringUtils.equals((CharSequence)"qualitycheckscheme.id", (CharSequence)curFieldName)) {
            return;
        }
        List customlist = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        Optional<List> qualitySampleLibraryValue = customlist.stream().filter(map -> "qualitysamplelibrary.id".equals(((List)map.get("FieldName")).get(0).toString())).map(map -> (List)map.get("Value")).findFirst();
        qualitySampleLibraryValue.ifPresent(list -> list.clear());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"RptQualityCheckProgressFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperlinkclickevent) {
        String fieldName = hyperlinkclickevent.getFieldName();
        DynamicObject selectData = hyperlinkclickevent.getRowData();
        if (selectData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u60a8\u8981\u67e5\u770b\u7684\u6570\u636e\u3002", (String)"RptQualityCheckProgressFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject person = selectData.getDynamicObject("person");
        if (person == null) {
            return;
        }
        Object personid = person.getPkValue();
        ReportQueryParam param = this.getQueryParam();
        FilterInfo filterInfo = param.getFilter();
        filterInfo.addFilterItem("personid", personid);
        String state = "";
        if ("taskdonecount".equalsIgnoreCase(fieldName)) {
            state = "done";
        } else if ("taskundocount".equalsIgnoreCase(fieldName)) {
            state = "undo";
        }
        filterInfo.addFilterItem("state", (Object)state);
        this.showDetailReportForm(param);
    }

    private void showDetailReportForm(ReportQueryParam queryParam) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("task_qcprogressdetailrpt");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        report.setQueryParam(queryParam);
        report.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u8fdb\u5ea6\u660e\u7ec6\u62a5\u8868", (String)"RptQualityCheckProgressFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)report);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List qfilters = args.getQfilters();
        String sscid = this.getPageCache().get("sscid");
        List<Long> sscIdList = CommonFilterUtil.getSscIdList(sscid);
        String name = args.getFieldName();
        if (CommonFilterUtil.hasSsc(sscid)) {
            if ("qualitycheckscheme.id".equals(name)) {
                qfilters.add(new QFilter("ssccenter", "in", sscIdList));
            } else if ("qualitysamplelibrary.id".equals(name)) {
                long checkSchemeId;
                args.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
                List filterValue = this.getView().getControlFilters().getFilter("qualitycheckscheme.id");
                long l = checkSchemeId = filterValue == null || filterValue.isEmpty() || "".equals(filterValue.get(0)) ? -1L : Long.parseLong(filterValue.get(0).toString());
                if (checkSchemeId == -1L) {
                    QFilter qFilter = new QFilter("smartcheckscheme.ssccenter.id", "in", sscIdList);
                    qFilter.and(new QFilter("issmart", "=", (Object)"1"));
                    qFilter.or(new QFilter("checkscheme.ssccenter.id", "in", sscIdList));
                    qfilters.add(qFilter);
                } else if (checkSchemeId == 0L) {
                    qfilters.add(new QFilter("smartcheckscheme.ssccenter.id", "in", sscIdList));
                    qfilters.add(new QFilter("issmart", "=", (Object)"1"));
                } else {
                    qfilters.add(new QFilter("checkscheme", "=", (Object)checkSchemeId));
                    qfilters.add(new QFilter("checkscheme.ssccenter.id", "in", sscIdList));
                }
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_qcprogressrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptQualityCheckProgressFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

