/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.ExportExcel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.RptTaskPersonalRankPlugin;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptTaskPersonalRankFormPlugin
extends AbstractReportFormPlugin {
    private static final String KEY_RPTPERSONRANK_FIRSTROAD = "rptPersonRankFirstRoad";
    private List<FilterColumn> commonFilters = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel) {
            int isPermission;
            Long userId = RequestContext.get().getCurrUserId();
            Long sscId = Long.parseLong(this.getPageCache().get(CacheKey.getSSCKey((Object)"rptPersonRankOldSSC")));
            String appId = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = "ssc";
            }
            if ((isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_personalrankrpt", (String)"4730fc9f000004ae")) != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4e2a\u4eba\u4efb\u52a1\u6392\u540d\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"RptTaskPersonalRankFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (int j = 0; j < rowData.size(); ++j) {
            DynamicObject dyn = (DynamicObject)rowData.get(j);
            String rankStr = (String)queryParam.getFilter().getFilterItem("ranksel").getValue();
            String rowCountStr = this.getPageCache().get("rowCount");
            int rowCount = 0;
            if (rowCountStr != null) {
                rowCount = Integer.parseInt(rowCountStr);
            }
            if ("tail5".equals(rankStr)) {
                dyn.set("rank", (Object)(rowCount - j));
                continue;
            }
            if ("tail10".equals(rankStr)) {
                dyn.set("rank", (Object)(rowCount - j));
                continue;
            }
            dyn.set("rank", dyn.get("fseq"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("ranksel".equals(e.getProperty().getName())) {
            this.getView().refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        String curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
        String curValue = (String)((List)currentCommonFilter.get("Value")).get(0);
        String oldSSC = this.getPageCache().get(CacheKey.getSSCKey((Object)"rptPersonRankOldSSC"));
        if ("sharecenter.id".equals(curFieldName) && !curValue.equals(oldSSC)) {
            this.getPageCache().put(CacheKey.getSSCKey((Object)"rptPersonRankOldSSC"), curValue);
            Map filterValues = args.getFilterValues();
            List customfilter = (List)filterValues.get("customfilter");
            customfilter.forEach(filter -> {
                String fieldName = (String)((List)filter.get("FieldName")).get(0);
                if ("tasktype.id".equals(fieldName)) {
                    ((List)filter.get("Value")).set(0, "");
                }
            });
            List filterItems = this.getQueryParam().getFilter().getFilterItems();
            Iterator iterator = filterItems.iterator();
            while (iterator.hasNext()) {
                FilterItemInfo next = (FilterItemInfo)iterator.next();
                String propName = next.getPropName();
                if (!"tasktype.id".equals(propName)) continue;
                iterator.remove();
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("ranksel");
        String valueStr = (String)this.getModel().getValue("ranksel");
        if (itemInfo != null) {
            if (valueStr == null || valueStr.trim().equals("")) {
                itemInfo.setValue((Object)"topAll");
            } else {
                itemInfo.setValue((Object)valueStr);
            }
        } else if (valueStr != null && !valueStr.trim().equals("")) {
            filterInfo.addFilterItem("ranksel", (Object)valueStr);
        } else {
            filterInfo.addFilterItem("ranksel", (Object)"topAll");
        }
        filterInfo.addFilterItem("pageID", (Object)this.getView().getPageId());
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            FilterInfo oFilterInfo;
            FilterItemInfo oItemInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"tasktype".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sharecenter.id")) == null) continue;
            Object sscFilterValue = oItemInfo.getValue();
            QFilter idFilter = new QFilter("orgfield.id", "in", sscFilterValue);
            QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptPersonRankTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, false);
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)KEY_RPTPERSONRANK_FIRSTROAD)) == null) {
            for (FilterColumn filterColumn : contInitEvent.getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sharecenter.name".equalsIgnoreCase(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscid);
                    commonFilterColumn.setDefValue(sscid);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)"rptPersonRankOldSSC"), sscid);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)KEY_RPTPERSONRANK_FIRSTROAD), "true");
                    continue;
                }
                if ("receivetime".equalsIgnoreCase(fieldName)) {
                    filterColumn.setDefaultValue("63");
                    continue;
                }
                if (!"tasktype".equalsIgnoreCase(fieldName) || kd.bos.orm.util.StringUtils.isEmpty((Object)sscid)) continue;
                QFilter idFilter = new QFilter("orgfield.id", "=", (Object)Long.valueOf(sscid));
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptPersonRankTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter).and(enableFilter), sscid, false);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("tasktype.id".equals(args.getFieldName())) {
            List filters = args.getQfilters();
            filters.add(new QFilter("orgfield.id", "=", (Object)Long.parseLong(this.getPageCache().get(CacheKey.getSSCKey((Object)"rptPersonRankOldSSC")))));
            filters.add(new QFilter("qualityjudge", "=", (Object)"0"));
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        int i;
        this.managerChart(queryParam);
        String rankStr = (String)queryParam.getFilter().getFilterItem("ranksel").getValue();
        if (rankStr != null && rankStr.startsWith("tail")) {
            queryParam.getFilter().getFilterItem("ranksel").setValue((Object)"top5");
            new RptTaskPersonalRankPlugin().query(queryParam, null);
        }
        Map<Long, Double> rankList = new RptTaskPersonalRankPlugin().getRankID(this.getView().getPageId());
        double rowCount = rankList.get(-1L);
        for (i = 1; i <= 5; ++i) {
            this.getModel().setValue("user" + i, null);
            ((Label)this.getControl("username" + i)).setText(null);
            ((Label)this.getControl("score" + i)).setText("0.0");
        }
        i = 0;
        Set<Map.Entry<Long, Double>> entrySet = rankList.entrySet();
        for (Map.Entry<Long, Double> entry : entrySet) {
            if (i > 5) break;
            if (i == 0) {
                this.getPageCache().put("rowCount", (int)rowCount + "");
            }
            if (i >= 1 && entry.getKey() != 0L) {
                this.getModel().setValue("user" + i, (Object)entry.getKey());
                Object userName = this.getModel().getValue("user" + i);
                if (userName != null) {
                    ((Label)this.getControl("username" + i)).setText(((DynamicObject)userName).getString("name"));
                    ((Label)this.getControl("score" + i)).setText(String.valueOf(entry.getValue()));
                }
            }
            ++i;
        }
    }

    private void managerChart(ReportQueryParam queryParam) {
        Chart customchart = (Chart)this.getControl("chart1");
        customchart.clearData();
        customchart.setShowTitle(false);
        customchart.setShowTooltip(true);
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.center, YAlign.bottom);
        customchart.setMargin(Position.bottom, "40px");
        customchart.setMargin(Position.left, "20px");
        Axis xaxis = customchart.createXAxis("", AxisType.category);
        xaxis.setPosition(Position.bottom);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>(3);
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", Integer.valueOf(0));
        axisLabel.put("rotate", Integer.valueOf(0));
        xaxis.setPropValue("axisLabel", axisLabel);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u4efb\u52a1\u91cf", (String)"RptTaskPersonalRankFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        String stack = "sss";
        expireSeries.setStack(stack);
        expireSeries.setBarWidth("40%");
        expireSeries.setColor("#6680fb");
        expireSeries.getLabel().setShow(false);
        BarSeries expireSeries2 = customchart.createBarSeries(ResManager.loadKDString((String)"\u5904\u7406\u4e2d\u4efb\u52a1\u91cf", (String)"RptTaskPersonalRankFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        expireSeries2.setStack(stack);
        expireSeries2.setBarWidth("40%");
        expireSeries2.setColor("#80c342");
        expireSeries2.getLabel().setShow(false);
        ArrayList<Double> l1 = new ArrayList<Double>();
        ArrayList<Double> l2 = new ArrayList<Double>();
        this.setChartsData(queryParam, xaxis, l1, l2);
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u91cf", (String)"RptTaskPersonalRankFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("axisTick", axisTick);
        Number[] yData1 = l1.toArray(new Double[0]);
        Number[] yData2 = l2.toArray(new Double[0]);
        Double maxTask = this.getMaxNumber((Double[])yData1, (Double[])yData2);
        this.setYAxisMaxValue(yAxis, maxTask);
        yAxis.setPropValue("axisLine", axisTick);
        expireSeries.setData(yData1);
        expireSeries2.setData(yData2);
        customchart.refresh();
    }

    private void setChartsData(ReportQueryParam queryParam, Axis xaxis, ArrayList<Double> yData1, ArrayList<Double> yData2) {
        Map<String, Double> map = new RptTaskPersonalRankPlugin().getData(this.getView().getPageId(), "rankcoefficient");
        Map<String, Double> map2 = new RptTaskPersonalRankPlugin().getData(this.getView().getPageId(), "processingrankcoefficient");
        ArrayList<String> xDimensions = new ArrayList<String>();
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            String key = entry.getKey();
            xDimensions.add(key);
            Double yDate1InMap = map.get(key);
            Double yData2InMap = map2.get(key);
            yDate1InMap = yDate1InMap == null ? Double.valueOf(0.0) : yDate1InMap;
            yData2InMap = yData2InMap == null ? Double.valueOf(0.0) : yData2InMap;
            yData1.add(yDate1InMap);
            yData2.add(yData2InMap);
        }
        for (int i = xDimensions.size(); i < 10; ++i) {
            xDimensions.add("");
        }
        xaxis.setCategorys(xDimensions);
    }

    private void setYAxisMaxValue(Axis yAxis, double maxTask) {
        double baseParam = maxTask <= 100.0 ? 25.0 : (maxTask > 100.0 && maxTask <= 500.0 ? 50.0 : (maxTask > 500.0 && maxTask <= 1000.0 ? 100.0 : (maxTask > 1000.0 && maxTask <= 5000.0 ? 500.0 : (maxTask > 5000.0 && maxTask <= 10000.0 ? 1000.0 : (maxTask > 10000.0 && maxTask <= 50000.0 ? 5000.0 : (maxTask >= 50000.0 && maxTask < 100000.0 ? 10000.0 : 50000.0))))));
        Double yMaxValue = BigDecimal.valueOf(maxTask).compareTo(new BigDecimal(0)) != 0 && BigDecimal.valueOf(maxTask % baseParam).compareTo(new BigDecimal(0)) == 0 ? maxTask : (double)(Math.floorDiv((long)maxTask, (long)baseParam) + 1L) * baseParam;
        Double interval = yMaxValue / 5.0;
        if (maxTask < 10.0) {
            yAxis.setMax((Number)10);
        } else {
            yAxis.setMax((Number)yMaxValue);
            yAxis.setInterval((Number)interval);
        }
    }

    private Double getMaxNumber(Double[] ary, Double[] ary2) {
        if (ary == null || ary.length == 0) {
            return 10.0;
        }
        Double max = ary[0];
        for (int i = 0; i < ary.length && i < ary2.length && ary2[i] != null && ary[i] != null; ++i) {
            max = Math.max(ary[i] + ary2[i], max);
        }
        return max;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"RptTaskPersonalRankFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String pageID = this.getView().getPageId();
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)pageID)) {
            SscDistributeCache.remove((String)pageID);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_personalrankrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptTaskPersonalRankFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

