/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.rpt.RptConstant;
import kd.ssc.task.formplugin.rpt.RptQualityCheckCommon;
import kd.ssc.task.util.ConverterUtil;

public class RptUnpassCheckPointQueryPlugin
extends AbstractReportListDataPlugin {
    private Boolean isorgdim = Boolean.FALSE;
    private Boolean ishandlepersondim = Boolean.FALSE;
    private Boolean isbilltypedim = Boolean.FALSE;
    private static final String ENTITY_TASKHISTORY = "task_taskhistory";
    private static final Log log = LogFactory.getLog(RptUnpassCheckPointQueryPlugin.class);
    private static final String[] SELECT_TASKCOUNT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "taskcount"};
    private static final String[] SELECT_POINTCOUNT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointcount"};
    private static final String[] SELECT_TPCOUNT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "taskcount", "pointcount"};
    private static final String[] SELECT_UNPASSTIME = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid", "pointname", "unpasstime"};
    private static final String[] SELECT_TOTALUNPASSTIME = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "totalunpasstime"};
    private static final String[] SELECT_UT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid", "pointname", "unpasstime", "totalunpasstime"};
    private static final String[] SELECT_All = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid", "pointname", "taskcount", "pointcount", "unpasstime", "totalunpasstime"};
    private static final String[] GROUPBY_TASKCOUNT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic"};
    private static final String[] GROUPBY_POINTCOUNT = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid"};
    private static final String[] GROUPBY_POINTCOUNT2 = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic"};
    private static final String[] GROUPBY_UNPASSTIME = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid"};
    private static final String[] GROUPBY_UNPASSTIME2 = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid", "name as pointname"};
    private static final String[] GROUPBY_UNPASSTIME3 = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic", "pointid", "pointname"};
    private static final String[] GROUPBY_TOTALUNPASSTIME = new String[]{"orgid", "orgname", "billtypeid", "billtypename", "tasktypeid", "tasktypename", "personid", "personname", "personpic"};

    private void initDim(ReportQueryParam param) {
        Object dimObj;
        FilterItemInfo filterItem = param.getFilter().getFilterItem("dimension");
        Object object = dimObj = filterItem == null ? null : filterItem.getValue();
        if (dimObj == null) {
            return;
        }
        List dimValues = (List)dimObj;
        this.isorgdim = dimValues.contains("orgdim");
        this.ishandlepersondim = dimValues.contains("handlepersondim");
        this.isbilltypedim = dimValues.contains("billtypedim");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam rqParam, Object obj) throws Throwable {
        this.initDim(rqParam);
        DataSet dsRet = null;
        DataSet dsTask = null;
        DataSet dsPassTask = null;
        DataSet dsFailTask = null;
        DataSet dsMessageRecord = null;
        DataSet dsCheckingPoint = null;
        DataSet dsTempTask = null;
        DataSet dsTempTaskMessageRecord = null;
        Object dsUnpassCheckingPoint = null;
        DataSet dsTempUnpassCheckingPoint = null;
        DataSet dsTempTotalUnpassCheckingPoint = null;
        List<String> partFieldList = this.getGroupByFields(true);
        String[] selectFieldArray = new String[partFieldList.size()];
        partFieldList.toArray(selectFieldArray);
        try {
            DataSet retGroupByFields;
            dsTask = this.getTaskDataSet(rqParam);
            if (this.isorgdim.booleanValue() || this.isbilltypedim.booleanValue() || this.ishandlepersondim.booleanValue()) {
                retGroupByFields = this.getGroupByFields(false);
                String[] retGroupByFieldArray = new String[retGroupByFields.size()];
                retGroupByFields.toArray(retGroupByFieldArray);
                ArrayList<String> retPassSelectFields = new ArrayList<String>();
                retPassSelectFields.addAll((Collection<String>)retGroupByFields);
                retPassSelectFields.add("taskcount");
                String[] retPassSelectFieldArray = new String[retPassSelectFields.size()];
                retPassSelectFields.toArray(retPassSelectFieldArray);
                dsPassTask = dsTask.groupBy(retGroupByFieldArray).count("taskcount").finish();
                dsPassTask = dsPassTask.select(retPassSelectFieldArray);
                ArrayList<String> retFailSelectFields = new ArrayList<String>();
                retFailSelectFields.addAll((Collection<String>)retGroupByFields);
                retFailSelectFields.add("(case when unpasstime is null then 0 else unpasstime end) as unpasstime");
                String[] retFailSelectFieldArray = new String[retFailSelectFields.size()];
                retFailSelectFields.toArray(retFailSelectFieldArray);
                dsFailTask = dsTask.filter("qualityresult = '0'").groupBy(retGroupByFieldArray).count("unpasstime").finish();
                dsFailTask = dsFailTask.select(retFailSelectFieldArray);
                ArrayList<String> retSelectFields = new ArrayList<String>();
                retSelectFields.addAll((Collection<String>)retGroupByFields);
                retSelectFields.add("(case when taskcount is null then 0 else taskcount end) as taskcount");
                retSelectFields.add("(case when unpasstime is null then 0 else unpasstime end) as unpasstime");
                String[] retSelectFieldsArray = new String[retSelectFields.size()];
                retSelectFields.toArray(retSelectFieldsArray);
                JoinDataSet tempDsRet = dsPassTask.join(dsFailTask, JoinType.LEFT);
                if (this.isorgdim.booleanValue()) {
                    tempDsRet.on("orgid", "orgid");
                } else if (this.isbilltypedim.booleanValue()) {
                    tempDsRet.on("billtypeid", "billtypeid");
                } else if (this.ishandlepersondim.booleanValue()) {
                    tempDsRet.on("personid", "personid");
                }
                dsRet = tempDsRet.select(retSelectFieldsArray).finish();
            } else {
                dsMessageRecord = RptQualityCheckCommon.getAllMessageRecordDataSet();
                dsCheckingPoint = RptQualityCheckCommon.getAllCheckPointDataSet();
                dsTempTask = dsTask.select(GROUPBY_TASKCOUNT).groupBy(GROUPBY_TASKCOUNT).count("taskcount").finish();
                dsTempTask = dsTempTask.select(SELECT_TASKCOUNT);
                dsTempTaskMessageRecord = dsTask.join(dsMessageRecord, JoinType.LEFT).on("id", "taskid").select(GROUPBY_POINTCOUNT).finish();
                dsTempTaskMessageRecord = dsTempTaskMessageRecord.groupBy(GROUPBY_POINTCOUNT).finish();
                dsTempTaskMessageRecord = dsTempTaskMessageRecord.groupBy(GROUPBY_POINTCOUNT2).count("pointcount").finish();
                dsTempTaskMessageRecord = dsTempTaskMessageRecord.select(SELECT_POINTCOUNT);
                dsTempTask = dsTempTask.join(dsTempTaskMessageRecord, JoinType.INNER).on("orgid", "orgid").on("tasktypeid", "tasktypeid").on("billtypeid", "billtypeid").on("personid", "personid").select(SELECT_TPCOUNT).finish();
                dsTempUnpassCheckingPoint = dsTask.filter("qualityresult = '0'").join(dsMessageRecord.filter("reviewmethod = '1' and messagetype = '0' and isnewmessage = 1"), JoinType.LEFT).on("id", "taskid").select(GROUPBY_UNPASSTIME).finish();
                dsTempUnpassCheckingPoint = dsTempUnpassCheckingPoint.join(dsCheckingPoint, JoinType.LEFT).on("pointid", "id").select(GROUPBY_UNPASSTIME2).finish();
                dsTempUnpassCheckingPoint = dsTempUnpassCheckingPoint.groupBy(GROUPBY_UNPASSTIME3).count("unpasstime").finish();
                dsTempUnpassCheckingPoint = dsTempUnpassCheckingPoint.select(SELECT_UNPASSTIME);
                dsTempTotalUnpassCheckingPoint = dsTempUnpassCheckingPoint.groupBy(GROUPBY_TOTALUNPASSTIME).sum("unpasstime", "totalunpasstime").finish();
                dsTempTotalUnpassCheckingPoint = dsTempTotalUnpassCheckingPoint.select(SELECT_TOTALUNPASSTIME);
                dsTempUnpassCheckingPoint = dsTempUnpassCheckingPoint.join(dsTempTotalUnpassCheckingPoint, JoinType.LEFT).on("orgid", "orgid").on("tasktypeid", "tasktypeid").on("billtypeid", "billtypeid").on("personid", "personid").select(SELECT_UT).finish();
                dsRet = dsTempTask.join(dsTempUnpassCheckingPoint, JoinType.LEFT).on("orgid", "orgid").on("tasktypeid", "tasktypeid").on("billtypeid", "billtypeid").on("personid", "personid").select(SELECT_All).finish();
            }
            retGroupByFields = dsRet;
            return retGroupByFields;
        }
        catch (KDException e) {
            log.error("\u8def\u5f84kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.query\u51fa\u9519\uff1a", (Throwable)e);
        }
        finally {
            if (dsTask != null) {
                dsTask.close();
            }
            if (dsPassTask != null) {
                dsPassTask.close();
            }
            if (dsFailTask != null) {
                dsFailTask.close();
            }
            if (dsMessageRecord != null) {
                dsMessageRecord.close();
            }
            if (dsCheckingPoint != null) {
                dsCheckingPoint.close();
            }
            if (dsTempTask != null) {
                dsTempTask.close();
            }
            if (dsTempTaskMessageRecord != null) {
                dsTempTaskMessageRecord.close();
            }
            if (dsTempUnpassCheckingPoint != null) {
                dsTempUnpassCheckingPoint.close();
            }
            if (dsTempTotalUnpassCheckingPoint != null) {
                dsTempTotalUnpassCheckingPoint.close();
            }
        }
        return dsRet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        RptQualityCheckCommon.createDimensionColumns(columnList, this.getQueryParam(), columns);
        this.handleReportListColumn(columns);
        return columnList;
    }

    private void handleReportListColumn(List<AbstractReportColumn> columnList) {
        Object dimObj;
        FilterItemInfo filterItem = this.getQueryParam().getFilter().getFilterItem("dimension");
        Object object = dimObj = filterItem == null ? null : filterItem.getValue();
        if (dimObj == null) {
            return;
        }
        List<String> hideKeys = Arrays.asList("pointcount", "pointname", "unpasspercent");
        for (AbstractReportColumn item : columnList) {
            ReportColumn curItem;
            String fieldKey;
            if (RptConstant.getQualitycheckperson().equals((Object)item.getCaption()) || !hideKeys.contains(fieldKey = (curItem = (ReportColumn)item).getFieldKey())) continue;
            curItem.setHide(true);
        }
    }

    private DataSet getTaskDataSet(ReportQueryParam rqParam) {
        ORM orm = ORM.create();
        QFilter[] filters = this.getFilters(rqParam);
        ArrayList<String> selectFieldList = new ArrayList<String>();
        selectFieldList.add("id");
        selectFieldList.addAll(this.getFields());
        selectFieldList.add("qualityresult");
        String selectFields = ConverterUtil.listConvertToString(selectFieldList);
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getTaskDataSet", ENTITY_TASKHISTORY, selectFields, filters);
        return dsRet;
    }

    private List<String> getFields() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("orgid.name as orgname");
        fieldList.add("orgid.id as orgid");
        fieldList.add("billtype.name as billtypename");
        fieldList.add("billtype.id as billtypeid");
        fieldList.add("tasktypeid.name as tasktypename");
        fieldList.add("tasktypeid.id as tasktypeid");
        fieldList.add("personid.name as personname");
        fieldList.add("personid.id as personid");
        fieldList.add("personid.picturefield as personpic");
        return fieldList;
    }

    private List<String> getGroupByFields(boolean isAll) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if (isAll) {
            fieldList.add("orgname");
            fieldList.add("orgid");
            fieldList.add("billtypename");
            fieldList.add("billtypeid");
            fieldList.add("tasktypename");
            fieldList.add("tasktypeid");
            fieldList.add("personname");
            fieldList.add("personid");
            fieldList.add("personpic");
        } else if (this.isbilltypedim.booleanValue()) {
            fieldList.add("billtypename");
            fieldList.add("billtypeid");
        } else if (this.isorgdim.booleanValue()) {
            fieldList.add("orgname");
            fieldList.add("orgid");
        } else if (this.ishandlepersondim.booleanValue()) {
            fieldList.add("personname");
            fieldList.add("personid");
            fieldList.add("personpic");
        }
        return fieldList;
    }

    private QFilter[] getFilters(ReportQueryParam rqParam) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter filterQualityCheckTask = new QFilter("qualitysamplelibrary", ">", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        filterList.add(filterQualityCheckTask);
        FilterInfo filter = rqParam.getFilter();
        List filterItems = filter.getFilterItems();
        QFilter qFilter = null;
        for (FilterItemInfo itemInfo : filterItems) {
            List<Long> ids;
            String propName = itemInfo.getPropName();
            if ("completetime".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("completetime", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("sharecenter.id".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("sscid.id", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("sharecenter.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("sscid.id", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if ("org.id".equals(propName)) {
                qFilter = new QFilter("orgid.id", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("org.name".equals(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("orgid.id", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if ("aduittype".equals(propName)) {
                qFilter = new QFilter("autoprocess", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("qualitycheckscheme.id".equals(propName)) {
                QFilter tempFilter = "0".equals(itemInfo.getValue() + "") ? new QFilter("issmart", "=", (Object)Character.valueOf('1')) : new QFilter("checkscheme", itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = RptQualityCheckCommon.qualitySampleLibraryFilter(tempFilter);
                if (qFilter != null) {
                    filterList.add(qFilter);
                    continue;
                }
                qFilter = new QFilter("qualitysamplelibrary.id", "=", (Object)-1);
                filterList.add(qFilter);
                continue;
            }
            if ("qualitycheckscheme.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getSchemeIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                QFilter tempFilter = new QFilter("checkscheme", "in", ids);
                qFilter = RptQualityCheckCommon.qualitySampleLibraryFilter(tempFilter);
                if (qFilter == null) continue;
                filterList.add(qFilter);
                continue;
            }
            if ("person.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getUserIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("orignalperson", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if (!"billtype.name".equalsIgnoreCase(propName)) continue;
            ids = RptQualityCheckCommon.getBillTypeFromName(itemInfo.getCompareType(), itemInfo.getValue());
            qFilter = new QFilter("billtype.id", "in", ids);
            filterList.add(qFilter);
        }
        return filterList.toArray(new QFilter[filterList.size()]);
    }
}

