/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.smartApproval.pojo.AIGeneralResult;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.pojo.SmartApprovalPredictedResult;
import kd.ssc.task.formplugin.pojo.FactorInfo;
import kd.ssc.task.formplugin.smartApproval.AffectFactorParser;

public class AIGeneralResultParser {
    public static String createPredictText(AIGeneralResult aiGeneralResult) {
        if (!aiGeneralResult.predictSuccess()) {
            return "";
        }
        IDISchemaResult schemaResult = aiGeneralResult.getSchemaResult();
        SmartApprovalPredictedResult predictResult = aiGeneralResult.getPredictResult();
        StringBuilder text = new StringBuilder();
        String head = ResManager.loadKDString((String)"\u7ed3\u5408\u5386\u53f2\u76f8\u4f3c\u5355\u636e\u5206\u6790\u53d1\u73b0\uff1a\r\n\r\n", (String)"AIGeneralResultParser_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        String schemaSuggest = schemaResult != null ? schemaResult.getSuggestDetail() : "";
        String but = ResManager.loadKDString((String)"\u4f46\u662f", (String)"AIGeneralResultParser_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        String predictSuggest = predictResult.getSuggestDetail();
        String end = String.format(ResManager.loadKDString((String)"\u672c\u5355\u636e\u4e3a%1$s\u5355\u636e\uff0c\u5efa\u8bae\u5ba1\u6279\u7ed3\u679c\u4e3a\uff1a%2$s\u3002", (String)"AIGeneralResultParser_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), aiGeneralResult.getAiRiskLevel().getText(), aiGeneralResult.getIsPassEnum().getText());
        if (schemaResult != null && aiGeneralResult.schemaSuccess()) {
            text.append(String.format(ResManager.loadKDString((String)"\u57fa\u4e8eAI\u673a\u5668\u5b66\u4e60+\u89c4\u5219\u5f15\u64ce+\u5927\u6570\u636e\u6316\u6398\u6280\u672f\uff0c%s", (String)"AIGeneralResultParser_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), head));
            if (schemaResult.isPass().booleanValue() && predictResult.isPass()) {
                text.append(predictSuggest);
            } else if (schemaResult.isPass().booleanValue() && !predictResult.isPass()) {
                text.append(schemaSuggest).append(String.format(ResManager.loadKDString((String)"\u4f46\u662f%s", (String)"AIGeneralResultParser_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), predictSuggest));
            } else if (!schemaResult.isPass().booleanValue() && predictResult.isPass()) {
                text.append(schemaSuggest);
            } else if (!schemaResult.isPass().booleanValue() && !predictResult.isPass()) {
                text.append(schemaSuggest).append(String.format(ResManager.loadKDString((String)"\u6b64\u5916\uff0c%s", (String)"AIGeneralResultParser_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), predictSuggest));
            }
            text.append(end);
        } else {
            text.append(String.format(ResManager.loadKDString((String)"\u57fa\u4e8eAI\u673a\u5668\u5b66\u4e60+\u5927\u6570\u636e\u6316\u6398\u6280\u672f\uff0c%s", (String)"AIGeneralResultParser_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), head)).append(predictSuggest).append(end);
        }
        return text.toString();
    }

    public static Map<String, Object> getTop5AffectFactors(long taskId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject taskApprovalResult = BusinessDataServiceHelper.loadSingle((String)"task_approval_result", (QFilter[])new QFilter[]{filter});
        HashMap<String, FactorInfo> fieldName2Info = AffectFactorParser.parseAffectFactorInfo(taskApprovalResult);
        List factorInfoList = fieldName2Info.values().stream().sorted((e1, e2) -> e2.getValue().compareTo(e1.getValue())).limit(5L).collect(Collectors.toList());
        ArrayList<String> factorString = new ArrayList<String>(factorInfoList.size());
        int size = Math.min(factorInfoList.size(), 5);
        for (int i = 0; i < size; ++i) {
            FactorInfo factorInfo = (FactorInfo)factorInfoList.get(i);
            String text = factorInfo.getField() + " = " + factorInfo.getName();
            factorString.add(text);
        }
        result.put("text", factorString);
        return result;
    }
}

