/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskApprovePageInvokerEnum;
import kd.ssc.smartApproval.enums.AIRiskLevel;
import kd.ssc.smartApproval.enums.BillFieldSourceEnum;
import kd.ssc.smartApproval.enums.IsPassEnum;
import kd.ssc.smartApproval.pojo.AIGeneralResult;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.smartApproval.pojo.SmartApprovalPredictedResult;
import kd.ssc.smartApproval.util.BillFieldExplanation;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.pojo.FactorInfo;
import kd.ssc.task.formplugin.smartApproval.AIGeneralResultParser;
import kd.ssc.task.formplugin.smartApproval.AffectFactorParser;
import kd.ssc.task.formplugin.smartApproval.PredictedDataHelper;
import kd.ssc.task.helper.TaskBillChildQueryServiceHelper;
import kd.ssc.task.util.SscLicenseUtil;

public class TaskPredictParsePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskPredictParsePlugin.class);
    public static final String KEY_TASK_ID = "taskId";
    public static final String KEY_IS_HISTORY = "isHistory";
    private AIGeneralResult aiGeneralResult;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        SscLicenseUtil.checkFeatureLicense((String)"PRO_SSC_IAA", (PreOpenFormEventArgs)e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billidlabel", "taskfp0", "taskfp1", "taskfp2"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject predictResult = this.loadApprovePredictResult();
        if (predictResult == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u4efb\u52a1\u5bf9\u5e94\u7684\u9884\u6d4b\u7ed3\u679c\u3002", (String)"TaskPredictParsePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        Long taskId = predictResult.getLong("taskid");
        this.setPredictInfo(taskId);
        this.setSimilarTask(predictResult);
        List<FactorInfo> factorInfoList = this.maskFactorInfoList(predictResult);
        this.fillFactorPanels(factorInfoList);
    }

    private AIGeneralResult createAIGeneralResult(DynamicObject task, long taskId) {
        List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)task.getLong("billtype"), (Long)task.getLong("tasktypeid"));
        IDISchemaResult schemaResult = null;
        if (idiSchemaList != null && !idiSchemaList.isEmpty()) {
            schemaResult = IDISchemaResult.getSchemaResult((Long)taskId);
        }
        SmartApprovalPredictedResult result = PredictedDataHelper.getPredictedDataByTask(taskId);
        return new AIGeneralResult(taskId, schemaResult, result);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("billidlabel")) {
            Long taskId = Long.valueOf(this.getPageCache().get(KEY_TASK_ID));
            boolean isHistory = "1".equals(this.getPageCache().get(KEY_IS_HISTORY));
            TaskApprevalHelper.showFormToApprove(this.getView(), taskId, isHistory, null, TaskApprovePageInvokerEnum.SMART_APPROVAL_SIMILAR_BILL.getValue());
        }
        if (key.startsWith("taskfp")) {
            char index = key.charAt(key.length() - 1);
            Long taskId = (Long)this.getModel().getValue("taskid" + index);
            if (taskId == null || taskId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u4efb\u52a1\u5bf9\u5e94\u7684\u9884\u6d4b\u7ed3\u679c\u3002", (String)"TaskPredictParsePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("task_predict_parse");
            showParameter.getOpenStyle().setTargetKey("tabap");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam(KEY_TASK_ID, (Object)taskId);
            this.getView().showForm(showParameter);
        }
    }

    private void setPredictInfo(Long taskId) {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"id,subject,billnumber,tasktypeid,billtype", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (task == null) {
            task = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"id,subject,billnumber,tasktypeid,billtype", (QFilter[])new QFilter("sourcetaskid", "=", (Object)taskId).toArray());
            this.getPageCache().put(KEY_IS_HISTORY, "1");
        }
        if (task == null) {
            return;
        }
        this.aiGeneralResult = this.createAIGeneralResult(task, taskId);
        this.getPageCache().put(KEY_TASK_ID, task.getString("id"));
        ((Label)this.getControl("subjectlabel")).setText(task.getString("subject"));
        ((Label)this.getControl("billidlabel")).setText(task.getString("billnumber"));
        IsPassEnum isPassEnum = this.aiGeneralResult.getIsPassEnum();
        if (isPassEnum == null) {
            return;
        }
        ((Label)this.getControl("ispasslabel")).setText(isPassEnum.getText());
        String colorStr = IsPassEnum.pass == isPassEnum ? "#1ba854" : "#ff0000";
        this.getView().updateControlMetadata("ispasslabel", Collections.singletonMap("fc", colorStr));
        AIRiskLevel aiRiskLevel = this.aiGeneralResult.getAiRiskLevel();
        if (AIRiskLevel.LOW_RISK == aiRiskLevel) {
            ((Label)this.getControl("risklabel")).setText(AIRiskLevel.LOW_RISK.getText());
            this.getView().updateControlMetadata("risklabel", Collections.singletonMap("fc", "#276FF5"));
            ((Image)this.getControl("imageap")).setUrl("/icons/pc/other/cwy_dfx.png");
        } else if (AIRiskLevel.MEDIUM_RISK == aiRiskLevel) {
            ((Label)this.getControl("risklabel")).setText(AIRiskLevel.MEDIUM_RISK.getText());
            this.getView().updateControlMetadata("risklabel", Collections.singletonMap("fc", "#FF991C"));
            ((Image)this.getControl("imageap")).setUrl("/icons/pc/other/cwy_zfx.png");
        } else if (AIRiskLevel.HIGH_RISK == aiRiskLevel) {
            ((Label)this.getControl("risklabel")).setText(AIRiskLevel.HIGH_RISK.getText());
            this.getView().updateControlMetadata("risklabel", Collections.singletonMap("fc", "#FB2323"));
            ((Image)this.getControl("imageap")).setUrl("/icons/pc/other/cwy_gfx.png");
        }
        String text = AIGeneralResultParser.createPredictText(this.aiGeneralResult);
        this.getModel().setValue("resulttext", (Object)text);
    }

    private void setSimilarTask(DynamicObject predictResult) {
        ArrayList taskIds;
        String similarTaskStr = predictResult.getString("similartask");
        try {
            taskIds = (ArrayList)SerializationUtils.fromJsonString((String)similarTaskStr, List.class);
        }
        catch (Exception e2) {
            log.error(String.format("Error to parse similartask field of task %s", predictResult.getString("taskid")), (Throwable)e2);
            this.getView().setVisible(Boolean.FALSE, new String[]{"similartaskfp"});
            return;
        }
        List ids = taskIds.stream().map(Long::parseLong).collect(Collectors.toList());
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"sourcetaskid,subject", (QFilter[])new QFilter("id", "in", ids).toArray());
        List sourceTaskIds = tasks.stream().map(e -> e.getLong("sourcetaskid")).collect(Collectors.toList());
        DynamicObjectCollection results = QueryServiceHelper.query((String)"task_approval_result", (String)"taskid,predictpass,predicttime", (QFilter[])new QFilter("taskid", "in", sourceTaskIds).toArray(), null, (int)3);
        if (results.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"similartaskfp"});
            return;
        }
        Map<Long, DynamicObject> id2Result = results.stream().collect(Collectors.toMap(k -> k.getLong("taskid"), v -> v));
        int i = 0;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (DynamicObject task : tasks) {
            ((Label)this.getControl("subjectlabel" + i)).setText(task.getString("subject"));
            DynamicObject result = id2Result.get(task.getLong("sourcetaskid"));
            if (result != null) {
                ((Label)this.getControl("timelabel" + i)).setText(formatter.format(result.getDate("predicttime")));
                this.getModel().setValue("taskid" + i, (Object)result.getLong("taskid"));
                boolean pass = result.getBoolean("predictpass");
                if (pass) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nopasslabel" + i});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"passlabel" + i});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"passlabel" + i, "nopasslabel" + i});
            }
            ++i;
        }
        for (int j = i; j < 3; ++j) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taskfp" + j});
        }
    }

    private List<FactorInfo> parseAffectFactorInfo(DynamicObject predictResult) {
        try {
            HashMap<String, FactorInfo> fieldName2Info = AffectFactorParser.parseAffectFactorInfo(predictResult);
            return fieldName2Info.values().stream().sorted((e1, e2) -> e2.getValue().compareTo(e1.getValue())).limit(5L).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(String.format("Error to parse affect field of task %s", predictResult.getString("taskid")), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u4efb\u52a1\u9884\u6d4b\u201d\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"TaskPredictParsePlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
            return Collections.emptyList();
        }
    }

    private DynamicObject loadApprovePredictResult() {
        QFilter filter;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long taskId = (Long)showParameter.getCustomParam(KEY_TASK_ID);
        if (taskId != null && taskId > 0L) {
            filter = new QFilter("taskid", "=", (Object)taskId);
        } else {
            Long id = (Long)showParameter.getCustomParam("id");
            if (id == null || id == 0L) {
                return null;
            }
            filter = new QFilter("id", "=", (Object)id);
        }
        return BusinessDataServiceHelper.loadSingle((String)"task_approval_result", (String)"taskid,billid,predictpass,predictpassratio,similartask,predicttime,affect", (QFilter[])filter.toArray());
    }

    private void fillFactorPanels(List<FactorInfo> factorInfoList) {
        int i;
        if (factorInfoList.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        for (i = 0; i < factorInfoList.size(); ++i) {
            FactorInfo factorInfo = factorInfoList.get(i);
            model.setValue("factor" + i, (Object)(factorInfo.getField() + " = " + factorInfo.getName()));
            model.setValue("explanation" + i, (Object)BillFieldExplanation.get((String)factorInfo.getFactor()));
        }
        for (i = factorInfoList.size(); i < 5; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"factorfp" + i});
        }
    }

    private List<FactorInfo> maskFactorInfoList(DynamicObject predictResult) {
        if (this.aiGeneralResult != null && this.aiGeneralResult.schemaSuccess() && this.aiGeneralResult.predictSuccess() && !this.aiGeneralResult.getSchemaResult().isPass().booleanValue() && this.aiGeneralResult.getPredictResult().isPass()) {
            FactorInfo factorInfo = new FactorInfo();
            factorInfo.setFactor(BillFieldSourceEnum.ruleresult.getFieldName());
            factorInfo.setField(BillFieldSourceEnum.ruleresult.getName());
            factorInfo.setName(ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"TaskPredictParsePlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Collections.singletonList(factorInfo);
        }
        return this.parseAffectFactorInfo(predictResult);
    }
}

