/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class AreaInitListPlugin
extends AbstractListPlugin {
    private String entityId = "som_knowledge_area";
    private String tableName = "t_tk_scs_area";
    private long sscid = OrgUnitServiceHelper.getRootOrgId();

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        this.entityId = source.getEntityId();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.entityId);
        this.tableName = entityType.getAlias();
        String sscidStr = this.getPageCache().get("createOrg");
        if (StringUtils.isEmpty((String)sscidStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AreaInitListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.sscid = Long.parseLong(sscidStr);
        String opKey = e.getOperateKey();
        if ("donothing_init".equals(opKey) && this.validate()) {
            this.executeInit(this.getDataJson());
        }
    }

    private boolean validate() {
        QFilter sscFil = new QFilter("createorg", "=", (Object)this.sscid);
        QFilter useSscFil = new QFilter("usessc.FBasedataId", "=", (Object)this.sscid);
        boolean isHasData = QueryServiceHelper.exists((String)this.entityId, (QFilter[])new QFilter[]{sscFil.or(useSscFil)});
        if (isHasData) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u4e0b\u5df2\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u521d\u59cb\u5316\u3002", (String)"AreaInitListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter dataSourceFil = new QFilter("datasource", "=", (Object)Character.valueOf('1'));
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)this.entityId, (String)"createorg.name", (QFilter[])new QFilter[]{dataSourceFil});
        if (dynObj != null) {
            String info = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u201c%s\u201d\u5df2\u5b58\u5728\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8bd5\u3002", (String)"AreaInitListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), dynObj.getString("createorg.name"));
            this.getView().showTipNotification(info);
            return false;
        }
        return true;
    }

    protected void executeInit(String dataJson) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("userid", RequestContext.get().getUserId());
        params.put("createtime", new Date());
        JSONArray dataArr = JSON.parseArray((String)dataJson);
        int size = dataArr.size();
        long[] areaIds = DB.genLongIds((String)this.tableName, (int)size);
        ArrayList<DynamicObject> areaDynObjs = new ArrayList<DynamicObject>(9);
        ArrayList knowlSubjects = new ArrayList(9);
        for (int i = 0; i < size; ++i) {
            params.put("areaid", areaIds[i]);
            JSONObject area = (JSONObject)dataArr.get(i);
            DynamicObject areaDynObj = this.createAreaDynObj(area, params);
            areaDynObjs.add(areaDynObj);
            JSONArray subjects = area.getJSONArray("subject");
            subjects.forEach(p -> {
                DynamicObject knowlSubject = this.createKnowlSubject((JSONObject)p, params);
                knowlSubjects.add(knowlSubject);
            });
        }
        OperateOption operateOption = OperateOption.create();
        String appId = this.getView().getFormShowParameter().getAppId();
        operateOption.setVariableValue("appId", appId);
        OperationResult areaOpResult = OperationServiceHelper.executeOperate((String)"save", (String)this.entityId, (DynamicObject[])areaDynObjs.toArray(new DynamicObject[areaDynObjs.size()]), (OperateOption)operateOption);
        if (areaOpResult.isSuccess()) {
            OperationResult subjectOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"som_knowledge_info", (DynamicObject[])knowlSubjects.toArray(new DynamicObject[areaDynObjs.size()]), null);
            if (subjectOpResult.isSuccess()) {
                BaseDataServiceHelper.refreshBaseDataUseRange((String)this.entityId, new ArrayList<Long>(Collections.singletonList(this.sscid)));
                ((IListView)this.getView()).refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"AreaInitListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                BaseDataServiceHelper.refreshBaseDataUseRange((String)this.entityId, new ArrayList<Long>(Collections.singletonList(this.sscid)));
                ((IListView)this.getView()).refresh();
                this.getView().showOperationResult(subjectOpResult);
            }
        } else {
            OperationServiceHelper.executeOperate((String)"delete", (String)this.entityId, (DynamicObject[])areaDynObjs.toArray(new DynamicObject[areaDynObjs.size()]), null);
            this.getView().showOperationResult(areaOpResult);
        }
    }

    private DynamicObject createAreaDynObj(JSONObject area, Map<String, Object> params) {
        DynamicObject areaDynObj = BusinessDataServiceHelper.newDynamicObject((String)this.entityId);
        areaDynObj.set("id", params.get("areaid"));
        areaDynObj.set("name", (Object)area.getString("areaname"));
        areaDynObj.set("number", (Object)area.getString("areanumber"));
        areaDynObj.set("creator_id", params.get("userid"));
        areaDynObj.set("createorg", (Object)BusinessDataServiceHelper.loadSingle((Object)this.sscid, (String)"bos_org"));
        areaDynObj.set("createtime", params.get("createtime"));
        areaDynObj.set("status", (Object)Character.valueOf('C'));
        areaDynObj.set("enable", (Object)Character.valueOf('1'));
        areaDynObj.set("ctrlstrategy", (Object)Character.valueOf('2'));
        areaDynObj.set("datasource", (Object)Character.valueOf('1'));
        DynamicObjectCollection usesscList = areaDynObj.getDynamicObjectCollection("usessc");
        DynamicObject usessc = usesscList.addNew();
        usessc.set("fbasedataid_id", (Object)this.sscid);
        DynamicObjectCollection roleList = areaDynObj.getDynamicObjectCollection("roles");
        DynamicObject role = roleList.addNew();
        role.set("fbasedataid_id", (Object)"1MDO9B9H4ED+");
        return areaDynObj;
    }

    private DynamicObject createKnowlSubject(JSONObject subject, Map<String, Object> params) {
        DynamicObject knowlSubject = BusinessDataServiceHelper.newDynamicObject((String)"som_knowledge_info");
        knowlSubject.set("area", params.get("areaid"));
        knowlSubject.set("name", (Object)subject.getString("name"));
        knowlSubject.set("number", (Object)subject.getString("number"));
        knowlSubject.set("subjectnum", (Object)subject.getString("number"));
        OrmLocaleValue question = (OrmLocaleValue)knowlSubject.get("question");
        question.setLocaleValue(ResManager.loadKDString((String)"\u7c7b\u76ee\u521d\u59cb\u5316", (String)"AreaInitListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        OrmLocaleValue answer = (OrmLocaleValue)knowlSubject.get("answer");
        answer.setLocaleValue(ResManager.loadKDString((String)"\u7c7b\u76ee\u521d\u59cb\u5316", (String)"AreaInitListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        knowlSubject.set("subject", (Object)Character.valueOf('1'));
        knowlSubject.set("creator", params.get("userid"));
        knowlSubject.set("createtime", params.get("createtime"));
        knowlSubject.set("status", (Object)Character.valueOf('C'));
        knowlSubject.set("enable", (Object)Character.valueOf('1'));
        return knowlSubject;
    }

    private String getDataJson() {
        String dataJson = "[{\"areaname\":\"\u8d39\u7528\u62a5\u9500\",\"areanumber\":\"fybx\",\"subject\":[{\"name\":\"\u51fa\u5dee\u7533\u8bf7\u53ca\u501f\u6b3e\",\"number\":\"fybx_001\"},{\"name\":\"\u5dee\u65c5\u8d39\",\"number\":\"fybx_002\"},{\"name\":\"\u90e8\u95e8\u6d3b\u52a8\u8d39\",\"number\":\"fybx_003\"},{\"name\":\"\u798f\u5229\u8d39\",\"number\":\"fybx_004\"},{\"name\":\"\u798f\u5229\u54c1\",\"number\":\"fybx_005\"},{\"name\":\"\u52a0\u73ed\u9910\u8d39\u53ca\u4ea4\u901a\u8d39\",\"number\":\"fybx_006\"},{\"name\":\"\u5e02\u573a\u6d3b\u52a8\u8d39\",\"number\":\"fybx_007\"},{\"name\":\"\u5458\u5de5\u501f\u6b3e\",\"number\":\"fybx_008\"},{\"name\":\"\u62db\u5f85\u8d39\",\"number\":\"fybx_009\"},{\"name\":\"\u62db\u8058\u8d39\",\"number\":\"fybx_010\"},{\"name\":\"\u79fb\u52a8\u7535\u8bdd\u8d39\",\"number\":\"fybx_011\"},{\"name\":\"\u5e02\u5185\u4ea4\u901a\u8d39\",\"number\":\"fybx_012\"},{\"name\":\"\u623f\u79df\u7269\u7ba1\u8d39\",\"number\":\"fybx_013\"},{\"name\":\"\u5185\u90e8\u5458\u5de5\u4ea4\u6d41\",\"number\":\"fybx_014\"},{\"name\":\"\u56e2\u961f\u8bc4\u4f18\u53ca\u5956\u52b1\",\"number\":\"fybx_015\"},{\"name\":\"\u5ba2\u6237\u57f9\u8bad\u8d39\",\"number\":\"fybx_016\"},{\"name\":\"\u90ae\u8d39\u53ca\u8fd0\u8d39\",\"number\":\"fybx_017\"},{\"name\":\"\u4f1a\u52a1\u8d39\",\"number\":\"fybx_018\"},{\"name\":\"\u6e20\u9053\u8d39\",\"number\":\"fybx_019\"},{\"name\":\"\u5458\u5de5\u57f9\u8bad\u8d39\",\"number\":\"fybx_020\"},{\"name\":\"\u4e13\u4e1a\u670d\u52a1\u8d39\",\"number\":\"fybx_021\"},{\"name\":\"\u5e7f\u544a\u8d39\",\"number\":\"fybx_022\"},{\"name\":\"\u9879\u76ee\u5408\u4f5c\u8d39\",\"number\":\"fybx_023\"},{\"name\":\"\u6295\u6807\u4fdd\u8bc1\u91d1\",\"number\":\"fybx_024\"},{\"name\":\"\u5de5\u8d44\u5956\u91d1\u53ca\u793e\u4fdd\",\"number\":\"fybx_025\"},{\"name\":\"\u5916\u5305\u4eba\u5458\u5de5\u8d44\",\"number\":\"fybx_026\"},{\"name\":\"\u8f66\u8f86\u8d39\",\"number\":\"fybx_027\"},{\"name\":\"\u884c\u653f\u529e\u516c\u8d39\",\"number\":\"fybx_028\"},{\"name\":\"\u5916\u5305\u670d\u52a1\u8d39\",\"number\":\"fybx_029\"},{\"name\":\"\u6c34\u7535\u8d39\",\"number\":\"fybx_030\"},{\"name\":\"\u7f51\u7edc\u8d39\u7528\",\"number\":\"fybx_031\"},{\"name\":\"\u7ef4\u4fee\u4fdd\u517b\u8d39\",\"number\":\"fybx_032\"},{\"name\":\"\u7535\u8bdd\u901a\u8baf\u8d39\",\"number\":\"fybx_033\"},{\"name\":\"\u7f5a\u6b3e_\u6350\u8d60\u53ca\u975e\u5e38\u635f\u5931\",\"number\":\"fybx_034\"},{\"name\":\"\u8bc9\u8bbc\u5f8b\u5e08\u8d39\",\"number\":\"fybx_035\"},{\"name\":\"\u4ea7\u54c1\u53ca\u7ba1\u7406\u7c7b\u54a8\u8be2\",\"number\":\"fybx_036\"},{\"name\":\"\u730e\u5934\u62db\u8058\u8d39\",\"number\":\"fybx_037\"},{\"name\":\"\u5916\u8058\u8bb2\u5e08\u8d39\",\"number\":\"fybx_038\"},{\"name\":\"\u9000\u8d27\u9000\u6b3e\",\"number\":\"fybx_039\"},{\"name\":\"\u62bc\u91d1\u3001\u4fdd\u8bc1\u91d1\u9000\u6b3e\",\"number\":\"fybx_040\"},{\"name\":\"\u6295\u8d44\u6b3e\",\"number\":\"fybx_041\"},{\"name\":\"\u4ee3\u6536\u4ee3\u4ed8\u6b3e\",\"number\":\"fybx_042\"},{\"name\":\"\u7b2c\u4e09\u65b9\u91c7\u8d2d\uff08\u9999\u6e2f\uff09\",\"number\":\"fybx_043\"},{\"name\":\"\u7a0e\u91d1\",\"number\":\"fybx_044\"},{\"name\":\"\u4e91\u79df\u8d41\u6210\u672c\",\"number\":\"fybx_045\"},{\"name\":\"\u8463\u4e8b\u4f1a\u8d39\",\"number\":\"fybx_046\"}]},{\"areaname\":\"\u7a0e\u52a1\u54a8\u8be2\",\"areanumber\":\"swzx\",\"subject\":[{\"name\":\"\u53d1\u7968\u5f00\u5177\",\"number\":\"swzx_001\"},{\"name\":\"\u5f00\u7968\u4fe1\u606f\",\"number\":\"swzx_002\"},{\"name\":\"\u6700\u65b0\u7a0e\u52a1\u653f\u7b56\",\"number\":\"swzx_003\"}]},{\"areaname\":\"\u5236\u5ea6\u53d1\u6587\",\"areanumber\":\"zdfw\",\"subject\":[{\"name\":\"\u6838\u7b97\u4f53\u7cfb\",\"number\":\"zdfw_001\"},{\"name\":\"\u4e1a\u52a1\u6838\u7b97\u89c4\u8303\u6307\u5357\",\"number\":\"zdfw_002\"},{\"name\":\"\u5171\u4eab\u670d\u52a1\u4e2d\u5fc3\u5c97\u4f4d\u6807\u51c6\u5316\u64cd\u4f5c\u624b\u518c\",\"number\":\"zdfw_003\"},{\"name\":\"\u8d44\u91d1\u7ed3\u7b97\",\"number\":\"zdfw_004\"},{\"name\":\"\u8d44\u91d1\u5185\u63a7\u7ba1\u7406\",\"number\":\"zdfw_005\"},{\"name\":\"RBU\u8d22\u52a1\u5de5\u4f5c\u624b\u518c\",\"number\":\"zdfw_006\"},{\"name\":\"\u8d39\u7528\u62a5\u9500\",\"number\":\"zdfw_007\"},{\"name\":\"\u5168\u9762\u9884\u7b97\u7ba1\u7406\u5236\u5ea6\",\"number\":\"zdfw_008\"},{\"name\":\"\u4e13\u9879\u9884\u7b97\u7ba1\u7406\u529e\u6cd5\",\"number\":\"zdfw_009\"},{\"name\":\"\u6536\u5165\u786e\u8ba4\u5236\u5ea6\",\"number\":\"zdfw_010\"},{\"name\":\"\u56fa\u5b9a\u8d44\u4ea7\u7ba1\u7406\u5236\u5ea6\u53ca\u7ec6\u5219\",\"number\":\"zdfw_011\"},{\"name\":\"\u5458\u5de5\u81ea\u5e26\u7b14\u8bb0\u672c\u7535\u8111\u7ba1\u7406\u529e\u6cd5\",\"number\":\"zdfw_012\"},{\"name\":\"\u53d1\u7968\u7ba1\u7406\u5236\u5ea6\",\"number\":\"zdfw_013\"},{\"name\":\"\u5e94\u6536\u8d26\u6b3e\u7ba1\u7406\u89c4\u8303\",\"number\":\"zdfw_014\"},{\"name\":\"\u5e94\u6536\u8d26\u6b3e\u7ba1\u7406\u7ec6\u5219\",\"number\":\"zdfw_015\"}]},{\"areaname\":\"\u8d44\u91d1\u7ba1\u7406\",\"areanumber\":\"zjgl\",\"subject\":[{\"name\":\"\u8d44\u91d1\u652f\u4ed8\",\"number\":\"zjgl_001\"},{\"name\":\"\u8d26\u6237\u7ba1\u7406\",\"number\":\"zjgl_002\"},{\"name\":\"\u73b0\u91d1\u7ba1\u7406\",\"number\":\"zjgl_003\"},{\"name\":\"\u8d44\u91d1\u7ed3\u7b97\",\"number\":\"zjgl_004\"},{\"name\":\"\u8d44\u91d1\u9884\u7b97\u7ba1\u7406\",\"number\":\"zjgl_005\"},{\"name\":\"\u7406\u8d22\u4e0e\u878d\u8d44\u7ba1\u7406\",\"number\":\"zjgl_006\"},{\"name\":\"\u7968\u636e\u3001\u5370\u9274\u7ba1\u7406\",\"number\":\"zjgl_007\"}]},{\"areaname\":\"\u6536\u5165\u6536\u6b3e\",\"areanumber\":\"srgl\",\"subject\":[{\"name\":\"\u76f4\u9500\u6536\u5165\u6536\u6b3e\",\"number\":\"srgl_001\"},{\"name\":\"\u5206\u9500\u6536\u5165\u6536\u6b3e\",\"number\":\"srgl_002\"}]},{\"areaname\":\"\u8d44\u4ea7\u7ba1\u7406\",\"areanumber\":\"zcgl\",\"subject\":[{\"name\":\"\u91c7\u8d2d\u5e94\u4ed8\",\"number\":\"zcgl_001\"},{\"name\":\"\u5b58\u8d27\",\"number\":\"zcgl_002\"},{\"name\":\"\u56fa\u5b9a\u8d44\u4ea7\",\"number\":\"zcgl_003\"},{\"name\":\"\u7269\u6d41\u6838\u7b97\",\"number\":\"zcgl_004\"}]},{\"areaname\":\"\u603b\u8d26\u7ba1\u7406\",\"areanumber\":\"zzgl\",\"subject\":[{\"name\":\"\u85aa\u916c\u6838\u7b97\",\"number\":\"zzgl_001\"},{\"name\":\"\u8d39\u7528\u5206\u7c7b\",\"number\":\"zzgl_002\"},{\"name\":\"\u5458\u5de5\u79bb\u804c\u4ea4\u63a5\u6d41\u7a0b\uff08\u8d22\u52a1\uff09\",\"number\":\"zzgl_003\"},{\"name\":\"\u5907\u7528\u91d1\u3001\u62bc\u91d1\u3001\u4fdd\u8bc1\u91d1\u7ba1\u7406\",\"number\":\"zzgl_004\"}]},{\"areaname\":\"\u5e94\u6536\u7ba1\u7406\",\"areanumber\":\"ysgl\",\"subject\":[{\"name\":\"\u5e94\u6536\u5408\u540c\u6b3e\",\"number\":\"ysgl_001\"},{\"name\":\"\u503a\u6743\u5e94\u6536\",\"number\":\"ysgl_002\"},{\"name\":\"\u53d1\u7968\u5e94\u6536\",\"number\":\"ysgl_003\"},{\"name\":\"\u51fd\u8bc1\u4e0e\u5f02\u5e38\u5e94\u6536\u7ba1\u7406\",\"number\":\"ysgl_004\"},{\"name\":\"\u8003\u6838\u7ba1\u7406\",\"number\":\"ysgl_005\"}]},{\"areaname\":\"\u9884\u7b97\u7533\u62a5\",\"areanumber\":\"yssb\",\"subject\":[{\"name\":\"\u9879\u76ee\u5206\u7c7b\u8bf4\u660e\",\"number\":\"yssb_001\"},{\"name\":\"\u6743\u9650\u5f00\u901a\u7533\u8bf7\",\"number\":\"yssb_002\"},{\"name\":\"\u9879\u76ee\u7acb\u9879\u64cd\u4f5c\u6307\u5f15\",\"number\":\"yssb_003\"},{\"name\":\"\u9879\u76ee\u7acb\u9879\u5b8c\u6210\u540e\u8c03\u6574\u9884\u7b97\u64cd\u4f5c\",\"number\":\"yssb_004\"},{\"name\":\"\u9879\u76ee\u5173\u95ed\u64cd\u4f5c\",\"number\":\"yssb_005\"},{\"name\":\"\u9879\u76ee\u7acb\u9879\u62a5\u9519\u81ea\u67e5\u64cd\u4f5c\",\"number\":\"yssb_006\"},{\"name\":\"\u9879\u76ee\u56e2\u961f\u8c03\u6574\u64cd\u4f5c\",\"number\":\"yssb_007\"},{\"name\":\"\u9884\u7b97\u4f7f\u7528\u60c5\u51b5\u67e5\u8be2\",\"number\":\"yssb_008\"},{\"name\":\"\u5185\u90e8\u989d\u5ea6\u8c03\u5242\",\"number\":\"yssb_009\"},{\"name\":\"\u65b0\u5efa\u6708\u5ea6\u635f\u76ca\u9884\u6d4b\",\"number\":\"yssb_010\"}]}]";
        return dataJson;
    }
}

