/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.formplugin.taskpool.AllTask;
import kd.ssc.task.formplugin.taskpool.ApprovalTask;
import kd.ssc.task.formplugin.taskpool.DoneAction;
import kd.ssc.task.formplugin.taskpool.HRHandlingTask;
import kd.ssc.task.formplugin.taskpool.ProcessAction;
import kd.ssc.task.formplugin.taskpool.QualityTask;
import kd.ssc.task.formplugin.taskpool.baseclass.Action;
import org.jetbrains.annotations.NotNull;

public class Factory {
    public static AllTask getTask(AllTask alltaskParam, TaskShowType taskType) {
        AllTask allTask;
        if (taskType == TaskShowType.ZJ) {
            allTask = new QualityTask(alltaskParam.getSscId(), alltaskParam.getAction());
        } else if (taskType == TaskShowType.GX) {
            allTask = new ApprovalTask(alltaskParam.getSscId(), alltaskParam.getAction());
        } else {
            if (taskType == TaskShowType.ALL) {
                return alltaskParam;
            }
            if (taskType == TaskShowType.BL) {
                allTask = new HRHandlingTask(alltaskParam.getSscId(), alltaskParam.getAction());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u6709\u8bef\u3002", (String)"Factory_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
        allTask.setView(alltaskParam.getView());
        return allTask;
    }

    public static AllTask getTask(TaskShowType taskType, IFormView iFormView, long sscId, Action action) {
        AllTask allTask;
        if (taskType == TaskShowType.ZJ) {
            allTask = new QualityTask(sscId, action);
        } else if (taskType == TaskShowType.GX) {
            allTask = new ApprovalTask(sscId, action);
        } else if (taskType == TaskShowType.ALL) {
            allTask = new AllTask(sscId, action);
        } else if (taskType == TaskShowType.BL) {
            allTask = new HRHandlingTask(sscId, action);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u6709\u8bef\u3002", (String)"Factory_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        allTask.setView(iFormView);
        return allTask;
    }

    public static Action getAction(String showpooltype) {
        if ("process".equals(showpooltype)) {
            return new ProcessAction();
        }
        if ("completed".equals(showpooltype)) {
            return new DoneAction();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u73af\u8282\u5165\u53c2\u9519\u8bef\uff0cprocess\uff1a\u5904\u7406\u4e2d\uff1bcompleted\uff1a\u5df2\u5b8c\u6210\u3002", (String)"Factory_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    public static AllTask getTaskByTasktype(AllTask alltaskParam, QFilter tasktypeidId, QFilter stateQFilter) {
        AllTask allTask;
        HashSet<String> set = new HashSet<String>(16);
        if (tasktypeidId != null) {
            try (DataSet distinct = QueryServiceHelper.queryDataSet((String)"change state by tasktype", (String)"task_tasktype", (String)"qualityjudge", (QFilter[])new QFilter[]{new QFilter("id", "in", tasktypeidId.getValue())}, null).distinct();){
                for (Row row : distinct) {
                    String qualityjudge = row.getString("qualityjudge");
                    set.add(qualityjudge);
                }
            }
            boolean allZj = set.stream().allMatch(p -> p.equals("1"));
            boolean allNotZj = set.stream().noneMatch(p -> p.equals("1"));
            if (allZj) {
                allTask = new QualityTask(alltaskParam.getSscId(), alltaskParam.getAction());
                if (stateQFilter != null && stateQFilter.getValue().equals(TaskStateEnum.TO_BE_TRACKED.getValue())) {
                    allTask.setAction(new ProcessAction());
                }
            } else {
                boolean existhrHandling;
                allTask = allNotZj ? ((existhrHandling = set.stream().anyMatch(p -> p.equals("4"))) ? new HRHandlingTask(alltaskParam.getSscId(), alltaskParam.getAction()) : new ApprovalTask(alltaskParam.getSscId(), alltaskParam.getAction())) : new AllTask(alltaskParam.getSscId(), alltaskParam.getAction());
            }
        } else {
            allTask = new ApprovalTask(alltaskParam.getSscId(), alltaskParam.getAction());
        }
        if (((Object)((Object)alltaskParam)).getClass().equals(((Object)((Object)allTask)).getClass())) {
            return alltaskParam;
        }
        allTask.setView(alltaskParam.getView());
        allTask.setNotReRegister(true);
        allTask.initialize();
        return allTask;
    }

    public static enum TaskShowType {
        ZJ("1"),
        GX("2"),
        BL("3"),
        ALL("0");

        String value;

        public String getValue() {
            return this.value;
        }

        private TaskShowType(String value) {
            this.value = value;
        }

        public static TaskShowType getTaskShowType(@NotNull String value) {
            for (int i = 0; i < TaskShowType.values().length; ++i) {
                if (!TaskShowType.values()[i].getValue().equals(value)) continue;
                return TaskShowType.values()[i];
            }
            return null;
        }
    }
}

