/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill.importexcel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.workbill.excel.WorkBillImportExcelHelper;

public class WorkBillImportExcelFormPlugin
extends AbstractFormPlugin
implements UploadListener,
ClickListener {
    private static Log log = LogFactory.getLog(WorkBillImportExcelFormPlugin.class);
    private static final String BTN_DOWNLOAD_EXCEL = "buttonap";
    private static final String BTN_OK = "btnok";
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanelap";
    private static final String KEY_URL = "url";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DOWNLOAD_EXCEL});
        this.addClickListeners(new String[]{BTN_OK});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        if (BTN_DOWNLOAD_EXCEL.equalsIgnoreCase(ctrl.getKey())) {
            this.downloadExcelFile();
        } else if (BTN_OK.equalsIgnoreCase(ctrl.getKey())) {
            String attachmentUrl = this.getPageCache().get(KEY_URL);
            List workBillExcelInfos = WorkBillImportExcelHelper.parsingExcel((String)attachmentUrl);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map existPanelNumMap = (Map)parameter.getCustomParam("panelNumAndTypeMap");
            List existFieldNumList = (List)parameter.getCustomParam("fieldNumList");
            List errMsgList = WorkBillImportExcelHelper.checkFieldInfoValid((List)workBillExcelInfos, (List)existFieldNumList, (Map)existPanelNumMap);
            if (CollectionUtils.isNotEmpty((Collection)errMsgList)) {
                this.showErrorForm(errMsgList);
                return;
            }
            Map resultMap = WorkBillImportExcelHelper.covertData((List)workBillExcelInfos, (Map)existPanelNumMap);
            this.getView().returnDataToParent((Object)resultMap);
            this.getView().close();
        }
    }

    private void downloadExcelFile() {
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("WorkBillImportTemplate.xlsx");){
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempUrl = cache.saveAsFullUrl("\u5de5\u5355\u5bfc\u5165\u5b57\u6bb5\u6a21\u677f.xlsx", in, 60);
            this.getView().download(tempUrl);
        }
        catch (IOException e) {
            log.error("download template error:" + e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0b\u8f7d\u5f02\u5e38\u3002", (String)"WorkBillImportFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        Map attachmentInfoMap = (Map)evt.getUrls()[0];
        String attachmentUrl = Optional.ofNullable(attachmentInfoMap).map(map -> map.get(KEY_URL)).map(url -> url.toString()).orElse("");
        this.getPageCache().put(KEY_URL, attachmentUrl);
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_OK});
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        this.getPageCache().put(KEY_URL, "");
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
    }

    private void showErrorForm(List<String> errorList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("ssc_wb_import_error_form");
        parameters.setCustomParam("errorMsg", errorList);
        this.getView().showForm(parameters);
    }
}

