/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.common.workcalendar.WorkCalendarServiceHelper;
import kd.ssc.task.common.workcalendar.WorkCalendarUtils;
import kd.ssc.task.formplugin.pojo.PersonInfo;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.formplugin.workcalendar.SscWorkCalendarBasePlugin;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class SscWorkCalendarUserEditPlugin
extends SscWorkCalendarBasePlugin
implements ListRowClickListener,
ClickListener,
RowClickEventListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog(SscWorkCalendarUserEditPlugin.class);
    private static final String CONFIRM_SYNC_OTHER_GROUP = "confirmSyncOtherGroup";
    private static final String OFFTIME_ALLDAY = "offtime_allday";
    private static final String OFFTIME_AM = "offtime_am";
    private static final String OFFTIME_PM = "offtime_pm";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid cardentry = (AbstractGrid)this.getControl("cardentry");
        cardentry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AbstractGrid cardentry = (AbstractGrid)this.getControl("cardentry");
        cardentry.selectRows(0);
    }

    public void entryRowClick(RowClickEvent e) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        IDataModel model = this.getModel();
        String groupId = this.getCurrentGroup();
        String orgId = this.getCurrentOrgId();
        int index = this.getModel().getEntryCurrentRowIndex("cardentry");
        DynamicObjectCollection cols = this.getModel().getEntryEntity("cardentry");
        if (cols != null && cols.size() > 0) {
            Date nowDate;
            DynamicObject selectCardRow = (DynamicObject)this.getModel().getEntryEntity("cardentry").get(index);
            Long uid = ((DynamicObject)selectCardRow.get("userfield")).getLong("id");
            this.putUidToCache(uid);
            String date = this.getPageCache().get("selectDate");
            try {
                nowDate = SDF.parse(date);
            }
            catch (ParseException e1) {
                log.error(e1.getMessage());
                return;
            }
            ArrayList<Long> userIdList = new ArrayList<Long>(1);
            userIdList.add(uid);
            Label label = (Label)this.getView().getControl("datelabel");
            label.setText(date);
            DynamicObjectCollection timeDatas = SscWorkCalendarApi.getData(orgId, groupId, nowDate, userIdList);
            if (timeDatas != null && timeDatas.size() > 0) {
                this.cleanEntryEntity(model, groupId, orgId, nowDate);
                WorkCalendarUtils.cleanEntryEntity(model);
                WorkCalendarUtils.setSingleDaySetOfUser(timeDatas, date, groupId, String.valueOf(uid), model);
            } else {
                this.cleanEntryEntity(model, groupId, orgId, nowDate);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        afterDoOperationEventArgs.getOperationResult();
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_batchset": {
                String org = this.getCurrentOrgId().trim();
                String group = this.getCurrentGroup().trim();
                if (StringUtils.isEmpty((CharSequence)org)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"SscWorkCalendarUserEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)group)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarUserEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<PersonInfo> personInfos = SscWorkCalendarLoadService.getUserListByGroupId(group);
                if (personInfos.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7528\u6237\u7ec4\u8bbe\u7f6e\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u7528\u6237\u3002", (String)"SscWorkCalendarUserEditPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bar_batchset");
                this.showForm("user_workcalendarsetting", null, closeCallBack, ShowType.Modal);
                this.setUserList();
                break;
            }
            case "donothing_save": {
                if (this.hasSyncTask()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u6709\u6b63\u5728\u8fdb\u884c\u201c\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u201d\u7684\u4efb\u52a1\u3002", (String)"SscWorkCalendarUserSettingPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                this.savePersonalizedData();
                this.loadBaseWorkCalendar(this.getCurrentYear());
                break;
            }
            case "newentryofftime": {
                this.validOffAndOverTime("offtimeentryentity", "offtimestart", "offtimestart");
                break;
            }
            case "newentryovertime": {
                this.validOffAndOverTime("overtimeentryentity", "overtimestart", "overtimestart");
                break;
            }
            case "syncothergroup": {
                boolean dataChange = this.isDataChange();
                if (dataChange) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u201c\u5458\u5de5\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e\u201d\u3002", (String)"SscWorkCalendarUserEditPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.hasSyncTask()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u6709\u6b63\u5728\u8fdb\u884c\u201c\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4\u201d\u7684\u4efb\u52a1\u3002", (String)"SscWorkCalendarUserSettingPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                this.showSyncOtherGroupForm();
                break;
            }
            case "newentryallday": {
                this.addOffTimeEntryByType(OFFTIME_ALLDAY);
                break;
            }
            case "newentryam": {
                this.addOffTimeEntryByType(OFFTIME_AM);
                break;
            }
            case "newentrypm": {
                this.addOffTimeEntryByType(OFFTIME_PM);
                break;
            }
        }
    }

    private boolean hasSyncTask() {
        String primaryKeyStr = SscDistributeCache.get((String)"work_calendar_sync_other_group");
        return StringUtils.isNotEmpty((CharSequence)primaryKeyStr) && StringUtils.equals((CharSequence)primaryKeyStr, (CharSequence)this.getCurrentOrgId());
    }

    private void showSyncOtherGroupForm() {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_SYNC_OTHER_GROUP, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u8be5\u5458\u5de5\u5f53\u65e5\u7684\u5de5\u4f5c\u65e5\u5386\u81f3\u5176\u4ed6\u7528\u6237\u7ec4\u540e\u5c06\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u8981\u540c\u6b65\u5417\uff1f", (String)"SscWorkCalendarUserSettingPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CONFIRM_SYNC_OTHER_GROUP.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.syncOtherGroup();
            this.loadBaseWorkCalendar(this.getCurrentYear());
        }
    }

    private void syncOtherGroup() {
        String uid = this.getUidFromCache();
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            List<Long> userGroupIds = WorkCalendarServiceHelper.queryUserGroupIdByUseId(uid, this.getCurrentOrgId(), this.getCurrentGroup());
            if (CollectionUtils.isEmpty(userGroupIds)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SscWorkCalendarUserEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean syncSuccess = this.syncSingleUserWorkCalendar(userGroupIds);
            if (!syncSuccess) {
                return;
            }
            Date date = this.getSelectDate();
            for (Long userGroupId : userGroupIds) {
                pub.publish((Object)new WorkCalendarTaskMessage(this.getCurrentOrgId(), userGroupId + "", Collections.singletonList(Long.parseLong(uid)), date, date, "user"));
            }
        }
    }

    private Date getSelectDate() {
        Date date;
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = SDF.parse(this.getPageCache().get("selectDate"));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return null;
        }
        return date;
    }

    private boolean syncSingleUserWorkCalendar(List<Long> userGroupIds) {
        Date date = this.getSelectDate();
        Map<String, String> panelData = this.getPanelData();
        if (panelData == null) {
            return Boolean.FALSE;
        }
        panelData.put("date", this.getPageCache().get("selectDate"));
        if (this.getUidFromCache() == null) {
            return Boolean.FALSE;
        }
        String workCalendarId = this.getWorkCalendarId();
        String dateEntryId = this.getDateEntryId();
        if (StringUtils.isEmpty((CharSequence)workCalendarId) || StringUtils.isEmpty((CharSequence)dateEntryId)) {
            return Boolean.FALSE;
        }
        boolean off = this.isvalidOffTime();
        boolean over = this.isvalidOverTime();
        if (!off || !over) {
            return Boolean.FALSE;
        }
        String userGroupIdsJson = CollectionUtils.isEmpty(userGroupIds) ? "" : JSONObject.toJSONString(userGroupIds);
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4start: workCalendarId = {}, userGroupIds = {}", (Object)workCalendarId, (Object)userGroupIdsJson);
        DynamicObject workCalendar = BusinessDataServiceHelper.loadSingle((Object)workCalendarId, (String)"ssc_workcalendarsetting");
        if (workCalendar == null) {
            return Boolean.FALSE;
        }
        DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
        for (Long userGroupId : userGroupIds) {
            DynamicObject dateEntry = this.buildDateEntry(date, panelData, dateEntrys, userGroupId);
            Map<String, Object> dynObjTypeMap = SscWorkCalendarLoadService.getDynamicObjectType(date, date, this.getCurrentOrgId());
            DynamicObjectType dateEntryType = (DynamicObjectType)dynObjTypeMap.get("dateEntryType");
            this.deleteUserOffOrOverWorkData(date, date, dateEntryType, userGroupId);
            DynamicObjectCollection timeEntrys = dateEntry.getDynamicObjectCollection("timeentry");
            DynamicObjectCollection offTimeSetCols = this.getModel().getEntryEntity("offtimeentryentity");
            if (this.setOffTimeEntrys(timeEntrys, offTimeSetCols)) {
                return false;
            }
            DynamicObjectCollection overTimeSetCols = this.getModel().getEntryEntity("overtimeentryentity");
            if (this.setOverTimeEntrys(timeEntrys, overTimeSetCols)) {
                return false;
            }
            if ((offTimeSetCols == null || offTimeSetCols.size() <= 0) && (overTimeSetCols == null || overTimeSetCols.size() <= 0)) continue;
            dateEntrys.add((Object)dateEntry);
        }
        return this.saveWorkCalendar2Db(workCalendar);
    }

    private boolean saveWorkCalendar2Db(DynamicObject workCalendar) {
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workCalendar});
        if (result != null) {
            this.setUserList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SscWorkCalendarUserEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean setOverTimeEntrys(DynamicObjectCollection timeEntrys, DynamicObjectCollection overtimeSetCols) {
        if (overtimeSetCols != null && overtimeSetCols.size() > 0) {
            for (DynamicObject obj : overtimeSetCols) {
                DynamicObject timeEntry = new DynamicObject(timeEntrys.getDynamicObjectType());
                int overStart = obj.getInt("overtimestart");
                int overEnd = obj.getInt("overtimeend");
                String overtimestart = SscWorkCalendarUtil.getTimeShow(overStart);
                String overtimeend = SscWorkCalendarUtil.getTimeShow(overEnd);
                log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4: overtimestart = {}, overtimeend = {}", (Object)overtimestart, (Object)overtimeend);
                if (overStart != -1 && overEnd != -1) {
                    this.setTimeEntry(overtimestart, overtimeend, timeEntry, SscTimeType.OVERTIME.getValue());
                    timeEntrys.add((Object)timeEntry);
                    continue;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a0\u73ed\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean setOffTimeEntrys(DynamicObjectCollection timeEntrys, DynamicObjectCollection offtiemSetCols) {
        if (offtiemSetCols != null && offtiemSetCols.size() > 0) {
            for (DynamicObject obj : offtiemSetCols) {
                DynamicObject timeEntry = new DynamicObject(timeEntrys.getDynamicObjectType());
                int offStart = obj.getInt("offtimestart");
                int offEnd = obj.getInt("offtimeend");
                String offtimestart = SscWorkCalendarUtil.getTimeShow(offStart);
                String offtimeend = SscWorkCalendarUtil.getTimeShow(offEnd);
                log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u540c\u6b65\u5176\u4ed6\u7528\u6237\u7ec4: offtimestart = {}, offtimeend = {}", (Object)offtimestart, (Object)offtimeend);
                if (offStart != -1 && offEnd != -1) {
                    this.setTimeEntry(offtimestart, offtimeend, timeEntry, SscTimeType.OFFTIME.getValue());
                    timeEntrys.add((Object)timeEntry);
                    continue;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bf7\u5047\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarBasePlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private DynamicObject buildDateEntry(Date date, Map<String, String> panelData, DynamicObjectCollection dateEntrys, Long userGroupId) {
        DynamicObject dateEntry = new DynamicObject(dateEntrys.getDynamicObjectType());
        dateEntry.set("ssc", (Object)this.getCurrentOrgId());
        dateEntry.set("user", (Object)this.getUidFromCache());
        dateEntry.set("usergroup", (Object)(userGroupId + ""));
        dateEntry.set("level", (Object)SscLevelType.EMPLOYEE.getValue());
        dateEntry.set("date", (Object)date);
        dateEntry.set("datetype", (Object)panelData.get("datetype"));
        return dateEntry;
    }

    private void deleteUserOffOrOverWorkData(Object startDate, Object endDate, DynamicObjectType dynamicObjectType, Long userGroupId) {
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(this.getCurrentOrgId()));
        filters.and(new QFilter("dateentry.usergroup", "=", (Object)userGroupId));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", startDate));
        filters.and(new QFilter("dateentry.date", "<=", endDate));
        filters.and(new QFilter("dateentry.user", "=", (Object)Long.parseLong(this.getUidFromCache())));
        List dateentryids = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.get("dateentry.id")).collect(Collectors.toList());
        if (dateentryids.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])dateentryids.toArray());
        }
    }

    public void validOffAndOverTime(String entryEntityName, String timeStart, String timeEnd) {
        DynamicObjectCollection timeCols = this.getModel().getEntryEntity(entryEntityName);
        int len = timeCols.size();
        for (int i = 0; i < len - 1; ++i) {
            DynamicObject obj = (DynamicObject)timeCols.get(i);
            int ostart = obj.getInt(timeStart);
            int oend = obj.getInt(timeEnd);
            if (ostart != -1 && oend != -1) continue;
            if ("offtimeentryentity".equals(entryEntityName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bf7\u5047\u5f00\u59cb\u65f6\u95f4\u548c\u8bf7\u5047\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserEditPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"overtimeentryentity".equals(entryEntityName)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u52a0\u73ed\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u3002", (String)"SscWorkCalendarUserEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        if ("bar_batchset".equals(closedCallBackEvent.getActionId()) && (returnData = this.getView().getReturnData() + "").trim().equals("refreshData")) {
            String selecteddate = this.getModel().getValue("selecteddate") + "";
            String uid = this.getUidFromCache();
            if (StringUtils.isEmpty((CharSequence)selecteddate.trim()) || StringUtils.isEmpty((CharSequence)uid)) {
                return;
            }
            DynamicObjectCollection userCols = null;
            try {
                userCols = SscWorkCalendarApi.getData(this.getCurrentOrgId(), this.getCurrentGroup(), DateUtil.parse((String)selecteddate, (String)"yyyy-MM-dd"), Collections.singletonList(NumberUtils.toLong((String)uid, (long)-1L)));
            }
            catch (ParseException e) {
                log.info(e.getMessage());
                return;
            }
            if (userCols != null && userCols.size() > 0) {
                WorkCalendarUtils.setSingleDaySetOfUser(userCols, selecteddate, this.getCurrentGroup(), uid, this.getModel());
            } else {
                WorkCalendarUtils.cleanEntryEntity(this.getModel());
            }
        }
    }

    private void addOffTimeEntryByType(String type) {
        DynamicObjectType entryType = this.getModel().getEntryEntity("offtimeentryentity").getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("offtimeentryentity");
        Object startTimeAM = this.getModel().getValue("morning_starttime");
        Object endTimeAM = this.getModel().getValue("morning_endtime");
        Object startTimePM = this.getModel().getValue("afternoon_starttime");
        Object endTimePM = this.getModel().getValue("afternoon_endtime");
        this.dealOffTimeEntry(type, entryColl);
        if ((OFFTIME_ALLDAY.equals(type) || OFFTIME_AM.equals(type)) && startTimeAM != null && endTimeAM != null) {
            DynamicObject entryAM = new DynamicObject(entryType);
            entryAM.set("textfield1", (Object)ResManager.loadKDString((String)"\u65f6\u95f4:", (String)"SscWorkCalendarUserEditPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            entryAM.set("offtimestart", startTimeAM);
            entryAM.set("offtimeend", endTimeAM);
            entryColl.add((Object)entryAM);
        }
        if ((OFFTIME_ALLDAY.equals(type) || OFFTIME_PM.equals(type)) && startTimePM != null && endTimePM != null) {
            DynamicObject entryPM = new DynamicObject(entryType);
            entryPM.set("textfield1", (Object)ResManager.loadKDString((String)"\u65f6\u95f4:", (String)"SscWorkCalendarUserEditPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            entryPM.set("offtimestart", startTimePM);
            entryPM.set("offtimeend", endTimePM);
            entryColl.add((Object)entryPM);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView("offtimeentryentity");
    }

    private void dealOffTimeEntry(String type, DynamicObjectCollection entryColl) {
        if (entryColl != null && entryColl.size() > 0) {
            Object startTimeAM = this.getModel().getValue("morning_starttime");
            Object endTimeAM = this.getModel().getValue("morning_endtime");
            Object startTimePM = this.getModel().getValue("afternoon_starttime");
            Object endTimePM = this.getModel().getValue("afternoon_endtime");
            for (int rowIndex = entryColl.size() - 1; rowIndex >= 0; --rowIndex) {
                int currentOffEndTime;
                int currentOffBeginTime = this.getModel().getValue("offtimestart", rowIndex) == null ? -1 : (Integer)this.getModel().getValue("offtimestart", rowIndex);
                int n = currentOffEndTime = this.getModel().getValue("offtimeend", rowIndex) == null ? -1 : (Integer)this.getModel().getValue("offtimeend", rowIndex);
                if ((OFFTIME_ALLDAY.equals(type) || OFFTIME_AM.equals(type)) && startTimeAM != null && endTimeAM != null && currentOffBeginTime >= (Integer)startTimeAM && currentOffEndTime <= (Integer)endTimeAM) {
                    entryColl.remove(rowIndex);
                }
                if (!OFFTIME_ALLDAY.equals(type) && !OFFTIME_PM.equals(type) || startTimePM == null || endTimePM == null || currentOffBeginTime < (Integer)startTimePM || currentOffEndTime > (Integer)endTimePM) continue;
                entryColl.remove(rowIndex);
            }
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386", (String)"SscWorkCalendarEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(map);
        map.put("creatorid", Long.parseLong(RequestContext.get().getUserId()));
        map.put("ssccenterid", this.getCurrentOrgId());
        map.put("groupid", this.getCurrentGroup());
        map.put("selecteduser", this.getUidFromCache());
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void cleanEntryEntity(IDataModel model, String groupId, String orgId, Date nowDate) {
        DynamicObjectCollection groupTimeDatas = SscWorkCalendarApi.getData(orgId, groupId, nowDate, null);
        if (groupTimeDatas != null && groupTimeDatas.size() > 0) {
            this.setSingleDaySetOfGroup(groupTimeDatas, groupId);
            WorkCalendarUtils.cleanEntryEntity(model);
        } else {
            DynamicObjectCollection sscTimeDatas = SscWorkCalendarApi.getData(orgId, null, nowDate, null);
            this.setSingleDaySetOfSSC(sscTimeDatas);
            WorkCalendarUtils.cleanEntryEntity(model);
        }
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "ssc_workcalendar_employee", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"SscWorkCalendarUserEditPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowIndex;
        RowDataEntity[] rowDataEntities;
        String name = e.getEntryProp().getName();
        if ("offtimeentryentity".equals(name)) {
            rowDataEntities = e.getRowDataEntities();
            rowIndex = -1;
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                rowIndex = rowDataEntities[0].getRowIndex();
            }
            if (rowIndex >= 0) {
                this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u65f6\u95f4:", (String)"SscWorkCalendarUserEditPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), rowIndex);
            }
        }
        if ("overtimeentryentity".equals(name)) {
            rowDataEntities = e.getRowDataEntities();
            rowIndex = -1;
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                rowIndex = rowDataEntities[0].getRowIndex();
            }
            if (rowIndex >= 0) {
                this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u65f6\u95f4:", (String)"SscWorkCalendarUserEditPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), rowIndex);
            }
        }
    }

    private Map<String, List<String>> buildOffTimeAndOverTimeStr() {
        DynamicObjectCollection overEntryEntity;
        IDataModel model = this.getModel();
        HashMap<String, List<String>> timeMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection offEntryEntity = model.getEntryEntity("offtimeentryentity");
        if (offEntryEntity != null && offEntryEntity.size() > 0) {
            for (int rowIndex = 0; rowIndex < offEntryEntity.size(); ++rowIndex) {
                int currentOffBeginTime = (Integer)model.getValue("offtimestart", rowIndex);
                int currentOffEndTime = (Integer)model.getValue("offtimeend", rowIndex);
                String beginTime = SscWorkCalendarUtil.getTimeShow(currentOffBeginTime);
                String endTime = SscWorkCalendarUtil.getTimeShow(currentOffEndTime);
                timeMap.computeIfAbsent(SscTimeType.OFFTIME.getValue(), p -> new ArrayList()).add(StringUtils.join((Object[])new String[]{beginTime, "-", endTime}));
            }
        }
        if ((overEntryEntity = model.getEntryEntity("overtimeentryentity")) != null && overEntryEntity.size() > 0) {
            for (int rowIndex = 0; rowIndex < overEntryEntity.size(); ++rowIndex) {
                int currentOverBeginTime = (Integer)model.getValue("overtimestart", rowIndex);
                int currentOverEndTime = (Integer)model.getValue("overtimeend", rowIndex);
                String beginTime = SscWorkCalendarUtil.getTimeShow(currentOverBeginTime);
                String endTime = SscWorkCalendarUtil.getTimeShow(currentOverEndTime);
                timeMap.computeIfAbsent(SscTimeType.OVERTIME.getValue(), p -> new ArrayList()).add(StringUtils.join((Object[])new String[]{beginTime, "-", endTime}));
            }
        }
        return timeMap;
    }

    private boolean isDataChange() {
        Map<String, List<String>> dbTimeMap = WorkCalendarUtils.getSingleDaySetOfUser(this.getCurrentOrgId(), this.getCurrentGroup(), this.getSelectDate(), this.getUidFromCache());
        Map<String, List<String>> currentTimeMap = this.buildOffTimeAndOverTimeStr();
        if (dbTimeMap.size() != currentTimeMap.size()) {
            return true;
        }
        for (Map.Entry<String, List<String>> dbEntry : dbTimeMap.entrySet()) {
            String timeType = dbEntry.getKey();
            List<String> dbTimes = dbEntry.getValue();
            List<String> currentTimes = currentTimeMap.get(timeType);
            if (CollectionUtils.isEmpty(currentTimes)) {
                return true;
            }
            if (dbTimes.size() != currentTimes.size()) {
                return true;
            }
            dbTimes.removeAll(currentTimes);
            if (!CollectionUtils.isNotEmpty(dbTimes)) continue;
            return true;
        }
        return false;
    }
}

