/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.task.common.CommonFilterUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskQueryServiceHelper {
    private static final Log log = LogFactory.getLog(TaskQueryServiceHelper.class);

    public static DynamicObjectCollection getDataOperationNumberAndtype(long billid) {
        QFilter filterId = new QFilter("id", "=", (Object)billid);
        QFilter[] filters = new QFilter[]{filterId};
        return QueryServiceHelper.query((String)"task_taskbill", (String)"bindbill.number,bindform.number,externalerp.number", (QFilter[])filters);
    }

    public static DynamicObjectCollection getDataTasklist(Object pkid, boolean isHistory) {
        String entityName = "task_task";
        String selector = "id,billtype,billtype.isembed,billtype.bindbill.number,oprt,billid,pooltype,state,subject,tasktypeid,personid,bizdata_tag,billnumber,apprevalmessage,innermsg,imagenumber,qualitysamplelibrary, qualitystate,orignalperson,reformperson,autoprocessforcheck,sourcetaskid,decisionitem,unpassreasondesc";
        if (isHistory) {
            entityName = "task_taskhistory";
        } else {
            selector = selector + ",approveop,pendingopinion,rescanopinion,unpassreasondata";
        }
        QFilter filter = new QFilter("id", "=", pkid);
        QFilter[] filters = new QFilter[]{filter};
        return QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])filters);
    }

    public static DynamicObject getDataTask(Object pkid, boolean isHistory) {
        String entityName = "task_task";
        String selector = "billtype,billtype.isembed,oprt,billid,pooltype,imagenumber,state,subject,tasktypeid,personid,bizdata_tag,billnumber,apprevalmessage,innermsg,qualitysamplelibrary, qualitystate,orignalperson,reformperson,autoprocessforcheck,sourcetype";
        if (isHistory) {
            entityName = "task_taskhistory";
            selector = selector + ",sourcetaskid";
        }
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)entityName, (String)selector);
    }

    public static Map<Long, Integer> getQualitySampleLibraryId(List<Object> taskIds) {
        HashMap<Long, Integer> sampleLibNum = new HashMap<Long, Integer>(8);
        QFilter filterId = new QFilter("id", "in", taskIds);
        String algoKey = TaskQueryServiceHelper.class + "getQualitySampleLibraryId(List<Object> taskIds)";
        try (DataSet taskAndSampleLib = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_task", (String)"id,qualitysamplelibrary", (QFilter[])new QFilter[]{filterId}, null);
             DataSet dSet = taskAndSampleLib.groupBy(new String[]{"qualitysamplelibrary"}).count("tasknum").finish();){
            for (Row row : dSet) {
                sampleLibNum.put(row.getLong("qualitysamplelibrary"), row.getInteger("tasknum"));
            }
        }
        return sampleLibNum;
    }

    public static String getGeneralFiler(List<QFilter> filterList, boolean isAdmin) {
        QFilter generalFilter = new QFilter("1", "=", (Object)1);
        for (QFilter f : filterList) {
            generalFilter = generalFilter.and(f);
        }
        if (!isAdmin) {
            QFilter filter = new QFilter("personid", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
            generalFilter = generalFilter.and(filter);
        }
        return generalFilter.toSerializedString();
    }

    public static Set<Long> getBillTypeTaskLevelByTaskId(Long taskId) {
        Long taskTypeId;
        QFilter taskTypeIdFilter;
        HashSet<Long> refIds = new HashSet<Long>();
        QFilter taskIdFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskInfoByTaskId = QueryServiceHelper.queryOne((String)"task_task", (String)"billtype,tasktypeid", (QFilter[])new QFilter[]{taskIdFilter});
        if (taskInfoByTaskId == null) {
            return refIds;
        }
        Long billTypeId = taskInfoByTaskId.getLong("billtype");
        QFilter billTypeIdFilter = new QFilter("id", "=", (Object)billTypeId);
        DynamicObjectCollection billTypeInfo = QueryServiceHelper.query((String)"task_taskbill", (String)"entryentity.childpkid", (QFilter[])new QFilter[]{billTypeIdFilter, taskTypeIdFilter = new QFilter("entryentity.tasktype", "=", (Object)(taskTypeId = Long.valueOf(taskInfoByTaskId.getLong("tasktypeid"))))});
        if (billTypeInfo == null || billTypeInfo.isEmpty() || ((DynamicObject)billTypeInfo.get(0)).get(0) == null) {
            return refIds;
        }
        Long childPkId = (Long)((DynamicObject)billTypeInfo.get(0)).get(0);
        QFilter childPkIdFilter = new QFilter("id", "=", (Object)childPkId);
        QFilter taskLevelEnable = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentitylevel.priority");
        DynamicObjectCollection taskPriorityColl = QueryServiceHelper.query((String)"task_taskbill_child", (String)"entryentitylevel.priority", (QFilter[])new QFilter[]{childPkIdFilter, taskLevelEnable});
        for (DynamicObject dynamicObject : taskPriorityColl) {
            Long taskLevelId = (Long)dynamicObject.get(0);
            refIds.add(taskLevelId);
        }
        return refIds;
    }

    @SdkDeprecated
    public static DynamicObjectCollection getDataMyTasklist(Long pkid, boolean isHistory) {
        String entityName = "task_task";
        String selector = "id,billtype,billtype.isembed,billtype.bindbill.number,billtype.isstoredindb,billtype.externalerp.number,billtype.isuseimage,oprt,billid,pooltype,state,subject,tasktypeid,tasktypeid.qualityjudge,bizdata_tag,qualitystate,apprevalmessage,qualitysamplelibrary,imagenumber,billnumber,innermsg,personid,decisionitem,unpassreasondesc,billlongid";
        if (isHistory) {
            selector = selector + ",sourcetaskid";
            entityName = "task_taskhistory";
        } else {
            selector = selector + ",approveop,pendingopinion,rescanopinion,unpassreasondata";
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)pkid);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet dataset = orm.queryDataSet("tasklist", entityName, selector, filters);){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)dataset, (String)entityName);
            return dynamicObjectCollection;
        }
    }

    public static List<Map<String, Object>> getMyTaskListInfoByPkIds(Set<Long> pkids) {
        String sql = "select a.*,c.fpriorityid, bc.fdownadjust from (select aa.fid,aa.ftasktypeid,aa.fbilltypeid,aa.fsubject,aa.ftasklevelid,bb.fpriority,aa.fqualitysamplelibraryid,aa.fstate from t_tk_task aa left join t_tk_tasklevel bb on aa.ftasklevelid = bb.fid where aa.fid in (%s))a left join t_tk_taskrulebill b on a.fbilltypeid = b.fid and a.ftasktypeid = b.ftasktype left join t_tk_levelentry c on b.fchildpkid = c.fid  left join T_tk_taskbillchild bc on b.fchildpkid = bc.fid";
        String params = StringUtils.join((Object[])pkids.toArray(), (String)",");
        try (DataSet ds = DB.queryDataSet((String)"kd.ssc.getMyTaskListInfoByPkIds", (DBRoute)DBRoute.of((String)"ssc"), (String)String.format(sql, params));){
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
            while (ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, Object> result = new HashMap<String, Object>(8);
                result.put("qualitySampleLibrary", row.getLong("fqualitysamplelibraryid"));
                result.put("id", row.getLong("fid"));
                result.put("state", row.getString("fstate"));
                result.put("priority", row.getLong("fpriorityid"));
                result.put("taskId", row.getLong("fid"));
                result.put("subject", row.getString("fsubject"));
                result.put("taskLevelId", row.getLong("ftasklevelid"));
                result.put("level", row.getInteger("fpriority"));
                result.put("billTypeId", row.getLong("fbilltypeid"));
                result.put("taskTypeId", row.getLong("ftasktypeid"));
                result.put("downAdjust", row.getString("fdownadjust"));
                resultList.add(result);
            }
            ArrayList<Map<String, Object>> arrayList = resultList;
            return arrayList;
        }
    }

    public static String getErpNumber(long billtypeid) {
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        if (billType == null) {
            return null;
        }
        String erpNumber = (String)billType.get("externalerp.number");
        return erpNumber == null ? null : erpNumber.toLowerCase();
    }

    public static boolean isTaskforcurrentperson(long id) {
        long personid;
        QFilter filter;
        RequestContext requestContext = RequestContext.get();
        long currentUserId = NumberUtils.toLong((String)requestContext.getUserId());
        ORM orm = ORM.create();
        DynamicObject obj = orm.queryOne("task_task", "id,personid", (filter = new QFilter("id", "=", (Object)id)).toArray());
        return obj == null || (personid = ((Long)obj.get("personid")).longValue()) != currentUserId;
    }

    public static DynamicObject getQualityCheckTask(long taskId, boolean isHistoryTask) {
        String entityName = "task_task";
        if (isHistoryTask) {
            entityName = "task_taskhistory";
        }
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        String selectFields = "billtype,billtype.isembed,sourcetaskid, oprt,billid,pooltype,state,subject,tasktypeid,bizdata_tag,personid, qualitysamplelibrary,qualitystate,orignalperson,reformperson,billnumber,apprevalmessage,innermsg,sscid";
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filter.toArray());
    }

    public static String findParentBillId(long billid, boolean processingTask) {
        log.info(String.format("request queryTaskRealBillId,param is %1s and %2s", billid, processingTask));
        Object data = DispatchServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"queryTaskRealBillId", (Object[])new Object[]{billid, processingTask});
        log.info(String.format("request queryTaskRealBillId,return is %s ", data.toString()));
        if (data instanceof Map) {
            Map map = (Map)data;
            String success = (String)map.get("success");
            if ("true".equals(success)) {
                Map realBillId = (Map)map.get("data");
                return (String)realBillId.get("realBillId");
            }
            throw new KDBizException(String.format(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8be5\u4efb\u52a1\u7684\u6bcd\u5355ID\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%1$s\u3002", (String)"TaskQueryServiceHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), map.get("msg")), new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8be5\u4efb\u52a1\u7684\u6bcd\u5355ID\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskQueryServiceHelper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }
}

