/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.satisfactionevaluation;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.satisfactionevaluation.service.EvaluateOpHelper;
import kd.ssc.task.satisfactionevaluation.common.EvaluateCommonFields;
import kd.ssc.task.satisfactionevaluation.util.EvaluateFormUtil;

public class EvaluateSidebarFormPlugin
extends AbstractFormPlugin
implements RateListener {
    private static final Log logger = LogFactory.getLog(EvaluateSidebarFormPlugin.class);

    public void registerListener(EventObject e) {
        Rate rate;
        int i;
        super.registerListener(e);
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("rateap" + i);
            rate.addRateListener((RateListener)this);
        }
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("userrate" + i);
            rate.addRateListener((RateListener)this);
        }
        Button btn = (Button)this.getView().getControl("btn_ok");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramMap != null) {
            Rate rate;
            int i;
            for (i = 1; i <= 10; ++i) {
                rate = (Rate)this.getControl("rateap" + i);
                rate.setRateTexts(Arrays.asList(EvaluateCommonFields.VERY_BAD, EvaluateCommonFields.BAD, EvaluateCommonFields.NORMAL, EvaluateCommonFields.SATISFIED, EvaluateCommonFields.VERY_SATISFIED));
            }
            for (i = 1; i <= 10; ++i) {
                rate = (Rate)this.getControl("userrate" + i);
                rate.setRateTexts(Arrays.asList(EvaluateCommonFields.VERY_BAD, EvaluateCommonFields.BAD, EvaluateCommonFields.NORMAL, EvaluateCommonFields.SATISFIED, EvaluateCommonFields.VERY_SATISFIED));
            }
            String evaluateStatus = (String)paramMap.get("evaluateStatus");
            String billNo = (String)paramMap.get("billNo");
            String billTypeName = (String)paramMap.get("billTypeName");
            if (EvaluateStatusEnum.EVALUATED_STATE.getStatus().equals(evaluateStatus)) {
                EvaluateFormUtil.showEvaluatedData(this.getView(), billNo, billTypeName);
            } else {
                EvaluateFormUtil.showEvaluatingData(this.getView(), billNo, billTypeName);
            }
        }
    }

    public void update(RateEvent rateEvent) {
        Number rateScore = rateEvent.getRateScore();
        String key = ((Rate)rateEvent.getSource()).getKey();
        this.getModel().setValue(key + "value", (Object)rateScore);
        int dimensionNum = Integer.parseInt(this.getPageCache().get("dimensionNum"));
        int userNum = Integer.parseInt(this.getPageCache().get("userNum"));
        if (key.startsWith("rateap")) {
            int score;
            for (int i = 1; i <= dimensionNum; ++i) {
                String rateAp = "rateap" + i;
                if (!rateAp.equals(key)) continue;
                EvaluateFormUtil.setReason(this.getView(), this.getModel().getValue("dimension" + i), i, rateScore.intValue(), "reason", "text");
            }
            if ("rateap1".equals(key) && (score = ((Integer)this.getModel().getValue(key + "value")).intValue()) >= 3 && !EvaluateFormUtil.isScoredOther(this.getModel(), dimensionNum)) {
                EvaluateFormUtil.setOtherScore(this.getView(), dimensionNum, score);
            }
        } else if (key.startsWith("userrate")) {
            for (int i = 1; i <= userNum; ++i) {
                String rateAp = "userrate" + i;
                if (!rateAp.equals(key)) continue;
                EvaluateFormUtil.setReason(this.getView(), this.getModel().getValue("dimension11"), i, rateScore.intValue(), "userreason", "usertext");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (propertyName.startsWith("reason")) {
            EvaluateFormUtil.setTextFlexVisible(this.getView(), propertyName, "text", newValue);
        } else if (propertyName.startsWith("userreason")) {
            EvaluateFormUtil.setTextFlexVisible(this.getView(), propertyName, "usertext", newValue);
        }
    }

    public void afterBindData(EventObject e) {
        int i;
        super.afterBindData(e);
        for (i = 1; i <= 10; ++i) {
            Object dimensionId = this.getModel().getValue("dimension" + i);
            if (dimensionId != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"dimensionflex" + i});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"dimensionflex" + i});
            }
            EvaluateFormUtil.setReasonTextVisible(this.getView(), "rateap", "reason", "text", i);
        }
        for (i = 1; i <= 10; ++i) {
            Object user = this.getModel().getValue("user" + i);
            if (user != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexuser" + i});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexuser" + i});
            }
            EvaluateFormUtil.setReasonTextVisible(this.getView(), "userrate", "userreason", "usertext", i);
        }
        EvaluateFormUtil.bindAttachments(this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_ok".equals(control.getKey())) {
            Map<String, Object> paramMap = EvaluateFormUtil.generateParamMap(this.getView());
            Optional opResult = EvaluateOpHelper.doEvaluate(paramMap);
            if (opResult.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"EvaluateSidebarFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[]{opResult.get()}));
            } else {
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
        }
    }
}

