/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.fatvs;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SmartApproval4FATVSService
implements ISkillRunnable {
    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        List autoQualityTasks;
        SkillRunResult res = skillRunContext.getSkillResult();
        res.setDate(skillRunContext.getStartTime());
        res.setFailCount(Integer.valueOf(0));
        QFilter dateFilter = new QFilter("completetime", ">", (Object)skillRunContext.getStartTime()).and(new QFilter("completetime", "<=", (Object)skillRunContext.getEndTime()));
        QFilter autoFilter = new QFilter("autoprocess", "=", (Object)"1");
        QFilter qualityFilter = new QFilter("qualitysamplelibrary", "=", (Object)0L);
        DynamicObjectCollection autoTaskInTimeRange = QueryServiceHelper.query((String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{dateFilter, autoFilter, qualityFilter});
        res.setTotalCount(Integer.valueOf(autoTaskInTimeRange.size()));
        LocalDate startDate = LocalDate.now().minusDays(30L);
        QFilter dateFilter2 = new QFilter("completetime", ">", (Object)startDate).and(new QFilter("completetime", "<=", (Object)LocalDateTime.now()));
        DynamicObjectCollection allTask = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,autoprocess,qualitysamplelibrary,sourcetaskid,qualityresult,decisionitem", (QFilter[])dateFilter2.toArray());
        List tasks = allTask.stream().filter(t -> t.getLong("qualitysamplelibrary") == 0L).collect(Collectors.toList());
        List autoTask = tasks.stream().filter(t -> t.getBoolean("autoprocess")).collect(Collectors.toList());
        ArrayList indexList = new ArrayList(3);
        res.setData(indexList);
        if (tasks.size() > 0) {
            BigDecimal autoRatio = new BigDecimal(autoTask.size()).multiply(new BigDecimal(100)).divide(new BigDecimal(tasks.size()), 2, 4);
            HashMap<String, String> autoRatioMap = new HashMap<String, String>();
            autoRatioMap.put("number", "znshl30");
            autoRatioMap.put("name", ResManager.loadKDString((String)"\u8fd130\u5929\u667a\u80fd\u5ba1\u6838\u7387", (String)"SmartApproval4FATVSService_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            autoRatioMap.put("value", autoRatio.toString() + '%');
            autoRatioMap.put("valueType", "1");
            indexList.add(autoRatioMap);
        }
        if ((autoQualityTasks = allTask.stream().filter(t -> t.getLong("qualitysamplelibrary") > 0L && t.getBoolean("autoprocess")).collect(Collectors.toList())).size() > 0) {
            BigDecimal autoQualityCount = new BigDecimal(autoQualityTasks.size());
            long qualifiedCount = autoQualityTasks.stream().filter(t -> "1".equals(t.getString("qualityresult"))).count();
            BigDecimal qualifiedRatio = new BigDecimal(qualifiedCount).multiply(new BigDecimal(100)).divide(autoQualityCount, 2, 4);
            HashMap<String, String> qualifiedRatioCountMap = new HashMap<String, String>();
            qualifiedRatioCountMap.put("number", "zjtgl30");
            qualifiedRatioCountMap.put("name", ResManager.loadKDString((String)"\u8fd130\u5929\u8d28\u68c0\u901a\u8fc7\u7387", (String)"SmartApproval4FATVSService_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            qualifiedRatioCountMap.put("value", qualifiedRatio.toString() + '%');
            qualifiedRatioCountMap.put("valueType", "1");
            indexList.add(qualifiedRatioCountMap);
        }
        List sourceTaskIds = autoTask.stream().map(qt -> qt.getLong("sourcetaskid")).collect(Collectors.toList());
        DynamicObjectCollection parNodes = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter("taskid", "in", sourceTaskIds).toArray());
        Set taskIdsOfNodes = parNodes.stream().map(node -> node.getLong("taskid")).collect(Collectors.toSet());
        List autoParTasks = autoTask.stream().filter(at -> taskIdsOfNodes.contains(at.getLong("sourcetaskid"))).collect(Collectors.toList());
        if (autoParTasks.size() > 0) {
            long returnSSCTaskCount = autoParTasks.stream().filter(apt -> "3".equals(apt.getString("decisionitem"))).count();
            BigDecimal reexamineRatio = new BigDecimal(returnSSCTaskCount).multiply(new BigDecimal(100)).divide(new BigDecimal(autoParTasks.size()), 2, 4);
            HashMap<String, String> reexamineRatioMap = new HashMap<String, String>();
            reexamineRatioMap.put("number", "fsdhl30");
            reexamineRatioMap.put("name", ResManager.loadKDString((String)"\u8fd130\u5929\u590d\u5ba1\u6253\u56de\u7387", (String)"SmartApproval4FATVSService_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            reexamineRatioMap.put("value", reexamineRatio.toString() + '%');
            reexamineRatioMap.put("valueType", "1");
            indexList.add(reexamineRatioMap);
        }
        return res;
    }
}

