/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.rpt.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.service.rpt.TaskCountService;

public class TaskQualityStatisticsServiceImpl
implements TaskCountService {
    private static final String TASK = "task_task";
    private static final String TASK_HIS = "task_taskhistory";
    private static final String STATE = "task_statechange";
    private static final String STATE_HIS = "task_statechangehis";
    private static final String TASK_QUALITY_STATISTICS = "task_qualitystatistics_t";
    private static final String TASK_FLAG = "taskFlag";
    private static final String STATE_FLAG = "stateFlag";
    private static final String ALL_FLAG = "allFlag";
    private static final int PAGE_SIZE = 1000;

    @Override
    public void countTask() {
        List dateRangeEnums = Arrays.stream(DateRangeEnum.values()).sorted(Enum::compareTo).collect(Collectors.toList());
        DateRangeEnum maxDateRange = (DateRangeEnum)((Object)dateRangeEnums.get(dateRangeEnums.size() - 1));
        try (DataSet taskDataSet = this.queryByDateRange(TASK, maxDateRange);
             DataSet stateDataSet = this.query(STATE);
             DataSet taskHisDataSet = this.queryByDateRange(TASK_HIS, maxDateRange);
             DataSet stateHisDateSet = this.query(STATE_HIS);){
            for (int i = 0; i < dateRangeEnums.size(); ++i) {
                DataSet processData = null;
                if (i == dateRangeEnums.size() - 1 && maxDateRange.compareTo((Enum)dateRangeEnums.get(i)) == 0) {
                    processData = this.process(taskDataSet, taskHisDataSet, stateDataSet, stateHisDateSet);
                } else {
                    try (DataSet taskGroup = this.group(taskDataSet.copy(), (DateRangeEnum)((Object)dateRangeEnums.get(i)));
                         DataSet taskHisGroup = this.group(taskHisDataSet.copy(), (DateRangeEnum)((Object)dateRangeEnums.get(i)));){
                        processData = this.process(taskGroup, taskHisGroup, stateDataSet.copy(), stateHisDateSet.copy());
                    }
                }
                if (null == processData) continue;
                this.delete((DateRangeEnum)((Object)dateRangeEnums.get(i)));
                this.save(processData, (DateRangeEnum)((Object)dateRangeEnums.get(i)));
            }
        }
    }

    private DataSet query(String entityName) {
        String selField = this.getFields(entityName);
        QFilter[] filters = this.getFilters(entityName);
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)entityName, (String)selField, (QFilter[])filters, null);
    }

    private DataSet queryByDateRange(String entityName, DateRangeEnum dateRangeEnum) {
        String selField = this.getFields(entityName);
        QFilter[] filters = this.getFilters(entityName);
        DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnum);
        Date startDate = dateRange.getStartDate();
        Date endDate = dateRange.getEndDate();
        if (TASK.equals(entityName) || TASK_HIS.equals(entityName)) {
            filters = Arrays.copyOf(filters, filters.length + 2);
            filters[filters.length - 2] = new QFilter("receivetime", ">=", (Object)startDate);
            filters[filters.length - 1] = new QFilter("receivetime", "<", (Object)endDate);
        }
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".query"), (String)entityName, (String)selField, (QFilter[])filters, null);
    }

    private DataSet group(DataSet dataSet, DateRangeEnum dateRangeEnum) {
        HashMap<String, Date> filterValue = new HashMap<String, Date>(2);
        DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnum);
        filterValue.put("startDate", dateRange.getStartDate());
        filterValue.put("endDate", dateRange.getEndDate());
        return dataSet.filter("receivetime >= startDate and receivetime < endDate", filterValue);
    }

    private DataSet process(DataSet taskDataSet, DataSet taskHisDataSet, DataSet stateDataSet, DataSet stateHisDataSet) {
        String[] selTask = this.getSel(TASK_FLAG);
        String[] selState = this.getSel(STATE_FLAG);
        String[] selAll = this.getSel(ALL_FLAG);
        String[] groupBy = this.getGroupBy();
        ArrayList<String> groupList = new ArrayList<String>(Arrays.asList(groupBy));
        groupList.add("id");
        String[] groupByWithId = groupList.toArray(new String[0]);
        DataSet taskDataSetCopy = taskDataSet.copy();
        DataSet taskHisDataSetCopy = taskHisDataSet.copy();
        DataSet taskcountDataSet = taskDataSetCopy.union(taskHisDataSetCopy);
        taskcountDataSet = taskcountDataSet.select(selTask).groupBy(groupBy).count("taskcount").finish();
        DataSet taskStateDataSet = taskDataSet.join(stateDataSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        DataSet taskStateHisDataSet = taskHisDataSet.join(stateHisDataSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        DataSet unionDataSet = taskStateDataSet.union(taskStateHisDataSet);
        unionDataSet = unionDataSet.select(selAll).groupBy(groupByWithId).sum("cast(case when state = '4' then 1 else 0 end as integer)", "unpasscount").sum("cast(case when state = '2' then 1 else 0 end as integer)", "returncount").sum("cast(case when state = '0' then 1 else 0 end as integer)", "pendingcount").sum("cast(case when state = '4' or state = '2' or state = '0' then 1 else 0 end as integer)", "exceptioncount").finish();
        ArrayList<String> selList = new ArrayList<String>(Arrays.asList(selTask));
        selList.add("unpasscount");
        selList.add("returncount");
        selList.add("pendingcount");
        selList.add("exceptioncount");
        unionDataSet = unionDataSet.select(selList.toArray(new String[0])).groupBy(groupBy).sum("case when unpasscount >= 1 then 1 else 0 end", "unpasscount").sum("cast(case when returncount >= 1 then 1 else 0 end as integer)", "returncount").sum("cast(case when pendingcount >= 1 then 1 else 0 end as integer)", "pendingcount").sum("cast(case when exceptioncount >= 1 then 1 else 0 end as integer)", "exceptioncount").finish();
        JoinDataSet joinDataSet = unionDataSet.join(taskcountDataSet, JoinType.LEFT).on("tasktypeid", "tasktypeid").on("billtypeid", "billtypeid").on("orgid", "orgid").on("personid", "personid");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(selTask));
        list.remove(0);
        String[] orderBy = list.toArray(new String[0]);
        list.add("unpasscount");
        list.add("returncount");
        list.add("pendingcount");
        list.add("exceptioncount");
        String[] selField = list.toArray(new String[0]);
        unionDataSet = joinDataSet.select(selField, new String[]{"taskcount"}).finish();
        return unionDataSet.orderBy(orderBy);
    }

    private void delete(DateRangeEnum dateRangeEnum) {
        QFilter filter = new QFilter("daterange", "=", (Object)dateRangeEnum.getValue());
        DeleteServiceHelper.delete((String)TASK_QUALITY_STATISTICS, (QFilter[])new QFilter[]{filter});
    }

    private void save(DataSet dataSet, DateRangeEnum dateRangeEnum) {
        int totalCount = dataSet.copy().count("sscid", false);
        int pageCount = totalCount / 1000;
        int remiCount = totalCount;
        for (int i = 0; i <= pageCount; ++i) {
            int fromIndex = i * 1000;
            int pageSizeAcu = Math.min(remiCount, 1000);
            try (AlgoContext context = Algo.newContext();){
                DataSet subDataSet = dataSet.copy().range(fromIndex, pageSizeAcu);
                this.savePage(subDataSet, dateRangeEnum, pageSizeAcu);
                if ((remiCount -= 1000) <= 0) break;
                subDataSet.close();
                continue;
            }
        }
        dataSet.close();
    }

    private void savePage(DataSet subDataSet, DateRangeEnum dateRangeEnum, int size) {
        DynamicObject[] dataArr = new DynamicObject[size];
        int i = 0;
        for (Row row : subDataSet) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)TASK_QUALITY_STATISTICS);
            obj.set("daterange", (Object)dateRangeEnum.getValue());
            obj.set("ssc", row.get("sscid"));
            obj.set("tasktype", row.get("tasktypeid"));
            obj.set("org", row.get("orgid"));
            obj.set("billtype", row.get("billtypeid"));
            obj.set("person", row.get("personid"));
            obj.set("taskcount", row.get("taskcount"));
            obj.set("unpasscount", row.get("unpasscount"));
            obj.set("returncount", row.get("returncount"));
            obj.set("pendingcount", row.get("pendingcount"));
            obj.set("exceptioncount", row.get("exceptioncount"));
            obj.set("createtime", (Object)new Date());
            dataArr[i++] = obj;
        }
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    private String getFields(String entityName) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if (TASK.equals(entityName) || TASK_HIS.equals(entityName)) {
            fieldList.add("id");
            fieldList.add("sscid");
            fieldList.add("receivetime");
            fieldList.add("tasktypeid.name as tasktypename");
            fieldList.add("tasktypeid.id as tasktypeid");
            fieldList.add("billtype.name as billtypename");
            fieldList.add("billtype.id as billtypeid");
            fieldList.add("orgid.name as orgname");
            fieldList.add("orgid.id as orgid");
            fieldList.add("personid.name as personname");
            fieldList.add("personid.id as personid");
            fieldList.add("personid.picturefield as personpic");
        } else if (STATE.equals(entityName) || STATE_HIS.equals(entityName)) {
            fieldList.add("jobid");
            fieldList.add("newjobstate as state");
        }
        String fieldListStr = ((Object)fieldList).toString();
        return fieldListStr.substring(1, fieldListStr.length() - 1);
    }

    private QFilter[] getFilters(String entityName) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        if (TASK.equals(entityName) || TASK_HIS.equals(entityName)) {
            qfList.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
            qfList.add(new QFilter("autoprocess", "=", (Object)"0"));
        } else if (STATE.equals(entityName) || STATE_HIS.equals(entityName)) {
            ArrayList<String> stateList = new ArrayList<String>();
            stateList.add("3");
            stateList.add("4");
            stateList.add("0");
            stateList.add("2");
            stateList.add("6");
            QFilter qFilter = new QFilter("newjobstate", "in", stateList);
            qfList.add(qFilter);
        }
        return qfList.toArray(new QFilter[0]);
    }

    private String[] getSel(String flag) {
        ArrayList<String> fieldList = new ArrayList<String>();
        if (TASK_FLAG.equals(flag) || ALL_FLAG.equals(flag)) {
            fieldList.add("id");
            fieldList.add("sscid");
            fieldList.add("tasktypename");
            fieldList.add("tasktypeid");
            fieldList.add("billtypename");
            fieldList.add("billtypeid");
            fieldList.add("orgname");
            fieldList.add("orgid");
            fieldList.add("personname");
            fieldList.add("personid");
            fieldList.add("personpic");
        }
        if (STATE_FLAG.equals(flag) || ALL_FLAG.equals(flag)) {
            fieldList.add("jobid");
            fieldList.add("state");
        }
        return fieldList.toArray(new String[0]);
    }

    private String[] getGroupBy() {
        ArrayList<String> groupList = new ArrayList<String>();
        groupList.add("sscid");
        groupList.add("tasktypename");
        groupList.add("tasktypeid");
        groupList.add("billtypename");
        groupList.add("billtypeid");
        groupList.add("orgname");
        groupList.add("orgid");
        groupList.add("personname");
        groupList.add("personid");
        groupList.add("personpic");
        return groupList.toArray(new String[0]);
    }
}

