/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.userworkload;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.helper.MessageHelper;
import kd.ssc.task.helper.MutexCacheHelper;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class DisTaskWithUserIdHelper {
    private static final Log log = LogFactory.getLog(DisTaskWithUserIdHelper.class);

    public static List<Long> disTaskNew(Long userId, List<Long> taskIds, StringBuilder errorMsg, Long userGroup, boolean isRedistribute, Map<Long, Integer> task2Index) {
        ArrayList<DynamicObject> disTaskDynaList = new ArrayList<DynamicObject>();
        Map<Long, DynamicObject> disTaskMap = Arrays.stream(BusinessDataServiceHelper.load((Object[])taskIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task"))).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long taskId : taskIds) {
            DynamicObject disTask = disTaskMap.get(taskId);
            if (disTask != null) {
                long personId = disTask.getLong("personid.id");
                long userGroupId = disTask.getLong("usergroup.id");
                String billNumber = disTask.getString("billnumber");
                if (isRedistribute && MutexCacheHelper.containsMutexCache(String.valueOf(taskId))) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6b63\u5728\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u91cd\u5206\u914d\u3002", (String)"TaskAdministrateListPlugin_104", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber));
                    errorMsg.append("\n");
                    continue;
                }
                if (userId.equals(personId) && userGroup.equals(userGroupId)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5206\u914d\u5931\u8d25\uff0c\u91cd\u5206\u914d\u4eba\u5458\u4e0e\u73b0\u5904\u7406\u4eba\u76f8\u540c\u3002", (String)"UserWorkLoadFormPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber));
                    errorMsg.append("\n");
                    continue;
                }
                disTaskDynaList.add(disTask);
                continue;
            }
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u53ef\u80fd\u5df2\u88ab\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868\u3002", (String)"UserWorkLoadFormPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), task2Index.get(taskId) + 1));
            errorMsg.append("\n");
        }
        List<Long> successIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(disTaskDynaList)) {
            if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
                successIds = Distribution.manualDisTaskDeal4Batch(userGroup, userId, disTaskDynaList, errorMsg);
            } else {
                DynamicObject[] disTasks = disTaskDynaList.toArray(new DynamicObject[disTaskDynaList.size()]);
                successIds = DisTaskWithUserIdHelper.disTaskOld(userId, disTasks, userGroup);
            }
            log.info("\u624b\u5de5\u5206\u914d\uff0c\u6210\u529f\u5206\u914d\u7684\u4efb\u52a1id\uff1a" + Arrays.toString((Object[])successIds.toArray(new Long[0])));
        }
        return successIds;
    }

    private static List<Long> disTaskOld(Long userId, DynamicObject[] disTaskDynaList, Long userGroup) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        boolean robotGroup = UserGroupUtil.isRobotGroup(userGroup);
        HashSet<Long> successSampleLibIds = new HashSet<Long>(8);
        ArrayList<DynamicObject> stateChangeDynObjs = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        for (DynamicObject disTask : disTaskDynaList) {
            boolean isQuality;
            String curPoolType = disTask.getString("pooltype");
            Long sampleLib = disTask.getLong("qualitysamplelibrary.id");
            Date firstreceivetime = disTask.getDate("firstreceivetime");
            disTask.set("personid", (Object)userId);
            if (sampleLib > 0L) {
                disTask.set("orignalperson", (Object)userId);
            }
            disTask.set("usergroup", (Object)userGroup);
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
                DisTaskWithUserIdHelper.setState4DisTask(disTask, now, stateChangeDynObjs, successSampleLibIds, userId);
            } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(curPoolType)) {
                DisTaskWithUserIdHelper.setState4RedisTask(disTask, now, stateChangeDynObjs, userId);
            } else {
                log.error("pooltype error, taskid = " + disTask.getLong("id") + ", pooltype = " + curPoolType);
                continue;
            }
            disTask.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
            disTask.set("receivetime", (Object)now);
            boolean bl = isQuality = sampleLib > 0L;
            if (!isQuality && firstreceivetime == null) {
                disTask.set("firstreceivetime", (Object)now);
            }
            disTask.set("autoprocess", (Object)robotGroup);
            taskIds.add(disTask.getLong("id"));
        }
        try {
            SaveServiceHelper.save((DynamicObject[])disTaskDynaList);
            SaveServiceHelper.save((DynamicObject[])stateChangeDynObjs.toArray(new DynamicObject[stateChangeDynObjs.size()]));
            DisTaskWithUserIdHelper.deletePriorityLog(taskIds);
            if (!successSampleLibIds.isEmpty()) {
                QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(successSampleLibIds);
            }
            OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(disTaskDynaList, null);
            DisTaskWithUserIdHelper.addTaskCommon(disTaskDynaList);
            try {
                ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDist((DynamicObject[])disTaskDynaList);
            }
            catch (Exception e) {
                log.error("UserWorkLoadFormPlugin.disTaskWithUserId: \u624b\u52a8\u5206\u914d -> \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            MessageHelper.sendMessage((DynamicObject[])disTaskDynaList);
        }
        catch (Exception e) {
            log.error("\u91cd\u5206\u914d\u5931\u8d25:", (Throwable)e);
            return new ArrayList<Long>();
        }
        return taskIds;
    }

    private static void setState4DisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Set<Long> successSampleLibIds, Long userId) {
        Long sampleLib = disTask.getLong("qualitysamplelibrary.id");
        String curState = disTask.getString("state");
        if (sampleLib > 0L) {
            disTask.set("state", (Object)TaskStateEnum.CHECKING.getValue());
            successSampleLibIds.add(sampleLib);
        } else {
            disTask.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        }
        DynamicObject stateChangeObj = DisTaskWithUserIdHelper.createTaskStateChangeDynObj(disTask.getLong("id"), disTask.getString("state"), curState, now, "6", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private static void setState4RedisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Long userId) {
        String curState = disTask.getString("state");
        DynamicObject stateChangeObj = DisTaskWithUserIdHelper.createTaskStateChangeDynObj(disTask.getLong("id"), curState, curState, now, "7", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private static DynamicObject createTaskStateChangeDynObj(Long taskId, String newJobState, String oldJobState, Date changeTime, String operation, Long tasktype_id, Long billtype_id, Long userId) {
        DynamicObject stateChangeDynObj = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        stateChangeDynObj.set("jobid", (Object)taskId);
        stateChangeDynObj.set("newjobstate", (Object)newJobState);
        stateChangeDynObj.set("oldjobstate", (Object)oldJobState);
        stateChangeDynObj.set("changetime", (Object)changeTime);
        stateChangeDynObj.set("operatorid_id", (Object)RequestContext.get().getCurrUserId());
        stateChangeDynObj.set("allocatedpersonid_id", (Object)userId);
        stateChangeDynObj.set("operation", (Object)operation);
        stateChangeDynObj.set("tasktype_id", (Object)tasktype_id);
        stateChangeDynObj.set("billtype_id", (Object)billtype_id);
        return stateChangeDynObj;
    }

    private static void deletePriorityLog(List<Long> jobId) {
        QFilter fjobId = new QFilter("job", "in", jobId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"ssc.deletePriorityLog", (String)"task_prioritychangerecord", (String)"id,job", (QFilter[])fjobId.toArray(), null);
        if (col != null && col.size() > 0) {
            Object[] pks = new Object[col.size()];
            int i = 0;
            for (DynamicObject obj : col) {
                pks[i++] = obj.getLong("id");
            }
            BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"task_prioritychangerecord"), (Object[])pks);
        }
    }

    private static void addTaskCommon(DynamicObject[] disTaskDynaList) {
        TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])disTaskDynaList, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"UserWorkLoadFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }
}

