/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.ssc.task.api.customerbase.TaskCustomerApi;

public class CreditBoardDataApiService
extends TaskCustomerApi
implements IBillWebApiPlugin {
    private StringBuilder errorInfo = null;

    public ApiResult doCustomService(Map<String, Object> params) {
        if (this.validateParams(params)) {
            Object result = this.invokeBizService("ssc", "task", "ICreditService", "getCreditBoardData", params);
            return ApiResult.success(result);
        }
        return ApiResult.fail((String)this.errorInfo.toString());
    }

    private boolean validateParams(Map<String, Object> params) {
        Date endTime;
        Date startTime;
        String sscid = (String)params.get("sscid");
        String startTimeStr = (String)params.get("starttime");
        String endTimeStr = (String)params.get("endtime");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)sscid)) {
            sb.append("The value of parameter sscid cannot be empty;");
        }
        if (StringUtils.isEmpty((CharSequence)startTimeStr)) {
            sb.append("The value of parameter starttime cannot be empty;");
        }
        if (StringUtils.isEmpty((CharSequence)endTimeStr)) {
            sb.append("The value of parameter endtime cannot be empty;");
        }
        if (sb.length() > 0) {
            this.errorInfo = sb;
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startTime = dateFormat.parse(startTimeStr);
            endTime = dateFormat.parse(endTimeStr);
        }
        catch (ParseException e) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u793a\u4f8b\uff1ayyyy-MM-dd", (String)"CreditBoardDataApiService_0", (String)"ssc-task-webapi", (Object[])new Object[0]));
            this.errorInfo = sb;
            return false;
        }
        if (startTime.after(endTime)) {
            sb.append("The value of startTime must be less than endTime;");
        } else if (this.validateDateRange(startTime, endTime)) {
            sb.append("The range of date cannot exceed one year;");
        }
        if (sb.length() > 0) {
            this.errorInfo = sb;
            return false;
        }
        return true;
    }

    private boolean validateDateRange(Date startTime, Date endTime) {
        Calendar calen = Calendar.getInstance();
        calen.setTime(endTime);
        calen.add(1, -1);
        Date lastYear = calen.getTime();
        return startTime.before(lastYear);
    }
}

