/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.dto.SynBailedOrgDTO;
import kd.ssc.task.opplugin.BizBillSynOrgValidator;
import kd.ssc.task.util.OrganizationSynchronizeUtil;

public class BizBillSynOrgPlugin
extends AbstractOperationServicePlugIn {
    private List<SynBailedOrgDTO> dataList;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("ssccenter");
        fieldKeys.add("bindbill");
        fieldKeys.add("bindbill_new");
        fieldKeys.add("applycond");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                long sscid = this.dataEntities[0].getDataEntity().getLong("ssccenter.id");
                List orgIds = OrgRelationQueryHelper.getFromOrgListFilterDutyScope((long)sscid, (boolean)true);
                if (orgIds.isEmpty()) {
                    String errMsg = ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u59d4\u6258\u5173\u7cfb\u672a\u8bbe\u7f6e\uff0c\u540c\u6b65\u5931\u8d25\u3002", (String)"BizBillSynOrgPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        this.addMessage(dataEntity, errMsg);
                    }
                }
            }
        });
        e.getValidators().add(new BizBillSynOrgValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.dataList = this.trans(e.getDataEntities());
        OrganizationSynchronizeUtil util = new OrganizationSynchronizeUtil(this.dataList);
        util.synBailedOrganizationWithoutValidate();
    }

    private List<SynBailedOrgDTO> trans(DynamicObject[] dataEntities) {
        ArrayList<SynBailedOrgDTO> bizData = new ArrayList<SynBailedOrgDTO>(dataEntities.length);
        for (DynamicObject dyo : dataEntities) {
            SynBailedOrgDTO dto = new SynBailedOrgDTO();
            dto.setBizBillId(Long.valueOf(dyo.getLong("id")));
            dto.setSscid(Long.valueOf(dyo.getLong("ssccenter.id")));
            dto.setBindBill(dyo.getString("bindbill_new.number"));
            dto.setAppCondId(Long.valueOf(dyo.getLong("applycond.id")));
            bizData.add(dto);
        }
        return bizData;
    }
}

