/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.opplugin.util.AbstractValidatorOWR;
import kd.ssc.task.util.CommonValidateUtil;

public class UserGroupSaveValidator
extends AbstractValidatorOWR {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("task_usergroup");
    }

    @Override
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuffer errorMsg = new StringBuffer();
            Long id = dataEntity.getBillPkId() == null ? 0L : Long.parseLong(dataEntity.getBillPkId().toString());
            String name = dataEntity.getValue("name") == null ? null : dataEntity.getValue("name").toString();
            String number = dataEntity.getValue("number") == null ? null : dataEntity.getValue("number").toString();
            DynamicObject ssccenterDynObj = (DynamicObject)dataEntity.getValue("orgfield");
            Long orgfield = ssccenterDynObj == null ? 0L : ssccenterDynObj.getLong("id");
            CommonValidateUtil.validatePropertyIfExisted((ExtendedDataEntity)dataEntity, (String)"task_usergroup", (Long)id, (String)"name", (Object)name, (String)"orgfield", (Long)orgfield, (String)(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"UserGroupSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]) + "\n"), (String)(ResManager.loadKDString((String)"\u6b64\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff1b", (String)"UserGroupSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]) + "\n"), (StringBuffer)errorMsg);
            if (errorMsg.length() > 0) {
                errorMsg.deleteCharAt(errorMsg.length() - 1);
                this.addMessage(dataEntity, CommonValidateUtil.replaceEnding((String)errorMsg.toString()), ErrorLevel.Error);
            }
            this.userValidate(dataEntity);
        }
    }

    private void userValidate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection dynObjs = (DynamicObjectCollection)dataEntity.getObjectByName("entryentity");
        StringBuilder sb = new StringBuilder();
        HashMap<Long, Integer> dupIdMap = new HashMap<Long, Integer>();
        HashMap<Long, String> userIDNameMap = new HashMap<Long, String>();
        int entrySize = dynObjs.size();
        HashSet<Integer> teamLeader = new HashSet<Integer>(8);
        for (int i = 0; i < entrySize; ++i) {
            Iterator userNum;
            DynamicObject dynObj = (DynamicObject)dynObjs.get(i);
            if (dynObj.getBoolean("teamleader")) {
                teamLeader.add(i);
            }
            if ((userNum = dynObj.get("userfield")) == null) continue;
            Long userID = ((DynamicObject)userNum).getLong("id");
            String userName = ((DynamicObject)userNum).getString("name");
            Integer dupCount = (Integer)dupIdMap.get(userID);
            if (dupCount != null) {
                dupCount = dupCount + 1;
                dupIdMap.put(userID, dupCount);
                continue;
            }
            dupIdMap.put(userID, 0);
            userIDNameMap.put(userID, userName);
        }
        DynamicObject createOrg = (DynamicObject)dataEntity.getValue("createorg");
        boolean openTeamleader = TeamLeaderApi.isOpenTeamleader((String)String.valueOf(createOrg.getPkValue()));
        if (entrySize > 0 && teamLeader.size() == 0 && openTeamleader) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u540d\u6210\u5458\u4e3a\u7ec4\u957f\u3002", (String)"UserGroupSaveValidator_8", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
        for (Map.Entry entry : dupIdMap.entrySet()) {
            int dupNumber = (Integer)entry.getValue();
            String dupName = (String)userIDNameMap.get(entry.getKey());
            if (dupNumber <= 0) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u7528\u6237\uff1a%1$s\uff0c\u5df2\u91cd\u590d\uff0c\u91cd\u590d\u6570\u91cf\uff1a%2$s", (String)"UserGroupSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]), dupName, dupNumber));
        }
        int abortCount = 0;
        for (DynamicObject entry : dynObjs) {
            if (((Boolean)entry.get("usestatus")).booleanValue()) continue;
            ++abortCount;
        }
        if (entrySize == 0 || entrySize == abortCount) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u542f\u7528\u4e00\u540d\u7528\u6237\u7ec4\u6210\u5458\u3002", (String)"UserGroupSaveValidator_10", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.addMessage(dataEntity, sb.toString());
        }
    }
}

