/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.enums.achieve.CalFactorFieldConfigEnum;
import kd.ssc.enums.achieve.TargetRule;

public class AchieveTargetSaveValidator
extends AbstractValidator {
    private static final BigDecimal zero = new BigDecimal(0);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject achieveTarget = dataEntity.getDataEntity();
            String targetType = achieveTarget.getString("targetType");
            BigDecimal minScore = achieveTarget.getBigDecimal("minScore");
            BigDecimal maxScore = achieveTarget.getBigDecimal("maxScore");
            boolean setUp = achieveTarget.getBoolean("setup");
            boolean setDown = achieveTarget.getBoolean("setdown");
            if (setDown && minScore == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u201c\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u201d\u3002", (String)"AchieveTargetSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (setUp && maxScore == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u201c\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u201d\u3002", (String)"AchieveTargetSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"2".equals(targetType)) {
                String scoringmethod = achieveTarget.getString("scoringmethod");
                if (StringUtils.isBlank((String)scoringmethod)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u201c\u8bc4\u5206\u65b9\u5f0f\u201d\u3002", (String)"AchieveTargetSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (setDown && minScore.compareTo(zero) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u201c\u989d\u5916\u52a0\u51cf\u5206\u201d\u6307\u6807\u7684\u6307\u6807\u6700\u5c0f\u503c\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"AchieveTargetSaveValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (setUp && maxScore.compareTo(zero) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u201c\u989d\u5916\u52a0\u51cf\u5206\u201d\u6307\u6807\u7684\u6307\u6807\u6700\u5927\u503c\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"AchieveTargetSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (setUp && setDown && minScore.compareTo(maxScore) >= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u5e94\u5927\u4e8e\u7b49\u4e8e\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u3002", (String)"AchieveTargetSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
            this.checkFunction(dataEntity);
        }
    }

    private void checkFunction(ExtendedDataEntity data) {
        String targetType = (String)data.getValue("targetType");
        if (!"0".equals(targetType)) {
            return;
        }
        String assessTypeStr = (String)data.getValue("assessobject");
        if (StringUtils.isEmpty((String)assessTypeStr)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u8003\u6838\u5bf9\u8c61\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AchieveTargetSaveValidator_6", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        String[] targetAssessType = assessTypeStr.split(",");
        ArrayList<AssessTypeEnum> assessTypeEnums = new ArrayList<AssessTypeEnum>(3);
        for (String type : targetAssessType) {
            if (StringUtils.isEmpty((String)type)) continue;
            AssessTypeEnum typeEnum = AssessTypeEnum.getAssessTypeByValue((String)type);
            if (typeEnum == null) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u503c\u4e3a\u201c%1$s\u201d\u7684\u8003\u6838\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"AchieveTargetSaveValidator_9", (String)"ssc-task-opplugin", (Object[])new Object[0]), type));
                return;
            }
            assessTypeEnums.add(typeEnum);
        }
        String ruleExpJson = (String)data.getValue("ruleexpjson_tag");
        if (StringUtils.isEmpty((String)ruleExpJson)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8ba1\u7b97\u6307\u6807\u7684\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AchieveTargetSaveValidator_7", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = "number,name,datasource,fieldmapping";
        TargetRule targetRule = (TargetRule)SerializationUtils.fromJsonString((String)ruleExpJson, TargetRule.class);
        BOSExpression bosExpression = new BOSExpression(targetRule.getExpression());
        Set vars = bosExpression.getVars();
        QFilter numberFilter = new QFilter("number", "in", (Object)vars);
        DynamicObjectCollection factors = QueryServiceHelper.query((String)"ssc_calculationfactor", (String)selectFields, (QFilter[])numberFilter.toArray());
        if (factors == null) {
            return;
        }
        Map<String, DynamicObject> numberMap = factors.stream().collect(Collectors.toMap(d -> d.getString("number"), d -> d, (d1, d2) -> d2));
        for (String var : vars) {
            DynamicObject factor = numberMap.get(var);
            if (factor == null) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"AchieveTargetSaveValidator_8", (String)"ssc-task-opplugin", (Object[])new Object[0]), var));
                continue;
            }
            String fieldMapping = factor.getString("fieldmapping");
            String dataSource = factor.getString("datasource");
            if (!"1".equals(dataSource) || StringUtils.isEmpty((String)fieldMapping)) continue;
            Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fieldMapping, Map.class);
            ArrayList<String> notConfigFields = new ArrayList<String>(3);
            for (AssessTypeEnum assessType : assessTypeEnums) {
                CalFactorFieldConfigEnum factorFieldConfig = assessType.getFactorFieldConfigEnum();
                String configKey = factorFieldConfig.getFieldKey();
                Map config = (Map)fieldMap.get(configKey);
                if (config != null && !StringUtils.isEmpty((String)((String)config.get("fieldNumber")))) continue;
                notConfigFields.add(factorFieldConfig.getFieldName());
            }
            if (notConfigFields.size() == 1) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u201c%1$s\u201d\u672a\u7ef4\u62a4\u201c%2$s\u201d\u53c2\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AchieveTargetSaveValidator_10", (String)"ssc-task-opplugin", (Object[])new Object[0]), factor.getString("name"), notConfigFields.get(0)));
                continue;
            }
            if (notConfigFields.size() == 2) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u201c%1$s\u201d\u672a\u7ef4\u62a4\u201c%2$s\u201d\u3001\u201c%3$s\u201d\u53c2\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AchieveTargetSaveValidator_11", (String)"ssc-task-opplugin", (Object[])new Object[0]), factor.getString("name"), notConfigFields.get(0), notConfigFields.get(1)));
                continue;
            }
            if (notConfigFields.size() != 3) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u201c%1$s\u201d\u672a\u7ef4\u62a4\u201c%2$s\u201d\u3001\u201c%3$s\u201d\u3001\u201c%4$s\u201d\u53c2\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AchieveTargetSaveValidator_12", (String)"ssc-task-opplugin", (Object[])new Object[0]), factor.getString("name"), notConfigFields.get(0), notConfigFields.get(1), notConfigFields.get(2)));
        }
    }
}

