/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.duty;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;

public class DutyManageSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_ORGRELATION = "bos_org_orgrelation";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.delegateorg");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entryentity");
            HashSet<Long> delegateOrgSet = ObjectUtils.isEmpty((Object)entry) ? new HashSet<Long>(0) : entry.stream().map(en -> en.getLong("delegateorg_id")).collect(Collectors.toSet());
            long sscOrg = data.getLong("sscorg_id");
            this.saveOrgRelation(sscOrg, delegateOrgSet);
        }
    }

    private void saveOrgRelation(long sscOrgId, Set<Long> fromOrgSet) {
        OperationResult operationResult;
        List oldFromOrgList = OrgRelationQueryHelper.loadOrgRelationFromDb((Long)sscOrgId);
        HashSet<Long> deleteRelationSet = null;
        if (oldFromOrgList != null) {
            deleteRelationSet = new HashSet<Long>(oldFromOrgList.size() / 2);
            for (Long oldEle : oldFromOrgList) {
                if (fromOrgSet.remove(oldEle)) continue;
                deleteRelationSet.add(oldEle);
            }
        }
        DynamicObject[] addNewRelations = this.buildUnit2SSCRelation(sscOrgId, fromOrgSet);
        if (deleteRelationSet != null && deleteRelationSet.size() > 0) {
            QFilter typeFile = new QFilter("typerelation", "=", (Object)OrgRelationQueryHelper.UNIT2SSC_RELATION_TYPE_ID);
            QFilter toFilter = new QFilter("toorg", "=", (Object)sscOrgId);
            QFilter fromFilter = new QFilter("fromorg", "in", deleteRelationSet);
            DeleteServiceHelper.delete((String)ENTITY_ORGRELATION, (QFilter[])new QFilter[]{typeFile, toFilter, fromFilter});
        }
        if (addNewRelations != null && addNewRelations.length > 0 && !(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_ORGRELATION, (DynamicObject[])addNewRelations, (OperateOption)OperateOption.create())).isSuccess()) {
            this.getOperationResult().setValidateResult(operationResult.getValidateResult());
        }
    }

    private DynamicObject[] buildUnit2SSCRelation(Long sscOrgId, Set<Long> fromOrgSet) {
        if (ObjectUtils.isEmpty(fromOrgSet) || sscOrgId < 1L) {
            return null;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(fromOrgSet.size());
        for (Long fromOrg : fromOrgSet) {
            DynamicObject relationObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ORGRELATION);
            relationObj.set("typerelation_id", (Object)OrgRelationQueryHelper.UNIT2SSC_RELATION_TYPE_ID);
            relationObj.set("fromorg_id", (Object)fromOrg);
            relationObj.set("toorg_id", (Object)sscOrgId);
            result.add(relationObj);
        }
        Object[] dynamicObjects = result.toArray(new DynamicObject[0]);
        BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dynamicObjects[0].getDataEntityType());
        return dynamicObjects;
    }
}

