/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.indicators;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;

public class IndicatorsDeleteValidator
extends AbstractValidator {
    public void validate() {
        QFilter qFilter = new QFilter("indicatorstype", "!=", (Object)IndicatorsTypeEnum.MANUAL.getType());
        DynamicObject[] indicatorsData = BusinessDataServiceHelper.load((String)"som_indicators_lib", (String)"id,name,number,calformulajson", (QFilter[])new QFilter[]{qFilter});
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            boolean referenced = this.checkIndicatorsReference(indicatorsData, number);
            if (!referenced) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6307\u6807\u5df2\u88ab\u5176\u4ed6\u6307\u6807\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"IndicatorsDeleteValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkIndicatorsReference(DynamicObject[] indicatorsData, String targetNumber) {
        if (indicatorsData == null || indicatorsData.length == 0) {
            return false;
        }
        for (DynamicObject indicators : indicatorsData) {
            String calFormulaJson;
            CRFormula crFormula;
            BOSExpression bosExpression;
            Set vars;
            String number = indicators.getString("number");
            if (targetNumber.equals(number) || !(vars = (bosExpression = new BOSExpression((crFormula = (CRFormula)SerializationUtils.fromJsonString((String)(calFormulaJson = indicators.getString("calformulajson")), CRFormula.class)).getExpression())).getVars()).contains(targetNumber)) continue;
            return true;
        }
        return false;
    }
}

