/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.task.util.AlgUtil;

public class AreaClearPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("craeteorg");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.clearKnowledge(e);
    }

    private void clearKnowledge(BeginOperationTransactionArgs e) {
        String algo = "clearKnowledge#info";
        String algo2 = "clearKnowledge#area";
        HashMap<Long, Map> areaSubjectInfo = new HashMap<Long, Map>();
        HashMap<Long, Long> areaMap = new HashMap<Long, Long>(64);
        HashMap<Long, Set> aiSubSet = new HashMap<Long, Set>(16);
        Object[] areaIds = Arrays.stream(e.getDataEntities()).map(d -> d.getLong("id")).distinct().toArray();
        ArrayList<Long> deletingKnowIds = new ArrayList<Long>(64);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)algo, (String)"som_knowledge_info", (String)"id,area,aisubjectid,aiquestionid,group", (QFilter[])new QFilter("area", "in", (Object)areaIds).toArray(), null);
             DataSet rs = rows.join(rows).on("group", "id").select(new String[]{"id", "area", "aiquestionid", "group"}, new String[]{"aisubjectid"}).finish();
             DataSet areas = QueryServiceHelper.queryDataSet((String)algo2, (String)"som_knowledge_area", (String)"id,aiareaid", (QFilter[])new QFilter("id", "in", (Object)areaIds).toArray(), null);
             DataSet subjects = QueryServiceHelper.queryDataSet((String)algo2, (String)"som_knowledge_info", (String)"id,area,aisubjectid", (QFilter[])new QFilter("area", "in", (Object)areaIds).toArray(), null);){
            for (Row area2 : areas) {
                Long aiAreaId = area2.getLong("aiareaid");
                if (aiAreaId == null || aiAreaId == 0L) continue;
                areaMap.put(area2.getLong("id"), aiAreaId);
            }
            for (Row subject : subjects) {
                Long aiSubjId = subject.getLong("aisubjectid");
                Long areaId = subject.getLong("area");
                if (aiSubjId == null || aiSubjId == 0L || !areaMap.containsKey(areaId)) continue;
                deletingKnowIds.add(subject.getLong("id"));
                Long aiAreaId = (Long)areaMap.get(areaId);
                Set aiSubjIds = aiSubSet.computeIfAbsent(aiAreaId, k -> new HashSet());
                aiSubjIds.add(aiSubjId);
            }
            for (Row r : rs) {
                Long areaId = r.getLong("area");
                Long aiQuesId = r.getLong("aiquestionid");
                Long aiSubjId = r.getLong("aisubjectid");
                Long aiAreaId = (Long)areaMap.get(areaId);
                if (aiAreaId == null) continue;
                deletingKnowIds.add(r.getLong("id"));
                Map subjectInfo = areaSubjectInfo.computeIfAbsent(aiAreaId, k -> new HashMap());
                Set ques = subjectInfo.computeIfAbsent(aiSubjId, k -> new HashSet());
                ques.add(aiQuesId);
            }
            areaSubjectInfo.forEach((area, sub) -> sub.forEach((k, v) -> AIMetaDataSynchrnizedUtil.deleteQuestionForBatching((Long)area, (Long)k, new ArrayList(v))));
            aiSubSet.forEach((k, v) -> AIMetaDataSynchrnizedUtil.deleteSubjectForBatching((Long)k, new ArrayList(v)));
            if (!deletingKnowIds.isEmpty()) {
                areaSubjectInfo.forEach((area, sub) -> sub.forEach((k, v) -> AIMetaDataSynchrnizedUtil.deleteQuestionForBatching((Long)area, (Long)k, new ArrayList(v))));
                AlgUtil.splitList(deletingKnowIds, (int)5000).forEach(list -> {
                    String ids = list.stream().map(Object::toString).collect(Collectors.joining(","));
                    String sql = "DELETE FROM t_tk_scs_detail WHERE fid in (" + ids + ");";
                    String sql_l = "DELETE FROM t_tk_scs_detail_l WHERE fid in (" + ids + ");";
                    DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql);
                    DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql_l);
                });
            }
            AIMetaDataSynchrnizedUtil.deleteAreaForBatching(new ArrayList(areaMap.values()));
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"som_knowledge_area"), (Object[])areaMap.keySet().toArray(new Long[0]));
        }
    }
}

