/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.business.workbill.ExtAppUtil;
import kd.ssc.task.business.workbill.WorkBillConfigDTO;
import kd.ssc.task.business.workbill.builder.BillFormModelBuilder;
import kd.ssc.task.business.workbill.builder.WorkBillConfigDTOBuilder;
import kd.ssc.task.opplugin.sscbillmanger.WorkBillDefineSavePlugin;

public class WorkBillDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final String bizUnitId = "2O+0I8AANUD9";
    private static final Log log = LogFactory.getLog(WorkBillDefineSavePlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pnumber");
        e.getFieldKeys().add("ptype");
        e.getFieldKeys().add("pcheckmeta");
        e.getFieldKeys().add("entityid");
        e.getFieldKeys().add("panelid");
        e.getFieldKeys().add("pname");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("subentryentity.seq");
        e.getFieldKeys().add("pisvisible");
        e.getFieldKeys().add("fieldtype");
        e.getFieldKeys().add("fieldpropertyjson_tag");
        e.getFieldKeys().add("fcheckmeta");
        e.getFieldKeys().add("fieldnumber");
        e.getFieldKeys().add("fieldname");
        e.getFieldKeys().add("isvisible");
        e.getFieldKeys().add("ismust");
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("fieldapid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successDataEntities = new ArrayList<DynamicObject>(dataEntities.length);
        ValidateResultCollection validateResultCollection = this.getOperationResult().getValidateResult();
        List validateResults = validateResultCollection.getValidateErrors();
        for (DynamicObject workBill : dataEntities) {
            WorkBillConfigDTO billConfig = WorkBillConfigDTOBuilder.createWorkBillConfigDTO((String)this.getExtBizAppId(), (DynamicObject)workBill);
            Map delResult = new BillFormModelBuilder(billConfig).deleteBillFormModel();
            if (delResult == null) continue;
            boolean success = (Boolean)delResult.get("success");
            if (success) {
                successDataEntities.add(workBill);
                continue;
            }
            String workBillName = workBill.getString("name");
            ValidationErrorInfo info = new ValidationErrorInfo(workBillName, workBill.getPkValue(), 0, 0, "errorcode_001", "", workBillName + "\uff1a" + delResult.get("message"), ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
        }
        DynamicObject[] successDynamicObjectArray = successDataEntities.toArray(new DynamicObject[successDataEntities.size()]);
        e.setDataEntities(successDynamicObjectArray);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    private String getExtBizAppId() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"ssc");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,bizcloud,number", (QFilter[])new QFilter[]{numberFilter});
        String bizCloudId = metaInfo.getString("bizcloud");
        String bizAppId = metaInfo.getString("id");
        return ExtAppUtil.getExtApp((String)bizCloudId, (String)bizAppId);
    }
}

