/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.extendplugin;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.extendplugin.TaskSumAmountBill;
import kd.ssc.task.extendplugin.base.TaskExtendBill;
import kd.ssc.task.util.EasTaskExpenseHelper;
import kd.ssc.task.util.ExchangeRateService;

public class TaskDailyLoanBill
extends TaskExtendBill
implements BeforeF7SelectListener,
ClickListener {
    private static final String CHCHE_TASKDAILYLOAN_APPLAYID_VALUE = "CHCHE_TASKDAILYLOAN_APPLAYID_VALUE";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit expensetype = (BasedataEdit)this.getControl("expensetype");
        expensetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit paymode1 = (BasedataEdit)this.getControl("paymode1");
        paymode1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"txttasklevel"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection collectionentries = data.getDynamicObjectCollection("collectionentries");
        this.setFieldEditEnable(collectionentries.size() > 1, "pamountori");
        this.setFloatAmountValues(collectionentries, "pamountori", "collectionentries", "pcurrency");
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        this.setFloatAmountValues(entries, "oriapproved", "entries", "currency");
    }

    private void setFloatAmountValues(DynamicObjectCollection entries, String keyCol, String entryName, String signColName) {
        BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(entries, keyCol);
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        String sign = "\uffe5";
        if (entries.size() > 0) {
            DynamicObject currency = (DynamicObject)((DynamicObject)entries.get(0)).get(signColName);
            sign = currency.get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyCol, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int payModeSize = this.getModel().getEntryRowCount("collectionentries");
        if (payModeSize > 0) {
            for (int i = 0; i < payModeSize; ++i) {
                if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("paymode", i)))) {
                    this.setFieldEditVisible(false, "paymode1");
                    continue;
                }
                this.setFieldEditVisible(false, "paymode");
            }
        }
        this.initPositionAndCostCompany();
    }

    public void initPositionAndCostCompany() {
        DynamicObject companycurrency;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entries");
        String costcompany = "";
        if (entries.size() > 0 && (companycurrency = (DynamicObject)((DynamicObject)entries.get(0)).get("costcompany")) != null) {
            costcompany = companycurrency.getString("name");
        }
        Label costcompanyed = (Label)this.getControl("costedcompany");
        costcompanyed.setText(costcompany);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskID = (String)formShowParameter.getCustomParams().get("taskID");
        FormShowParameter parFormShowPara = this.getView().getParentView().getFormShowParameter();
        String pooltype = (String)parFormShowPara.getCustomParams().get("pooltype");
        if (StringUtils.isNull((String)pooltype)) {
            pooltype = (String)parFormShowPara.getCustomParams().get("pooltype-mytask");
        }
        DynamicObject task = null;
        task = !pooltype.equals("2") ? BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_task")) : BusinessDataReader.loadSingle((Object)taskID, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_taskhistory"));
        DynamicObject applier = task.getDynamicObject("creator");
        this.getPageCache().put(CHCHE_TASKDAILYLOAN_APPLAYID_VALUE, String.valueOf(applier.getLong("id")));
        EasTaskExpenseHelper.showCreditInfoForm(this.getView(), applier.getLong("id"));
        String picturefield = (String)applier.get("picturefield");
        Image picture = (Image)this.getControl("imageap");
        picture.setUrl(picturefield);
        String product = (String)this.getModel().getValue("producttype");
        if (product.equals(" ")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"producttype"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("txttasklevel".equals(key)) {
            String userId = this.getPageCache().get(CHCHE_TASKDAILYLOAN_APPLAYID_VALUE);
            IFormView view = this.getView();
            EasTaskExpenseHelper.showCreditFilesForm(view, userId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        if ("oriapproved".equals(propertyName) || "rate".equals(propertyName)) {
            BigDecimal addLocAmt = null;
            int locPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            if ("oriapproved".equals(propertyName)) {
                BigDecimal amtori = (BigDecimal)changeData.getNewValue();
                BigDecimal exchangerate = (BigDecimal)model.getValue("rate", changeData.getRowIndex());
                BigDecimal localAmt = amtori.multiply(exchangerate).setScale(locPrec, 4);
                model.setValue("locapproved", (Object)localAmt, changeData.getRowIndex());
                BigDecimal amtori_old = (BigDecimal)changeData.getOldValue();
                addLocAmt = amtori.subtract(amtori_old).multiply(exchangerate).setScale(locPrec, 4);
            } else if ("rate".equals(propertyName)) {
                BigDecimal rateNew = (BigDecimal)changeData.getNewValue();
                BigDecimal amtori = (BigDecimal)model.getValue("oriapproved", changeData.getRowIndex());
                BigDecimal amtLoc = (BigDecimal)model.getValue("locapproved", changeData.getRowIndex());
                BigDecimal localAmtNew = amtori.multiply(rateNew).setScale(locPrec, 4);
                model.setValue("locapproved", (Object)localAmtNew, changeData.getRowIndex());
                addLocAmt = localAmtNew.subtract(amtLoc);
            } else {
                addLocAmt = new BigDecimal("0");
            }
            this.setSumAmountValues2("oriapproved", "entries", "currency");
            int pamoutSize = this.getModel().getEntryRowCount("collectionentries");
            if (pamoutSize > 1) {
                return;
            }
            BigDecimal pamountori = (BigDecimal)model.getValue("pamountori", 0);
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", 0);
            BigDecimal pamount = (BigDecimal)model.getValue("pamount", 0);
            BigDecimal recLocalAmt = addLocAmt.add(pamount);
            model.setValue("pamount", (Object)recLocalAmt, 0);
            int oriPrec = ((DynamicObject)model.getValue("pcurrency", 0)).getInt("amtprecision");
            BigDecimal recOriAmt = recLocalAmt.divide(payrate, oriPrec, 4);
            DynamicObjectCollection collectionentries = this.getModel().getEntryEntity("entries");
            BigDecimal valueSum = TaskSumAmountBill.setSumAmountValue(collectionentries, "oriapproved");
            BigDecimal abs = BigDecimal.valueOf(0.01).setScale(2, 4);
            BigDecimal sub = recOriAmt.subtract(valueSum).abs();
            if (sub.compareTo(abs) <= 0) {
                model.setValue("pamountori", (Object)valueSum, 0);
            } else {
                model.setValue("pamountori", (Object)recOriAmt, 0);
            }
            this.setSumAmountValues2("oriapproved", "entries", "currency");
        } else if ("pcurrency".equals(propertyName)) {
            DynamicObject currency = (DynamicObject)changeData.getNewValue();
            DynamicObject loccur = (DynamicObject)model.getValue("loccur");
            List tablePks = QueryServiceHelper.queryPrimaryKeys((String)"ssc.TaskTripReimburseBill.bd_exratetable", (String)"bd_exratetable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"er_exchangeratetable")}, null, (int)1);
            if (tablePks != null && tablePks.size() > 0) {
                ExchangeRateService service = new ExchangeRateService();
                BigDecimal excg = service.getExchangeRate((Long)tablePks.get(0), (Long)currency.getPkValue(), (Long)loccur.getPkValue(), new Date());
                if (excg == null) {
                    excg = new BigDecimal("1.0000");
                }
                model.setValue("payrate", (Object)excg, changeData.getRowIndex());
                BigDecimal pamount = (BigDecimal)model.getValue("pamount", changeData.getRowIndex());
                int oriPrecRec = currency.getInt("amtprecision");
                BigDecimal recOriAmt = pamount.divide(excg, oriPrecRec, 4);
                model.setValue("pamountori", (Object)recOriAmt, changeData.getRowIndex());
            }
        } else if ("pamountori".equals(propertyName)) {
            BigDecimal amtori = (BigDecimal)changeData.getNewValue();
            BigDecimal payrate = (BigDecimal)model.getValue("payrate", changeData.getRowIndex());
            int locPrec = ((DynamicObject)model.getValue("loccur")).getInt("amtprecision");
            BigDecimal amtloc = amtori.multiply(payrate).setScale(locPrec, 4);
            int lastCollectionentryIndex = this.getModel().getEntryRowCount("collectionentries") - 1;
            if (lastCollectionentryIndex != changeData.getRowIndex()) {
                model.setValue("pamount", (Object)amtloc, changeData.getRowIndex());
            }
            BigDecimal oriapprovedSum = new BigDecimal("0");
            BigDecimal locapprovedSum = new BigDecimal("0");
            int entrySize = this.getModel().getEntryRowCount("entries");
            if (entrySize > 0) {
                for (int i = 0; i < entrySize; ++i) {
                    BigDecimal oriapproved = (BigDecimal)this.getModel().getValue("oriapproved", i);
                    BigDecimal locapproved = (BigDecimal)this.getModel().getValue("locapproved", i);
                    oriapprovedSum = oriapprovedSum.add(oriapproved);
                    locapprovedSum = locapprovedSum.add(locapproved);
                }
            }
            BigDecimal pamountoriSum = new BigDecimal("0");
            BigDecimal pamountSum = new BigDecimal("0");
            BigDecimal pamountSumNotLast = new BigDecimal("0");
            int collectionentrySize = this.getModel().getEntryRowCount("collectionentries");
            if (collectionentrySize > 0) {
                for (int i = 0; i < collectionentrySize; ++i) {
                    BigDecimal pamountori = (BigDecimal)this.getModel().getValue("pamountori", i);
                    BigDecimal pamountForSum = (BigDecimal)this.getModel().getValue("pamount", i);
                    if (i != collectionentrySize - 1) {
                        pamountSumNotLast = pamountSumNotLast.add(pamountForSum);
                    }
                    pamountoriSum = pamountoriSum.add(pamountori);
                    pamountSum = pamountSum.add(pamountForSum);
                }
            }
            if (pamountoriSum.compareTo(oriapprovedSum) == 0) {
                BigDecimal amountapprovedDiff = locapprovedSum.subtract(pamountSumNotLast);
                model.setValue("pamount", (Object)amountapprovedDiff, lastCollectionentryIndex);
            } else {
                model.setValue("pamount", (Object)amtloc, changeData.getRowIndex());
            }
            this.setSumAmountValues2("pamountori", "collectionentries", "pcurrency");
        }
    }

    private void setSumAmountValues2(String keyValues, String keyEntry, String currencySign) {
        BigDecimal valueSum = new BigDecimal("0");
        DecimalFormat dFormat = new DecimalFormat("###,##0.00");
        int sizeForSum = this.getModel().getEntryRowCount(keyEntry);
        String sign = "\uffe5";
        if (sizeForSum > 0) {
            for (int i = 0; i < sizeForSum; ++i) {
                BigDecimal tmp = (BigDecimal)this.getModel().getValue(keyValues, i);
                valueSum = valueSum.add(tmp);
            }
            sign = ((DynamicObject)this.getModel().getValue(currencySign, 0)).get("sign").toString();
        }
        HashMap<String, String> floatButtomData = new HashMap<String, String>();
        floatButtomData.put(keyValues, sign + dFormat.format(valueSum));
        EntryGrid entryGrid = (EntryGrid)this.getControl(keyEntry);
        entryGrid.setFloatButtomData(floatButtomData);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("expensetype".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        } else if ("paymode1".equals(edit.getKey())) {
            showParameter.setMultiSelect(false);
        }
    }
}

