/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.facade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.business.boardv2.pojo.BillCreditLose;
import kd.ssc.task.business.boardv2.pojo.BoardResult;
import kd.ssc.task.business.boardv2.pojo.ChartData;
import kd.ssc.task.business.boardv2.pojo.CreditLose;
import kd.ssc.task.business.boardv2.pojo.MulSeriesData;
import kd.ssc.task.business.boardv2.pojo.OrgCreditLose;
import kd.ssc.task.business.boardv2.pojo.RankModel;
import kd.ssc.task.business.boardv2.pojo.RuleData;
import kd.ssc.task.business.boardv2.pojo.RuleGroupData;
import kd.ssc.task.business.boardv2.pojo.TaskTaskData;
import kd.ssc.task.business.boardv2.pojo.UserCreditLose;
import kd.ssc.task.business.boardv2.query.TaskDataProcessor;
import kd.ssc.task.business.boardv2.query.WFDataProcessor;
import kd.ssc.task.util.AlgUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BoardDataHelper {
    private static final Log log = LogFactory.getLog(BoardDataHelper.class);
    private long sscId = 0L;
    private final String appId;
    private final int lastYear = 0;
    private final int curYear = 1;
    private final String[] timeDimDesc = new String[]{ResManager.loadKDString((String)"\u5f53\u65e5", (String)"BoardDataHelper_9", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u6708", (String)"BoardDataHelper_10", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u5e74", (String)"BoardDataHelper_11", (String)"ssc-task-business", (Object[])new Object[0])};
    private final String[] monthDesc = new String[]{ResManager.loadKDString((String)"1\u6708", (String)"BoardDataHelper_19", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"2\u6708", (String)"BoardDataHelper_20", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"3\u6708", (String)"BoardDataHelper_21", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"4\u6708", (String)"BoardDataHelper_22", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"5\u6708", (String)"BoardDataHelper_23", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"6\u6708", (String)"BoardDataHelper_24", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"7\u6708", (String)"BoardDataHelper_25", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"8\u6708", (String)"BoardDataHelper_26", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"9\u6708", (String)"BoardDataHelper_27", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u6708", (String)"BoardDataHelper_28", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"11\u6708", (String)"BoardDataHelper_29", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"12\u6708", (String)"BoardDataHelper_30", (String)"ssc-task-business", (Object[])new Object[0])};
    private static final Map<String, String> boardMap = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = -7326482061720845542L;
        {
            this.put("overall", "som_board");
            this.put("efficiency", "som_board_efficiency");
            this.put("quality", "som_board_quality");
            this.put("credit", "som_board_credit");
        }
    };
    private final DecimalFormat d1 = new DecimalFormat("0.0");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

    public BoardDataHelper(String appId) {
        this.appId = StringUtils.isBlank((CharSequence)appId) ? "som" : appId;
    }

    @Deprecated
    public BoardDataHelper() {
        this.appId = "som";
    }

    public BoardResult getDefaultBoard(long ssc, boolean tabInit, String board) {
        BoardResult result = new BoardResult();
        this.sscId = BoardDataHelper.findSscId(ssc, this.appId, result, tabInit, board);
        result.setCheckedOrg(String.valueOf(this.sscId));
        log.info("\u5f53\u524d\u770b\u677f\u7684\u5171\u4eab\u4e2d\u5fc3id:" + this.sscId);
        if (this.sscId == 0L) {
            return result;
        }
        this.getPermBoard(this.sscId, result);
        Map<String, ChartData> data = result.getData();
        TaskDataProcessor taskDataProcessor = new TaskDataProcessor();
        TaskTaskData taskTaskData = taskDataProcessor.realTimeQuery(this.sscId);
        data.put("CHART0000", this.c0000());
        data.put("CHART1001", this.c1001());
        data.put("CHART1002", this.c1002());
        data.put("CHART1003", this.c1003());
        data.put("CHART1004", this.c1004());
        data.put("CHART1005", taskTaskData.toChart1005());
        data.put("CHART1006", taskTaskData.toChart1006());
        data.put("CHART1007", this.c1007());
        data.put("CHART1008", this.c1008());
        data.put("CHART1009", this.c1009());
        data.put("CHART1010", this.c1010());
        data.put("CHART1012", this.c1012());
        data.put("CHART2001", this.c2001());
        data.put("CHART2002", this.c2002());
        data.put("CHART2003", this.c2003());
        data.put("CHART2004", this.c2004());
        data.put("CHART2005", this.c2005());
        data.put("CHART2006", this.c2006());
        data.put("CHART2007", this.c2007());
        data.put("CHART2008", this.c2008());
        data.put("CHART2009", this.c2009());
        data.put("CHART2010", this.c2010());
        data.put("CHART2011", this.c2011());
        data.put("CHART3001", this.c3001());
        data.put("CHART3002", this.c3002());
        data.put("CHART3003", this.c3003());
        data.put("CHART3004", this.c3004());
        data.put("CHART3005", this.c3005());
        data.put("CHART3006", "credit".equalsIgnoreCase(board) ? this.c3006() : ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u8d39\u7528\u7c7b\u578b\u6263\u5206TOP10", (String)"BoardDataHelper_77", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null));
        data.put("CHART3007", this.c3007());
        data.put("CHART3008", "credit".equalsIgnoreCase(board) ? this.c3008() : ChartData.newEmpty(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u7528\u5206\u6392\u540dTOP10", (String)"BoardDataHelper_64", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null));
        return result;
    }

    private void getPermBoard(long sscId, BoardResult result) {
        boardMap.forEach((k, v) -> {
            boolean hasPermission;
            boolean bl = hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)sscId, (String)this.appId, (String)v, (String)"47150e89000000ac") > 0;
            if (hasPermission) {
                result.addPermBoard((String)k);
            }
        });
    }

    private ChartData c0000() {
        ChartData titleOnly = new ChartData();
        titleOnly.setTitle(ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u8fd0\u8425\u6574\u4f53\u770b\u677f", (String)"BoardDataHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
        return titleOnly;
    }

    private ChartData c1001() {
        ChartData c1001 = new ChartData();
        c1001.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u5355\u636e\u6d41\u7a0b\u65f6\u6548\uff08\u5c0f\u65f6/\u5355\uff09", (String)"BoardDataHelper_2", (String)"ssc-task-business", (Object[])new Object[0]));
        c1001.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u4e1a\u52a1\u5ba1\u6279", (String)"BoardDataHelper_3", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f71\u50cf\u4e0a\u4f20", (String)"BoardDataHelper_4", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6838", (String)"BoardDataHelper_5", (String)"ssc-task-business", (Object[])new Object[0])));
        long[] data = WFDataProcessor.loadData(this.sscId);
        double auditAvg = data[0] <= 0L ? 0.0 : new BigDecimal(data[1]).divide(new BigDecimal(3600000).multiply(new BigDecimal(data[0])), 1, RoundingMode.HALF_UP).doubleValue();
        double imageAvg = data[2] <= 0L ? 0.0 : new BigDecimal(data[3]).divide(new BigDecimal(3600000).multiply(new BigDecimal(data[2])), 1, RoundingMode.HALF_UP).doubleValue();
        MulSeriesData mulSeriesData = new MulSeriesData();
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        mulSeriesData.setData(Arrays.asList(this.d1.format(auditAvg), this.d1.format(imageAvg), sscCurDyo == null || StringUtils.isBlank((CharSequence)sscCurDyo.getString("aveaging")) ? "0.0" : sscCurDyo.get("aveaging")));
        c1001.addSeries(mulSeriesData);
        return c1001;
    }

    private ChartData c1002() {
        ChartData c1002 = new ChartData();
        c1002.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4efb\u52a1\u5904\u7406\u65f6\u6548\uff08\u5c0f\u65f6/\u5355\uff09", (String)"BoardDataHelper_1", (String)"ssc-task-business", (Object[])new Object[0]));
        Map<Object, DynamicObject> workGroupMap = DataHelper.getWorkGroupFromCache(this.sscId);
        if (!workGroupMap.isEmpty()) {
            Map<Object, DynamicObject> groupCurDyoMap = DataHelper.getGroupCurDyoMapFromCache(this.sscId, "2");
            HashMap<Object, BigDecimal[]> workGroupDataMap = new HashMap<Object, BigDecimal[]>(workGroupMap.size());
            for (Map.Entry<Object, DynamicObject> entry : workGroupMap.entrySet()) {
                DynamicObjectCollection dynamicObjectCollection = entry.getValue().getDynamicObjectCollection("entryentity");
                BigDecimal[] bigDecimals = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
                for (DynamicObject group : dynamicObjectCollection) {
                    DynamicObject dyo = groupCurDyoMap.get(group.get("usergroup_id"));
                    if (dyo == null) continue;
                    bigDecimals[0] = bigDecimals[0].add(dyo.getBigDecimal("costwaittime"));
                    bigDecimals[1] = bigDecimals[1].add(dyo.getBigDecimal("taskload"));
                }
                workGroupDataMap.put(entry.getKey(), bigDecimals);
            }
            HashMap aveAgingGroupMap = new HashMap(workGroupDataMap.size());
            for (Map.Entry entry : workGroupDataMap.entrySet()) {
                if (((BigDecimal[])entry.getValue())[0].compareTo(new BigDecimal(0)) <= 0 || ((BigDecimal[])entry.getValue())[1].compareTo(new BigDecimal(0)) <= 0) continue;
                aveAgingGroupMap.put(entry.getKey(), ((BigDecimal[])entry.getValue())[0].divide(((BigDecimal[])entry.getValue())[1], 1, 4));
            }
            ArrayList arrayList = new ArrayList(aveAgingGroupMap.entrySet());
            arrayList.sort(Map.Entry.comparingByValue());
            MulSeriesData mulSeriesData = new MulSeriesData();
            mulSeriesData.setData(new ArrayList<Object>(arrayList.size()));
            c1002.addSeries(mulSeriesData);
            for (Map.Entry entry : arrayList) {
                c1002.addxAxis(workGroupMap.get(entry.getKey()).getString("name"));
                mulSeriesData.addData((Object)((BigDecimal)entry.getValue()).toString());
            }
        } else {
            c1002 = ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4efb\u52a1\u5904\u7406\u65f6\u6548\uff08\u5c0f\u65f6/\u5355\uff09", (String)"BoardDataHelper_1", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null);
        }
        return c1002;
    }

    private ChartData c1003() {
        ChartData c1003;
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        String title = ResManager.loadKDString((String)"\u672c\u6708\u4efb\u52a1\u5904\u7406\u91cf\u6392\u884cTOP3", (String)"BoardDataHelper_35", (String)"ssc-task-business", (Object[])new Object[0]);
        if (sscCurDyo == null) {
            c1003 = ChartData.newEmpty(title, null, null, null);
        } else {
            Map taskRankMap = null;
            try {
                taskRankMap = (Map)JSON.parseObject((String)sscCurDyo.getString("taskrankjson"), (TypeReference)new TypeReference<LinkedHashMap<Long, Double>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (taskRankMap == null || taskRankMap.isEmpty()) {
                c1003 = ChartData.newEmpty(title, null, null, null);
            } else {
                Map userMap = BusinessDataServiceHelper.loadFromCache((Object[])taskRankMap.keySet().toArray(), (String)"bos_user");
                c1003 = new ChartData();
                c1003.setTitle(title);
                MulSeriesData mulSeriesData = new MulSeriesData();
                c1003.addSeries(mulSeriesData);
                mulSeriesData.setName(ResManager.loadKDString((String)"\u4efb\u52a1\u91cf", (String)"BoardDataHelper_48", (String)"ssc-task-business", (Object[])new Object[0]));
                taskRankMap.forEach((k, v) -> {
                    DynamicObject userDyo = (DynamicObject)userMap.get(k);
                    if (userDyo != null) {
                        c1003.addxAxis(userDyo.getString("name"));
                        mulSeriesData.addData(v);
                    }
                });
                if (mulSeriesData.getData() == null || mulSeriesData.getData().isEmpty()) {
                    return ChartData.newEmpty(title, null, null, null);
                }
            }
        }
        return c1003;
    }

    private ChartData c1004() {
        DynamicObject[] sscCurDyoArr = new DynamicObject[]{DataHelper.getSscCurDyoFromCache(this.sscId, "1"), DataHelper.getSscCurDyoFromCache(this.sscId, "2"), DataHelper.getSscCurDyoFromCache(this.sscId, "3")};
        ChartData c1004 = new ChartData();
        c1004.setTitle(ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u6982\u89c8", (String)"BoardDataHelper_6", (String)"ssc-task-business", (Object[])new Object[0]));
        c1004.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u4efb\u52a1\u5165\u6c60\u91cf", (String)"BoardDataHelper_7", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u91cf", (String)"BoardDataHelper_8", (String)"ssc-task-business", (Object[])new Object[0])));
        for (int i = 0; i < 3; ++i) {
            MulSeriesData mulSeriesData = new MulSeriesData();
            c1004.addSeries(mulSeriesData);
            mulSeriesData.setName(this.timeDimDesc[i]);
            mulSeriesData.addData(sscCurDyoArr[i] != null ? sscCurDyoArr[i].get("taskcntall") : Integer.valueOf(0));
            mulSeriesData.addData(sscCurDyoArr[i] != null ? sscCurDyoArr[i].get("taskcntdone") : Integer.valueOf(0));
        }
        return c1004;
    }

    private ChartData c1007() {
        ChartData c1007 = new ChartData();
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo == null || StringUtils.isBlank((CharSequence)sscCurDyo.getString("autoratio")) || "0".equals(sscCurDyo.getString("autoratio"))) {
            c1007 = ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u5ba1\u6838\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_12", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null);
        } else {
            c1007.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u5ba1\u6838\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_12", (String)"ssc-task-business", (Object[])new Object[0]));
            c1007.addxAxis(ResManager.loadKDString((String)"\u5ba1\u6838\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_13", (String)"ssc-task-business", (Object[])new Object[0]));
            MulSeriesData mulSeriesData = new MulSeriesData();
            c1007.addSeries(mulSeriesData);
            mulSeriesData.addData((Object)sscCurDyo.getString("autoratio"));
        }
        return c1007;
    }

    private ChartData c1008() {
        ChartData c1008 = new ChartData();
        c1008.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u51ed\u8bc1\u5904\u7406\u8fdb\u5ea6", (String)"BoardDataHelper_43", (String)"ssc-task-business", (Object[])new Object[0]));
        c1008.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u5df2\u8fc7\u8d26", (String)"BoardDataHelper_47", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u672a\u8fc7\u8d26", (String)"BoardDataHelper_46", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"BoardDataHelper_45", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6682\u5b58", (String)"BoardDataHelper_44", (String)"ssc-task-business", (Object[])new Object[0])));
        MulSeriesData mulSeriesData = new MulSeriesData();
        c1008.addSeries(mulSeriesData);
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo != null) {
            BigDecimal saveCnt = sscCurDyo.getBigDecimal("savecnt");
            BigDecimal submitCnt = sscCurDyo.getBigDecimal("submitcnt");
            BigDecimal auditNoPost = sscCurDyo.getBigDecimal("auditnopost");
            BigDecimal auditPost = sscCurDyo.getBigDecimal("auditpost");
            BigDecimal allCnt = new BigDecimal(0).add(saveCnt).add(submitCnt).add(auditNoPost).add(auditPost);
            boolean zeroData = false;
            if (allCnt.compareTo(new BigDecimal(0)) == 0) {
                zeroData = true;
                allCnt = new BigDecimal(1);
            }
            BigDecimal auditPostRatio = auditPost.multiply(new BigDecimal(100)).divide(allCnt, 1, 4);
            mulSeriesData.addData((Object)auditPostRatio.toString());
            BigDecimal auditNoPostRatio = auditNoPost.multiply(new BigDecimal(100)).divide(allCnt, 1, 4);
            mulSeriesData.addData((Object)auditNoPostRatio.toString());
            BigDecimal submitCntRatio = submitCnt.multiply(new BigDecimal(100)).divide(allCnt, 1, 4);
            mulSeriesData.addData((Object)submitCntRatio.toString());
            if (zeroData) {
                mulSeriesData.addData((Object)saveCnt.multiply(new BigDecimal(100)).divide(allCnt, 1, 4).toString());
            } else {
                mulSeriesData.addData((Object)new BigDecimal(100).subtract(auditPostRatio.add(auditNoPostRatio).add(submitCntRatio)).divide(new BigDecimal(1), 1, 4).toString());
            }
        } else {
            mulSeriesData.setData(Collections.emptyList());
        }
        return c1008;
    }

    private ChartData c1009() {
        ChartData c1009;
        block39: {
            c1009 = new ChartData();
            Map<Object, DynamicObject> workGroupMap = DataHelper.getWorkGroupFromCache(this.sscId);
            if (!workGroupMap.isEmpty()) {
                Date[] curMonthRange = DateHelper.getCurMonthRange();
                QFilter curMonthFilter = new QFilter("sscid", "=", (Object)this.sscId).and("completetime", ">=", (Object)curMonthRange[0]).and("completetime", "<", (Object)curMonthRange[1]).and("qualitysamplelibrary", "=", (Object)0L).and("pooltype", "=", (Object)"2");
                QFilter curMonthTimeFilter = new QFilter("sscid", "=", (Object)this.sscId).and("daten", ">=", (Object)curMonthRange[0]).and("daten", "<", (Object)curMonthRange[1]);
                try (DataSet monthTaskDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)"task_taskhistory", (String)"id,coefficient,usergroup", (QFilter[])curMonthFilter.toArray(), null);
                     DataSet monthTimeDataSet = QueryServiceHelper.queryDataSet((String)"TaskHistoryDataProcessor#task_taskhistory", (String)"ssc_userondutytime", (String)"id,groupid,userid,daten,dutytimebitset", (QFilter[])curMonthTimeFilter.toArray(), null);
                     DataSet monthTaskSumDataSet = monthTaskDataSet.groupBy(new String[]{"usergroup"}).sum("coefficient").finish();){
                    Map<Object, BigDecimal> groupTaskLoadMap = DataHelper.calculateGroupTaskLoad(monthTaskSumDataSet, workGroupMap);
                    Map<Object, Integer> groupDutyTimeMap = DataHelper.calculateGroupDutyTime(monthTimeDataSet, workGroupMap);
                    HashMap<Object, BigDecimal> aveEfficiencyMap = new HashMap<Object, BigDecimal>(groupDutyTimeMap.size());
                    for (Map.Entry<Object, Integer> entry : groupDutyTimeMap.entrySet()) {
                        BigDecimal coefficient = groupTaskLoadMap.get(entry.getKey());
                        if (coefficient == null || coefficient.compareTo(new BigDecimal(0)) <= 0 || entry.getValue() <= 0) continue;
                        aveEfficiencyMap.put(entry.getKey(), coefficient.multiply(new BigDecimal(60)).divide(new BigDecimal(entry.getValue()), 1, 4));
                    }
                    ArrayList aveEfficiencyList = new ArrayList(aveEfficiencyMap.entrySet());
                    aveEfficiencyList.sort((v1, v2) -> ((BigDecimal)v2.getValue()).compareTo((BigDecimal)v1.getValue()));
                    c1009.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4eba\u5747\u6548\u80fd\u7edf\u8ba1\uff08\u5355/\u5c0f\u65f6\uff09", (String)"BoardDataHelper_42", (String)"ssc-task-business", (Object[])new Object[0]));
                    MulSeriesData mulSeriesData = new MulSeriesData();
                    mulSeriesData.setData(new ArrayList<Object>(aveEfficiencyList.size()));
                    c1009.addSeries(mulSeriesData);
                    for (Map.Entry entry : aveEfficiencyList) {
                        c1009.addxAxis(workGroupMap.get(entry.getKey()).getString("name"));
                        mulSeriesData.addData((Object)((BigDecimal)entry.getValue()).toString());
                    }
                    break block39;
                }
            }
            c1009 = ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4eba\u5747\u6548\u80fd\u7edf\u8ba1\uff08\u5355/\u5c0f\u65f6\uff09", (String)"BoardDataHelper_42", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null);
        }
        return c1009;
    }

    private ChartData c1010() {
        ChartData c1010 = new ChartData();
        Map<Object, DynamicObject> workGroupMap = DataHelper.getWorkGroupFromCache(this.sscId);
        if (!workGroupMap.isEmpty()) {
            Map<Object, DynamicObject> groupCurDyoMap = DataHelper.getGroupCurDyoMapFromCache(this.sscId, "2");
            HashMap<Object, int[]> workGroupDataMap = new HashMap<Object, int[]>(workGroupMap.size());
            for (Map.Entry<Object, DynamicObject> entry : workGroupMap.entrySet()) {
                DynamicObjectCollection dynamicObjectCollection = entry.getValue().getDynamicObjectCollection("entryentity");
                int[] ints = new int[]{0, 0};
                for (DynamicObject group : dynamicObjectCollection) {
                    DynamicObject dynamicObject = groupCurDyoMap.get(group.get("usergroup_id"));
                    if (dynamicObject == null) continue;
                    ints[0] = ints[0] + dynamicObject.getInt("taskcntall");
                    ints[1] = ints[1] + dynamicObject.getInt("taskcntundone");
                }
                workGroupDataMap.put(entry.getKey(), ints);
            }
            HashMap taskUndoneRatioMap = new HashMap(workGroupDataMap.size());
            for (Map.Entry entry : workGroupDataMap.entrySet()) {
                if (((int[])entry.getValue())[0] <= 0 || ((int[])entry.getValue())[1] <= 0) continue;
                taskUndoneRatioMap.put(entry.getKey(), new BigDecimal(((int[])entry.getValue())[1]).multiply(new BigDecimal(100)).divide(new BigDecimal(((int[])entry.getValue())[0]), 1, 4));
            }
            ArrayList arrayList = new ArrayList(taskUndoneRatioMap.entrySet());
            arrayList.sort((v1, v2) -> ((BigDecimal)v2.getValue()).compareTo((BigDecimal)v1.getValue()));
            c1010.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4efb\u52a1\u5904\u7406\u8fdb\u5ea6", (String)"BoardDataHelper_38", (String)"ssc-task-business", (Object[])new Object[0]));
            MulSeriesData mulSeriesData = new MulSeriesData(ResManager.loadKDString((String)"\u4efb\u52a1\u603b\u91cf", (String)"BoardDataHelper_39", (String)"ssc-task-business", (Object[])new Object[0]), new ArrayList<Object>(arrayList.size()));
            c1010.addSeries(mulSeriesData);
            MulSeriesData mulSeriesData2 = new MulSeriesData(ResManager.loadKDString((String)"\u672a\u5904\u7406\u91cf", (String)"BoardDataHelper_40", (String)"ssc-task-business", (Object[])new Object[0]), new ArrayList<Object>(arrayList.size()));
            c1010.addSeries(mulSeriesData2);
            MulSeriesData mulSeriesData3 = new MulSeriesData(ResManager.loadKDString((String)"\u672a\u5904\u7406\u7387", (String)"BoardDataHelper_41", (String)"ssc-task-business", (Object[])new Object[0]), new ArrayList<Object>(arrayList.size()));
            c1010.addSeries(mulSeriesData3);
            for (Map.Entry entry : arrayList) {
                c1010.addxAxis(workGroupMap.get(entry.getKey()).getString("name"));
                mulSeriesData.addData((Object)((int[])workGroupDataMap.get(entry.getKey()))[0]);
                mulSeriesData2.addData((Object)((int[])workGroupDataMap.get(entry.getKey()))[1]);
                mulSeriesData3.addData((Object)((BigDecimal)entry.getValue()).toString());
            }
        } else {
            c1010 = ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u5404\u7ec4\u4efb\u52a1\u5904\u7406\u8fdb\u5ea6", (String)"BoardDataHelper_38", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null);
        }
        return c1010;
    }

    private ChartData c1012() {
        ChartData c1012 = new ChartData();
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo == null || StringUtils.isBlank((CharSequence)sscCurDyo.getString("voucherautoratio")) || "0".equals(sscCurDyo.getString("voucherautoratio"))) {
            c1012 = ChartData.newEmpty(ResManager.loadKDString((String)"\u672c\u6708\u4f5c\u4e1a\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_36", (String)"ssc-task-business", (Object[])new Object[0]), null, null, null);
        } else {
            c1012.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u4f5c\u4e1a\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_36", (String)"ssc-task-business", (Object[])new Object[0]));
            c1012.addxAxis(ResManager.loadKDString((String)"\u51ed\u8bc1\u81ea\u52a8\u5316\u7387", (String)"BoardDataHelper_37", (String)"ssc-task-business", (Object[])new Object[0]));
            MulSeriesData mulSeriesData = new MulSeriesData();
            c1012.addSeries(mulSeriesData);
            mulSeriesData.addData((Object)sscCurDyo.getString("voucherautoratio"));
        }
        return c1012;
    }

    private ChartData c2001() {
        ChartData c2001 = new ChartData();
        c2001.setTitle(ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u7387", (String)"BoardDataHelper_14", (String)"ssc-task-business", (Object[])new Object[0]));
        c2001.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u91cf", (String)"BoardDataHelper_15", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u4efb\u52a1\u91cf", (String)"BoardDataHelper_16", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u7387", (String)"BoardDataHelper_17", (String)"ssc-task-business", (Object[])new Object[0])));
        MulSeriesData mulSeriesData2 = new MulSeriesData();
        c2001.addSeries(mulSeriesData2);
        mulSeriesData2.setName(this.timeDimDesc[1]);
        DynamicObject sscCurDyo2 = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        mulSeriesData2.addData(sscCurDyo2 == null ? Integer.valueOf(0) : sscCurDyo2.get("qualitycnt"));
        mulSeriesData2.addData(sscCurDyo2 == null ? Integer.valueOf(0) : sscCurDyo2.get("unqualitycnt"));
        mulSeriesData2.addData(sscCurDyo2 == null || StringUtils.isBlank((CharSequence)sscCurDyo2.getString("unqualityratio")) ? "0.0" : sscCurDyo2.get("unqualityratio"));
        MulSeriesData mulSeriesData3 = new MulSeriesData();
        c2001.addSeries(mulSeriesData3);
        mulSeriesData3.setName(this.timeDimDesc[2]);
        DynamicObject sscCurDyo3 = DataHelper.getSscCurDyoFromCache(this.sscId, "3");
        mulSeriesData3.addData(sscCurDyo3 == null ? Integer.valueOf(0) : sscCurDyo3.get("qualitycnt"));
        mulSeriesData3.addData(sscCurDyo3 == null ? Integer.valueOf(0) : sscCurDyo3.get("unqualitycnt"));
        mulSeriesData3.addData(sscCurDyo3 == null || StringUtils.isBlank((CharSequence)sscCurDyo3.getString("unqualityratio")) ? "0.0" : sscCurDyo3.get("unqualityratio"));
        return c2001;
    }

    private ChartData c2002() {
        ChartData c2002 = new ChartData();
        c2002.setTitle(ResManager.loadKDString((String)"\u5355\u636e\u8d28\u91cf\u8d8b\u52bf", (String)"BoardDataHelper_18", (String)"ssc-task-business", (Object[])new Object[0]));
        for (int i = 0; i < 12; ++i) {
            c2002.addxAxis(this.monthDesc[i]);
        }
        this.fillYearRangeData(c2002, "billquality", 0);
        this.fillYearRangeData(c2002, "billquality", 1);
        return c2002;
    }

    private ChartData c2003() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u4e0d\u5408\u683c\u4efb\u52a1\u5360\u6bd4", (String)"BoardDataHelper_49", (String)"ssc-task-business", (Object[])new Object[0]));
        DynamicObject curMonthDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        int autoNotPass = 0;
        int auditNotPass = 0;
        int rescan = 0;
        if (curMonthDyo != null) {
            autoNotPass = curMonthDyo.getInt("autounpasscnt");
            auditNotPass = curMonthDyo.getInt("auditunpasscnt");
            rescan = curMonthDyo.getInt("rescancnt");
        }
        List<RankModel> rankModels = Arrays.asList(new RankModel(0L, autoNotPass, ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\u4e0d\u901a\u8fc7", (String)"BoardDataHelper_50", (String)"ssc-task-business", (Object[])new Object[0])), new RankModel(0L, auditNotPass, ResManager.loadKDString((String)"\u6279\u9000", (String)"BoardDataHelper_51", (String)"ssc-task-business", (Object[])new Object[0])), new RankModel(0L, rescan, ResManager.loadKDString((String)"\u9000\u626b", (String)"BoardDataHelper_52", (String)"ssc-task-business", (Object[])new Object[0])));
        rankModels.sort((r1, r2) -> NumberUtils.compare((int)((Integer)r2.getRankValue()), (int)((Integer)r1.getRankValue())));
        double[] values = rankModels.stream().mapToDouble(r -> NumberUtils.toDouble((String)(r.getRankValue() + ""), (double)0.0)).toArray();
        double[] ratios = AlgUtil.maxRemainder((double[])values, (int)1);
        result.setxAxis(rankModels.stream().map(RankModel::getName).collect(Collectors.toList()));
        MulSeriesData mulSeriesData = new MulSeriesData();
        result.addSeries(mulSeriesData);
        for (double ratio : ratios) {
            mulSeriesData.addData((Object)this.d1.format(ratio));
        }
        return result;
    }

    private ChartData c2004() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u8d28\u68c0\u4e0d\u5408\u683c\u7387TOP5\u5ba1\u5355\u4eba", (String)"BoardDataHelper_53", (String)"ssc-task-business", (Object[])new Object[0]));
        this.fillCurMonthRankData(result, "notquality_auditor5", "bos_user", "name", ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u7387", (String)"BoardDataHelper_62", (String)"ssc-task-business", (Object[])new Object[0]));
        return result;
    }

    private ChartData c2005() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u6279\u9000\u7387", (String)"BoardDataHelper_54", (String)"ssc-task-business", (Object[])new Object[0]));
        result.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u4efb\u52a1\u603b\u91cf", (String)"BoardDataHelper_39", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6279\u9000\u4efb\u52a1\u91cf", (String)"BoardDataHelper_55", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6279\u9000\u7387", (String)"BoardDataHelper_56", (String)"ssc-task-business", (Object[])new Object[0])));
        DynamicObject[] dataArray = new DynamicObject[]{null, DataHelper.getSscCurDyoFromCache(this.sscId, "2"), DataHelper.getSscCurDyoFromCache(this.sscId, "3")};
        for (int i = 1; i < 3; ++i) {
            DynamicObject dyo = dataArray[i];
            int taskCnt = 0;
            int auditPass = 0;
            String notPassRate = "0.0";
            if (dyo != null) {
                taskCnt = dyo.getInt("taskcntdone");
                auditPass = dyo.getInt("auditunpasscnt");
                notPassRate = dyo.getString("unpass_rate");
                if (StringUtils.isBlank((CharSequence)notPassRate)) {
                    notPassRate = "0.0";
                }
            }
            MulSeriesData seriesData = new MulSeriesData();
            result.addSeries(seriesData);
            seriesData.setName(this.timeDimDesc[i]);
            seriesData.addData((Object)taskCnt);
            seriesData.addData((Object)auditPass);
            seriesData.addData((Object)notPassRate);
        }
        return result;
    }

    private ChartData c2006() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u6279\u9000\u7387\u53d8\u5316\u8d8b\u52bf", (String)"BoardDataHelper_63", (String)"ssc-task-business", (Object[])new Object[0]));
        result.setxAxis(Arrays.stream(this.monthDesc).collect(Collectors.toList()));
        this.fillYearRangeData(result, "unpass_rate", 0);
        this.fillYearRangeData(result, "unpass_rate", 1);
        return result;
    }

    private ChartData c2007() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u6279\u9000\u539f\u56e0TOP5", (String)"BoardDataHelper_57", (String)"ssc-task-business", (Object[])new Object[0]));
        this.fillCurMonthRankData(result, "unpass_reason5", "task_withdrawal", "name", null);
        return result;
    }

    private ChartData c2008() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u6279\u9000\u7387TOP5\u5355\u636e\u7c7b\u578b", (String)"BoardDataHelper_58", (String)"ssc-task-business", (Object[])new Object[0]));
        this.fillCurMonthRankData(result, "unpass_billtype5", "task_taskbill", "name", null);
        return result;
    }

    private ChartData c2009() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u6279\u9000\u7387TOP5\u7ec4\u7ec7\u673a\u6784", (String)"BoardDataHelper_59", (String)"ssc-task-business", (Object[])new Object[0]));
        this.fillCurMonthRankData(result, "unpass_org5", "bos_org", "name", ResManager.loadKDString((String)"\u6279\u9000\u7387", (String)"BoardDataHelper_56", (String)"ssc-task-business", (Object[])new Object[0]));
        return result;
    }

    private ChartData c2010() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u8d8b\u52bf", (String)"BoardDataHelper_60", (String)"ssc-task-business", (Object[])new Object[0]));
        result.setxAxis(Arrays.stream(this.monthDesc).collect(Collectors.toList()));
        this.fillYearRangeData(result, "unqualityratio", 0);
        this.fillYearRangeData(result, "unqualityratio", 1);
        return result;
    }

    private ChartData c2011() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u8d28\u68c0\u4e0d\u5408\u683c\u539f\u56e0TOP5", (String)"BoardDataHelper_61", (String)"ssc-task-business", (Object[])new Object[0]));
        this.fillCurMonthRankData(result, "notquality_point5", "task_checkingpoint", "name", null);
        return result;
    }

    private ChartData c3001() {
        ChartData result = new ChartData();
        result.setTitle(ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u4efb\u52a1\u5360\u6bd4\u8d8b\u52bf", (String)"BoardDataHelper_33", (String)"ssc-task-business", (Object[])new Object[0]));
        result.setxAxis(Arrays.stream(this.monthDesc).collect(Collectors.toList()));
        this.fillYearRangeData(result, "subscoreratio", 0);
        this.fillYearRangeData(result, "subscoreratio", 1);
        return result;
    }

    private ChartData c3002() {
        String tag;
        ChartData c = new ChartData();
        c.setTitle(ResManager.loadKDString((String)"\u672c\u6708\u4fe1\u7528\u6263\u5206\u539f\u56e0\u5206\u6790", (String)"BoardDataHelper_34", (String)"ssc-task-business", (Object[])new Object[0]));
        ArrayList<String> xAxis = new ArrayList<String>(6);
        c.setxAxis(xAxis);
        DynamicObject dyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (dyo == null || (tag = dyo.getString("ruleratiojson_tag")) == null || StringUtils.isBlank((CharSequence)tag)) {
            MulSeriesData mulSeriesData = new MulSeriesData();
            c.addSeries(mulSeriesData);
            mulSeriesData.setData(new ArrayList<Object>());
            return c;
        }
        List groups = SerializationUtils.fromJsonStringToList((String)tag, RuleGroupData.class);
        List gIds = groups.stream().map(RuleGroupData::getGroupId).collect(Collectors.toList());
        Map<Long, String> groupMap = QueryServiceHelper.query((String)"fircm_subscorerulegroup", (String)"id,name", (QFilter[])new QFilter("id", "in", gIds).toArray()).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
        List sortedList = groups.stream().sorted(Comparator.comparingDouble(RuleGroupData::getRatio).reversed()).collect(Collectors.toList());
        ArrayList<Double> values = new ArrayList<Double>(sortedList.size());
        for (RuleGroupData ruleGroupData : sortedList) {
            String groupName = groupMap.get(ruleGroupData.getGroupId());
            xAxis.add(groupName);
            values.add(ruleGroupData.getRatio());
        }
        double[] doubles = AlgUtil.maxRemainder((double[])values.stream().mapToDouble(e -> e).toArray(), (int)1);
        MulSeriesData mulSeriesData = new MulSeriesData();
        for (double aDouble : doubles) {
            mulSeriesData.addData((Object)this.d1.format(aDouble));
        }
        c.setxAxis(xAxis);
        c.addSeries(mulSeriesData);
        return c;
    }

    private ChartData c3003() {
        List creditLoseRankList;
        ChartData c3003 = new ChartData();
        String title = ResManager.loadKDString((String)"\u672c\u6708\u4fe1\u7528\u6263\u5206\u660e\u7ec6\u539f\u56e0TOP5", (String)"BoardDataHelper_68", (String)"ssc-task-business", (Object[])new Object[0]);
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo != null && StringUtils.isNotBlank((CharSequence)sscCurDyo.getString("creditloserankjson")) && (creditLoseRankList = JSON.parseArray((String)sscCurDyo.getString("creditloserankjson"), RuleData.class)) != null && !creditLoseRankList.isEmpty()) {
            Map ruleMap = BusinessDataServiceHelper.loadFromCache((Object[])creditLoseRankList.stream().map(RuleData::getRuleId).toArray(), (String)"fircm_subscorerule");
            c3003.setTitle(title);
            MulSeriesData mulSeriesData = new MulSeriesData();
            c3003.addSeries(mulSeriesData);
            for (RuleData r : creditLoseRankList) {
                DynamicObject ruleDyo = (DynamicObject)ruleMap.get(r.getRuleId());
                c3003.addxAxis(ruleDyo == null ? "" : ruleDyo.getString("name"));
                mulSeriesData.addData((Object)r.getCount());
            }
        }
        if (c3003.getSeries().isEmpty()) {
            c3003 = ChartData.newEmpty(title, null, null, null);
        }
        return c3003;
    }

    private ChartData c3004() {
        ChartData c3004 = new ChartData();
        String title = ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u4efb\u52a1\u5360\u6bd4", (String)"BoardDataHelper_69", (String)"ssc-task-business", (Object[])new Object[0]);
        DynamicObject sscCurDyoMonth = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        DynamicObject sscCurDyoDay = DataHelper.getSscCurDyoFromCache(this.sscId, "1");
        c3004.setTitle(title);
        c3004.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6838\u4efb\u52a1\u91cf", (String)"BoardDataHelper_70", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u4efb\u52a1\u91cf", (String)"BoardDataHelper_71", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u4efb\u52a1\u5360\u6bd4", (String)"BoardDataHelper_69", (String)"ssc-task-business", (Object[])new Object[0])));
        MulSeriesData mulSeriesData1 = new MulSeriesData();
        c3004.addSeries(mulSeriesData1);
        mulSeriesData1.setName(ResManager.loadKDString((String)"\u5f53\u65e5", (String)"BoardDataHelper_9", (String)"ssc-task-business", (Object[])new Object[0]));
        MulSeriesData mulSeriesData2 = new MulSeriesData();
        c3004.addSeries(mulSeriesData2);
        mulSeriesData2.setName(ResManager.loadKDString((String)"\u5f53\u6708", (String)"BoardDataHelper_10", (String)"ssc-task-business", (Object[])new Object[0]));
        if (sscCurDyoDay != null) {
            mulSeriesData1.addData(sscCurDyoDay.get("ssctaskauditcnt"), sscCurDyoDay.get("creditlosecnt"), StringUtils.isBlank((CharSequence)sscCurDyoDay.getString("subscoreratio")) ? "0.0" : this.d1.format(NumberUtils.toDouble((String)(sscCurDyoDay.get("subscoreratio") + ""), (double)0.0)));
        } else {
            mulSeriesData1.addData(0, 0, "0.0");
        }
        if (sscCurDyoMonth != null) {
            mulSeriesData2.addData(sscCurDyoMonth.get("ssctaskauditcnt"), sscCurDyoMonth.get("creditlosecnt"), StringUtils.isBlank((CharSequence)sscCurDyoMonth.getString("subscoreratio")) ? "0.0" : this.d1.format(NumberUtils.toDouble((String)(sscCurDyoMonth.get("subscoreratio") + ""), (double)0.0)));
        } else {
            mulSeriesData2.addData(0, 0, "0.0");
        }
        return c3004;
    }

    private ChartData c3005() {
        List userCreditLoseList;
        ChartData c3005 = new ChartData();
        String title = ResManager.loadKDString((String)"\u672c\u6708\u5458\u5de5\u4fe1\u7528\u6263\u5206\u6392\u540dTOP10", (String)"BoardDataHelper_72", (String)"ssc-task-business", (Object[])new Object[0]);
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo != null && StringUtils.isNotBlank((CharSequence)sscCurDyo.getString("usercreditloserankjson")) && (userCreditLoseList = JSON.parseArray((String)sscCurDyo.getString("usercreditloserankjson"), UserCreditLose.class)) != null && !userCreditLoseList.isEmpty()) {
            Map userMap = BusinessDataServiceHelper.loadFromCache((Object[])userCreditLoseList.stream().map(CreditLose::getId).toArray(), (String)"bos_user");
            Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])userCreditLoseList.stream().map(UserCreditLose::getCompanyId).toArray(), (String)"bos_org");
            c3005.setTitle(title);
            c3005.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u6392\u540d", (String)"BoardDataHelper_65", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5458\u5de5\u5de5\u53f7", (String)"BoardDataHelper_73", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5458\u5de5\u59d3\u540d", (String)"BoardDataHelper_74", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6263\u5206\u603b\u6570", (String)"BoardDataHelper_75", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u5728\u516c\u53f8", (String)"BoardDataHelper_76", (String)"ssc-task-business", (Object[])new Object[0])));
            int rank = 1;
            for (UserCreditLose r : userCreditLoseList) {
                MulSeriesData mulSeriesData = new MulSeriesData();
                c3005.addSeries(mulSeriesData);
                DynamicObject userDyo = (DynamicObject)userMap.get(((Number)r.getId()).longValue());
                DynamicObject orgDyo = (DynamicObject)orgMap.get(((Number)r.getCompanyId()).longValue());
                mulSeriesData.addData(rank++, userDyo == null ? "" : userDyo.getString("number"), userDyo == null ? "" : userDyo.getString("name"), r.getTotalSubScore().toString(), orgDyo == null ? "" : orgDyo.getString("name"));
            }
        }
        if (c3005.getSeries().isEmpty()) {
            c3005 = ChartData.newEmpty(title, null, null, null);
        }
        return c3005;
    }

    private ChartData c3006() {
        List billCreditLoseList;
        ChartData c3006 = new ChartData();
        String title = ResManager.loadKDString((String)"\u672c\u6708\u8d39\u7528\u7c7b\u578b\u6263\u5206TOP10", (String)"BoardDataHelper_77", (String)"ssc-task-business", (Object[])new Object[0]);
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo != null && StringUtils.isNotBlank((CharSequence)sscCurDyo.getString("billcreditloserankjson")) && (billCreditLoseList = JSON.parseArray((String)sscCurDyo.getString("billcreditloserankjson"), BillCreditLose.class)) != null && !billCreditLoseList.isEmpty()) {
            HashMap<String, Collection> map = new HashMap<String, Collection>(billCreditLoseList.size());
            for (BillCreditLose creditLose : billCreditLoseList) {
                map.computeIfAbsent(creditLose.getEntity(), p -> new HashSet(10)).add(creditLose.getId());
            }
            HashMap nameMap = new HashMap(10);
            map.forEach((k, v) -> {
                DynamicObject[] dyoArr = BusinessDataServiceHelper.load((String)k, (String)"id,name", (QFilter[])new QFilter("id", "in", v).toArray());
                if (dyoArr != null && dyoArr.length > 0) {
                    for (DynamicObject dyo : dyoArr) {
                        nameMap.put(dyo.get("id"), dyo.getString("name"));
                    }
                }
            });
            c3006.setTitle(title);
            MulSeriesData mulSeriesData = new MulSeriesData();
            c3006.addSeries(mulSeriesData);
            for (BillCreditLose r : billCreditLoseList) {
                c3006.addxAxis(nameMap.get(((Number)r.getId()).longValue()) == null ? "" : (String)nameMap.get(((Number)r.getId()).longValue()));
                mulSeriesData.addData((Object)r.getTotalSubScore().toString());
            }
        }
        if (c3006.getSeries().isEmpty()) {
            c3006 = ChartData.newEmpty(title, null, null, null);
        }
        return c3006;
    }

    private ChartData c3007() {
        List orgCreditLoseList;
        ChartData c3007 = new ChartData();
        String title = ResManager.loadKDString((String)"\u672c\u6708\u7ec4\u7ec7\u4fe1\u7528\u6263\u5206\u6392\u540dTOP10", (String)"BoardDataHelper_78", (String)"ssc-task-business", (Object[])new Object[0]);
        DynamicObject sscCurDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (sscCurDyo != null && StringUtils.isNotBlank((CharSequence)sscCurDyo.getString("orgcreditloserankjson")) && (orgCreditLoseList = JSON.parseArray((String)sscCurDyo.getString("orgcreditloserankjson"), OrgCreditLose.class)) != null && !orgCreditLoseList.isEmpty()) {
            Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgCreditLoseList.stream().map(CreditLose::getId).toArray(), (String)"bos_org");
            c3007.setTitle(title);
            MulSeriesData mulSeriesData = new MulSeriesData();
            c3007.addSeries(mulSeriesData);
            for (OrgCreditLose r : orgCreditLoseList) {
                DynamicObject orgDyo = (DynamicObject)orgMap.get(((Number)r.getId()).longValue());
                c3007.addxAxis(orgDyo == null ? "" : orgDyo.getString("name"));
                mulSeriesData.addData((Object)r.getTotalSubScore().toString());
            }
        }
        if (c3007.getSeries().isEmpty()) {
            c3007 = ChartData.newEmpty(title, null, null, null);
        }
        return c3007;
    }

    private ChartData c3008() {
        ChartData c3008 = new ChartData();
        DataHelper.getOrgAvgScoreRank(this.sscId, c3008);
        String title = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u7528\u5206\u6392\u540dTOP10", (String)"BoardDataHelper_64", (String)"ssc-task-business", (Object[])new Object[0]);
        if (c3008.getSeries().isEmpty()) {
            c3008 = ChartData.newEmpty(title, null, null, null);
        } else {
            c3008.setTitle(title);
            c3008.setxAxis(Arrays.asList(ResManager.loadKDString((String)"\u6392\u540d", (String)"BoardDataHelper_65", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7\u673a\u6784", (String)"BoardDataHelper_66", (String)"ssc-task-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4fe1\u7528\u5206", (String)"BoardDataHelper_67", (String)"ssc-task-business", (Object[])new Object[0])));
        }
        return c3008;
    }

    private static long findSscId(long sscId, String appId, BoardResult result, boolean tabInit, String board) {
        Iterator<Long> iterator;
        LinkedHashMap<Long, String> retList = BoardDataHelper.getExpenseBoardOrgData(board, appId);
        result.setOrg(retList);
        if (sscId == 0L && !retList.isEmpty() && (iterator = retList.keySet().iterator()).hasNext()) {
            sscId = iterator.next();
        }
        return sscId;
    }

    private static LinkedHashMap<Long, String> getExpenseBoardOrgData(String board, String appId) {
        long userid = RequestContext.get().getCurrUserId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userid, (String)"12", (String)appId, (String)boardMap.getOrDefault(board, "som_board"), (String)"47150e89000000ac");
        List orgIDs = allPermOrgs.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"12") : allPermOrgs.getHasPermOrgs();
        QFilter idFilter = new QFilter("id", "in", (Object)orgIDs);
        QFilter issccFilter = new QFilter("fisscc", "=", (Object)"1");
        ArrayList<QFilter> qFList = new ArrayList<QFilter>();
        qFList.add(idFilter);
        qFList.add(issccFilter);
        QFilter[] qF = qFList.toArray(new QFilter[0]);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])qF, null);
        LinkedHashMap<Long, String> orgMap = new LinkedHashMap<Long, String>(16);
        if (result == null || result.length == 0) {
            return orgMap;
        }
        for (DynamicObject dynObj : result) {
            Long orgId = dynObj.getLong("id");
            String orgName = dynObj.getLocaleString("name").getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)orgName)) {
                orgName = dynObj.getString("name");
            }
            orgMap.put(orgId, orgName);
        }
        return orgMap;
    }

    private void fillYearRangeData(ChartData data, String field, int yearType) {
        int monthLength;
        String selectFilter;
        String seriesName;
        if (yearType == 0) {
            seriesName = ResManager.loadKDString((String)"\u53bb\u5e74", (String)"BoardDataHelper_31", (String)"ssc-task-business", (Object[])new Object[0]);
            selectFilter = this.sscId + DateHelper.getLastYear() + "-%";
            monthLength = 12;
        } else {
            seriesName = ResManager.loadKDString((String)"\u4eca\u5e74", (String)"BoardDataHelper_32", (String)"ssc-task-business", (Object[])new Object[0]);
            selectFilter = this.sscId + DateHelper.getCurYear() + "-%";
            monthLength = Calendar.getInstance().get(2) + 1;
        }
        MulSeriesData mulSeriesData = new MulSeriesData();
        data.addSeries(mulSeriesData);
        mulSeriesData.setName(seriesName);
        List<DynamicObject> sscCurDyoList = DataHelper.getSscCurDyoFromCache(selectFilter, selectFilter + "-%");
        for (int i = 0; i < monthLength; ++i) {
            boolean noData = true;
            String month = DateHelper.getCurYear() + '-' + String.format("%02d", i + 1);
            for (DynamicObject dyo : sscCurDyoList) {
                if (!month.equalsIgnoreCase(this.sdf.format(dyo.getDate("querydate")))) continue;
                mulSeriesData.addData((Object)(StringUtils.isBlank((CharSequence)dyo.getString(field)) ? "0.0" : this.d1.format(NumberUtils.toDouble((String)(dyo.get(field) + ""), (double)0.0))));
                noData = false;
                break;
            }
            if (!noData) continue;
            mulSeriesData.addData((Object)"0.0");
        }
    }

    private void fillCurMonthRankData(ChartData result, String jsonField, String entityNameForDescription, String descriptionField, String rankSeriesName) {
        List rankModels;
        DynamicObject curMonthDyo = DataHelper.getSscCurDyoFromCache(this.sscId, "2");
        if (curMonthDyo == null) {
            return;
        }
        String json = curMonthDyo.getString(jsonField);
        if (StringUtils.isNotBlank((CharSequence)json) && !(rankModels = JSON.parseArray((String)json, RankModel.class)).isEmpty()) {
            RankModel.fillNames(rankModels, entityNameForDescription, descriptionField);
            MulSeriesData mulSeriesData = new MulSeriesData();
            if (StringUtils.isNotBlank((CharSequence)rankSeriesName)) {
                mulSeriesData.setName(rankSeriesName);
            }
            ArrayList<String> xAxis = new ArrayList<String>(rankModels.size());
            result.setxAxis(xAxis);
            result.addSeries(mulSeriesData);
            for (RankModel rankModel : rankModels) {
                Object rankValue = rankModel.getRankValue();
                double v = NumberUtils.toDouble((String)(rankValue + ""), (double)0.0);
                if (v == 0.0) continue;
                xAxis.add(rankModel.getName());
                mulSeriesData.addData(rankValue);
            }
        }
    }
}

