/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.helper;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class DateHelper {
    private static final Log logger = LogFactory.getLog(DateHelper.class);

    public static Date[] getCurDayRange() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startCurDay = cal.getTime();
        cal.add(5, 1);
        Date endCurDay = cal.getTime();
        return new Date[]{startCurDay, endCurDay};
    }

    public static String getCurDay() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public static Date[] getCurMonthRange() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startCurMonth = cal.getTime();
        cal.add(2, 1);
        Date endCurMonth = cal.getTime();
        return new Date[]{startCurMonth, endCurMonth};
    }

    public static String getCurMonth() {
        return new SimpleDateFormat("yyyy-MM").format(new Date());
    }

    public static Date[] getCurYearRange() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startCurYear = cal.getTime();
        cal.add(1, 1);
        Date endCurYear = cal.getTime();
        return new Date[]{startCurYear, endCurYear};
    }

    public static String getCurYear() {
        return new SimpleDateFormat("yyyy").format(new Date());
    }

    public static String getLastYear() {
        return new SimpleDateFormat("yyyy").format(DateHelper.getFirstDayOfLastYear());
    }

    public static Date getFirstDayOfLastYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(1, -1);
        return cal.getTime();
    }

    public static List<String> getMonthsFromLastYearJanToNow() {
        return DateHelper.getMonthsFromLastYearJanToNow("");
    }

    public static List<String> getMonthsFromLastYearJanToNow(String input) {
        LocalDate now = LocalDate.now();
        LocalDate currentDate = now.minusYears(1L).withMonth(1).withDayOfMonth(1);
        if (StringUtils.isNotBlank((CharSequence)input)) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate inputDate = LocalDate.parse(input + "-01", formatter);
                currentDate = inputDate.isBefore(now) ? inputDate : currentDate;
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u9519\u8befinput:" + input, (Throwable)e);
            }
        }
        ArrayList<String> dateList = new ArrayList<String>(now.getMonthValue() + 12);
        while (!currentDate.isAfter(now)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
            String formattedDate = currentDate.format(formatter);
            dateList.add(formattedDate);
            currentDate = currentDate.plusMonths(1L);
        }
        Collections.sort(dateList);
        return dateList;
    }

    public static String getYearFilter(long sscId, Date date) {
        return sscId + DateUtil.format((Object)date, (String)"yyyy");
    }

    public static String getMonthFilter(long sscId, Date date) {
        return sscId + DateUtil.format((Object)date, (String)"yyyy-MM");
    }

    public static String getDayFilter(long sscId, Date date) {
        return sscId + DateUtil.format((Object)date, (String)"yyyy-MM-dd");
    }
}

