/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.business.boardv2.pojo.CreditLose;
import kd.ssc.task.business.boardv2.pojo.OrgCreditLose;
import kd.ssc.task.business.boardv2.pojo.RuleData;
import kd.ssc.task.business.boardv2.pojo.RuleGroupData;
import kd.ssc.task.business.boardv2.pojo.UserCreditLose;
import kd.ssc.task.business.boardv2.query.CreditExpenseItemStatistics;
import kd.ssc.task.util.AlgUtil;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class FircmDataProcessor {
    private static final Log log = LogFactory.getLog(FircmDataProcessor.class);
    private List<Object> taskBills;
    private Map<Long, Long> ruleGroupMap;

    public void query(Date date) {
        Map dyoMap;
        Date start = DateUtil.getFirstDateOfMonth((Date)date);
        Date now = DateUtil.getFirstDateOfMonth((Date)new Date());
        int diffYear = now.getYear() - start.getYear();
        if (diffYear > 1) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            calendar.set(1, now.getYear() - 1);
            calendar.set(2, 1);
            calendar.set(5, 1);
            start = calendar.getTime();
        }
        DynamicObjectCollection fircmCreditarg = QueryServiceHelper.query((String)"fircm_creditarg", (String)"bizbill.number as nn", null);
        Set billNumbers = fircmCreditarg.stream().map(f -> f.getString("nn")).collect(Collectors.toSet());
        this.taskBills = QueryServiceHelper.queryPrimaryKeys((String)"task_taskbill", (QFilter[])new QFilter("bindbill.number", "in", billNumbers).toArray(), null, (int)-1);
        HashMap<String, Map<String, DynamicObject>> saveDyoMap = new HashMap<String, Map<String, DynamicObject>>(4);
        if (start.before(now)) {
            while (start.before(now)) {
                Date end = DateUtil.addMonth((Date)start, (int)1);
                this.query0(start, end, "2", saveDyoMap);
                start = end;
            }
        } else {
            this.calOrgAvgCreditScore(now);
            this.query0(now, DateUtil.addMonth((Date)now, (int)1), "2", saveDyoMap);
            Date[] curDayRange = DateHelper.getCurDayRange();
            this.query0(curDayRange[0], curDayRange[1], "1", saveDyoMap);
            this.calSubScoreDetail(now, DateUtil.addMonth((Date)now, (int)1), "2", saveDyoMap);
        }
        if ((dyoMap = (Map)saveDyoMap.get("som_task_ssc")) != null && !dyoMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dyoMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void query0(Date start, Date end, String timeDim, Map<String, Map<String, DynamicObject>> saveDyoMap) {
        Map<Long, Integer> sscFirmCount = this.countFircmTask(start, end);
        this.countDeductTask(start, end, sscFirmCount, timeDim, saveDyoMap);
    }

    private Map<Long, Integer> countFircmTask(Date start, Date end) {
        QFilter[] qFilters = new QFilter[]{new QFilter("billtype", "in", this.taskBills), new QFilter("completetime", ">=", (Object)start), new QFilter("completetime", "<", (Object)end)};
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FircmDataProcessor#countFircmTask", (String)"task_taskhistory", (String)"sscid", (QFilter[])qFilters, null).groupBy(new String[]{"sscid"}).count("size").finish();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long sscId = row.getLong("sscid");
                Integer size = row.getInteger("size");
                if (sscId == null || sscId == 0L || size == null || size == 0) continue;
                result.put(sscId, size);
            }
        }
        return result;
    }

    private void countDeductTask(Date start, Date end, Map<Long, Integer> sscFirmCount, String timeDim, Map<String, Map<String, DynamicObject>> saveDyoMap) {
        QFilter[] logFilter = new QFilter[]{new QFilter("modifydate", ">=", (Object)start), new QFilter("modifydate", "<", (Object)end), new QFilter("modifysource", "in", (Object)new String[]{"2", "4"}), new QFilter("modifytype", "in", (Object)new String[]{"2", "4"})};
        HashSet<String> billSet = new HashSet<String>(10000);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FircmDataProcessor#countDeductTask", (String)"task_creditmodifylog", (String)"billid", (QFilter[])logFilter, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billId = row.getString("billid");
                if (NumberUtils.toLong((String)billId, (long)0L) == 0L) continue;
                billSet.add(billId);
            }
        }
        this.ruleGroupMap = QueryServiceHelper.query((String)"fircm_subscorerule", (String)"id,group", null).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("group")));
        List slist = AlgUtil.splitList(new ArrayList(billSet), (int)5000);
        HashMap<Long, List<List<Long>>> sscTaskIdsMap = new HashMap<Long, List<List<Long>>>(16);
        for (List billIds : slist) {
            this.splitSscTask(billIds, start, end, sscTaskIdsMap);
        }
        HashMap<Long, List> sscMap = new HashMap<Long, List>(16);
        HashMap<Long, Integer> subScoreCount = new HashMap<Long, Integer>(16);
        for (Map.Entry sscTaskIdsEntry : sscTaskIdsMap.entrySet()) {
            Long sscId = (Long)sscTaskIdsEntry.getKey();
            List groups = sscMap.computeIfAbsent(sscId, s -> new ArrayList());
            int size = 0;
            List taskIdsList = (List)sscTaskIdsEntry.getValue();
            size += this.queryPassBreak(groups, AlgUtil.splitList((List)((List)taskIdsList.get(0)), (int)5000));
            size += this.queryUnPass(groups, AlgUtil.splitList((List)((List)taskIdsList.get(1)), (int)5000));
            subScoreCount.put(sscId, size += this.queryQuality(groups, AlgUtil.splitList((List)((List)taskIdsList.get(2)), (int)5000)));
        }
        Map somTaskSSCMap = saveDyoMap.computeIfAbsent("som_task_ssc", p -> new HashMap(sscFirmCount.size()));
        for (Map.Entry<Long, Integer> sscTotal : sscFirmCount.entrySet()) {
            double subScoreRatio;
            Long sscId = sscTotal.getKey();
            Integer total = sscTotal.getValue();
            ArrayList ruleGroupDataList = (ArrayList)sscMap.get(sscId);
            List<RuleData> creditLoseRankList = new ArrayList<RuleData>(10);
            if (total == 0 || ruleGroupDataList == null) {
                ruleGroupDataList = new ArrayList();
                subScoreRatio = 0.0;
            } else {
                for (RuleGroupData r : ruleGroupDataList) {
                    creditLoseRankList.addAll(r.getRuleDataList());
                }
                creditLoseRankList.sort((v1, v2) -> Integer.compare(v2.getCount(), v1.getCount()));
                if (creditLoseRankList.size() > 5) {
                    creditLoseRankList = creditLoseRankList.subList(0, 5);
                }
                double[] groupCounts = ruleGroupDataList.stream().mapToDouble(RuleGroupData::getCount).toArray();
                double[] groupRatios = AlgUtil.maxRemainder((double[])groupCounts, (int)2);
                for (int i = 0; i < groupRatios.length; ++i) {
                    RuleGroupData ruleGroupData = (RuleGroupData)ruleGroupDataList.get(i);
                    ruleGroupData.setRatio(groupRatios[i]);
                }
                subScoreRatio = new BigDecimal(subScoreCount.getOrDefault(sscId, 0)).multiply(new BigDecimal(100)).divide(new BigDecimal(total), 2, RoundingMode.HALF_UP).doubleValue();
            }
            if ("2".equals(timeDim)) {
                ArrayList<String> dates = new ArrayList<String>();
                String formatStart = DateUtil.format((Object)start, (String)"yyyy-MM");
                dates.add(formatStart);
                DynamicObject dyo = somTaskSSCMap.computeIfAbsent(sscId + "&" + timeDim + "&" + formatStart, p -> DataHelper.getSscCurDyo(sscId, dates, "2").get(0));
                dyo.set("complete", (Object)total);
                dyo.set("ssctaskauditcnt", (Object)total);
                dyo.set("creditlosecnt", (Object)subScoreCount.getOrDefault(sscId, 0));
                dyo.set("subscoreratio", (Object)subScoreRatio);
                dyo.set("ruleratiojson_tag", (Object)SerializationUtils.toJsonString(ruleGroupDataList));
                dyo.set("creditloserankjson", (Object)JSON.toJSONString(creditLoseRankList));
                continue;
            }
            if (!"1".equals(timeDim)) continue;
            String formatStart = DateUtil.format((Object)start, (String)"yyyy-MM-dd");
            DynamicObject sscCurDyo = somTaskSSCMap.computeIfAbsent(sscId + "&" + timeDim + "&" + formatStart, p -> DataHelper.getSscCurDyo(sscId, timeDim));
            sscCurDyo.set("complete", (Object)total);
            sscCurDyo.set("ssctaskauditcnt", (Object)total);
            sscCurDyo.set("creditlosecnt", (Object)subScoreCount.getOrDefault(sscId, 0));
            sscCurDyo.set("subscoreratio", (Object)subScoreRatio);
        }
    }

    private int queryPassBreak(List<RuleGroupData> groups, List<List<Long>> idsList) {
        if (idsList.isEmpty()) {
            return 0;
        }
        HashSet<Long> existIds = new HashSet<Long>(64);
        for (List<Long> ids : idsList) {
            QFilter[] qFilters = new QFilter[]{new QFilter("histaskid", "in", ids)};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_crebreakrulerecord", (String)"histaskid,subscorerule r", (QFilter[])qFilters);
            for (DynamicObject object : collection) {
                long r = object.getLong("r");
                this.addData(r, this.ruleGroupMap.get(r), groups);
                existIds.add(object.getLong("histaskid"));
            }
        }
        return existIds.size();
    }

    private int queryUnPass(List<RuleGroupData> groups, List<List<Long>> idsList) {
        if (idsList.isEmpty()) {
            return 0;
        }
        HashSet<Long> existIds = new HashSet<Long>(64);
        for (List<Long> ids : idsList) {
            QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "in", ids)};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_withdrawal_unpass", (String)"taskid,withdrawal.subscorerule r", (QFilter[])qFilters);
            for (DynamicObject object : collection) {
                long r = object.getLong("r");
                Long groupId = this.ruleGroupMap.get(r);
                if (groupId != null) {
                    this.addData(r, groupId, groups);
                }
                existIds.add(object.getLong("taskid"));
            }
        }
        return existIds.size();
    }

    private int queryQuality(List<RuleGroupData> groups, List<List<Long>> idsList) {
        if (idsList.isEmpty()) {
            return 0;
        }
        HashSet<Long> existIds = new HashSet<Long>(64);
        for (List<Long> ids : idsList) {
            QFilter[] qFilters = new QFilter[]{new QFilter("qualitycheck", "in", ids), new QFilter("reviewmethod", "=", (Object)"1")};
            QFilter[] pointFilters = new QFilter[]{new QFilter("subscorerule", "is not null", null)};
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FircmDataProcessor.queryQuality", (String)"task_qualitymessagerecord", (String)"id,point,qualitycheck", (QFilter[])qFilters, null).join(QueryServiceHelper.queryDataSet((String)"FircmDataProcessor.queryQuality", (String)"task_checkingpoint", (String)"id,subscorerule r", (QFilter[])pointFilters, null)).on("point", "id").select(new String[]{"id", "qualitycheck"}, new String[]{"r"}).finish();
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    long r = row.getLong("r");
                    if (r != 0L) {
                        this.addData(r, this.ruleGroupMap.get(r), groups);
                    }
                    existIds.add(row.getLong("qualitycheck"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return existIds.size();
    }

    private void splitSscTask(List<String> billIds, Date start, Date end, Map<Long, List<List<Long>>> sscTaskIdsMap) {
        QFilter[] historyFilter = new QFilter[]{new QFilter("billid", "in", billIds), new QFilter("completetime", ">=", (Object)start), new QFilter("completetime", "<", (Object)end)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,sscid,sourcetaskid,qualitysamplelibrary,state", (QFilter[])historyFilter);
        for (DynamicObject col : collection) {
            long sscId = col.getLong("sscid");
            boolean q = col.getLong("qualitysamplelibrary") != 0L;
            long id = col.getLong("id");
            long sid = col.getLong("sourcetaskid");
            String state = col.getString("state");
            List taskIdsList = sscTaskIdsMap.computeIfAbsent(sscId, d -> {
                ArrayList t = new ArrayList();
                t.add(new ArrayList());
                t.add(new ArrayList());
                t.add(new ArrayList());
                return t;
            });
            if (q) {
                ((List)taskIdsList.get(2)).add(id);
                continue;
            }
            if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
                ((List)taskIdsList.get(1)).add(sid);
                continue;
            }
            if (!TaskStateEnum.AUDIT_PASSED.getValue().equals(state)) continue;
            ((List)taskIdsList.get(0)).add(id);
        }
    }

    private void addData(long ruleId, long groupId, List<RuleGroupData> groups) {
        RuleData rule;
        RuleGroupData ruleGroupData;
        if (ruleId == 0L) {
            return;
        }
        Optional<RuleGroupData> groupOptional = groups.stream().filter(g -> g.getGroupId() == groupId).findAny();
        if (!groupOptional.isPresent()) {
            ruleGroupData = new RuleGroupData();
            groups.add(ruleGroupData);
        } else {
            ruleGroupData = groupOptional.get();
        }
        ruleGroupData.setGroupId(groupId);
        ruleGroupData.add();
        List<RuleData> rules = ruleGroupData.getRuleDataList();
        Optional<RuleData> ruleOptional = rules.stream().filter(r -> r.getRuleId() == ruleId).findAny();
        if (!ruleOptional.isPresent()) {
            rule = new RuleData(ruleId, 0);
            rules.add(rule);
        } else {
            rule = ruleOptional.get();
        }
        rule.add();
    }

    private void calOrgAvgCreditScore(Date now) {
        String algoKey = this.getClass() + ".query().calOrgAvgCreditScore()";
        String selFields = "company,creditvalue";
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter companyFilter = new QFilter("company.id", ">", (Object)0L);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditfiles", (String)selFields, (QFilter[])new QFilter[]{statusFilter, companyFilter}, null);
             DataSet dataSet1 = dataSet.groupBy(new String[]{"company"}).avg("creditvalue", "avgscore").finish();){
            ArrayList<DynamicObject> dynObjs = new ArrayList<DynamicObject>(10);
            for (Row row : dataSet1) {
                DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"ssc_creditboardavgscore");
                dynObj.set("company", (Object)row.getLong("company"));
                dynObj.set("avgscore", (Object)row.getBigDecimal("avgscore"));
                dynObjs.add(dynObj);
            }
            DeleteServiceHelper.delete((String)"ssc_creditboardavgscore", null);
            SaveServiceHelper.save((DynamicObject[])dynObjs.toArray(new DynamicObject[0]));
        }
    }

    private void calSubScoreDetail(Date start, Date end, String timeDim, Map<String, Map<String, DynamicObject>> saveDyoMap) {
        String algoKey = this.getClass() + ".query().calSubScoreDetail()";
        String selFields = "raiser,company,modifysource source,changedscore,modifydate,taskid";
        QFilter[] filters = new QFilter[]{QFilter.of((String)"modifydate >= ? and modifydate < ?", (Object[])new Object[]{start, end}), new QFilter("modifytype", "in", Arrays.asList(Character.valueOf('2'), Character.valueOf('4'))), new QFilter("modifysource", "in", Arrays.asList(Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'))), new QFilter("taskid", ">", (Object)0)};
        String selhisTaskFields = "id,sscid,billtype.bindbill.number billentity,billtype.externalerp bizsys,billid";
        Set<Long> taskIds = this.getTaskIdsByCreditModifyLog(filters);
        if (taskIds.isEmpty()) {
            log.info("calSubScoreDetail().taskIds is empty");
            return;
        }
        QFilter taskIdFil = new QFilter("id", "in", taskIds);
        try (DataSet creditLogs = QueryServiceHelper.queryDataSet((String)(algoKey + "_0"), (String)"task_creditmodifylog", (String)selFields, (QFilter[])filters, null);
             DataSet creditLogs1 = creditLogs.select(new String[]{"raiser", "company", "source", "-changedscore score", "modifydate", "taskid"});
             DataSet taskHisData = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)"task_taskhistory", (String)selhisTaskFields, (QFilter[])new QFilter[]{taskIdFil}, null);
             DataSet resultData = creditLogs1.join(taskHisData, JoinType.INNER).on("taskid", "id").select(new String[]{"modifydate", "raiser", "company", "source", "score", "taskid"}, new String[]{"sscid", "billentity", "bizsys", "billid"}).finish().orderBy(new String[]{"sscid", "modifydate desc"});){
            Map somTaskSSCMap = saveDyoMap.computeIfAbsent("som_task_ssc", p -> new HashMap(16));
            HashMap<Long, Map<Object, CreditLose>> creditMap = new HashMap<Long, Map<Object, CreditLose>>(16);
            HashMap<Long, Map<Object, CreditLose>> billTypeCreditMap = new HashMap<Long, Map<Object, CreditLose>>(16);
            HashMap<Long, Map<Object, CreditLose>> orgComCreditMap = new HashMap<Long, Map<Object, CreditLose>>(16);
            HashMap<String, Object> sourceDataMap = new HashMap<String, Object>(16);
            for (Row row : resultData) {
                Long sscId = row.getLong("sscid");
                Long userId = row.getLong("raiser");
                Long companyId = row.getLong("company");
                BigDecimal subScore = row.getBigDecimal("score");
                Map userCreditMap = creditMap.computeIfAbsent(sscId, p -> new HashMap(16));
                CreditLose userCreditLose = userCreditMap.computeIfAbsent(userId, p -> new UserCreditLose(userId, new BigDecimal(0), companyId));
                userCreditLose.add(subScore);
                Set billEntitySet = (Set)sourceDataMap.computeIfAbsent("billEntity", p -> new HashSet(10));
                billEntitySet.add(row.getString("billentity"));
                Map billInfoMap = (Map)sourceDataMap.computeIfAbsent("billInfo", p -> new HashMap(16));
                String key = sscId + "#" + row.get("billentity");
                try {
                    billInfoMap.computeIfAbsent(key, p -> new HashSet(10)).add(row.getLong("billid"));
                }
                catch (Exception ignored) {
                    billInfoMap.computeIfAbsent(key, p -> new HashSet(10)).add(row.get("billid"));
                }
                Map orgCreditMap = orgComCreditMap.computeIfAbsent(sscId, p -> new HashMap(16));
                CreditLose orgCreditLose = orgCreditMap.computeIfAbsent(companyId, p -> new OrgCreditLose(companyId, new BigDecimal(0)));
                orgCreditLose.add(subScore);
            }
            CreditExpenseItemStatistics.statistics(sourceDataMap, billTypeCreditMap);
            String formatStart = DateUtil.format((Object)start, (String)"yyyy-MM");
            this.sortDesc(creditMap, timeDim, somTaskSSCMap, "usercreditloserankjson", formatStart, 10);
            this.sortDesc(billTypeCreditMap, timeDim, somTaskSSCMap, "billcreditloserankjson", formatStart, 10);
            this.sortDesc(orgComCreditMap, timeDim, somTaskSSCMap, "orgcreditloserankjson", formatStart, 10);
        }
    }

    private void sortDesc(Map<Long, Map<Object, CreditLose>> creditMap, String timeDim, Map<String, DynamicObject> somTaskSSCMap, String column, String formatStart, int top) {
        for (Map.Entry<Long, Map<Object, CreditLose>> entry : creditMap.entrySet()) {
            Long sscId = entry.getKey();
            List<CreditLose> creditLoses = new ArrayList<CreditLose>(entry.getValue().values());
            creditLoses.sort((v1, v2) -> v2.getTotalSubScore().compareTo(v1.getTotalSubScore()));
            if (creditLoses.size() > top) {
                creditLoses = creditLoses.subList(0, top);
            }
            DynamicObject sscCurDyo = somTaskSSCMap.computeIfAbsent(sscId + "&" + timeDim + "&" + formatStart, p -> DataHelper.getSscCurDyo(sscId, timeDim));
            sscCurDyo.set(column, (Object)JSON.toJSONString(creditLoses));
        }
    }

    private Set<Long> getTaskIdsByCreditModifyLog(QFilter[] filters) {
        HashSet<Long> taskIds = new HashSet<Long>(32);
        String algoKey = this.getClass() + ".getTaskIdsByCreditModifyLog()";
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_creditmodifylog", (String)"taskid", (QFilter[])filters, null);){
            for (Row row : dSet) {
                taskIds.add(row.getLong("taskid"));
            }
        }
        return taskIds;
    }
}

