/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.excel;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import kd.ssc.task.business.workbill.excel.WorkBillExcelFieldEnum;
import kd.ssc.task.business.workbill.excel.WorkBillExcelFieldTypeEnum;
import kd.ssc.task.business.workbill.excel.WorkBillExcelInfo;
import kd.ssc.task.business.workbill.excel.WorkBillImportExcelUtil;
import kd.ssc.task.business.workbill.excel.WorkBillPanelTypeEnum;
import kd.ssc.task.business.workbill.excel.WorkBillVisibleOrMustEnum;

public class WorkBillImportExcelHelper
extends WorkBillCommonHelper {
    private static final Log log = LogFactory.getLog(WorkBillImportExcelHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WorkBillExcelInfo> parsingExcel(String attachmentUrl) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = tempFileCache.getInputStream(attachmentUrl);){
            List<WorkBillExcelInfo> list = WorkBillImportExcelUtil.readExcelOfList(inputStream);
            return list;
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("parsingExcel error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u683c\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"WorkBillImportFieldHelper_1", (String)"ssc-task-business", (Object[])new Object[0]));
        }
    }

    public static List<String> checkFieldInfoValid(List<WorkBillExcelInfo> workBillExcelInfos, List<String> existFieldNumList, Map<String, String> existPanelNumMap) {
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        if (CollectionUtils.isEmpty(workBillExcelInfos)) {
            errorMsgList.add(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkBillImportFieldHelper_2", (String)"ssc-task-business", (Object[])new Object[0]));
            return errorMsgList;
        }
        errorMsgList.addAll(WorkBillImportExcelHelper.checkExcelFieldMustInput(workBillExcelInfos));
        if (CollectionUtils.isNotEmpty(errorMsgList)) {
            return errorMsgList;
        }
        errorMsgList.addAll(WorkBillImportExcelHelper.checkExcelFieldFormat(workBillExcelInfos));
        if (CollectionUtils.isNotEmpty(errorMsgList)) {
            return errorMsgList;
        }
        errorMsgList.addAll(WorkBillImportExcelHelper.checkExcelFieldLength(workBillExcelInfos));
        if (CollectionUtils.isNotEmpty(errorMsgList)) {
            return errorMsgList;
        }
        errorMsgList.addAll(WorkBillImportExcelHelper.checkExcelFieldRepeat(workBillExcelInfos, existFieldNumList, existPanelNumMap));
        if (CollectionUtils.isNotEmpty(errorMsgList)) {
            return errorMsgList;
        }
        return errorMsgList;
    }

    public static Map<String, List<WorkBillExcelInfo>> covertData(List<WorkBillExcelInfo> workBillExcelInfos, Map<String, String> existPanelNumMap) {
        TreeMap<String, List<WorkBillExcelInfo>> infoMap = new TreeMap<String, List<WorkBillExcelInfo>>();
        String isvPrefix = WorkBillImportExcelHelper.getIsvPrefix();
        for (WorkBillExcelInfo excelInfo : workBillExcelInfos) {
            String fieldNum = WorkBillImportExcelHelper.amendNumber(excelInfo.getFieldNumber(), isvPrefix);
            excelInfo.setFieldNumber(fieldNum);
            String fieldType = WorkBillExcelFieldTypeEnum.getFieldTypeItem(excelInfo.getFieldType()).getNumber();
            excelInfo.setFieldType(fieldType);
            String panelNum = existPanelNumMap.containsKey(excelInfo.getPanelNumber()) ? excelInfo.getPanelNumber() : WorkBillImportExcelHelper.amendNumber(excelInfo.getPanelNumber(), isvPrefix);
            excelInfo.setPanelNumber(panelNum);
            String panelType = WorkBillPanelTypeEnum.getPanelTypeItem(excelInfo.getPanelType()).getValue();
            excelInfo.setPanelType(panelType);
            List fieldInfoList = infoMap.computeIfAbsent(panelNum, key -> new ArrayList(8));
            fieldInfoList.add(excelInfo);
        }
        return infoMap;
    }

    private static List<String> checkExcelFieldFormat(List<WorkBillExcelInfo> workBillExcelInfos) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        for (WorkBillExcelInfo excelInfo : workBillExcelInfos) {
            List<String> unValidFieldMsgList = WorkBillImportExcelHelper.checkFieldFormat(excelInfo);
            if (CollectionUtils.isEmpty(unValidFieldMsgList)) continue;
            errorList.addAll(unValidFieldMsgList);
        }
        return errorList;
    }

    private static List<String> checkExcelFieldLength(List<WorkBillExcelInfo> workBillExcelInfos) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        String isvPrefix = WorkBillImportExcelHelper.getIsvPrefix();
        for (WorkBillExcelInfo excelInfo : workBillExcelInfos) {
            List<String> unValidFieldMsgList = WorkBillImportExcelHelper.checkMaxLength(excelInfo, isvPrefix);
            if (CollectionUtils.isEmpty(unValidFieldMsgList)) continue;
            errorList.addAll(unValidFieldMsgList);
        }
        return errorList;
    }

    private static List<String> checkExcelFieldRepeat(List<WorkBillExcelInfo> workBillExcelInfos, List<String> existFieldNumList, Map<String, String> existPanelNumMap) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        String isvPrefix = WorkBillImportExcelHelper.getIsvPrefix();
        for (WorkBillExcelInfo excelInfo : workBillExcelInfos) {
            List<String> unValidFieldMsgList = WorkBillImportExcelHelper.checkFieldRepeat(excelInfo, existFieldNumList, existPanelNumMap, isvPrefix);
            if (CollectionUtils.isEmpty(unValidFieldMsgList)) continue;
            errorList.addAll(unValidFieldMsgList);
        }
        return errorList;
    }

    private static List<String> checkFieldRepeat(WorkBillExcelInfo excelInfo, List<String> existFieldNumList, Map<String, String> existPanelNumMap, String isvPrefix) {
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        String fieldNum = WorkBillImportExcelHelper.amendNumber(excelInfo.getFieldNumber(), isvPrefix);
        if (existFieldNumList.contains(fieldNum)) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5b57\u6bb5\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"WorkBillImportFieldHelper_4", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum()));
        } else {
            existFieldNumList.add(fieldNum);
        }
        String panelNum = existPanelNumMap.containsKey(excelInfo.getPanelNumber()) ? excelInfo.getPanelNumber() : WorkBillImportExcelHelper.amendNumber(excelInfo.getPanelNumber(), isvPrefix);
        String panelTypeAndName = WorkBillPanelTypeEnum.getPanelTypeItem(excelInfo.getPanelType()).getValue() + excelInfo.getPanelName();
        String existPanelTypeAndName = existPanelNumMap.get(panelNum);
        if (StringUtils.isEmpty((CharSequence)existPanelTypeAndName)) {
            existPanelNumMap.put(panelNum, panelTypeAndName);
            return errorMsgList;
        }
        if (!StringUtils.equals((CharSequence)existPanelTypeAndName, (CharSequence)panelTypeAndName)) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u9762\u677f\u7f16\u7801\u91cd\u590d\uff0c\u7c7b\u578b\u6216\u540d\u79f0\u4e0d\u4e00\u81f4\u3002", (String)"WorkBillImportFieldHelper_6", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum()));
        }
        return errorMsgList;
    }

    private static List<String> checkFieldFormat(WorkBillExcelInfo excelInfo) {
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        block11: for (Field field : excelInfo.getClass().getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            WorkBillExcelFieldEnum fieldInfoItem = WorkBillExcelFieldEnum.getFieldInfoItem(field.getName());
            try {
                switch (fieldInfoItem) {
                    case FIELD_TYPE: {
                        WorkBillExcelFieldTypeEnum.getFieldTypeItem(excelInfo.getFieldType());
                        continue block11;
                    }
                    case IS_VISIBLE: {
                        WorkBillVisibleOrMustEnum.getVisibleOrMustItem(excelInfo.getIsVisible(), WorkBillExcelFieldEnum.IS_VISIBLE);
                        continue block11;
                    }
                    case IS_MUST: {
                        WorkBillVisibleOrMustEnum.getVisibleOrMustItem(excelInfo.getIsMust(), WorkBillExcelFieldEnum.IS_MUST);
                        continue block11;
                    }
                    case PANEL_TYPE: {
                        WorkBillPanelTypeEnum.getPanelTypeItem(excelInfo.getPanelType());
                        continue block11;
                    }
                    case FIELD_NUMBER: {
                        WorkBillImportExcelHelper.isEngLetter(excelInfo.getFieldNumber(), WorkBillExcelFieldEnum.FIELD_NUMBER);
                        continue block11;
                    }
                    case PANEL_NUMBER: {
                        WorkBillImportExcelHelper.isEngLetter(excelInfo.getPanelNumber(), WorkBillExcelFieldEnum.PANEL_NUMBER);
                        continue block11;
                    }
                    case FIELD_PROPERTY: {
                        boolean isComboProp;
                        boolean bl = isComboProp = StringUtils.equals((CharSequence)WorkBillExcelFieldTypeEnum.COMBO.getName(), (CharSequence)excelInfo.getFieldType()) && StringUtils.isNotEmpty((CharSequence)excelInfo.getFieldProperty());
                        if (!isComboProp) break;
                        WorkBillImportExcelHelper.isValidComboStr(excelInfo.getFieldProperty());
                    }
                }
            }
            catch (KDBizException e) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"WorkBillImportFieldHelper_10", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), e.getMessage()));
            }
        }
        return errorMsgList;
    }

    private static List<String> checkExcelFieldMustInput(List<WorkBillExcelInfo> workBillExcelInfos) {
        ArrayList<String> errorList = new ArrayList<String>(16);
        for (WorkBillExcelInfo excelInfo : workBillExcelInfos) {
            List<String> isNullFields = WorkBillImportExcelHelper.checkFieldIsNull(excelInfo);
            if (CollectionUtils.isEmpty(isNullFields)) continue;
            for (String fieldName : isNullFields) {
                WorkBillExcelFieldEnum fieldInfoItem = WorkBillExcelFieldEnum.getFieldInfoItem(fieldName);
                errorList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkBillImportFieldHelper_5", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldInfoItem.getName()));
            }
        }
        return errorList;
    }

    private static List<String> checkFieldIsNull(WorkBillExcelInfo excelInfo) {
        ArrayList<String> isNullFields = new ArrayList<String>(16);
        for (Field field : excelInfo.getClass().getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            String fieldName = field.getName();
            WorkBillExcelFieldEnum fieldInfoItem = WorkBillExcelFieldEnum.getFieldInfoItem(fieldName);
            try {
                if (WorkBillExcelFieldEnum.FIELD_PROPERTY == fieldInfoItem || !ObjectUtils.isEmpty((Object)field.get(excelInfo))) continue;
                isNullFields.add(fieldName);
            }
            catch (IllegalAccessException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u89e3\u6790\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"WorkBillImportFieldHelper_11", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldInfoItem.getName()));
            }
        }
        return isNullFields;
    }

    private static void isEngLetter(String passengerName, WorkBillExcelFieldEnum fieldItem) {
        String eng = "^[a-zA-Z0-9_]*$";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(passengerName);
        if (matcher.matches()) {
            return;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"WorkBillImportFieldHelper_7", (String)"ssc-task-business", (Object[])new Object[0]), fieldItem.getName()));
    }

    private static List<String> checkMaxLength(WorkBillExcelInfo excelInfo, String prefix) {
        int maxLength = 0;
        String fieldContent = "";
        String fieldName = "";
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        block6: for (Field field : excelInfo.getClass().getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            WorkBillExcelFieldEnum fieldInfoItem = WorkBillExcelFieldEnum.getFieldInfoItem(field.getName());
            fieldName = fieldInfoItem.getName();
            switch (fieldInfoItem) {
                case PANEL_NUMBER: {
                    fieldContent = WorkBillImportExcelHelper.amendNumber(excelInfo.getPanelNumber(), prefix);
                    String panelType = excelInfo.getPanelType();
                    WorkBillPanelTypeEnum panelTypeItem = WorkBillPanelTypeEnum.getPanelTypeItem(panelType);
                    maxLength = panelTypeItem.getMaxLength();
                    if (fieldContent.length() <= maxLength) continue block6;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u5185\u5bb9\u52a0\u4e0a\u5f00\u53d1\u5546\u524d\u7f00%3$s\u8d85\u8fc7%4$s\u4e2a\u5b57\u7b26\u957f\u5ea6\u9650\u5236\u3002", (String)"WorkBillImportFieldHelper_3", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldName, prefix, maxLength));
                    continue block6;
                }
                case FIELD_NUMBER: {
                    fieldContent = WorkBillImportExcelHelper.amendNumber(excelInfo.getFieldNumber(), prefix);
                    maxLength = 22;
                    if (fieldContent.length() <= maxLength) continue block6;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u5185\u5bb9\u52a0\u4e0a\u5f00\u53d1\u5546\u524d\u7f00%3$s\u8d85\u8fc7%4$s\u4e2a\u5b57\u7b26\u957f\u5ea6\u9650\u5236\u3002", (String)"WorkBillImportFieldHelper_3", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldName, prefix, maxLength));
                    continue block6;
                }
                case FIELD_NAME: {
                    fieldContent = excelInfo.getFieldName();
                    maxLength = 50;
                    if (fieldContent.length() <= maxLength) continue block6;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u5185\u5bb9\u8d85\u8fc7%3$s\u4e2a\u5b57\u7b26\u957f\u5ea6\u9650\u5236\u3002", (String)"WorkBillImportFieldHelper_9", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldName, maxLength));
                    continue block6;
                }
                case PANEL_NAME: {
                    fieldContent = excelInfo.getPanelName();
                    maxLength = 50;
                    if (fieldContent.length() <= maxLength) continue block6;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u5185\u5bb9\u8d85\u8fc7%3$s\u4e2a\u5b57\u7b26\u957f\u5ea6\u9650\u5236\u3002", (String)"WorkBillImportFieldHelper_9", (String)"ssc-task-business", (Object[])new Object[0]), excelInfo.getRowNum(), fieldName, maxLength));
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return errorMsgList;
    }

    public static String splitComboToJson(String content) {
        String[] arr = content.split(",");
        ArrayList results = new ArrayList(8);
        int i = 0;
        for (String s : arr) {
            String[] pair = s.split(":");
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("Caption", pair[0]);
            map.put("Value", pair[1]);
            map.put("Seq", i++);
            results.add(map);
        }
        HashMap para = new HashMap(8);
        para.put("items", results);
        return JSONObject.toJSONString(para);
    }

    public static String splitComboCaption(String content) {
        String[] arr = content.split(",");
        ArrayList<String> captionList = new ArrayList<String>(8);
        for (String s : arr) {
            String[] pair = s.split(":");
            captionList.add(pair[0]);
        }
        return captionList.stream().collect(Collectors.joining(","));
    }

    private static void isValidComboStr(String content) {
        String[] arr;
        for (String s : arr = content.split(",")) {
            String[] pair = s.split(":");
            if (pair.length == 2) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42\uff0c\u8bf7\u6309\u7167key1:value1\uff0ckey2:value2\u7684\u683c\u5f0f\u7f16\u8f91\u5185\u5bb9\u3002", (String)"WorkBillFieldInfoEnum_11", (String)"ssc-task-business", (Object[])new Object[0]));
        }
    }
}

