/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.file;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import kd.ssc.task.business.workbill.pojo.WorkBillVersionInfo;
import kd.ssc.workbill.util.EntityJsonTransferUtil;
import kd.ssc.workbill.util.MetaDataFileUtil;
import kd.ssc.workbill.util.XmlUtil;

public class WorkBillExportHelper
extends WorkBillCommonHelper {
    private static final String SYSTEM_TYPE = "ssc-task-business";

    public static String exportWorkBill(List<Long> ids) {
        DynamicObject[] workBillDyns = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_billmanger"));
        String extBizAppId = WorkBillExportHelper.getExtBizAppId();
        ArrayList<String> urls = new ArrayList<String>(8);
        for (DynamicObject workBillDyn : workBillDyns) {
            String bizNum = workBillDyn.getString("number");
            String bizId = MetadataDao.getIdByNumber((String)bizNum, (MetaCategory)MetaCategory.Form);
            String entityFileUrl = EntityJsonTransferUtil.exportEntityFile((String)bizNum, (DynamicObject)workBillDyn);
            String metaDataFileUrl = MetaDataFileUtil.exportMetaData((String)extBizAppId, (String)bizId, (String)bizNum);
            urls.add(entityFileUrl);
            urls.add(metaDataFileUrl);
        }
        urls.add(WorkBillExportHelper.getVersionXmlUrl());
        return CacheFactory.getCommonCacheFactory().getTempFileCache().compress(WorkBillExportHelper.getExportFileName() + ".zip", urls.toArray(new String[0]), 5000);
    }

    private static String getVersionXmlUrl() {
        WorkBillVersionInfo versionInfo = new WorkBillVersionInfo();
        Map<String, String> versionMap = WorkBillExportHelper.queryVersionInfo();
        versionInfo.setCsVersion(versionMap.get("csVersion"));
        versionInfo.setCcsVersion(versionMap.get("cssVersion"));
        versionInfo.setPrefix(WorkBillExportHelper.getIsvPrefix());
        return XmlUtil.getDownloadUrl((String)"version", (Object)versionInfo);
    }

    private static String getExportFileName() {
        String fileName = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_\u5171\u4eab\u5de5\u5355\u5f15\u5165\u6a21\u677f_", (String)"WorkBillExportHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss");
        return fileName + format.format(now);
    }
}

