/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.eventSend.event;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.eventSend.core.SscEventContext;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.entity.SscEventDo;
import kd.ssc.eventSend.event.SscSendEvent;
import kd.ssc.eventSend.util.DutyManageDataHelper;
import kd.ssc.eventSend.util.SscEventResultHelper;

public class TaskSyncDataEvent
implements SscSendEvent {
    private static final Log logger = LogFactory.getLog(TaskSyncDataEvent.class);

    @Override
    public Map<String, Object> event(SscEventContext context) {
        String taskEntityNumber = context.getTaskEntityNumber();
        DataChangeTypeEnum dataChangeType = context.getDataChangeType();
        boolean fullSync = context.isFullSync();
        Long sscId = context.getSscId();
        List<Long> taskIdList = context.getTaskIdList();
        SscEventDo sscEventDo = context.getSscEventDo();
        logger.info("TaskSyncDataEvent.event() start, taskEntityNumber = {}, fullSync = {}, dataChangeType = {}, sscId = {}, taskIdList = {}", new Object[]{taskEntityNumber, fullSync, dataChangeType, sscId, JSONObject.toJSONString(taskIdList)});
        return this.taskSyncData(sscEventDo, taskEntityNumber, fullSync, dataChangeType, sscId, taskIdList);
    }

    private Map<String, Object> taskSyncData(SscEventDo sscEventDo, String taskEntityNumber, boolean fullSync, DataChangeTypeEnum dataChangeType, Long sscId, List<Long> taskIdList) {
        if (!"task_task".equals(taskEntityNumber) && !"task_taskhistory".equals(taskEntityNumber)) {
            logger.error("TaskSyncDataEvent.event() end\uff1ataskEntityNumber = {} , \u53ea\u652f\u6301\u5171\u4eab\u4efb\u52a1\u5b9e\u4f53", (Object)taskEntityNumber);
            return SscEventResultHelper.getSuccessResult(null);
        }
        DynamicObject sscDo = QueryServiceHelper.queryOne((String)"bos_org", (String)"id, number", (QFilter[])new QFilter("id", "=", (Object)sscId).toArray());
        if (sscDo == null) {
            logger.error("TaskSyncDataEvent.event() end\uff1asscId = {} , \u5171\u4eab\u4e2d\u5fc3\u4e0d\u5b58\u5728", (Object)sscId);
            return SscEventResultHelper.getSuccessResult(null);
        }
        if (CollectionUtils.isEmpty(taskIdList)) {
            logger.error("TaskSyncDataEvent.event() end\uff1ataskIdList\u4e3a\u7a7a");
            return SscEventResultHelper.getSuccessResult(null);
        }
        return this.doBizService(sscEventDo, taskEntityNumber, fullSync, dataChangeType, sscId, taskIdList);
    }

    private Map<String, Object> doBizService(SscEventDo sscEventDo, String taskEntityNumber, boolean fullSync, DataChangeTypeEnum dataChangeType, Long sscId, List<Long> taskIdList) {
        QFilter filter3;
        QFilter filter2;
        String sscType = DutyManageDataHelper.getSSCType(sscId);
        String caseNumber = sscEventDo.getEventType().getCaseNumber();
        QFilter filter1 = new QFilter("bizextcase.number", "=", (Object)caseNumber);
        DynamicObject bizExtServiceDo = QueryServiceHelper.queryOne((String)"ssc_bizextservice", (String)"id,servicename,methodname,cloudid.number,appid.number", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("sscbusinesstype", "=", (Object)sscType), filter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (bizExtServiceDo == null) {
            logger.info("TaskSyncDataEvent.event() end\uff0csscType = {}\uff0ccaseNumber = {}\uff1a\u672a\u627e\u5230\u76f8\u5173\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u65e0\u9700\u6267\u884c", (Object)sscType, (Object)caseNumber);
            return SscEventResultHelper.getSuccessResult(null);
        }
        String serviceName = bizExtServiceDo.getString("servicename");
        String methodName = bizExtServiceDo.getString("methodname");
        String cloudId = bizExtServiceDo.getString("cloudid.number");
        String appId = bizExtServiceDo.getString("appid.number");
        if (StringUtils.isEmpty((Object)serviceName) || StringUtils.isEmpty((Object)methodName) || StringUtils.isEmpty((Object)cloudId) || StringUtils.isEmpty((Object)appId)) {
            logger.info("TaskSyncDataEvent.event() end\uff0c\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u76f8\u5173\u914d\u7f6e\u4e3a\u7a7a");
            return SscEventResultHelper.getSuccessResult(null);
        }
        cloudId = cloudId.toLowerCase();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("taskEntityNumber", taskEntityNumber);
        paramMap.put("isFullSync", fullSync);
        paramMap.put("dataChangeType", dataChangeType.getValue());
        paramMap.put("idList", taskIdList);
        String paramMapJson = JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        sscEventDo.setEventDetailJson(paramMapJson);
        int maxCount = sscEventDo.getMaxCount();
        for (int i = 1; i <= maxCount; ++i) {
            try {
                logger.info("TaskSyncDataEvent.event(), paramMap=" + paramMapJson);
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{paramMap});
                logger.info("TaskSyncDataEvent.event(), resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                return resultMap;
            }
            catch (Exception e) {
                logger.error("TaskSyncDataEvent.event() failed ", (Throwable)e);
                if (i != maxCount) continue;
                throw e;
            }
        }
        return SscEventResultHelper.getSuccessResult(null);
    }
}

