/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.compensate;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.task.create.CreateTaskByWorkflow;

public class WfTaskCompensateHandler
extends CompensateHandler {
    public WfTaskCompensateHandler(ExceptionDTO dto) {
        super(dto);
    }

    @Override
    public boolean exceptionCompensate() {
        try {
            long taskId = this.createWfTaskByParam();
            if (taskId == 0L) {
                ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.FAILURE, this.dto);
                return false;
            }
            ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.SUCCESS, this.dto);
            return true;
        }
        catch (Exception e) {
            ExceptionHelperUtil.updateTableAfterCompensateException(e, this.dto);
            return false;
        }
    }

    private long createWfTaskByParam() {
        Map queryParam = (Map)SerializationUtils.fromJsonString((String)this.dto.getRequestParam(), Map.class);
        long taskTypeId = Long.parseLong((String)queryParam.get("taskTypeId"));
        String billId = (String)queryParam.get("billId");
        long billTypeId = Long.parseLong((String)queryParam.get("billTypeId"));
        String workFlowId = (String)queryParam.get("workflowId");
        if (ExceptionHelperUtil.taskIsExisted(billId, taskTypeId)) {
            return -1L;
        }
        return new CreateTaskByWorkflow().createTask(taskTypeId, billTypeId, billId, 0L, "", "", 0L, workFlowId);
    }
}

