/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.domain;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.task.util.ObjectCloneUtil;

public class ExceptionDO {
    private String billId;
    private String billNo;
    private String billType;
    private String billTypeName;
    private String exceptionType;
    private String requestParam;
    private String failureReason;
    private String failureMsg;
    private Date failureTime;
    private Date retryTime;
    private Integer retryCounts;
    private Integer isNotified;
    private String notifyType;
    private String notifyMember;
    private String compensateStatus;
    private String dealType;
    private String interfaceType;
    private String sourceSystem;
    private Long applicant;
    private Long applOrg;
    private String isCompensate;

    private ExceptionDO() {
    }

    public ExceptionDO(DynamicObject dyn) {
        this();
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (IDataEntityProperty prop : properties) {
            propertyNames.add(prop.getName());
        }
        if (propertyNames.contains("billid")) {
            this.billId = dyn.getString("billid");
        }
        if (propertyNames.contains("billno")) {
            this.billNo = dyn.getString("billno");
        }
        if (propertyNames.contains("billtype")) {
            this.billType = dyn.getString("billtype");
        }
        if (propertyNames.contains("billtypename")) {
            this.billTypeName = dyn.getString("billtypename");
        }
        if (propertyNames.contains("exceptiontype")) {
            this.exceptionType = dyn.getString("exceptiontype");
        }
        if (propertyNames.contains("requestparam")) {
            this.requestParam = dyn.getString("requestparam_tag");
        }
        if (propertyNames.contains("failurereason")) {
            this.failureMsg = dyn.getString("failurereason");
            this.failureReason = dyn.getString("failurereason_tag");
        }
        if (propertyNames.contains("failuretime")) {
            this.failureTime = dyn.getDate("failuretime");
        }
        if (propertyNames.contains("retrytime")) {
            this.retryTime = dyn.getDate("retrytime");
        }
        if (propertyNames.contains("retrycounts")) {
            this.retryCounts = dyn.getInt("retrycounts");
        }
        if (propertyNames.contains("isnotified")) {
            this.isNotified = dyn.getInt("isnotified");
        }
        if (propertyNames.contains("notifytype")) {
            this.notifyType = dyn.getString("notifytype");
        }
        if (propertyNames.contains("notifymember")) {
            this.notifyMember = dyn.getString("notifymember");
        }
        if (propertyNames.contains("compensatestatus")) {
            this.compensateStatus = dyn.getString("compensatestatus");
        }
        if (propertyNames.contains("dealtype")) {
            this.dealType = dyn.getString("dealtype");
        }
        if (propertyNames.contains("inftype")) {
            this.interfaceType = dyn.getString("inftype");
        }
        if (propertyNames.contains("sourcesys")) {
            this.sourceSystem = dyn.getString("sourcesys");
        }
        if (propertyNames.contains("applicant")) {
            this.applicant = dyn.getLong("applicant");
        }
        if (propertyNames.contains("applorg")) {
            this.applOrg = dyn.getLong("applorg");
        }
        if (propertyNames.contains("iscompensate")) {
            this.isCompensate = dyn.getString("iscompensate");
        }
    }

    public ExceptionDO(String billId, String billType, String exceptionType) {
        this.billId = billId;
        this.billType = billType;
        this.exceptionType = exceptionType;
    }

    public void saveAndUpdate() {
        DynamicObject saveData = this.getSaveObj();
        if (this.billId != null) {
            saveData.set("billid", (Object)this.billId);
        }
        if (this.billNo != null) {
            saveData.set("billno", (Object)this.billNo);
        }
        if (this.billType != null) {
            saveData.set("billtype", (Object)this.billType);
        }
        if (this.billTypeName != null) {
            saveData.set("billtypename", (Object)this.billTypeName);
        }
        if (this.exceptionType != null) {
            saveData.set("exceptiontype", (Object)this.exceptionType);
        }
        if (this.requestParam != null) {
            saveData.set("requestparam_tag", (Object)this.requestParam);
        }
        if (this.failureMsg != null) {
            if (this.failureMsg.length() > 200) {
                this.failureMsg = this.failureMsg.substring(0, 200);
            }
            saveData.set("failurereason", (Object)this.failureMsg);
        }
        if (this.failureReason != null) {
            saveData.set("failurereason_tag", (Object)this.failureReason);
        }
        if (this.failureTime != null) {
            saveData.set("failuretime", (Object)this.failureTime);
        }
        if (this.retryTime != null) {
            saveData.set("retrytime", (Object)this.retryTime);
        }
        if (this.retryCounts != null) {
            saveData.set("retrycounts", (Object)this.retryCounts);
        }
        if (this.isNotified != null) {
            saveData.set("isnotified", (Object)this.isNotified);
        }
        if (this.notifyType != null) {
            saveData.set("notifytype", (Object)this.notifyType);
        }
        if (this.notifyMember != null) {
            saveData.set("notifymember", (Object)this.notifyMember);
        }
        if (this.compensateStatus != null) {
            saveData.set("compensatestatus", (Object)this.compensateStatus);
        }
        if (this.dealType != null) {
            saveData.set("dealtype", (Object)this.dealType);
        }
        if (this.interfaceType != null) {
            saveData.set("inftype", (Object)this.interfaceType);
        }
        if (this.sourceSystem != null) {
            saveData.set("sourcesys", (Object)this.sourceSystem);
        }
        if (this.applicant != null) {
            saveData.set("applicant", (Object)this.applicant);
        }
        if (this.applOrg != null) {
            saveData.set("applorg", (Object)this.applOrg);
        }
        if (this.isCompensate != null) {
            saveData.set("iscompensate", (Object)this.isCompensate);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
    }

    public void saveHisTable() {
        DynamicObject saveData = BusinessDataServiceHelper.newDynamicObject((String)"task_exceptionhistory");
        if (this.billId != null) {
            saveData.set("billid", (Object)this.billId);
        }
        if (this.billNo != null) {
            saveData.set("billno", (Object)this.billNo);
        }
        if (this.exceptionType != null) {
            saveData.set("exceptiontype", (Object)this.exceptionType);
        }
        if (this.dealType != null) {
            saveData.set("dealtype", (Object)this.dealType);
        }
        if (this.retryTime != null) {
            saveData.set("retrytime", (Object)this.retryTime);
        }
        if (this.compensateStatus != null) {
            saveData.set("compensatestatus", (Object)this.compensateStatus);
        }
        if (this.failureMsg != null) {
            if (this.failureMsg.length() > 200) {
                this.failureMsg = this.failureMsg.substring(0, 200);
            }
            saveData.set("failurereason", (Object)this.failureMsg);
        }
        if (this.failureReason != null) {
            saveData.set("failurereason_tag", (Object)this.failureReason);
        }
        if (this.failureTime != null) {
            saveData.set("failuretime", (Object)this.failureTime);
        }
        if (this.requestParam != null) {
            saveData.set("requestparam_tag", (Object)this.requestParam);
            String reqParam = this.requestParam;
            if (reqParam.length() > 200) {
                reqParam = StringUtils.substring((String)reqParam, (int)0, (int)199);
            }
            saveData.set("requestparam", (Object)reqParam);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
    }

    private DynamicObject getSaveObj() {
        QFilter[] qFilters = this.getUniqueFilter();
        String selectFields = this.getSelectedField();
        if (QueryServiceHelper.exists((String)"task_exceptionrecord", (QFilter[])qFilters)) {
            return BusinessDataServiceHelper.loadSingle((String)"task_exceptionrecord", (String)selectFields, (QFilter[])qFilters);
        }
        DynamicObject saveData = BusinessDataServiceHelper.newDynamicObject((String)"task_exceptionrecord");
        saveData.set("compensatestatus", (Object)CompensateStatusEnum.FAILURE.getValue());
        return saveData;
    }

    private QFilter[] getUniqueFilter() {
        QFilter[] qFilters = new QFilter[]{new QFilter("billid", "=", (Object)this.billId), new QFilter("billtype", "=", (Object)this.billType), new QFilter("exceptiontype", "=", (Object)this.exceptionType)};
        return qFilters;
    }

    private String getSelectedField() {
        return EntityField.buildSelectField("billid", "billno", "billtype", "billtypename", "exceptiontype", "requestparam", "requestparam_tag", "failurereason", "failurereason_tag", "failuretime", "retrytime", "retrycounts", "isnotified", "notifytype", "notifymember", "compensatestatus", "dealtype", "inftype", "sourcesys", "applicant", "applorg", "iscompensate");
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public String getRequestParam() {
        return this.requestParam;
    }

    public void setRequestParam(String requestParam) {
        this.requestParam = requestParam;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Date getFailureTime() {
        return (Date)ObjectCloneUtil.cloneObject(this.failureTime);
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = (Date)ObjectCloneUtil.cloneObject(failureTime);
    }

    public Date getRetryTime() {
        return (Date)ObjectCloneUtil.cloneObject(this.retryTime);
    }

    public void setRetryTime(Date retryTime) {
        this.retryTime = (Date)ObjectCloneUtil.cloneObject(retryTime);
    }

    public Integer getRetryCounts() {
        return this.retryCounts;
    }

    public void setRetryCounts(Integer retryCounts) {
        this.retryCounts = retryCounts;
    }

    public Integer getIsNotified() {
        return this.isNotified;
    }

    public void setIsNotified(Integer isNotified) {
        this.isNotified = isNotified;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public String getNotifyMember() {
        return this.notifyMember;
    }

    public void setNotifyMember(String notifyMember) {
        this.notifyMember = notifyMember;
    }

    public String getCompensateStatus() {
        return this.compensateStatus;
    }

    public void setCompensateStatus(String compensateStatus) {
        this.compensateStatus = compensateStatus;
    }

    public String getBillTypeName() {
        return this.billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getDealType() {
        return this.dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    public String getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public Long getApplicant() {
        return this.applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }

    public Long getApplOrg() {
        return this.applOrg;
    }

    public void setApplOrg(Long applOrg) {
        this.applOrg = applOrg;
    }

    public String getFailureMsg() {
        return this.failureMsg;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }

    public String getIsCompensate() {
        return this.isCompensate;
    }

    public void setIsCompensate(String isCompensate) {
        this.isCompensate = isCompensate;
    }

    public String toString() {
        return "ExceptionDO{billId='" + this.billId + '\'' + ", billNo='" + this.billNo + '\'' + ", billType='" + this.billType + '\'' + ", billTypeName='" + this.billTypeName + '\'' + ", exceptionType='" + this.exceptionType + '\'' + ", requestParam='" + this.requestParam + '\'' + ", failureReason='" + this.failureReason + '\'' + ", failureTime=" + this.failureTime + ", retryTime=" + this.retryTime + ", retryCounts=" + this.retryCounts + ", isNotified=" + this.isNotified + ", notifyType='" + this.notifyType + '\'' + ", notifyMember='" + this.notifyMember + '\'' + ", compensateStatus='" + this.compensateStatus + '\'' + ", dealType='" + this.dealType + '\'' + ", interfaceType='" + this.interfaceType + '\'' + ", sourceSystem='" + this.sourceSystem + '\'' + ", applicant=" + this.applicant + ", applOrg=" + this.applOrg + ", isCompensate=" + this.isCompensate + '}';
    }
}

