/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.formula.FormulaEngineServiceHelper;
import kd.ssc.task.util.TaskOwningSysUtil;

public class TaskFormulaEngine {
    private static final Log log = LogFactory.getLog(TaskFormulaEngine.class);

    public static boolean fastMatchByEngine(String billId, String filterjson, String billEntity) {
        return TaskFormulaEngine.fastMatchByEngine(billId, filterjson, billEntity, null);
    }

    public static boolean fastMatchByEngine(String billId, String filterjson, String billEntity, String erpNumber) {
        FilterObject filterObject = FormulaEngineServiceHelper.getBillFilterObject(billEntity, filterjson);
        Map<String, FilterField> filterFieldMap = FormulaEngineServiceHelper.getAllFilterFields(filterObject);
        Map<String, Set<String>> filterFieldGroupMap = TaskFormulaEngine.groupFields(billEntity, filterFieldMap);
        boolean result = false;
        Set<String> heads = filterFieldGroupMap.get("head");
        boolean containsHead = heads != null && !heads.isEmpty();
        Set<String> bodys = filterFieldGroupMap.get("body");
        boolean containsBody = bodys != null && !bodys.isEmpty();
        boolean canFastMatch = TaskFormulaEngine.canFastMach(filterObject, heads, bodys);
        if (canFastMatch) {
            if (!containsBody && containsHead) {
                result = TaskFormulaEngine.fastMatchOnlyHead(billId, billEntity, filterObject, filterFieldGroupMap, erpNumber);
            }
            if (containsHead && containsBody && (result = TaskFormulaEngine.fastMatchWithBody(billId, billEntity, filterjson, erpNumber))) {
                QFilter filter = filterObject.getQFilter();
                result = TaskFormulaEngine.directQuery(billEntity, filter, billId, erpNumber);
            }
        } else {
            QFilter filter = filterObject.getQFilter();
            result = TaskFormulaEngine.directQuery(billEntity, filter, billId, erpNumber);
        }
        return result;
    }

    private static boolean canFastMach(FilterObject filterObject, Set<String> heads, Set<String> bodys) {
        boolean containsBody;
        boolean containsHead = heads != null && !heads.isEmpty();
        boolean bl = containsBody = bodys != null && !bodys.isEmpty();
        if (containsBody && !containsHead) {
            return false;
        }
        List filterRows = filterObject.getFilterRows();
        for (FilterRow row : filterRows) {
            String cmpId;
            int cmpGroupId = row.getCompareType().getGroupId();
            if (6 == cmpGroupId || 9 == cmpGroupId) {
                return false;
            }
            String fieldName = row.getFilterField().getFieldName();
            if (bodys == null || !bodys.contains(fieldName) || !"37".equals(cmpId = row.getCompareType().getId()) && !"9".equals(cmpId)) continue;
            return false;
        }
        return true;
    }

    private static boolean fastMatchWithBody(String billId, String billEntity, String filterjson, String erpNumber) {
        boolean result;
        try {
            FilterObject oldObj = FormulaEngineServiceHelper.getBillFilterObject(billEntity, filterjson);
            FilterObject newObj = TaskFormulaEngine.rebuildFilterObj(billEntity, oldObj, filterjson);
            Map<String, Object> value = TaskFormulaEngine.constructMapContainsBody(billId, billEntity, newObj, erpNumber);
            FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
            String[] filterScripts = scriptBuilder.buildFilterScript(newObj);
            String filterScript = filterScripts[0];
            log.info("\u5355\u636eid\uff1a" + billId + " \u8f6c\u6362\u540e\u89c4\u5219\uff1a" + filterScript);
            result = (Boolean)FormulaEngine.execExcelFormula((String)filterScript, value);
        }
        catch (Exception e) {
            log.error("\u5355\u636eid\uff1a" + billId + " \u8f6c\u6362\u524d\u89c4\u5219\uff1a" + filterjson + "\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            result = true;
        }
        return result;
    }

    private static FilterObject rebuildFilterObj(String billEntity, FilterObject oldObj, String filterJson) {
        String cp = "67";
        FilterCondition oldFc = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        List oldSimpRows = oldFc.getFilterRow();
        HashMap<String, List> oldFieldMap = new HashMap<String, List>();
        HashSet<String> bodyFields = new HashSet<String>();
        ArrayList<FilterRow> newSimpRows = new ArrayList<FilterRow>(16);
        List filterRows = oldObj.getFilterRows();
        for (FilterRow row : filterRows) {
            FilterField rowField = row.getFilterField();
            if (billEntity.equals(rowField.getEntityKey()) && rowField.getFieldName().equals(rowField.getFullFieldName())) continue;
            bodyFields.add(rowField.getFieldName());
        }
        for (FilterRow row : oldSimpRows) {
            String fieldName = row.getFieldName();
            if (bodyFields.contains(fieldName)) {
                List value = row.getValue();
                if (!oldFieldMap.containsKey(fieldName)) {
                    oldFieldMap.put(fieldName, value);
                } else {
                    value = (List)oldFieldMap.get(fieldName);
                }
                row.setCompareType(cp);
                row.setValue(value);
            }
            newSimpRows.add(row);
        }
        FilterCondition newFc = new FilterCondition();
        newFc.setFilterRow(newSimpRows);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, newFc);
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject();
    }

    private static Map<String, Object> constructMapContainsBody(String billId, String billEntity, FilterObject newObj, String erpNumber) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        Map fieldMap = newObj.getAllFilterFields();
        HashSet<String> headFiledSet = new HashSet<String>();
        for (Map.Entry fieldEntry : fieldMap.entrySet()) {
            FilterField field = (FilterField)fieldEntry.getValue();
            String fieldName = field.getFieldName();
            if (!field.getEntityKey().equals(billEntity) || !field.getFieldName().equals(field.getFullFieldName())) continue;
            headFiledSet.add(fieldName);
            if (!StringUtils.isNotEmpty((String)field.getRefEntityId())) continue;
            String fieldId = field.getSrcFieldKey() + ".id";
            headFiledSet.add(fieldId);
        }
        String selectField = TaskFormulaEngine.getSelectFields(billId, headFiledSet);
        QFilter qFilter = TaskOwningSysUtil.getBillIdQFilter(erpNumber, billId);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)billEntity, (String)selectField, (QFilter[])qFilter.toArray());
        for (String field : headFiledSet) {
            valueMap.put(field, dyo.get(field));
        }
        for (FilterRow row : newObj.getFilterRows()) {
            String fieldName = row.getFilterField().getFieldName();
            if (headFiledSet.contains(fieldName)) continue;
            String fieldValue = (String)row.getValue().get(0);
            valueMap.put(fieldName, fieldValue);
        }
        return valueMap;
    }

    private static boolean fastMatchOnlyHead(String billId, String billEntity, FilterObject filterObject, Map<String, Set<String>> filterFieldGroupMap, String erpNumber) {
        String selectFields = TaskFormulaEngine.getSelectFields(billId, filterFieldGroupMap.get("head"));
        QFilter qFilter = TaskOwningSysUtil.getBillIdQFilter(erpNumber, billId);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)billEntity, (String)selectFields, (QFilter[])qFilter.toArray());
        Map<String, Object> value = TaskFormulaEngine.constructMapOnlyHead(dyo, filterFieldGroupMap);
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        String[] filterScripts = scriptBuilder.buildFilterScript(filterObject);
        String filterScript = filterScripts[0];
        boolean result = (Boolean)FormulaEngine.execExcelFormula((String)filterScript, value);
        return result;
    }

    private static boolean directQuery(String billEntity, QFilter filter, String billId, String erpNumber) {
        log.info("\u76f4\u63a5\u67e5\u8868\uff0cbillid\uff1a" + billId);
        QFilter idFilters = TaskOwningSysUtil.getBillIdQFilter(erpNumber, billId);
        filter.and(idFilters);
        return QueryServiceHelper.exists((String)billEntity, (QFilter[])filter.toArray());
    }

    private static Map<String, Object> constructMapOnlyHead(DynamicObject dyo, Map<String, Set<String>> filterFieldGroupMap) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        Set<String> fields = filterFieldGroupMap.get("head");
        for (String s : fields) {
            valueMap.put(s, dyo.get(s));
        }
        return valueMap;
    }

    private static String getSelectFields(String billId, Set<String> filterHeadFieldSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("id,");
        for (String s : filterHeadFieldSet) {
            sb.append(s);
            sb.append(",");
        }
        String s = sb.toString();
        s = s.substring(0, s.length() - 1);
        log.info("\u5355\u636eid\uff1a" + billId + "\u67e5\u8be2\u5b57\u6bb5\uff1a" + s);
        return s;
    }

    private static Map<String, Set<String>> groupFields(String bill, Map<String, FilterField> filterFieldMap) {
        HashMap<String, Set<String>> groupMap = new HashMap<String, Set<String>>();
        if (filterFieldMap == null || filterFieldMap.isEmpty()) {
            return groupMap;
        }
        for (Map.Entry<String, FilterField> field : filterFieldMap.entrySet()) {
            Set set;
            FilterField value = field.getValue();
            if (value.getEntityKey().equals(bill) && value.getFieldName().equals(value.getFullFieldName())) {
                set = groupMap.computeIfAbsent("head", k -> new HashSet());
                set.add(value.getFieldName());
                if (value.getRefEntityId() == null) continue;
                set.add(value.getSrcFieldKey() + ".id");
                continue;
            }
            set = groupMap.computeIfAbsent("body", k -> new HashSet());
            set.add(value.getFullFieldName());
        }
        return groupMap;
    }
}

