/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.formula.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.formula.TaskFormulaHandler;
import kd.ssc.formula.context.TaskConditionContext;
import kd.ssc.formula.service.IDataSource;
import kd.ssc.formula.var.IVariableMode;
import kd.ssc.formula.var.SourceFieldVariable;

public class TaskBillDataSource
implements IDataSource {
    private static final Log logger = LogFactory.getLog(TaskBillDataSource.class);

    @Override
    public List<QFilter> buildFilter(String dataSource, TaskConditionContext context) {
        if (StringUtils.isBlank((CharSequence)dataSource) || null == context) {
            return new ArrayList<QFilter>();
        }
        ArrayList<QFilter> qFilterList = new ArrayList(8);
        if (CollectionUtils.isNotEmpty(context.getQfilters())) {
            qFilterList = context.getQfilters();
        }
        if (context.getCondition() == null || context.getCondition().getFilterCondition() == null) {
            return qFilterList;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, context.getCondition().getFilterCondition());
        filterBuilder.buildFilter();
        qFilterList.addAll(filterBuilder.getQFilters());
        return qFilterList;
    }

    @Override
    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, TaskConditionContext context) {
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)dataSource);
        if (StringUtils.isBlank((CharSequence)mainType.getAlias())) {
            throw new KDException(new ErrorCode("DataSource", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%1$s(%2$s)\u8868\u540d\u4e3a\u7a7a\u3002", (String)"TaskBillDataSource_0", (String)"ssc-task-common", (Object[])new Object[0]), mainType.getDisplayName() == null ? "" : mainType.getDisplayName().getLocaleValue(), mainType.getName())), new Object[0]);
        }
        TaskFormulaHandler formulaHandler = new TaskFormulaHandler(context.getCondition().getExpression(), (BillEntityType)mainType);
        QFilter[] filters = filterList == null || filterList.isEmpty() ? null : filterList.toArray(new QFilter[filterList.size()]);
        Set<String> selectProperties = this.getSearchFields(mainType, filters, false);
        Set<String> formulaFields = this.addFormulaSourceFields(formulaHandler.getVars(), selectProperties);
        String useToQuerySelectedProp = this.handleComplexProps(selectProperties);
        DynamicObjectCollection queryResults = new DynamicObjectCollection();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dataSource, (String)useToQuerySelectedProp, (QFilter[])filters);
        this.filterAndFillData(formulaFields, dynamicObjects, queryResults, formulaHandler);
        return queryResults;
    }

    private Set<String> addFormulaSourceFields(List<IVariableMode> vars, Set<String> selectFldStrings) {
        HashSet<String> formulaFields = new HashSet<String>();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldString = srcField.getFullPropName();
            selectFldStrings.add(fldString);
            formulaFields.add(fldString);
        }
        return formulaFields;
    }

    private void filterAndFillData(Set<String> formulaFields, DynamicObject[] dynamicObjects, DynamicObjectCollection queryResults, TaskFormulaHandler formulaHandler) {
        if (dynamicObjects.length == 0 || StringUtils.isBlank((CharSequence)formulaHandler.getFormula())) {
            queryResults.addAll(Arrays.asList(dynamicObjects));
            return;
        }
        HashMap<String, DynamicProperty> fieldProps = new HashMap<String, DynamicProperty>(formulaFields.size());
        IDataEntityType dataEntityType = dynamicObjects[0].getDataEntityType();
        for (String field : formulaFields) {
            DynamicProperty dynamicProperty = this.getFieldProp(field, dataEntityType);
            fieldProps.put(field, dynamicProperty);
        }
        try {
            for (DynamicObject row : dynamicObjects) {
                if (!((Boolean)formulaHandler.getValue(fieldProps, row)).booleanValue()) continue;
                queryResults.add((Object)row);
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"TaskBillDataSource_1", (String)"ssc-task-common", (Object[])new Object[0]));
        }
    }

    private DynamicProperty getFieldProp(String field, IDataEntityType dataEntityType) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        String[] keys = StringUtils.split((String)field, (String)".");
        if (keys.length == 1) {
            IDataEntityProperty prop = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            return prop == null ? null : (DynamicProperty)prop;
        }
        IDataEntityType propertyType = dataEntityType;
        IDataEntityProperty property = null;
        for (int i = 0; i < keys.length; ++i) {
            property = (IDataEntityProperty)propertyType.getProperties().get((Object)keys[i]);
            if (i == keys.length - 1) break;
            if (!(property instanceof BasedataProp)) {
                property = null;
                break;
            }
            propertyType = ((BasedataProp)property).getComplexType();
        }
        return property == null ? null : (DynamicProperty)property;
    }

    private Set<String> getSearchFields(MainEntityType mainEntityType, QFilter[] filters, boolean isOnlyEntry) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(mainEntityType.getPrimaryKey().getName());
        if (null != filters) {
            for (QFilter filter : filters) {
                if (!StringUtils.isNotBlank((CharSequence)filter.getProperty())) continue;
                this.fetchField(mainEntityType, filter.getProperty(), fields, isOnlyEntry);
            }
        }
        return fields;
    }

    private String handleComplexProps(Set<String> selectProperties) {
        Object[] querySelectProperties = selectProperties.toArray(new String[0]);
        for (int i = 0; i < querySelectProperties.length; ++i) {
            if (!querySelectProperties[i].contains(".")) continue;
            int index = ((String)querySelectProperties[i]).indexOf(".");
            if ((index = ((String)querySelectProperties[i]).indexOf(".", index + 1)) == -1) continue;
            querySelectProperties[i] = ((String)querySelectProperties[i]).substring(0, index);
        }
        return StringUtils.join((Object[])querySelectProperties, (String)",");
    }

    private void fetchField(MainEntityType mainEntityType, String macroName, Set<String> fields, boolean isOnlyEntry) {
        if (StringUtils.isBlank((CharSequence)macroName)) {
            return;
        }
        String[] arr = StringUtils.split((String)macroName, (String)".");
        if (null == arr || arr.length == 0) {
            return;
        }
        IDataEntityProperty property = mainEntityType.findProperty(arr[0]);
        if (null == property) {
            return;
        }
        if (!isOnlyEntry) {
            DynamicObjectType type;
            fields.add(macroName);
            if (property instanceof DynamicCollectionProperty && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                String id = type.getPrimaryKey().getName();
                fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
            }
        } else {
            DynamicObjectType type;
            if (property instanceof SubEntryProp) {
                return;
            }
            if (property instanceof EntryProp && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                String id = type.getPrimaryKey().getName();
                fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
            }
        }
    }
}

