/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.create.CreateParTaskByWorkFlow;
import kd.ssc.task.create.CreateTaskByWorkflow;

public class CreateTaskHelper {
    public static boolean isLegitimateInput(Long taskId, Long wfTaskId) {
        String msg = "";
        if (taskId == null || taskId == 0L) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5165\u53c2taskId\u503c\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("input_error", msg);
            throw new KDException(code, new Object[0]);
        }
        if (!QueryServiceHelper.exists((String)"task_taskhistory", (Object)taskId)) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5165\u53c2taskId\u503c\u6709\u8bef", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("input_error", msg);
            throw new KDException(code, new Object[0]);
        }
        if (wfTaskId == null || wfTaskId == 0L) {
            msg = ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u5165\u53c2wfTaskId\u503c\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("input_error", msg);
            throw new KDException(code, new Object[0]);
        }
        return true;
    }

    public static boolean createTaskByWithdraw(Long taskId, Long wfTaskId) throws Exception {
        Map<String, Long> bizConfig = CreateTaskHelper.getBillTypeAndTaskTypeByWithdraw(taskId);
        Long taskTypeId = bizConfig.get("taskTypeId");
        Long billTypeId = bizConfig.get("billTypeId");
        String billId = CreateTaskHelper.getBillIdByTask(taskId);
        return CreateTaskHelper.createTask(taskTypeId, billTypeId, billId, wfTaskId, false);
    }

    public static long createTaskByWithdrawZxjt(Long taskId, Long wfTaskId) throws Exception {
        Map<String, Long> bizConfig = CreateTaskHelper.getBillTypeAndTaskTypeByWithdraw(taskId);
        Long taskTypeId = bizConfig.get("taskTypeId");
        Long billTypeId = bizConfig.get("billTypeId");
        String billId = CreateTaskHelper.getBillIdByTask(taskId);
        if (CreateTaskHelper.isPartask(billTypeId)) {
            ErrorCode errorCode = new ErrorCode("createPartaskErr", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u521b\u5efa\u5171\u4eab\u591a\u7ea7\u4efb\u52a1\u521b\u8bf7\u68c0\u67e5\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eid\u4e3a\uff1a%1s\uff0c\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2s\u3002", (String)"", (String)"", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{billId, billTypeId});
        }
        CreateTaskByWorkflow task = new CreateTaskByWorkflow();
        long rtnId = task.createTask(taskTypeId, billTypeId, billId, 0L, "", "", 0L, String.valueOf(wfTaskId));
        if (rtnId <= 0L) {
            ErrorCode errorCode = new ErrorCode("createTaskErr", ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1s\uff0c\u4f7f\u7528\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2s\uff0c\u521b\u5efa\u5931\u8d25\u7684\u4efb\u52a1\u7c7b\u578bid\u4e3a\uff1a%3s\u3002", (String)"", (String)"", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{billId, billTypeId, taskTypeId});
        }
        return rtnId;
    }

    private static String getBillIdByTask(Long taskId) {
        String selectFields = "billid";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)taskId)};
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)selectFields, (QFilter[])qFilters);
        return dyo.getString("billid");
    }

    private static Map<String, Long> getBillTypeAndTaskTypeByWithdraw(Long taskId) {
        String selectFields = "billtype,tasktypeid";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)taskId)};
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)selectFields, (QFilter[])qFilters);
        long billType = dyo.getLong("billtype");
        long taskType = dyo.getLong("tasktypeid");
        HashMap<String, Long> rtnMap = new HashMap<String, Long>(2);
        rtnMap.put("billTypeId", billType);
        rtnMap.put("taskTypeId", taskType);
        return rtnMap;
    }

    private static boolean createTask(Long taskTypeId, Long billTypeId, String billId, Long wfTaskId, boolean custom) throws Exception {
        if (CreateTaskHelper.isPartask(billTypeId)) {
            CreateParTaskByWorkFlow partask = new CreateParTaskByWorkFlow();
            Long[] taskTypeIds = CreateTaskHelper.getAllTaskTypeByBillType(billTypeId);
            boolean success = partask.publishInialMessage(billId, billTypeId, taskTypeIds, wfTaskId);
            if (!success) {
                ErrorCode errorCode = new ErrorCode("createPartaskErr", ResManager.loadKDString((String)"\u5171\u4eab\u591a\u7ea7\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eid\u4e3a\uff1a%1s\uff0c\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2s\u3002", (String)"", (String)"", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[]{billId, billTypeId});
            }
        } else {
            CreateTaskByWorkflow task = new CreateTaskByWorkflow();
            long taskId = task.createTask(taskTypeId, billTypeId, billId, 0L, "", "", 0L, String.valueOf(wfTaskId));
            if (taskId <= 0L) {
                ErrorCode errorCode = new ErrorCode("createTaskErr", ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1s\uff0c\u4f7f\u7528\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2s\uff0c\u521b\u5efa\u5931\u8d25\u7684\u4efb\u52a1\u7c7b\u578bid\u4e3a\uff1a%3s\u3002", (String)"", (String)"", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[]{billId, billTypeId, taskTypeId});
            }
        }
        return true;
    }

    private static Long[] getAllTaskTypeByBillType(Long billTypeId) {
        HashSet<Long> taskTypeIds = new HashSet<Long>();
        String query_tasktype_sql = "select ftasktypeid,ftaskoriginal from t_tk_taskbillchild where fid in(select fchildpkid from t_tk_taskrulebill where fid = ?) and ftaskoriginal<'9'";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)billTypeId)};
        String algoKey = CreateTaskHelper.class + ".isPartaskByBillTypeId()";
        try (DataSet taskTypeDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)query_tasktype_sql, (Object[])params);){
            if (taskTypeDataSet.hasNext()) {
                for (Row row : taskTypeDataSet) {
                    Long taskTypeId = row.getLong("ftasktypeid");
                    if (taskTypeId.equals(0L)) continue;
                    taskTypeIds.add(taskTypeId);
                }
            }
        }
        return taskTypeIds.toArray(new Long[0]);
    }

    private static boolean isPartask(Long billTypeId) {
        boolean isParTask;
        block13: {
            String query_ispartask_sql = "select ftaskoriginal from t_tk_taskbillchild where fid in(select fchildpkid from t_tk_taskrulebill where fid = ?)";
            Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)billTypeId)};
            String algoKey = CreateTaskHelper.class + ".isPartaskByBillTypeId()";
            isParTask = false;
            try (DataSet taskTypeDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)query_ispartask_sql, (Object[])params);){
                if (!taskTypeDataSet.hasNext()) break block13;
                for (Row row : taskTypeDataSet) {
                    String taskOriginal = row.getString("ftaskoriginal");
                    if (!"2".equals(taskOriginal)) continue;
                    isParTask = true;
                    break;
                }
            }
        }
        return isParTask;
    }
}

