/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.ierp;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.constant.DecisionItemEnum;
import kd.ssc.enums.Source;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.dto.ApprovalRecordDTO;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;

public class TaskFacadeHelper {
    private static final Log log = LogFactory.getLog(TaskFacadeHelper.class);

    public static Map<String, Object> getApprovalRecord(String billId) {
        log.info("TaskFacadeHelper.billId=" + billId);
        DynamicObject newestHistoryTask = TaskFacadeHelper.getNewestHistoryTaskByBillId(billId);
        if (newestHistoryTask == null) {
            log.error("TaskFacadeHelper.newestHistoryTask is null");
            return new HashMap<String, Object>();
        }
        DynamicObject[] allHistoryParTask = TaskFacadeHelper.queryAllHistoryTask(newestHistoryTask);
        String jsonString = TaskFacadeHelper.buildApprovalJsonStr(allHistoryParTask);
        if (StringUtils.isEmpty((String)jsonString)) {
            log.error("TaskFacadeHelper.jsonString is empty");
            return new HashMap<String, Object>();
        }
        return TaskFacadeHelper.buildApprovalMap(jsonString, newestHistoryTask, billId);
    }

    private static Map<String, Object> buildApprovalMap(String jsonString, DynamicObject newestHistoryTask, String billId) {
        HashMap<String, Object> approvalRecordMap = new HashMap<String, Object>();
        String sourceTaskId = newestHistoryTask.getString("sourceTaskId");
        DynamicObject billTypeDyn = newestHistoryTask.getDynamicObject("billtype");
        String billType = billTypeDyn.getString("bindbill.number");
        String assignId = newestHistoryTask.getString("assignid");
        approvalRecordMap.put("isCompleted", TaskFacadeHelper.isCompletedTask(billId, assignId, sourceTaskId));
        approvalRecordMap.put("billId", billId);
        approvalRecordMap.put("billType", billType);
        approvalRecordMap.put("jsonString", jsonString);
        Map<String, Object> sourceBillParam = TaskFacadeHelper.querySourceBillParam(billId, billType);
        approvalRecordMap.putAll(sourceBillParam);
        log.info("TaskFacadeHelper.approvalRecordMap=" + approvalRecordMap);
        return approvalRecordMap;
    }

    private static Map<String, Object> querySourceBillParam(String billId, String billType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        try {
            String selectProperties = "sourcebilltype,sourcebillid";
            DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)billType, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billId))});
            if (dynObj == null) {
                return paramMap;
            }
            paramMap.put("sourcebilltype", dynObj.getString("sourcebilltype"));
            paramMap.put("sourcebillid", dynObj.getString("sourcebillid"));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6e90\u5355\u6570\u636e\u5931\u8d25,billId:" + billId + ",billType:" + billType, (Object)e.getMessage(), (Object)e);
        }
        return paramMap;
    }

    private static boolean isCompletedTask(String billId, String assignId, String sourceTaskId) {
        boolean isParTask = ParTaskAuditMsgUpdateUtil.isParTask(Long.parseLong(billId), Long.parseLong(assignId));
        if (isParTask) {
            return TaskFacadeHelper.isLastTaskFromParTask(Long.parseLong(sourceTaskId));
        }
        return TaskFacadeHelper.isLastTaskFromMultiWf(Long.parseLong(sourceTaskId), billId);
    }

    private static String buildApprovalJsonStr(DynamicObject[] allHistoryTask) {
        if (allHistoryTask == null || allHistoryTask.length == 0) {
            return "";
        }
        ArrayList<ApprovalRecordDTO> approvalRecordDTOList = new ArrayList<ApprovalRecordDTO>(8);
        for (DynamicObject historyTask : allHistoryTask) {
            ApprovalRecordDTO dto = new ApprovalRecordDTO();
            String personId = historyTask.getString("personid.id");
            dto.setPersonId(personId);
            String personName = historyTask.getString("personid.name");
            dto.setPersonName(personName);
            String personNumber = historyTask.getString("personid.number");
            dto.setPersonNumber(personNumber);
            String userName = historyTask.getString("personid.username");
            dto.setUserName(userName);
            String state = historyTask.getString("state");
            TaskStateEnum taskStateEnum = TaskStateEnum.getTaskState(state);
            Optional.ofNullable(taskStateEnum).ifPresent(taskState -> dto.setApprovalResult(taskState.getName()));
            String taskType = historyTask.getString("tasktypeid.name");
            dto.setTaskType(taskType);
            Date approvalDate = historyTask.getDate("completetime");
            dto.setApprovalDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(approvalDate));
            String approvalMessage = historyTask.getString("apprevalmessage");
            dto.setApprovalMessage(approvalMessage);
            String decisionValue = historyTask.getString("decisionvalue");
            dto.setDecisionValue(decisionValue);
            String unpassreasondesc = historyTask.getString("unpassreasondesc");
            dto.setFailedReason(unpassreasondesc);
            String decisionitem = historyTask.getString("decisionitem");
            DecisionItemEnum decisionItemEnum = DecisionItemEnum.getDecisionItem(decisionitem);
            Optional.ofNullable(decisionItemEnum).ifPresent(itemEnum -> dto.setOperationType(itemEnum.getName()));
            String historyTaskId = historyTask.getString("id");
            dto.setHistoryTaskId(historyTaskId);
            approvalRecordDTOList.add(dto);
        }
        return JSON.toJSONString(approvalRecordDTOList);
    }

    private static DynamicObject[] queryAllHistoryTask(DynamicObject newestHistoryTask) {
        String assignId = newestHistoryTask.getString("assignid");
        if (StringUtils.isEmpty((String)assignId)) {
            log.error("TaskFacadeHelper.assignId is empty");
            return null;
        }
        String billId = newestHistoryTask.getString("billid");
        return TaskFacadeHelper.getHistoryTasks(assignId, billId);
    }

    private static DynamicObject[] getHistoryTasks(String assignId, String billId) {
        QFilter filterQualityCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)0);
        QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
        QFilter assignIdFilter = new QFilter("assignId", "=", (Object)assignId);
        String selectFields = "id,personid.id,personid.name,personid.number,personid.username,state,tasktypeid.name,completetime,apprevalmessage,decisionvalue,unpassreasondesc,decisionitem";
        String orderBy = "completetime desc";
        return BusinessDataServiceHelper.load((String)"task_taskhistory", (String)selectFields, (QFilter[])new QFilter[]{billIdFilter, assignIdFilter, filterQualityCheckTask}, (String)orderBy);
    }

    public static DynamicObject getNewestHistoryTaskByBillId(String billId) {
        String orderBy;
        QFilter filterQualityCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)0);
        String selectProps = "id,sourcetaskid,assignid,billtype,billid";
        QFilter qFilter = new QFilter("billid", "=", (Object)(billId + ""));
        DynamicObject[] historyTasks = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)selectProps, (QFilter[])new QFilter[]{qFilter, filterQualityCheckTask}, (String)(orderBy = "completetime desc"), (int)1);
        if (historyTasks == null || historyTasks.length == 0) {
            return null;
        }
        return historyTasks[0];
    }

    public static boolean isLastTaskFromMultiWf(long taskId, String billId) {
        String selecField = "id,source";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "!=", (Object)taskId), new QFilter("billid", "=", (Object)billId)};
        DynamicObjectCollection qryResults = QueryServiceHelper.query((String)"task_task", (String)selecField, (QFilter[])qFilters);
        if (qryResults == null || qryResults.isEmpty()) {
            return true;
        }
        for (DynamicObject dyo : qryResults) {
            String source = dyo.getString("source");
            if (!String.valueOf(Source.WorkFlow.getValue()).equals(source)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLastTaskFromParTask(long taskId) {
        ParTaskNodeServiceImpl parTaskNodeService = new ParTaskNodeServiceImpl();
        ParTaskFlowInstServiceImpl parTaskFlowInstService = new ParTaskFlowInstServiceImpl();
        try {
            long instId = parTaskNodeService.getInstIdByTaskId(taskId);
            long flowDefId = parTaskFlowInstService.getFlowIdWithInsId(instId);
            DynamicObject taskInstDo = BusinessDataServiceHelper.loadSingle((Object)instId, (String)"task_partaskinst", (String)"id,ptstatus");
            int status = taskInstDo.getInt("ptstatus");
            if (FlowInstEnum.FAILED.getValue() == status) {
                return true;
            }
            if (FlowInstEnum.REPULSE.getValue() == status) {
                return false;
            }
            return parTaskNodeService.isAllNodeComplete(flowDefId, instId);
        }
        catch (Exception e) {
            log.error("TaskFacadeHelper.isLastTaskFromParTask error: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

