/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.ierp;

import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.enums.Source;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.bill.TaskBillHandler;
import kd.ssc.task.bill.TaskBillHandlerFactory;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class TaskFacadeImpl
implements TaskFacade {
    private static final Log log = LogFactory.getLog(TaskFacadeImpl.class);

    @Override
    public String getEmbedViewUrl(String billID, String taskID, boolean isHis) {
        return null;
    }

    protected String getErpNumber() {
        return null;
    }

    protected String getBillReturnJson(DynamicObject billData, String extID, boolean isPass) {
        String erpNumber = this.getErpNumber();
        TaskBillHandler pack = TaskBillHandlerFactory.getBillHandlerFactory(erpNumber, billData.getDynamicObjectType().getName());
        Map<String, Object> bizData = null;
        if (pack == null) {
            bizData = new HashMap<String, String>();
        } else {
            pack.validate(billData, isPass);
            bizData = pack.pack(billData, isPass);
            if (bizData == null) {
                bizData = new HashMap();
            }
        }
        bizData.put("id", extID);
        return SerializationUtils.toJsonString(bizData);
    }

    @Override
    public boolean approve(long jobID, String handlerID, boolean isPass, String messages, DynamicObject bizData, int decision, String decisionValue, boolean isTaskAdministor, IFormView subView) throws Exception {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)jobID, (String)"task_task", (String)"id,billtype.id,billtype.externalerp.number,billtype.entryentity.tasktype,billtype.entryentity.childpkid,tasktypeid.id,tasktypeid.name,source,assignid,personid,billid,billnumber,sscid");
        log.info(this.getClass().getName() + ".approve() billnumber: " + task.getString("billnumber"));
        DynamicObject billType = task.getDynamicObject("billtype");
        long taskTypeId = task.getLong("tasktypeid.id");
        String extendNum = task.getString("billtype.externalerp.number");
        String source = task.getString("source");
        String workflowIdStr = task.getString("assignid");
        Long workFlowId = StringUtils.isEmpty((String)workflowIdStr) ? 0L : Long.parseLong(workflowIdStr);
        String billId = task.getString("billid");
        String decOptionNumber = isPass ? "Consent" : (StringUtils.isNotEmpty((String)decisionValue) ? decisionValue : "Reject");
        Map<String, Object> wfParams = this.buildWfTaskParamMap(task, isPass, workFlowId, decOptionNumber, messages, null, false, null);
        if (source.equals(Integer.toString(Source.BillOperation.getValue())) || !"KDCC".equalsIgnoreCase(extendNum)) {
            if (isPass) {
                String executeOprtNumber = this.getBillTypeOpeNum(billType, taskTypeId);
                return this.excuteBillTypeOper(bizData, subView, billType, executeOprtNumber);
            }
        } else if (source.equals(Integer.toString(Source.WorkFlow.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            if (isPass) {
                boolean isLastWork = this.lastWork(jobID, billId, workflowIdStr);
                if (isLastWork) {
                    this.processWorkflow(wfParams);
                } else {
                    wfParams.put("isPushWf", Boolean.FALSE);
                    this.processWorkflow(wfParams);
                }
            } else {
                this.processWorkflow(wfParams);
                this.deleteOtherTaskAndNoticeWF(jobID, billId, (String)wfParams.get("subactivityName"));
            }
        } else if (source.equals(Integer.toString(Source.ParTask.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            this.handleParTask(jobID, workFlowId, decision, wfParams);
            this.handleParTaskNodeInfo(jobID, decision, messages);
        } else {
            this.processWorkflow(wfParams);
        }
        return true;
    }

    @Override
    public boolean approve(long jobID, String handlerID, boolean isPass, String messages, DynamicObject bizData, int decision, String decisionValue, boolean isTaskAdministor, IFormView subView, Map<String, Object> paramMap) throws Exception {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)jobID, (String)"task_task", (String)"id,billtype.id,billtype.externalerp.number,billtype.entryentity.tasktype,billtype.entryentity.childpkid,tasktypeid.id,tasktypeid.name,source,assignid,personid,billid,billnumber,sscid");
        log.info(this.getClass().getName() + ".approve() billnumber: " + task.getString("billnumber"));
        DynamicObject billType = task.getDynamicObject("billtype");
        long taskTypeId = task.getLong("tasktypeid.id");
        String extendNum = task.getString("billtype.externalerp.number");
        String source = task.getString("source");
        String workflowIdStr = task.getString("assignid");
        Long workFlowId = StringUtils.isEmpty((String)workflowIdStr) ? 0L : Long.parseLong(workflowIdStr);
        String billId = task.getString("billid");
        String itemId = (String)paramMap.get("itemId");
        Map<String, Object> wfParams = this.buildWfTaskParamMap(task, isPass, workFlowId, decisionValue, messages, itemId, false, null);
        if (source.equals(Integer.toString(Source.BillOperation.getValue())) || !"KDCC".equalsIgnoreCase(extendNum)) {
            if (isPass) {
                String executeOprtNumber = this.getBillTypeOpeNum(billType, taskTypeId);
                return this.excuteBillTypeOper(bizData, subView, billType, executeOprtNumber);
            }
        } else if (source.equals(Integer.toString(Source.WorkFlow.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            if (isPass) {
                boolean isLastWork = this.lastWork(jobID, billId, workflowIdStr);
                if (isLastWork) {
                    this.processWorkflow(wfParams);
                } else {
                    wfParams.put("isPushWf", Boolean.FALSE);
                    this.processWorkflow(wfParams);
                }
            } else {
                this.processWorkflow(wfParams);
                this.deleteOtherTaskAndNoticeWF(jobID, billId, (String)wfParams.get("subactivityName"));
            }
        } else if (source.equals(Integer.toString(Source.ParTask.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            boolean res = this.handleParTask(jobID, workFlowId, decision, wfParams);
            if (res && decision != 1) {
                TaskFacadeImpl.handleTerminationTask(jobID);
            }
            this.handleParTaskNodeInfo(jobID, decision, messages);
        } else {
            this.processWorkflow(wfParams);
        }
        return true;
    }

    @Override
    public boolean approve(long jobID, boolean isPass, String messages, int decision, String decisionValue, Map<String, Object> paramMap) throws Exception {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)jobID, (String)"task_task", (String)"id,billtype.id,billtype.externalerp.number,billtype.entryentity.tasktype,billtype.entryentity.childpkid,tasktypeid.id,tasktypeid.name,source,assignid,personid,billid,billnumber,sscid");
        log.info(this.getClass().getName() + ".approve() billnumber: " + task.getString("billnumber"));
        DynamicObject billType = task.getDynamicObject("billtype");
        long taskTypeId = task.getLong("tasktypeid.id");
        String extendNum = task.getString("billtype.externalerp.number");
        String source = task.getString("source");
        String workflowIdStr = task.getString("assignid");
        Long workFlowId = StringUtils.isEmpty((String)workflowIdStr) ? 0L : Long.parseLong(workflowIdStr);
        String billId = task.getString("billid");
        String itemId = (String)paramMap.get("itemId");
        boolean rejectBackToNode = false;
        Boolean rejectParamValue = (Boolean)paramMap.get("rejectBackToNode");
        if (rejectParamValue != null) {
            rejectBackToNode = rejectParamValue;
        }
        Map<String, Object> wfParams = this.buildWfTaskParamMap(task, isPass, workFlowId, decisionValue, messages, itemId, rejectBackToNode, paramMap);
        if (source.equals(Integer.toString(Source.WorkFlow.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            if (isPass) {
                boolean isLastWork = this.lastWork(jobID, billId, workflowIdStr);
                if (isLastWork) {
                    this.processWorkflow(wfParams);
                } else {
                    wfParams.put("isPushWf", Boolean.FALSE);
                    this.processWorkflow(wfParams);
                }
            } else {
                this.processWorkflow(wfParams);
                this.deleteOtherTaskAndNoticeWF(jobID, billId, (String)wfParams.get("subactivityName"));
            }
        } else if (source.equals(Integer.toString(Source.ParTask.getValue())) && "KDCC".equalsIgnoreCase(extendNum)) {
            boolean res = this.handleParTask(jobID, workFlowId, decision, wfParams);
            if (res && decision != 1) {
                TaskFacadeImpl.handleTerminationTask(jobID);
            }
            this.handleParTaskNodeInfo(jobID, decision, messages);
        } else {
            this.processWorkflow(wfParams);
        }
        return true;
    }

    private void deleteOtherTaskAndNoticeWF(long taskId, String billId, String thisTaskTypeName) {
        String selectFields = "id,assignid,tasktypeid.name taskTypeName";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "!=", (Object)taskId), new QFilter("billid", "=", (Object)billId), new QFilter("source", "=", (Object)String.valueOf(Source.WorkFlow.getValue()))};
        DynamicObjectCollection otherTasks = QueryServiceHelper.query((String)"task_task", (String)selectFields, (QFilter[])qFilters);
        if (otherTasks == null || otherTasks.size() < 1) {
            return;
        }
        HashSet<Long> oTaskIds = new HashSet<Long>(4);
        String auditMsg = String.format(ResManager.loadKDString((String)"\u5e76\u884c\u4efb\u52a1\uff08%s\uff09\u9a73\u56de", (String)"", (String)"", (Object[])new Object[0]), thisTaskTypeName);
        String resultName = AuditStateEnum.SYSTEM_REJECT.getValue();
        for (DynamicObject oTask : otherTasks) {
            long oTaskId = oTask.getLong("id");
            long workflowId = oTask.getLong("assignid");
            String subActivityName = oTask.getString("taskTypeName");
            oTaskIds.add(oTaskId);
            try {
                TaskWorkFlowUtil.completeWfMsg(oTaskId, workflowId, 0L, resultName, auditMsg, subActivityName);
            }
            catch (Exception ex) {
                log.error(String.format("%s\u56de\u5199\u5de5\u4f5c\u6d41\u7b2c\u4e09\u65b9\u5ba1\u6279\u8bb0\u5f55\u5931\u8d25", auditMsg), (Throwable)ex);
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"task_task"), (Object[])oTaskIds.toArray());
    }

    private boolean lastWork(long jobID, String billId, String workFlowTaskId) {
        String selecField = "id,source";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "!=", (Object)jobID), new QFilter("billid", "=", (Object)billId), new QFilter("assignid", "=", (Object)workFlowTaskId)};
        DynamicObjectCollection qryResults = QueryServiceHelper.query((String)"task_task", (String)selecField, (QFilter[])qFilters);
        if (qryResults == null || qryResults.isEmpty()) {
            return true;
        }
        for (DynamicObject dyo : qryResults) {
            String source = dyo.getString("source");
            if (!String.valueOf(Source.WorkFlow.getValue()).equals(source)) continue;
            return false;
        }
        return true;
    }

    private boolean excuteBillTypeOper(DynamicObject bizData, IFormView subView, DynamicObject billtype, String executeoprtnumber) {
        OperationResult result = subView != null ? subView.invokeOperation(executeoprtnumber) : OperationServiceHelper.executeOperate((String)executeoprtnumber, (String)billtype.getString("bindbill.number"), (DynamicObject[])new DynamicObject[]{bizData});
        if (!result.isSuccess()) {
            List list = result.getAllErrorOrValidateInfo();
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo iOperateInfo : list) {
                sb.append(iOperateInfo.getMessage());
                sb.append(' ');
            }
            KDException exception = TaskKDExcetptionUtil.createKDException("fi.ssc.OperEecuteError", sb.toString(), new Object());
            throw exception;
        }
        return result.isSuccess();
    }

    private String getBillTypeOpeNum(DynamicObject billtype, long tasktypeid) {
        DynamicObjectCollection billtypeEntry = billtype.getDynamicObjectCollection("entryentity");
        String executeoprtnumber = null;
        for (DynamicObject entry : billtypeEntry) {
            long entryTaskTypeID = entry.getLong("tasktype.id");
            if (tasktypeid != entryTaskTypeID) continue;
            long childpkid = entry.getLong("childpkid");
            DynamicObject task_taskbill_child = BusinessDataServiceHelper.loadSingle((Object)childpkid, (String)"task_taskbill_child");
            executeoprtnumber = task_taskbill_child.getString("executeoprtnumber");
            break;
        }
        if (StringUtils.isEmpty(executeoprtnumber)) {
            KDException exception = TaskKDExcetptionUtil.createKDException("fi.ssc.billTypeOperNumNotConfig", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u672a\u914d\u7f6e\u6267\u884c\u64cd\u4f5c\u3002", (String)"TaskFacadeImpl_0", (String)"ssc-task-common", (Object[])new Object[0]), new Object());
            throw exception;
        }
        return executeoprtnumber;
    }

    private Map<String, Object> buildWfTaskParamMap(DynamicObject task, boolean isPass, Long workflowId, String decOptionNumber, String auditMesssage, String itemId, boolean rejectBackToNode, Map<String, Object> paramMap) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("taskId", task.getLong("id"));
        params.put("workflowId", workflowId);
        if (!isPass) {
            params.put("itemId", itemId);
            params.put("rejectBackToNode", rejectBackToNode);
        }
        params.put("isPushWf", Boolean.TRUE);
        boolean hideUser = ParTaskAuditMsgUpdateUtil.isHideUser(task.getLong("sscid.id"));
        long personId = task.getLong("personid.id");
        if (personId == 0L) {
            personId = RequestContext.get().getCurrUserId();
        }
        params.put("userId", hideUser ? -2L : personId);
        params.put("decOptionNumber", decOptionNumber);
        params.put("auditOpName", isPass ? AuditStateEnum.PASS.getValue() : AuditStateEnum.NOPASS.getValue());
        params.put("auditMesssage", auditMesssage);
        String subactivityName = task.getString("tasktypeid.name");
        if (StringUtils.isEmpty((String)subactivityName)) {
            subactivityName = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        params.put("subactivityName", subactivityName);
        if (paramMap != null && paramMap.containsKey("attachment")) {
            params.put("attachment", paramMap.get("attachment"));
        }
        return params;
    }

    private void processWorkflow(Map<String, Object> wfParams) {
        log.info("kd.ssc.task.ierp.TaskFacadeImpl.pushWorkflow(Map<String, Object>) params: " + wfParams);
        Long workflowId = (Long)wfParams.get("workflowId");
        if (workflowId == 0L) {
            log.info("workflowId is 0, processWorkflow() end! ");
            return;
        }
        Long taskId = (Long)wfParams.get("taskId");
        Long userId = (Long)wfParams.get("userId");
        String itemId = (String)wfParams.get("itemId");
        String decOptionNumber = (String)wfParams.get("decOptionNumber");
        String auditOpName = (String)wfParams.get("auditOpName");
        String auditMesssage = (String)wfParams.get("auditMesssage");
        String subactivityName = (String)wfParams.get("subactivityName");
        Boolean rejectBackToNode = (Boolean)wfParams.get("rejectBackToNode");
        Map attMap = (Map)wfParams.get("attachment");
        try {
            if (((Boolean)wfParams.get("isPushWf")).booleanValue()) {
                TaskWorkFlowUtil.pushWfTask(workflowId, userId, decOptionNumber, auditMesssage, itemId, rejectBackToNode);
            }
        }
        catch (KDException e) {
            ErrorCode errCode = e.getErrorCode();
            if (errCode != null && "bos.wf.task.taskCompleted".equalsIgnoreCase(errCode.getCode())) {
                log.info(String.format("\u5de5\u4f5c\u6d41\u63a5\u53e3\u5df2\u8c03\u7528\u6210\u529f\u3002 taskId = %s, workflowId = %s ", taskId, workflowId));
            }
            log.info(String.format("errCode is null or not equal to 'bos.wf.task.taskCompleted'. taskId = %s, workflowId = %s ", taskId, workflowId));
            throw e;
        }
        TaskWorkFlowUtil.completeWfMsg(taskId, workflowId, userId, auditOpName, auditMesssage, subactivityName, attMap);
    }

    private boolean handleParTask(Long taskId, Long workFlowId, int decision, Map<String, Object> wfParams) throws Exception {
        ParTaskNodeServiceImpl parTaskNodeService = new ParTaskNodeServiceImpl();
        ParTaskFlowInstServiceImpl parTaskFlowInstService = new ParTaskFlowInstServiceImpl();
        long instId = 0L;
        long flowDefId = 0L;
        boolean isInstField = false;
        try {
            instId = parTaskNodeService.getInstIdByTaskId(taskId);
            flowDefId = parTaskFlowInstService.getFlowIdWithInsId(instId);
            isInstField = parTaskFlowInstService.isParTaskInsFiled(instId);
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5b58\u5728\u6570\u636e\u95ee\u9898\uff0c\u8bf7\u901a\u8fc7\u5de5\u4f5c\u6d41\u91cd\u65b0\u8df3\u8f6c\u8fdb\u5165\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"TaskFacadeImpl_1", (String)"ssc-task-common", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("approve_partask_inst_lost", errorMsg);
            throw new KDException((Throwable)e, code, new Object[0]);
        }
        if (isInstField) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5b58\u5728\u5e76\u884c\u4efb\u52a1\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u5ba1\u6838\uff0c\u9700\u5728\u201c\u4efb\u52a1\u7ba1\u7406\u201d\u4e2d\u5bf9\u5f53\u524d\u4efb\u52a1\u6267\u884c\u5220\u9664\u3002", (String)"TaskFacadeImpl_2", (String)"ssc-task-common", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("approve_partask_inst_failed", errorMsg);
            throw new KDException(code, new Object[0]);
        }
        if (decision == 1) {
            boolean isLastNode;
            try {
                isLastNode = parTaskNodeService.isLastNode(flowDefId, instId);
            }
            catch (Exception e) {
                log.error("TaskFacadeImpl.handleParTask error: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            if (workFlowId != 0L) {
                wfParams.put("isPushWf", isLastNode);
                this.processWorkflow(wfParams);
            }
            if (isLastNode) {
                parTaskFlowInstService.updateInstStatus(instId, FlowInstEnum.SUCCESS);
            }
            parTaskNodeService.updateTableAfterNodeTaskComplete(taskId);
        } else if (decision == 2 || decision == 3 || decision == 4) {
            if (workFlowId != 0L) {
                this.processWorkflow(wfParams);
            }
            parTaskNodeService.flowInstFinish(taskId, FlowInstEnum.SUCCESS);
        }
        return true;
    }

    private static void handleTerminationTask(long taskid) {
        ParTaskNodeServiceImpl parTaskNodeService = new ParTaskNodeServiceImpl();
        long instId = parTaskNodeService.getInstIdByTaskId(taskid);
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
        QFilter nodeStateFilter = new QFilter("state", "=", (Object)InstNodeEnum.TERMINATION.getValue());
        DynamicObjectCollection taskList = QueryServiceHelper.query((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{instIdFilter, nodeStateFilter});
        if (!taskList.isEmpty()) {
            ArrayList<Long> taskIds = new ArrayList<Long>(taskList.size());
            for (DynamicObject task : taskList) {
                Object taskIdTmp = task.get("taskid");
                if (!(taskIdTmp instanceof Long)) continue;
                taskIds.add((Long)taskIdTmp);
            }
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
        }
    }

    private void handleParTaskNodeInfo(Long taskId, int decision, String auditMessages) {
        try {
            AuditStateEnum state = AuditStateEnum.NOPASS;
            if (decision == 1) {
                state = AuditStateEnum.PASS;
            }
            ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterApproval(taskId, 0L, auditMessages, state);
        }
        catch (Exception e) {
            log.error(this.getClass().getSimpleName() + ".handleParTaskNodeInfo(): \u5ba1\u6279 -> \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean workDone(String action, BigInteger jobID, String handlerID) {
        return false;
    }

    @Override
    public boolean flowBack(BigInteger jobID, String handlerID, String messages, int jobPriorityID, int flowBackStgID) {
        return false;
    }

    @Override
    public boolean discard(BigInteger jobID, String handlerID, String messages) {
        return false;
    }

    @Override
    public boolean pause(BigInteger jobID, String handlerID, String msgTitle, String messages) {
        return false;
    }

    @Override
    public String getApprovalOpinion(String billid, String procinstId, long taskid) throws Exception {
        return null;
    }

    @Override
    public Map getAttachment(Map<String, Object> paramMap) {
        return null;
    }

    @Override
    public void synAttachmentToExternal(String action, long attachmentID, String externalBillID, Map<String, Object> syscParam) {
    }

    @Override
    public void updateAssignmentPerformer(Long jobid, String assignId, long userID) throws Exception {
    }

    @Override
    public boolean embedApprove(long jobID, String handlerID, boolean isPass, String messages, DynamicObject bizData, int decision, String decisionValue, boolean isTaskAdministor, IFormView subView) throws RemoteException {
        return true;
    }

    @Override
    public String getEmbedWFUrl(Long taskID, boolean isHis) {
        return null;
    }
}

