/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.ierp;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.enums.RespCodeEnum;
import kd.ssc.task.domain.RecordExceptionDO;
import kd.ssc.task.dto.TaskLogRecordDTO;
import kd.ssc.task.face.TaskLogFacade;
import kd.ssc.task.util.RecordExceptionUtil;
import kd.ssc.task.util.TaskParamControlUtil;

public class TaskLogFacadeImpl
implements TaskLogFacade {
    private static final Log log = LogFactory.getLog((String)TaskLogFacade.class.getName());
    private static final String PARAM_SAVE_DB_APP_LIST = "saveDBAppList";
    private static final String PARAM_SAVE_DB_ALL_LOG_APP_LIST = "saveDBAllLogAppList";
    private static final char DELIMITER = '|';
    private static final String SEMICOLON = ";";

    @Override
    public boolean saveTaskLogRecord(TaskLogRecordDTO taskLogRecordDTO) {
        if (taskLogRecordDTO == null) {
            return true;
        }
        String saveAppList = TaskParamControlUtil.getParamControl(PARAM_SAVE_DB_APP_LIST);
        try {
            String[] appListArray = Optional.of(saveAppList).orElse("").split(SEMICOLON);
            List<String> appList = Arrays.asList(appListArray);
            if (!appList.contains(taskLogRecordDTO.getType())) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("saveTaskLogRecord#Parse param config error, name=saveDBAppList, value=" + saveAppList);
            return false;
        }
        String saveAllLogAppList = TaskParamControlUtil.getParamControl(PARAM_SAVE_DB_ALL_LOG_APP_LIST);
        try {
            String[] array = Optional.of(saveAllLogAppList).orElse("").split(SEMICOLON);
            List<String> appList = Arrays.asList(array);
            if (!appList.contains(taskLogRecordDTO.getType()) && RespCodeEnum.ok.getValue() == taskLogRecordDTO.getRespCode().intValue()) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("Parse Param Config error, name=saveDBAllLogAppList, value=" + saveAllLogAppList);
            return false;
        }
        RecordExceptionDO recordExceptionDO = this.convertRecordExceptionDO(taskLogRecordDTO);
        return RecordExceptionUtil.saveRecordExcept(recordExceptionDO);
    }

    private RecordExceptionDO convertRecordExceptionDO(TaskLogRecordDTO taskLogRecordDTO) {
        return RecordExceptionDO.builder().appId(taskLogRecordDTO.getAppId()).duration(taskLogRecordDTO.getDuration()).errorMsg(taskLogRecordDTO.getErrorMsg()).ip(taskLogRecordDTO.getIp()).errorStack(taskLogRecordDTO.getErrorStack()).method(taskLogRecordDTO.getMethod()).param(taskLogRecordDTO.getParam()).respCode(taskLogRecordDTO.getRespCode()).retry(taskLogRecordDTO.getRetry()).retryTime(taskLogRecordDTO.getRetryTime()).type(taskLogRecordDTO.getType()).voucher(taskLogRecordDTO.getVoucher()).voucherId(taskLogRecordDTO.getVoucherId()).build();
    }
}

