/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.enums.CurNodeEnum;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.factory.TaskFactory;
import kd.ssc.task.partask.service.ParTaskFlowInstService;
import kd.ssc.task.partask.service.ParTaskFlowService;
import kd.ssc.task.partask.service.ParTaskNodeService;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskFlowServiceImpl;

public class ParTaskNodeServiceImpl
implements ParTaskNodeService {
    private static final Log log = LogFactory.getLog(ParTaskNodeServiceImpl.class);
    private ParTaskFlowService parTaskFlowService = new ParTaskFlowServiceImpl();
    private ParTaskFlowInstService parTaskFlowInstService = new ParTaskFlowInstServiceImpl();

    @Override
    public long createNewNode(long sscId, long billTypeId, String billId, String workFlowId, long flowDefId, long instId, long nextTaskTypeId, String nextNodeDefId) throws Exception {
        if (this.isNextNodeExists(instId, nextNodeDefId)) {
            log.info("ParTaskNodeServiceImpl.createNewNode\uff1a\u4e0b\u7ea7\u8282\u70b9\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u4f5c\u5904\u7406, instId:" + instId + ", nextNodeDefId:" + nextNodeDefId);
            return -1L;
        }
        boolean parTaskComplete = this.isParTaskComplete(flowDefId, instId, nextNodeDefId);
        if (!parTaskComplete) {
            log.info("ParTaskNodeServiceImpl.createNewNode\uff1a\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5e76\u884c\u8282\u70b9\uff0c\u4e0d\u4f5c\u5904\u7406, flowDefId:" + flowDefId + ", instId:" + instId + ", nextNodeDefId:" + nextNodeDefId);
            return -2L;
        }
        if (nextTaskTypeId == 0L || StringUtils.isEmpty((String)nextNodeDefId)) {
            if (!this.isAllNodeComplete(flowDefId, instId)) {
                return -1L;
            }
            log.info("ParTaskNodeServiceImpl.createNewNode\uff1a\u6d41\u7a0b\u7ed3\u675f");
            this.parTaskFlowInstService.updateInstStatus(instId, FlowInstEnum.SUCCESS);
            this.clearCurNodeTable(instId, nextNodeDefId);
            return -3L;
        }
        log.info("ParTaskNodeServiceImpl.createNewNode\uff1a\u51c6\u5907\u521b\u5efa\u4e0b\u7ea7\u8282\u70b9");
        long taskId = TaskFactory.createTaskByParTask(nextTaskTypeId, billTypeId, billId, workFlowId);
        if (taskId == 0L) {
            return taskId;
        }
        QFilter instIdFilter = new QFilter("instid", "=", (Object)instId);
        QFilter nextNodeDefIdFilter = new QFilter("nextnodedefid", "=", (Object)nextNodeDefId);
        DataSet parentNodes = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"task_partaskcurnode", (String)"curtaskid, curnodedefid", (QFilter[])new QFilter[]{instIdFilter, nextNodeDefIdFilter}, null);
        ArrayList<DynamicObject> nodeList = new ArrayList<DynamicObject>();
        if (parentNodes.isEmpty()) {
            long parentTaskId = 0L;
            long parentNodeTypeId = 0L;
            DynamicObject nodeInst = this.getNodeInst(instId, taskId, nextTaskTypeId, nextNodeDefId, parentNodeTypeId, parentTaskId);
            nodeList.add(nodeInst);
        }
        for (Row parentNode : parentNodes) {
            long parentTaskId = parentNode.getLong("curtaskid");
            String parentDefId = parentNode.getString("curnodedefid");
            long parentNodeTypeId = this.getTaskTypeIdFromNodeDefId(parentDefId);
            DynamicObject nodeInst = this.getNodeInst(instId, taskId, nextTaskTypeId, nextNodeDefId, parentNodeTypeId, parentTaskId);
            nodeList.add(nodeInst);
        }
        log.info("save task_partaskinstnode \uff1anodeList = {}", (Object)nodeList.size());
        SaveServiceHelper.save((DynamicObject[])nodeList.toArray(new DynamicObject[0]));
        this.clearCurNodeTable(instId, nextNodeDefId);
        this.insertNewDataToCurNodeTable(flowDefId, nodeList);
        return taskId;
    }

    @Override
    public void updateNodeTaskIdAfterApproval(Long taskId, Long taskHisId) {
        DynamicObject[] instNodes;
        QFilter taskIdFilter = new QFilter("taskid", "=", (Object)taskId);
        for (DynamicObject node : instNodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{taskIdFilter})) {
            node.set("taskid", (Object)taskHisId);
        }
        SaveServiceHelper.save((DynamicObject[])instNodes);
    }

    @Override
    public void updateTableAfterNodeTaskComplete(long taskId) {
        DynamicObject[] curNodes;
        DynamicObject[] instNodes;
        log.info("ParTaskNodeServiceImpl.nodeTaskComplete\uff1a\u66f4\u65b0\u5b9e\u4f8b\u8282\u70b9\u8868\uff0ctaskId = " + taskId + " \u7684\u8282\u70b9\u72b6\u6001\u6539\u4e3a \u5df2\u5b8c\u6210");
        QFilter taskIdFilter = new QFilter("taskid", "=", (Object)taskId);
        for (DynamicObject node : instNodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"state", (QFilter[])new QFilter[]{taskIdFilter})) {
            node.set("state", (Object)InstNodeEnum.COMPLETED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])instNodes);
        log.info("ParTaskNodeServiceImpl.nodeTaskComplete\uff1a\u66f4\u65b0\u8fd0\u884c\u65f6\u8868\uff0ctaskId = " + taskId + " \u7684\u8282\u70b9\u72b6\u6001\u6539\u4e3a \u5df2\u5b8c\u6210");
        taskIdFilter = new QFilter("curtaskid", "=", (Object)taskId);
        for (DynamicObject node : curNodes = BusinessDataServiceHelper.load((String)"task_partaskcurnode", (String)"status", (QFilter[])new QFilter[]{taskIdFilter})) {
            node.set("status", (Object)CurNodeEnum.COMPLETED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])curNodes);
    }

    @Override
    public void flowInstFinish(long taskId, FlowInstEnum flowInstEnum) {
        QFilter taskIdFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject[] instNodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"instantid", (QFilter[])new QFilter[]{taskIdFilter});
        if (instNodes.length == 0) {
            log.info("ParTaskNodeServiceImpl.nodeTaskComplete\uff1a\u672a\u67e5\u5230taskId\u4e3a " + taskId + " \u7684\u5b9e\u4f8b\u8282\u70b9");
            return;
        }
        long instId = instNodes[0].getLong("instantid");
        this.parTaskFlowInstService.updateInstStatus(instId, flowInstEnum);
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
        QFilter stateFilter = new QFilter("state", "=", (Object)InstNodeEnum.PROCESSING.getValue());
        for (DynamicObject node : instNodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid, state", (QFilter[])new QFilter[]{instIdFilter, stateFilter})) {
            if (node.getLong("taskid") == taskId) {
                if (FlowInstEnum.REPULSE == flowInstEnum) {
                    node.set("state", (Object)InstNodeEnum.RETURN.getValue());
                    continue;
                }
                node.set("state", (Object)InstNodeEnum.FAILED.getValue());
                continue;
            }
            node.set("state", (Object)InstNodeEnum.TERMINATION.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])instNodes);
        instIdFilter = new QFilter("instid", "=", (Object)instId);
        DeleteServiceHelper.delete((String)"task_partaskcurnode", (QFilter[])new QFilter[]{instIdFilter});
    }

    @Override
    public boolean isAllNodeComplete(long flowDefId, long flowInstId) throws Exception {
        int defNodeNum;
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)flowInstId);
        QFilter stateFilter = new QFilter("state", "=", (Object)InstNodeEnum.COMPLETED.getValue());
        DataSet nodeTaskIdDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{instIdFilter, stateFilter}, null);
        int completeNodeNum = nodeTaskIdDataSet.count("taskid", true);
        return completeNodeNum == (defNodeNum = this.parTaskFlowService.getNodeNumber(flowDefId).intValue());
    }

    @Override
    public boolean isLastNode(long flowDefId, long flowInstId) throws Exception {
        int defNodeNum;
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)flowInstId);
        QFilter stateFilter = new QFilter("state", "=", (Object)InstNodeEnum.COMPLETED.getValue());
        DataSet nodeTaskIdDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"task_partaskinstnode", (String)"taskid", (QFilter[])new QFilter[]{instIdFilter, stateFilter}, null);
        int completeNodeNum = nodeTaskIdDataSet.count("taskid", true);
        return completeNodeNum == (defNodeNum = this.parTaskFlowService.getNodeNumber(flowDefId).intValue()) - 1;
    }

    @Override
    public boolean isNextNodeExists(long instId, String nextNodeDefId) {
        QFilter instIdFilter = new QFilter("instantid", "=", (Object)instId);
        QFilter nodeDefIdFilter = new QFilter("nodedefid", "=", (Object)nextNodeDefId);
        return QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])new QFilter[]{instIdFilter, nodeDefIdFilter});
    }

    @Override
    public void updateTableAfterCreateParTaskFailed(long instId, String nextNodeDefId) {
        this.parTaskFlowInstService.updateInstStatus(instId, FlowInstEnum.FAILED);
        this.clearCurNodeTable(instId, nextNodeDefId);
    }

    @Override
    @SdkDeprecated
    public long getInstIdByTaskId(long taskId) {
        QFilter taskIdFilter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject instant = QueryServiceHelper.queryOne((String)"task_partaskinstnode", (String)"instantid", (QFilter[])new QFilter[]{taskIdFilter});
        if (instant == null) {
            return 0L;
        }
        return instant.getLong("instantid");
    }

    @Override
    public List<ParTaskMessage> getNextNodeMsg(long taskId, long workFlowId) {
        QFilter taskIdFilter = new QFilter("curtaskid", "=", (Object)taskId);
        DynamicObject[] curNodeList = BusinessDataServiceHelper.load((String)"task_partaskcurnode", (String)"instid, nextnodedefid", (QFilter[])new QFilter[]{taskIdFilter});
        if (curNodeList.length == 0) {
            return null;
        }
        long instId = curNodeList[0].getLong("instid");
        DynamicObject inst = BusinessDataServiceHelper.loadSingle((Object)instId, (String)"task_partaskinst", (String)"sscid.id,billtype.id,billid,flowcode.id");
        long sscId = inst.getLong("sscid.id");
        long billTypeId = inst.getLong("billtype.id");
        String billId = inst.getString("billid");
        long flowDefId = inst.getLong("flowcode.id");
        ArrayList<ParTaskMessage> msgList = new ArrayList<ParTaskMessage>(10);
        for (DynamicObject nodeObj : curNodeList) {
            String nextNodeDefId = nodeObj.getString("nextnodedefid");
            long taskTypeId = 0L;
            if (StringUtils.isNotEmpty((String)nextNodeDefId)) {
                taskTypeId = this.getTaskTypeIdFromNodeDefId(nextNodeDefId);
            }
            ParTaskMessage msg = new ParTaskMessage(sscId, billTypeId, billId, flowDefId, instId, taskTypeId, nextNodeDefId, workFlowId);
            msgList.add(msg);
        }
        return msgList;
    }

    @Override
    public long getTaskTypeIdFromNodeDefId(String nodeDefId) {
        int index = nodeDefId.lastIndexOf(95);
        return Long.parseLong(nodeDefId.substring(index + 1));
    }

    @Override
    public DynamicObject updateNodeInfo(DynamicObject node, DynamicObject task, AuditStateEnum state) {
        if (node == null || task == null) {
            return node;
        }
        Object nodeTmp = node;
        try {
            Object realState;
            nodeTmp = OrmUtils.clone((Object)node, (IDataEntityType)node.getDataEntityType(), (boolean)true, (boolean)false);
            if (AuditStateEnum.TODEL == state) {
                node.set("billid", task.get("billid"));
                node.set("workflowid", (Object)Long.valueOf(task.getString("assignid")));
            }
            log.info("\u66f4\u6539\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\uff0cpersonid = " + task.get("personid"));
            long personId = task.get("personid") instanceof DynamicObject ? task.getLong("personid.id") : task.getLong("personid");
            node.set("personid", (Object)personId);
            node.set("dealdate", (Object)new Date());
            node.set("taskstate", (Object)state.getState());
            if (state == AuditStateEnum.PASS || state == AuditStateEnum.NOPASS || state == AuditStateEnum.REPULSE || state == AuditStateEnum.RETURN) {
                String msg;
                node.set("auditmsg", (Object)msg.substring(0, (msg = task.getString("apprevalmessage")).length() > 1020 ? 1020 : msg.length()));
            } else {
                node.set("auditmsg", (Object)"");
            }
            if (state == AuditStateEnum.INPROCESS && "10".equals(realState = task.get("state"))) {
                node.set("taskstate", (Object)AuditStateEnum.TODEL.getState());
            }
        }
        catch (Exception e) {
            log.error("updateNodeInfo", (Throwable)e);
            node = nodeTmp;
        }
        return node;
    }

    private DynamicObject getNodeInst(long instId, long taskId, long taskTypeId, String nodeDefId, long parentTaskTypeId, long parentTaskId) {
        DynamicObject node = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskinstnode");
        node.set("instantid", (Object)instId);
        node.set("taskid", (Object)taskId);
        node.set("type", (Object)taskTypeId);
        node.set("nodedefid", (Object)nodeDefId);
        node.set("parenttype", (Object)parentTaskTypeId);
        node.set("parenttaskid", (Object)parentTaskId);
        node.set("state", (Object)InstNodeEnum.PROCESSING.getValue());
        node.set("createdate", (Object)new Date());
        try {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task", (String)"id, billid, assignid, personid, state, apprevalmessage");
            node = this.updateNodeInfo(node, task, AuditStateEnum.TODEL);
        }
        catch (Exception e) {
            log.error("getNodeInst=> taskid: " + taskId, (Throwable)e);
        }
        return node;
    }

    private boolean isParTaskComplete(long flowDefId, long instId, String nextNodeDefId) throws Exception {
        int parentNumber = StringUtils.isEmpty((String)nextNodeDefId) ? this.parTaskFlowService.getEndNode(flowDefId).size() : this.parTaskFlowService.getParentNumber(flowDefId, nextNodeDefId).intValue();
        QFilter instIdFilter = new QFilter("instid", "=", (Object)instId);
        QFilter nextNodeDefIdFilter = new QFilter("nextnodedefid", "=", (Object)nextNodeDefId);
        QFilter statusFilter = new QFilter("status", "=", (Object)CurNodeEnum.COMPLETED.getValue());
        int taskIdNum = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"task_partaskcurnode", (String)"curtaskid", (QFilter[])new QFilter[]{instIdFilter, nextNodeDefIdFilter, statusFilter}, null).count("curtaskid", true);
        return taskIdNum == parentNumber;
    }

    private int clearCurNodeTable(long instId, String nextNodeDefId) {
        log.info("ParTaskNodeServiceImpl.clearCurNodeTable() \uff1ainstId = {}, nextNodeDefId = {}", (Object)instId, (Object)nextNodeDefId);
        QFilter instIdFilter = new QFilter("instid", "=", (Object)instId);
        QFilter nextNodeDefIdFilter = new QFilter("nextnodedefid", "=", (Object)nextNodeDefId).or(new QFilter("curnodedefid", "=", (Object)nextNodeDefId));
        return DeleteServiceHelper.delete((String)"task_partaskcurnode", (QFilter[])new QFilter[]{instIdFilter, nextNodeDefIdFilter});
    }

    private Object[] insertNewDataToCurNodeTable(long flowDefId, List<DynamicObject> nodeList) throws Exception {
        log.info("ParTaskNodeServiceImpl.insertNewDataToCurNodeTable() \uff1aflowDefId = {}, nodeList = {}", (Object)flowDefId, (Object)nodeList.size());
        ArrayList<DynamicObject> curNodeList = new ArrayList<DynamicObject>();
        for (DynamicObject node : nodeList) {
            List<String> nextNodeDefIdList = this.parTaskFlowService.getChildId(flowDefId, node.getString("nodedefid"));
            for (String nextNodeDefId : nextNodeDefIdList) {
                DynamicObject curNode = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskcurnode");
                curNode.set("instid", (Object)node.getLong("instantid"));
                curNode.set("curtaskid", (Object)node.getLong("taskid"));
                curNode.set("curnodedefid", (Object)node.getString("nodedefid"));
                curNode.set("status", (Object)CurNodeEnum.PROCESSING.getValue());
                curNode.set("nextnodedefid", (Object)nextNodeDefId);
                curNodeList.add(curNode);
            }
            if (!nextNodeDefIdList.isEmpty()) continue;
            DynamicObject curNode = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskcurnode");
            curNode.set("instid", (Object)node.getLong("instantid"));
            curNode.set("curtaskid", (Object)node.getLong("taskid"));
            curNode.set("curnodedefid", (Object)node.getString("nodedefid"));
            curNode.set("status", (Object)CurNodeEnum.PROCESSING.getValue());
            curNode.set("nextnodedefid", (Object)"");
            curNodeList.add(curNode);
        }
        return SaveServiceHelper.save((DynamicObject[])curNodeList.toArray(new DynamicObject[0]));
    }
}

