/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.util;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.partask.service.impl.ParTaskFlowServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;

public class PartaskUniversalUtil {
    public static boolean isStartInProcessing(long taskId) throws Exception {
        if (!PartaskUniversalUtil.isParTaskOnProcessing(taskId)) {
            return false;
        }
        DynamicObject taskType = QueryServiceHelper.queryOne((String)"task_task", (String)"id,tasktypeid", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (taskType == null || taskType.get("tasktypeid") == null) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        long taskTypeId = taskType.getLong("tasktypeid");
        List<Long> startTaskType = PartaskUniversalUtil.getStartTaskTypesInProcessing(taskId);
        return startTaskType.contains(taskTypeId);
    }

    public static boolean isParTaskOnProcessing(long taskId) {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"id,source", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (task == null) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        Object taskSource = task.get("source");
        return "5".equals(taskSource);
    }

    public static boolean isParTaskCompleted(long taskId) {
        DynamicObject hisTask = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"id,sourcetaskid", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (hisTask == null) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        Object sourceTaskId = hisTask.get("sourcetaskid");
        return QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])new QFilter("taskid", "=", sourceTaskId).toArray());
    }

    public static List<Long> getStartTaskTypesInProcessing(long taskId) throws Exception {
        DynamicObject instNode = QueryServiceHelper.queryOne((String)"task_partaskinstnode", (String)"id,instantid", (QFilter[])new QFilter("taskid", "=", (Object)taskId).toArray());
        if (instNode == null || instNode.get("instantid") == null) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u65e0\u6cd5\u901a\u8fc7\u4efb\u52a1\uff0c\u627e\u5230\u591a\u7ea7\u4efb\u52a1\u5b9e\u4f8b\u8282\u70b9\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        Object insId = instNode.get("instantid");
        DynamicObject instance = QueryServiceHelper.queryOne((String)"task_partaskinst", (String)"id,flowcode", (QFilter[])new QFilter("id", "=", insId).toArray());
        if (instance == null) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        long defId = instance.getLong("flowcode");
        if (defId == 0L) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id\uff1a", (String)"", (String)"", (Object[])new Object[0]) + " " + taskId);
            throw new KDException(code, new Object[0]);
        }
        List<String> startNodeList = new ParTaskFlowServiceImpl().getStartNode(defId);
        return startNodeList.stream().map(s -> new ParTaskNodeServiceImpl().getTaskTypeIdFromNodeDefId((String)s)).collect(Collectors.toList());
    }
}

