/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommonValidateUtil {
    public static boolean nullValidateAndTip(ExtendedDataEntity dataEntity, String property, String description, StringBuffer errorMsg) {
        Object oEntryshareexp = dataEntity.getValue(property);
        if (oEntryshareexp != null) {
            if (oEntryshareexp instanceof String) {
                String oEntryshareexpStr = oEntryshareexp.toString();
                if (StringUtils.isEmpty((String)oEntryshareexpStr)) {
                    errorMsg.append(description);
                    return false;
                }
            } else if (oEntryshareexp instanceof DynamicObjectCollection) {
                DynamicObjectCollection entryshareexp = (DynamicObjectCollection)oEntryshareexp;
                if (entryshareexp.size() <= 0) {
                    errorMsg.append(description);
                    return false;
                }
            } else {
                String oEntryshareexpStr = oEntryshareexp.toString();
                if (StringUtils.isEmpty((String)oEntryshareexpStr) || MessageDigest.isEqual(oEntryshareexpStr.getBytes(StandardCharsets.UTF_8), "0".getBytes(StandardCharsets.UTF_8))) {
                    errorMsg.append(description);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkPropertyIfExisted(String entityName, String sscidFiledName, Object sscidValue, String propertyName, Object propertyValue) {
        QFilter sscFilter = new QFilter(sscidFiledName, "=", sscidValue);
        QFilter proFilter = new QFilter(propertyName, "=", propertyValue);
        QFilter[] filters = new QFilter[]{sscFilter, proFilter};
        return CommonValidateUtil.checkPropertyIfExisted(entityName, filters);
    }

    public static boolean checkEditedPropertyIfExisted(String entityName, String sscidFiledName, Object sscidValue, String propertyName, Object propertyValue, long id) {
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter sscFilter = new QFilter(sscidFiledName, "=", sscidValue);
        QFilter proFilter = new QFilter(propertyName, "=", propertyValue);
        QFilter[] filters = new QFilter[]{idFilter, sscFilter, proFilter};
        return CommonValidateUtil.checkPropertyIfExisted(entityName, filters);
    }

    public static boolean checkPropertyIfExisted(String entityName, QFilter[] filters) {
        return QueryServiceHelper.exists((String)entityName, (QFilter[])filters);
    }

    public static void validatePropertyIfExisted(ExtendedDataEntity dataEntity, String entityName, Long id, String propertyName, Object propertyValue, String ssccenterName, Long ssccenter, String nullMessage, String existMessage, StringBuffer errorMsg) {
        if (CommonValidateUtil.nullValidateAndTip(dataEntity, propertyName, nullMessage, errorMsg)) {
            if (id == 0L) {
                if (CommonValidateUtil.checkPropertyIfExisted(entityName, ssccenterName, ssccenter, propertyName, propertyValue)) {
                    errorMsg.append(existMessage);
                }
            } else if (CommonValidateUtil.checkEditedPropertyIfExisted(entityName, ssccenterName, ssccenter, propertyName, propertyValue, id)) {
                errorMsg.append(existMessage);
            }
        }
    }

    public static String replaceEnding(String errorMsg) {
        if (errorMsg == null) {
            return null;
        }
        String trim = errorMsg.trim();
        if (trim.length() == 0) {
            return errorMsg;
        }
        int last = trim.length() - 1;
        char ending = trim.charAt(last);
        if ('\uff1b' == ending) {
            return trim.substring(0, last) + "\u3002";
        }
        if (';' == ending) {
            return trim.substring(0, last) + ".";
        }
        return errorMsg;
    }
}

