/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomUtil {
    private static Random rand;

    public static Set<Integer> generateRandom(int min, int max, int num) {
        if (min < 0 || max < 0 || num < 0 || max < min) {
            throw new IllegalArgumentException();
        }
        int range = max - min;
        num = Math.min(num, range);
        HashSet<Integer> numSet = new HashSet<Integer>((int)((float)num / 0.75f) + 1);
        if ((float)num / (float)range < 0.9f) {
            while (numSet.size() < num) {
                numSet.add(min + rand.nextInt(range));
            }
            return numSet;
        }
        HashSet<Integer> allNum = new HashSet<Integer>((int)((float)range / 0.75f) + 1);
        for (int i = min; i < max; ++i) {
            allNum.add(i);
        }
        int removeNum = range - num;
        while (numSet.size() < removeNum) {
            numSet.add(min + rand.nextInt(range));
        }
        allNum.removeAll(numSet);
        return allNum;
    }

    public static int nextInt(int bound) {
        return rand.nextInt(bound);
    }

    static {
        try {
            rand = SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            rand = new SecureRandom();
        }
    }
}

