/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.ThirdCommentInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.enums.Source;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.ExceptionTypeEnum;
import kd.ssc.exception.enums.InterfaceTypeEnum;
import kd.ssc.exception.enums.SourceSystemEnum;
import kd.ssc.exception.factory.DtoCreateFactory;
import kd.ssc.exception.util.QueryParamUtil;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;

public class TaskWorkFlowUtil {
    private static Log log = LogFactory.getLog(TaskWorkFlowUtil.class);
    private static final String COMMONTYPE = "commontype";
    private static final String ASSIGNTYPE = "assigntype";

    @Deprecated
    public static void addWorkFlowComment(DynamicObject[] tasks, String msg, String result, Long person) {
        if (tasks == null) {
            return;
        }
        for (DynamicObject task : tasks) {
            if (!TaskWorkFlowUtil.validatePass(task, false, COMMONTYPE)) continue;
            TaskWorkFlowUtil.addComment(task, msg, result, person);
        }
    }

    @Deprecated
    private static void addComment(DynamicObject task, String msg, String result, Long person) {
        person = person == null ? Long.valueOf(0L) : person;
        String source = task.getString("source");
        String extendNum = task.getString("billtype.externalerp.number");
        if ((source.equals(Integer.toString(Source.WorkFlow.getValue())) || source.equals(Integer.toString(Source.ParTask.getValue()))) && "KDCC".equalsIgnoreCase(extendNum)) {
            Comment comment = TaskWorkFlowUtil.buildCommon(task, msg, result, person);
            IWorkflowService iWorkflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
            iWorkflowService.addComment(comment);
        }
    }

    private static Comment buildCommon(DynamicObject task, String msg, String result, Long person) {
        IWorkflowService iWorkflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
        Comment comment = iWorkflowService.createNewComment();
        comment.setMessage(msg);
        comment.setTaskId(Long.valueOf(task.getLong("assignid")));
        comment.setTime(new Date());
        comment.setUserId(person);
        comment.setActivityName(ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskWorkFlowUtil_0", (String)"ssc-task-common", (Object[])new Object[0]));
        comment.setResultName(result);
        return comment;
    }

    public static void createWfMsg(DynamicObject task) {
        log.info("\u5ba1\u6279\u8bb0\u5f55\u5f00\u59cb\u5199\u5de5\u4f5c\u6d41\u7b2c\u4e09\u65b9\u8868createWfMsg\uff0ctaskId=" + task.getLong("id"));
        ThirdCommentInfo thirdCommentInfo = TaskWorkFlowUtil.getThirdCommentInfo(task);
        try {
            if (TaskWorkFlowUtil.commentExist((Long)task.getPkValue())) {
                WorkflowServiceHelper.updateTrdComment((ThirdCommentInfo)thirdCommentInfo);
            } else {
                WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
            }
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.TaskWorkFlowUtil.createWfMsg\u63a5\u53e3\u5f02\u5e38\uff0ctaskId=" + task.getLong("id"), (Throwable)e);
        }
    }

    public static void updateWfMsg(DynamicObject task, boolean back) {
        log.info("\u5ba1\u6279\u8bb0\u5f55\u66f4\u65b0\u5de5\u4f5c\u6d41\u5199\u7b2c\u4e09\u65b9\u8868updateWfMsg\uff0ctaskId=" + task.getLong("id"));
        ThirdCommentInfo thirdCommentInfo = TaskWorkFlowUtil.getThirdCommentInfo(task);
        Object sscidTmp = task.get("sscid");
        Long sscid = 0L;
        if (sscidTmp instanceof DynamicObject) {
            sscid = (Long)((DynamicObject)sscidTmp).getPkValue();
        } else if (sscidTmp instanceof Long) {
            sscid = (Long)sscidTmp;
        }
        Long person = back || ParTaskAuditMsgUpdateUtil.isHideUser(sscid) ? Long.valueOf(-2L) : TaskWorkFlowUtil.getPersonID(task);
        thirdCommentInfo.setUserId(person);
        thirdCommentInfo.setResultName(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"AuditStateEnum_1", (String)"ssc-task-common", (Object[])new Object[0]));
        if (back) {
            thirdCommentInfo.setResultName(ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AuditStateEnum_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        try {
            if (TaskWorkFlowUtil.commentExist((Long)task.getPkValue())) {
                WorkflowServiceHelper.updateTrdComment((ThirdCommentInfo)thirdCommentInfo);
            } else {
                WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
            }
        }
        catch (Exception e) {
            log.error("kd.ssc.task.util.TaskWorkFlowUtil.updateWfMsg\u63a5\u53e3\u5f02\u5e38\uff0ctaskId=" + task.getLong("id"), (Throwable)e);
        }
    }

    public static void updateWfMsgAfterTaskDelete(DynamicObject task, String newStatus, String newComment, long userId, int status) {
        ThirdCommentInfo thirdCommentInfo = TaskWorkFlowUtil.getThirdCommentInfo(task);
        thirdCommentInfo.setResultName(newStatus);
        thirdCommentInfo.setAuditMesssage(newComment);
        if (userId == 0L) {
            userId = -2L;
        }
        thirdCommentInfo.setUserId(Long.valueOf(userId));
        if (TaskWorkFlowUtil.commentExist(task.getLong("id"))) {
            WorkflowServiceHelper.updateTrdComment((ThirdCommentInfo)thirdCommentInfo);
        } else {
            WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
        }
        if (status == 1) {
            Long workflowId;
            IWorkflowService iWorkflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
            TaskInfo taskInfo = iWorkflowService.findTaskById(workflowId = Long.valueOf(task.getString("assignid")));
            if (taskInfo != null) {
                taskInfo.setHandleState("5");
                ArrayList<Long> userlist = new ArrayList<Long>();
                userlist.add(userId);
                iWorkflowService.updateTaskInfoAndParticipant(taskInfo, userlist);
            } else {
                log.info("updateWfMsgAfterTaskDelete() end , taskInfo is null: workflowId = {}", (Object)workflowId);
            }
        }
    }

    private static ThirdCommentInfo getThirdCommentInfo(DynamicObject task) {
        ThirdCommentInfo thirdCommentInfo = WorkflowServiceHelper.createNewTrdComment();
        Long assignid = task.getLong("assignid");
        String subactivityName = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
        subactivityName = TaskWorkFlowUtil.getTaskTypeName(task, subactivityName);
        thirdCommentInfo.setTaskId(assignid);
        if (assignid == null || assignid == 0L) {
            log.error("Error build instance for ThirdCommentInfo: assignid = {}, sscTaskId = {}", (Object)assignid, (Object)task.getLong("id"));
        }
        thirdCommentInfo.setId(Long.valueOf(task.getLong("id")));
        thirdCommentInfo.setUserId(Long.valueOf(-2L));
        thirdCommentInfo.setAuditTime(Long.valueOf(System.currentTimeMillis()));
        thirdCommentInfo.setSourceSystem("ssc");
        thirdCommentInfo.setAuditMesssage("");
        thirdCommentInfo.setSubactivityName(subactivityName);
        String resultName = ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AuditStateEnum_0", (String)"ssc-task-common", (Object[])new Object[0]);
        try {
            String poolType = task.getString("pooltype");
            TaskPoolTypeEnum poolTypeEnum = TaskPoolTypeEnum.getTaskPoolType(poolType);
            if (poolTypeEnum != null) {
                resultName = poolTypeEnum.getName();
            }
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u7b2c\u4e09\u65b9\u5ba1\u6279\u8bb0\u5f55-\u5ba1\u6279\u7ed3\u679c\u9519\u8bef", (Throwable)e);
        }
        thirdCommentInfo.setResultName(resultName);
        return thirdCommentInfo;
    }

    public static void completeWfMsg(Long taskId, Long workflowId, Long userId, String auditOpName, String auditMesssage, String subactivityName) {
        TaskWorkFlowUtil.completeWfMsg(taskId, workflowId, userId, auditOpName, auditMesssage, subactivityName, new HashMap<Long, ILocaleString>(0));
    }

    public static void completeWfMsg(Long taskId, Long workflowId, Long userId, String auditOpName, String auditMesssage, String subactivityName, Map<Long, ILocaleString> attMap) {
        log.info("\u5ba1\u6279\u8bb0\u5f55\u5b8c\u6210\u5199\u5de5\u4f5c\u6d41\u7b2c\u4e09\u65b9\u8868updateWfMsg\uff0ctaskId=" + taskId);
        ThirdCommentInfo thirdCommentInfo = WorkflowServiceHelper.createNewTrdComment();
        thirdCommentInfo.setTaskId(workflowId);
        thirdCommentInfo.setId(taskId);
        if (attMap != null && !attMap.isEmpty()) {
            TaskInfo ti = WorkflowServiceHelper.findTaskById((Long)workflowId);
            if (ti != null) {
                thirdCommentInfo.setProcessInstanceId(ti.getProcessInstanceId());
            }
            thirdCommentInfo.setAttchments(attMap);
        }
        thirdCommentInfo.setUserId(userId);
        thirdCommentInfo.setResultName(auditOpName);
        thirdCommentInfo.setAuditTime(Long.valueOf(System.currentTimeMillis()));
        thirdCommentInfo.setSourceSystem("ssc");
        String resultNumber = "Reject";
        String decisiontype = "reject";
        if (AuditStateEnum.PASS.getValue().equals(auditOpName)) {
            resultNumber = "Consent";
            decisiontype = "approve";
        }
        thirdCommentInfo.setResultNumber(resultNumber);
        thirdCommentInfo.setDecisiontype(decisiontype);
        thirdCommentInfo.setAuditMesssage(auditMesssage);
        thirdCommentInfo.setSubactivityName(subactivityName);
        log.info("completeWfMsg\u65b9\u6cd5\u540c\u6b65\u5de5\u4f5c\u6d41\u7b2c\u4e09\u65b9\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3start\uff0ctaskId=" + taskId);
        long start = System.currentTimeMillis();
        if (TaskWorkFlowUtil.commentExist(taskId)) {
            WorkflowServiceHelper.updateTrdComment((ThirdCommentInfo)thirdCommentInfo);
        } else {
            WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
        }
        long end = System.currentTimeMillis();
        log.info("completeWfMsg\u65b9\u6cd5\u540c\u6b65\u5de5\u4f5c\u6d41\u7b2c\u4e09\u65b9\u5ba1\u6279\u8bb0\u5f55\u63a5\u53e3end\uff0ctaskId=" + taskId + ",\u603b\u8017\u65f6\uff08ms\uff09\uff1a" + (end - start));
    }

    private static boolean commentExist(Long taskId) {
        return QueryServiceHelper.exists((String)"wf_trdhicomment", (Object)taskId);
    }

    public static void pushWfTask(Long workflowId, Long userId, String decOptionNumber, String message, String itemId, Boolean rejectBackToNode) {
        if (workflowId == null || userId == null || StringUtils.isNull((String)decOptionNumber)) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        if (workflowId == 0L) {
            sb.append("workflowId cannot be equal to 0. ");
        }
        if (StringUtils.isEmpty((String)decOptionNumber)) {
            sb.append("decOptionNumber is not empty. ");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
        HashMap<String, String> variableMap = new HashMap<String, String>();
        if (itemId != null) {
            variableMap.put("nextNodeId", itemId);
            variableMap.put("dynType", "dynReject");
        }
        if (rejectBackToNode != null) {
            variableMap.put("rejectBackToNode", String.valueOf(rejectBackToNode));
        }
        WorkflowServiceHelper.completeTask((Long)workflowId, (Long)userId, (String)decOptionNumber, (String)message, variableMap);
    }

    public static void updateMsgCreateTask(DynamicObject[] tasks, String msg) {
        Arrays.stream(tasks).forEach(s -> TaskWorkFlowUtil.createWfMsg(s));
        TaskWorkFlowUtil.updatePersonAndMsgWithCheck(tasks, msg, false);
    }

    public static void updatePersonAndMsgDisTask(DynamicObject[] tasks, String msg) {
        Arrays.stream(tasks).forEach(s -> TaskWorkFlowUtil.updateWfMsg(s, false));
        TaskWorkFlowUtil.updatePersonAndMsgWithCheck(tasks, msg, true);
    }

    public static void updatePersonAndMsgWithCheck(DynamicObject[] tasks, String msg, boolean isCheckperson) {
        if (tasks == null) {
            return;
        }
        for (DynamicObject task : tasks) {
            if (!TaskWorkFlowUtil.validatePass(task, isCheckperson, ASSIGNTYPE)) continue;
            try {
                TaskWorkFlowUtil.updateWorkFlowInfo(task, msg);
            }
            catch (Exception e) {
                log.error("kd.ssc.task.util.TaskWorkFlowUtil.updatePersonAndMsgWithCheck#Error: \u540c\u6b65\u5de5\u4f5c\u6d41\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static ExceptionDTO buildDto(DynamicObject task, String msg, boolean isCheckperson, Throwable e) {
        ExceptionDTO dto = null;
        if (TaskWorkFlowUtil.isLegal2Compensate(task)) {
            String failureReason = e instanceof KDException ? ((KDException)e).getStackTraceMessage() : Arrays.toString(e.getStackTrace());
            String billId = task.getString("billid");
            String billTypeId = task.getString("billtype.bindbill.number");
            ExceptionTypeEnum typeEnum = ExceptionTypeEnum.EXCEPTION_TYPE_WF_SYN_STAS;
            dto = DtoCreateFactory.getDtoInstance(billId, billTypeId, typeEnum.getCode());
            String taskId = task.getString("id");
            String queryParam = QueryParamUtil.getSynWfStasQryParam(taskId, msg, isCheckperson);
            dto.setFailureTime(new Date());
            dto.setFailureMsg(e.getMessage());
            dto.setFailureReason(failureReason);
            dto.setRequestParam(queryParam);
            dto.setInterfaceType(InterfaceTypeEnum.StasSyn.getValue());
            dto.setSourceSystem(SourceSystemEnum.NextGeneration.getValue());
        }
        return dto;
    }

    private static boolean isLegal2Compensate(DynamicObject task) {
        if (task == null) {
            return false;
        }
        DataEntityPropertyCollection properties = task.getDataEntityType().getProperties();
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (IDataEntityProperty prop : properties) {
            propertyNames.add(prop.getName());
        }
        if (!propertyNames.contains("id")) {
            return false;
        }
        if (!propertyNames.contains("billid")) {
            return false;
        }
        if (!propertyNames.contains("billtype")) {
            return false;
        }
        return task.get("id") != null && task.get("billid") != null && task.get("billtype.bindbill.number") != null;
    }

    private static void updateWorkFlowInfo(DynamicObject task, String msg) {
        String source = task.getString("source");
        String extendNum = task.getString("billtype.externalerp.number");
        if ((source.equals(Integer.toString(Source.WorkFlow.getValue())) || String.valueOf(Source.ParTask.getValue()).equals(source)) && "KDCC".equalsIgnoreCase(extendNum)) {
            TaskWorkFlowUtil.updatePersonAndMsg(task, msg);
        }
    }

    public static Long getPersonID(DynamicObject task) {
        Long person = task.get("personid") instanceof DynamicObject ? Long.valueOf(task.getLong("personid.id")) : Long.valueOf(task.getLong("personid"));
        person = person == null ? Long.valueOf(0L) : person;
        return person;
    }

    private static boolean validatePass(DynamicObject task, boolean isCheckperson, String type) {
        boolean passCheck = true;
        String source = task.getString("source");
        String extendNum = task.getString("billtype.externalerp.number");
        Long person = TaskWorkFlowUtil.getPersonID(task);
        StringBuilder jobTipDisBuf = new StringBuilder();
        if (source == null || StringUtils.isEmpty((String)extendNum)) {
            String tip = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u4fee\u6539\u5ba1\u6279\u4fe1\u606f\u6216\u6dfb\u52a0\u5ba1\u6279\u8bb0\u5f55\u4efb\u52a1\u4fe1\u606f\u6709\u8bef\uff1a", (String)"TaskWorkFlowUtil_1", (String)"ssc-task-common", (Object[])new Object[0]);
            if (COMMONTYPE.endsWith(type) || ASSIGNTYPE.endsWith(type)) {
                tip = ResManager.loadKDString((String)"\u6dfb\u52a0\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u62a5\u9519\uff1a", (String)"TaskWorkFlowUtil_2", (String)"ssc-task-common", (Object[])new Object[0]);
            }
            jobTipDisBuf.append(tip).append(ResManager.loadKDString((String)"\u4efb\u52a1\u4e3b\u9898\uff1a", (String)"TaskWorkFlowUtil_3", (String)"ssc-task-common", (Object[])new Object[0])).append(task.getString("subject")).append(',').append(ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90\uff1a", (String)"TaskWorkFlowUtil_4", (String)"ssc-task-common", (Object[])new Object[0])).append(task.getString("source")).append(',').append(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u4efb\u52a1\uff1a", (String)"TaskWorkFlowUtil_5", (String)"ssc-task-common", (Object[])new Object[0])).append(task.getString("assignid")).append(',').append(ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf\u7f16\u7801\uff1a", (String)"TaskWorkFlowUtil_6", (String)"ssc-task-common", (Object[])new Object[0])).append(extendNum);
            passCheck = false;
        }
        if (isCheckperson && (person == null || person.equals(0L))) {
            jobTipDisBuf.append(',').append(ResManager.loadKDString((String)"\u5206\u914d\u4ebaID\uff1a", (String)"TaskWorkFlowUtil_7", (String)"ssc-task-common", (Object[])new Object[0])).append(person);
            passCheck = false;
        }
        if (jobTipDisBuf.length() > 0) {
            jobTipDisBuf.append("\r\n");
            log.info("kd.ssc.task.common.TaskWorkFlowUtil.addWorkFlowComment:" + jobTipDisBuf);
        }
        return passCheck;
    }

    private static void updatePersonAndMsg(DynamicObject task, String msg) {
        Long person = TaskWorkFlowUtil.getPersonID(task);
        Long assignid = task.getLong("assignid");
        String poolType = task.getString("pooltype");
        assignid = assignid == null ? Long.valueOf(0L) : assignid;
        IWorkflowService iWorkflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskInfo taskInfo = iWorkflowService.findTaskById(assignid);
        log.info("before TaskInfo == null ");
        log.info("TaskInfo == null : " + (taskInfo == null));
        if (taskInfo == null) {
            return;
        }
        String deftValue = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
        if (deftValue.equals(msg)) {
            msg = TaskWorkFlowUtil.getTaskTypeName(task, deftValue);
        }
        taskInfo.setHandleState(poolType);
        ArrayList<Long> list = new ArrayList<Long>(1);
        try {
            if (!ParTaskAuditMsgUpdateUtil.isHideUser(task.getLong("sscid.id"))) {
                list.add(person);
            } else {
                list.add(-2L);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570(\u5ba1\u6279\u8bb0\u5f55\u9690\u85cf\u5171\u4eab\u73af\u8282\u5904\u7406\u4eba)\u62a5\u9519 ", (Throwable)e);
        }
        log.info("before updateTaskInfoAndParticipant");
        iWorkflowService.updateTaskInfoAndParticipant(taskInfo, list);
        log.info("after updateTaskInfoAndParticipant");
    }

    public static String getTaskTypeName(DynamicObject task, String deftValue) {
        if (StringUtils.isEmpty((String)deftValue)) {
            deftValue = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        if (task == null) {
            return deftValue;
        }
        if (task.getDataEntityType().getProperties().get((Object)"tasktypeid") != null) {
            Object taskTypeTmp = task.get("tasktypeid");
            if (taskTypeTmp instanceof DynamicObject) {
                deftValue = ((DynamicObject)taskTypeTmp).getLocaleString("name").getLocaleValue();
            } else if (taskTypeTmp instanceof Long) {
                DynamicObject taskTypeDo = BusinessDataServiceHelper.loadSingle((Object)taskTypeTmp, (String)"task_tasktype", (String)"id,name");
                deftValue = taskTypeDo.getLocaleString("name").getLocaleValue();
            }
        }
        return deftValue;
    }

    public static void updateWfSscNodeInfoByTaskHis(DynamicObject taskHisDo, String resultName, String auditMessage, long userId, String handleState) {
        ThirdCommentInfo thirdCommentInfo = TaskWorkFlowUtil.getThirdCommentInfoByTaskHis(taskHisDo);
        thirdCommentInfo.setResultName(resultName);
        thirdCommentInfo.setAuditMesssage(auditMessage);
        if (userId == 0L || ParTaskAuditMsgUpdateUtil.isHideUser(taskHisDo.getLong("sscid.id"))) {
            userId = -2L;
        }
        thirdCommentInfo.setUserId(Long.valueOf(userId));
        if (TaskWorkFlowUtil.commentExist(taskHisDo.getLong("sourcetaskid"))) {
            WorkflowServiceHelper.updateTrdComment((ThirdCommentInfo)thirdCommentInfo);
        } else {
            WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
        }
        if (StringUtils.isNotEmpty((String)handleState)) {
            Long workflowId;
            IWorkflowService iWorkflowService = (IWorkflowService)ServiceFactory.getService(WorkflowService.class);
            TaskInfo taskInfo = iWorkflowService.findTaskById(workflowId = Long.valueOf(taskHisDo.getString("assignid")));
            if (taskInfo != null) {
                taskInfo.setHandleState(handleState);
                ArrayList<Long> userList = new ArrayList<Long>();
                userList.add(userId);
                iWorkflowService.updateTaskInfoAndParticipant(taskInfo, userList);
            } else {
                log.info("updateWfSscNodeInfoByTaskHis() end , taskInfo is null: workflowId = {}", (Object)workflowId);
            }
        }
    }

    private static ThirdCommentInfo getThirdCommentInfoByTaskHis(DynamicObject taskHisDo) {
        ThirdCommentInfo thirdCommentInfo = WorkflowServiceHelper.createNewTrdComment();
        Long assignid = taskHisDo.getLong("assignid");
        String subactivityName = ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]);
        subactivityName = TaskWorkFlowUtil.getTaskTypeName(taskHisDo, subactivityName);
        thirdCommentInfo.setTaskId(assignid);
        thirdCommentInfo.setId(Long.valueOf(taskHisDo.getLong("sourcetaskid")));
        thirdCommentInfo.setUserId(Long.valueOf(-2L));
        thirdCommentInfo.setAuditTime(Long.valueOf(System.currentTimeMillis()));
        thirdCommentInfo.setSourceSystem("ssc");
        thirdCommentInfo.setAuditMesssage("");
        thirdCommentInfo.setSubactivityName(subactivityName);
        String resultName = ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AuditStateEnum_0", (String)"ssc-task-common", (Object[])new Object[0]);
        String poolType = taskHisDo.getString("pooltype");
        TaskPoolTypeEnum poolTypeEnum = TaskPoolTypeEnum.getTaskPoolType(poolType);
        if (poolTypeEnum != null) {
            resultName = poolTypeEnum.getName();
        }
        thirdCommentInfo.setResultName(resultName);
        return thirdCommentInfo;
    }
}

