/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.task.service.IEvaluateService;

public class EvaluateServiceImpl
implements IEvaluateService {
    private static Log log = LogFactory.getLog(EvaluateServiceImpl.class);
    private static final String FORM_ID = "som_billevaluate";
    private static final String UPDATE_SQL = "update t_tk_evaluating_data set fstatus =?,fwaitevaluatetime=? where fbillid =? and fstatus =?";
    private static final String REIMBURSEMENT_UPDATE_SQL = "update t_dhc_mybilllist set fevaluatestatus=? where fbillid =? and fevaluatestatus=?";
    private static final String METADATA_BOS_USER = "bos_user";

    public String getEvaluateUrl(long billId, String entityNumber, String permFieldKey) {
        MainEntityType srcMainET = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (srcMainET == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6807\u8bc6\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53\u3002", (String)"EvaluateServiceImpl_0", (String)"ssc-task-mservice", (Object[])new Object[0])});
        }
        if (StringUtils.isEmpty((String)permFieldKey)) {
            permFieldKey = "creator";
        } else {
            DynamicProperty dynamicProperty = srcMainET.getProperty(permFieldKey);
            if (dynamicProperty instanceof BasedataProp) {
                if (!METADATA_BOS_USER.equals(((BasedataProp)dynamicProperty).getBaseEntityId())) {
                    throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5b57\u6bb5\u975e\u201c\u4eba\u5458\u201d\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"EvaluateServiceImpl_1", (String)"ssc-task-mservice", (Object[])new Object[0])});
                }
            } else {
                throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5b57\u6bb5\u975e\u201c\u4eba\u5458\u201d\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"EvaluateServiceImpl_1", (String)"ssc-task-mservice", (Object[])new Object[0])});
            }
        }
        String contextPath = RequestContext.get().getClientFullContextPath();
        QFilter idFilter = new QFilter("billid", "=", (Object)billId);
        QFilter entityFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        String url = contextPath + "index.html?formId=" + FORM_ID + "&billId=" + billId + "&entityNumber=" + entityNumber + "&permFieldKey=" + permFieldKey;
        if (!QueryServiceHelper.exists((String)"som_evaluating_data", (QFilter[])new QFilter[]{idFilter, entityFilter})) {
            if (QueryServiceHelper.exists((String)"som_evaluatedetail", (QFilter[])new QFilter[]{idFilter})) {
                log.info("bill evaluated id:", (Object)billId);
                return url;
            }
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u8fdb\u5171\u4eab\uff0c\u4e0d\u652f\u6301\u8bc4\u4ef7\u3002", (String)"EvaluateServiceImpl_2", (String)"ssc-task-mservice", (Object[])new Object[0])});
        }
        Date date = new Date();
        Object[] params = new Object[]{EvaluateStatusEnum.EVALUATING_STATE.getStatus(), date, billId, EvaluateStatusEnum.INIT_STATE.getStatus()};
        Object[] reimbursementParams = new Object[]{EvaluateStatusEnum.EVALUATING_STATE.getStatus(), billId, EvaluateStatusEnum.INIT_STATE.getStatus()};
        try (TXHandle tx = TX.required((String)"kd.ssc.task.service.EvaluateServiceImpl.getEvaluateUrl");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)UPDATE_SQL, (Object[])params);
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)REIMBURSEMENT_UPDATE_SQL, (Object[])reimbursementParams);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(String.format("executeDb billId:%s,e:", billId), e);
                throw new KDBizException(BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluateServiceImpl_3", (String)"ssc-task-mservice", (Object[])new Object[0])});
            }
        }
        return url;
    }
}

