/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.enums.DealTypeEnum;
import kd.ssc.exception.enums.ExceptionTypeEnum;
import kd.ssc.exception.enums.NotCompensateEnum;

public class TaskHelper {
    private static final Log log = LogFactory.getLog(TaskHelper.class);

    public static boolean updateTaskExcRecAndAddHisRec(String billId, List<DynamicObject> tasks) {
        ArrayList<DynamicObject> historyRecords = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> exceptionRecords = new ArrayList<DynamicObject>(10);
        for (DynamicObject task : tasks) {
            if (task.getString("iscompensate").equals(NotCompensateEnum.N_COMPENSATE.getValue()) && task.getString("compensatestatus").equals(CompensateStatusEnum.STOP.getValue())) continue;
            task.set("iscompensate", (Object)NotCompensateEnum.N_COMPENSATE.getValue());
            task.set("compensatestatus", (Object)CompensateStatusEnum.STOP.getValue());
            task.set("dealtype", (Object)DealTypeEnum.WorkFlowWithdraw.getValue());
            exceptionRecords.add(task);
            historyRecords.add(TaskHelper.packageTaskHistoryRecord(billId, task));
        }
        if (exceptionRecords.size() != 0 && historyRecords.size() != 0) {
            try (TXHandle h = TX.required((String)"kd.ssc.task.service.TaskService.canWithdraw");){
                try {
                    SaveServiceHelper.update((DynamicObject[])exceptionRecords.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])historyRecords.toArray(new DynamicObject[0]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error(String.format("\u5de5\u4f5c\u6d41\u8282\u70b9\u64a4\u56de\u6821\u9a8c\uff0c\u5f02\u5e38\u8868\u66f4\u65b0&\u5f02\u5e38\u5386\u53f2\u8868\u65b0\u589e\u5931\u8d25\uff0c\u8fd4\u56defalse=>billId:%s", billId), e);
                    boolean bl = false;
                    if (h != null) {
                        if (var5_5 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public static List<Object> getTaskBillTypeNumbers(String entityNumber) {
        ArrayList<Object> taskBillTypeIds = new ArrayList<Object>();
        QFilter[] filters = new QFilter[]{new QFilter("bindbill.number", "=", (Object)entityNumber)};
        QueryServiceHelper.query((String)"task_taskbill", (String)"id", (QFilter[])filters).stream().forEach(taskBillType -> taskBillTypeIds.add(taskBillType.get("id")));
        return taskBillTypeIds;
    }

    public static boolean isExistsPendingTask(String billId, List<Object> taskBillTypeIds) {
        QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billId), new QFilter("billtype", "in", taskBillTypeIds)};
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])filters);
    }

    public static List<DynamicObject> getTaskExceptionRecords(String billId, String entityNumber) {
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)billId), new QFilter("billtype", "=", (Object)entityNumber), new QFilter("exceptiontype", "=", (Object)ExceptionTypeEnum.EXCEPTION_TYPE_TASK_WF.getCode())};
        String selectFields = "id,billno,billtype,exceptiontype,requestparam_tag,failurereason,failurereason_tag,dealtype,iscompensate,compensatestatus";
        return orm.query("task_exceptionrecord", selectFields, filters);
    }

    public static DynamicObject packageTaskHistoryRecord(String billId, DynamicObject exceptionRecord) {
        DynamicObject historyRecord = BusinessDataServiceHelper.newDynamicObject((String)"task_exceptionhistory");
        historyRecord.set("billid", (Object)billId);
        historyRecord.set("billno", (Object)exceptionRecord.getString("billno"));
        historyRecord.set("exceptiontype", (Object)exceptionRecord.getString("exceptiontype"));
        historyRecord.set("failurereason", (Object)exceptionRecord.getString("failurereason"));
        historyRecord.set("failurereason_tag", exceptionRecord.get("failurereason_tag"));
        historyRecord.set("compensatestatus", (Object)CompensateStatusEnum.STOP.getValue());
        historyRecord.set("dealtype", (Object)exceptionRecord.getString("dealtype"));
        Object requestParamTag = exceptionRecord.get("requestparam_tag");
        if (requestParamTag != null) {
            String reqParam = requestParamTag.toString();
            historyRecord.set("requestparam_tag", (Object)reqParam);
            if (reqParam.length() > 200) {
                reqParam = StringUtils.substring((String)reqParam, (int)0, (int)199);
            }
            historyRecord.set("requestparam", (Object)reqParam);
        }
        return historyRecord;
    }
}

