/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class EvaluativeDimensionUpgradeServiceImpl
implements IUpgradeService {
    private static final long sscViewId = 12L;
    private static final long unitId = 15L;
    private static final DBRoute dbRoute = DBRoute.of((String)"ssc");
    private static final String DELETE_SQL = "delete from  t_tk_evaluate_dimension where fid in(2119557781294981120,2119559675451056128)";
    private static final String ENTIRETY_INSERT_SQL = "INSERT INTO t_tk_evaluate_dimension  (fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, fcreateorgid, forgid, fctrlstrategy, fsourcedataid, fbitindex, fsourcebitindex, fsrccreateorgid, fdescription, fispreset)  VALUES(2119557781294981120, 'entirety', ?, 'C', 1, 1, '1', ?, ?, 2119557781294981120, ?, ?, '5', 2119557781294981120, 1, 1, ?, ?, '1')";
    private static final String STAFF_INSERT_SQL = "INSERT INTO t_tk_evaluate_dimension  (fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, fcreateorgid, forgid, fctrlstrategy, fsourcedataid, fbitindex, fsourcebitindex, fsrccreateorgid, fdescription, fispreset)  VALUES(2119559675451056128, 'ssc_staff', ?, 'C', 1, 1, '1', ?, ?, 2119559675451056128, ?, ?, '5', 2119559675451056128, 2, 2, ?, ?, '1')";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            long rootSscOrgId = this.getRootOrgByViewId(12L);
            ArrayList<Object[]> paramsEntirety = new ArrayList<Object[]>(4);
            ArrayList<Object[]> paramsStaff = new ArrayList<Object[]>(4);
            Date date = new Date();
            String entiretyName = ResManager.loadKDString((String)"\u603b\u4f53", (String)"EvaluativeDimensionUpgradeServiceImpl_2", (String)"ssc-task-upgradeservice", (Object[])new Object[0]);
            String staffName = ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u4eba\u5458", (String)"EvaluativeDimensionUpgradeServiceImpl_3", (String)"ssc-task-upgradeservice", (Object[])new Object[0]);
            String entiretyDesc = ResManager.loadKDString((String)"\u7528\u4e8e\u5355\u636e\u603b\u4f53\u6ee1\u610f\u5ea6\u8bc4\u4ef7", (String)"EvaluativeDimensionUpgradeServiceImpl_4", (String)"ssc-task-upgradeservice", (Object[])new Object[0]);
            String staffDesc = ResManager.loadKDString((String)"\u7528\u4e8e\u5bf9\u5355\u636e\u7684\u5171\u4eab\u5904\u7406\u4eba\u5458\u8fdb\u884c\u8bc4\u4ef7", (String)"EvaluativeDimensionUpgradeServiceImpl_5", (String)"ssc-task-upgradeservice", (Object[])new Object[0]);
            if (rootSscOrgId > 0L) {
                paramsEntirety.add(new Object[]{entiretyName, date, date, rootSscOrgId, rootSscOrgId, rootSscOrgId, entiretyDesc});
                paramsStaff.add(new Object[]{staffName, date, date, rootSscOrgId, rootSscOrgId, rootSscOrgId, staffDesc});
            } else {
                long rootOrgId = this.getRootOrgByViewId(15L);
                paramsEntirety.add(new Object[]{entiretyName, date, date, rootOrgId, rootOrgId, rootOrgId, entiretyDesc});
                paramsStaff.add(new Object[]{staffName, date, date, rootOrgId, rootOrgId, rootOrgId, staffDesc});
            }
            if (!paramsEntirety.isEmpty()) {
                DB.execute((DBRoute)dbRoute, (String)DELETE_SQL);
                DB.executeBatch((DBRoute)dbRoute, (String)ENTIRETY_INSERT_SQL, paramsEntirety);
                DB.executeBatch((DBRoute)dbRoute, (String)STAFF_INSERT_SQL, paramsStaff);
            }
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u9884\u7f6e\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"EvaluativeDimensionUpgradeServiceImpl_0", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setLog(ResManager.loadKDString((String)"\u8bc4\u4ef7\u7ef4\u5ea6\u9884\u7f6e\u6570\u636e\u5347\u7ea7\u5931\u8d25\u3002", (String)"EvaluativeDimensionUpgradeServiceImpl_1", (String)"ssc-task-upgradeservice", (Object[])new Object[0]));
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private long getRootOrgByViewId(long viewId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(" select forgid from t_org_structure b  where  b.flevel =1  and b.fparentid =0  ", new Object[0]);
        sqlBuilder.append("and b.fviewid =? ", new Object[]{viewId});
        try (DataSet dataSet = DB.queryDataSet((String)"evaluativeDimensionUpgradeQuery", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
            if (dataSet.hasNext()) {
                long l = dataSet.next().getLong("forgid");
                return l;
            }
        }
        return 0L;
    }
}

